/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.miniapplet;

import es.gob.afirma.core.AOCancelledOperationException;
import es.gob.afirma.core.AOException;
import es.gob.afirma.core.AOFormatFileException;
import es.gob.afirma.core.misc.Base64;
import es.gob.afirma.core.misc.Platform;
import es.gob.afirma.core.signers.AOSigner;
import es.gob.afirma.keystores.AOKeyStore;
import es.gob.afirma.keystores.misc.JarSignatureCertExtractor;
import es.gob.afirma.miniapplet.CertFilterManager;
import es.gob.afirma.miniapplet.CoSignAction;
import es.gob.afirma.miniapplet.CounterSignAction;
import es.gob.afirma.miniapplet.DescargaInformeAction;
import es.gob.afirma.miniapplet.ExtraParamsProcessor;
import es.gob.afirma.miniapplet.GetFileContentAction;
import es.gob.afirma.miniapplet.GetFileNameContentAction;
import es.gob.afirma.miniapplet.GetPropertyAction;
import es.gob.afirma.miniapplet.HttpDownloadAction;
import es.gob.afirma.miniapplet.HttpIPostAction;
import es.gob.afirma.miniapplet.HttpIPostListener;
import es.gob.afirma.miniapplet.HttpPostAction;
import es.gob.afirma.miniapplet.HttpsDownloadAction;
import es.gob.afirma.miniapplet.HttpsIPostAction;
import es.gob.afirma.miniapplet.HttpsPostAction;
import es.gob.afirma.miniapplet.MiniAfirma;
import es.gob.afirma.miniapplet.MiniAfirmaWindow;
import es.gob.afirma.miniapplet.MiniAppletMessages;
import es.gob.afirma.miniapplet.PrintPdfAction;
import es.gob.afirma.miniapplet.SaveFileAction;
import es.gob.afirma.miniapplet.SelectPrivateKeyAction;
import es.gob.afirma.miniapplet.SelectSignerAction;
import es.gob.afirma.miniapplet.SendSoapAction;
import es.gob.afirma.miniapplet.SignAction;
import es.gob.afirma.miniapplet.distintivos.components.PrintersWindow;
import es.gob.afirma.miniapplet.distintivos.core.Printers;
import es.gob.afirma.miniapplet.distintivos.listeners.PrintersListener;
import es.gob.afirma.miniapplet.exceptions.DownloadActionException;
import java.awt.Component;
import java.awt.geom.AffineTransform;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.CookieHandler;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.CertificateEncodingException;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.UIManager;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.multipdf.PDFMergerUtility;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.PDPageTree;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.hccp.net.CookieManager;
import org.mozilla.universalchardet.UniversalDetector;

public final class MiniAfirmaApplet
extends MiniAfirmaWindow
implements MiniAfirma {
    private final StringBuilder dataStore = new StringBuilder();
    private static final String EOF = "%%EOF%%";
    private static final String DEFAULT_CHUNK_ENCODING = "ISO-8859-1";
    private static final int BUFFER_SIZE = 0x100000;
    private InputStream chunkedReturnStream;
    private KeyStore.PrivateKeyEntry stickyKeyEntry = null;
    private KeyStore.PrivateKeyEntry myKeyEntry = null;
    private boolean stickySignatory = true;
    private static final long serialVersionUID = -4364574240099120486L;
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");
    public static final String APPLET_PARAM_OPERATION = "Operation";
    public static final String APPLET_PARAM_SUB_OPERATION = "SubOperation";
    public static final String APPLET_PARAM_USER_AGENT = "UserAgent";
    public static final String APPLET_PARAM_USER_KEYSTORE = "Keystore";
    public static final String APPLET_PARAM_USER_SESSION_ID = "SessionId";
    public static final String APPLET_PARAM_USER_SESSION_NAME = "SessionName";
    public static final String APPLET_PARAM_USER_LAST_REFRESH = "LastRefresh";
    public static final String APPLET_PARAM_USER_LAST_REFRESH_NAME = "LastRefreshName";
    public static final String APPLET_PARAM_USER_ROOT = "HtmlRoot";
    public static final String APPLET_PARAM_SIGNATURE_ALGORITHM = "Algorithm";
    public static final String APPLET_PARAM_DOCUMENT_SOURCE = "Source";
    public static final String APPLET_PARAM_USER_CSRF_NAME = "CSRFName";
    public static final String APPLET_PARAM_USER_CSRF = "CSRF";
    public static final String APPLET_PARAM_GFX_BACKGROUND = "gfx.background";
    public static final String APPLET_PARAM_GFX_ICON = "gfx.icon";
    public static final String APPLET_PARAM_GFX_PROGRESS_BAR = "gfx.progressbar";
    public static final String APPLET_PARAM_GFX_TITLE = "gfx.title";
    public static final String APPLET_PARAM_ERRORS_ENABLED = "errors.enabled";
    public static final String APPLET_PARAM_FIREFOX_KEYSTORE = "firefox.keystore";
    public static final String SIGNATURE_FORMAT_AUTO = "AUTO";
    private String userAgent = null;
    private AOKeyStore keystoreType = null;
    private String keystoreLib = null;
    private String errorMessage = null;
    private String errorType = null;
    private String modeloAEAT = "";

    @Override
    public void setStickySignatory(boolean bl) {
        this.stickySignatory = bl;
        if (!bl) {
            this.stickyKeyEntry = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void main(String[] stringArray) {
        int n;
        void var4_10;
        Object object;
        try {
            for (UIManager.LookAndFeelInfo object22 : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(object22.getName())) continue;
                UIManager.setLookAndFeel(object22.getClassName());
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        CookieHandler.setDefault(null);
        String string = stringArray[0];
        Properties properties = ExtraParamsProcessor.convertToProperties(string);
        properties.list(System.out);
        String string2 = properties.getProperty(APPLET_PARAM_USER_KEYSTORE);
        String string3 = properties.getProperty(APPLET_PARAM_USER_AGENT);
        String string4 = properties.getProperty(APPLET_PARAM_OPERATION);
        String string5 = properties.getProperty(APPLET_PARAM_ERRORS_ENABLED);
        MiniAfirmaApplet miniAfirmaApplet = new MiniAfirmaApplet();
        miniAfirmaApplet.enableErrors = string5 != null && string5.toLowerCase().equals("true");
        String string6 = properties.getProperty(APPLET_PARAM_GFX_BACKGROUND);
        String string7 = properties.getProperty(APPLET_PARAM_GFX_ICON);
        String string8 = properties.getProperty(APPLET_PARAM_GFX_PROGRESS_BAR);
        String string9 = properties.getProperty(APPLET_PARAM_GFX_TITLE);
        if (string6 != null && string6.length() > 0) {
            miniAfirmaApplet.setBackgroundB64(string6);
        }
        if (string7 != null && string7.length() > 0) {
            miniAfirmaApplet.setTrayIconB64(string7);
        }
        if (string8 != null && string8.length() > 0 && ((String[])(object = string8.split(","))).length >= 4) {
            try {
                miniAfirmaApplet.setProgressBarBounds(Integer.parseInt((String)object[0]), Integer.parseInt((String)object[1]), Integer.parseInt((String)object[2]), Integer.parseInt((String)object[3]));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (string3.toLowerCase().contains("firefox") && (object = properties.getProperty(APPLET_PARAM_FIREFOX_KEYSTORE)) != null && !((String)object).isEmpty()) {
            Object object2 = object;
        }
        System.out.println("UserAgent KeyStore: " + (String)var4_10);
        miniAfirmaApplet.open();
        miniAfirmaApplet.init(string2, (String)var4_10);
        int n2 = 1;
        int n3 = 0;
        do {
            n = Integer.parseInt(stringArray[n2]);
            ++n3;
        } while ((n2 = n2 + n + 2) < stringArray.length);
        System.setProperty("https.protocols", "TLSv1.2,TLSv1.1,TLSv1");
        if (string4.equals("PrintDistintivos")) {
            miniAfirmaApplet.setTitle("Impresi\u00f3n de Distintivos");
            miniAfirmaApplet.setProgress(-1);
            try {
                Printers.instance().configure(string, miniAfirmaApplet.selectPrivateKey(properties));
            }
            catch (PrivilegedActionException printersWindow) {
                Logger.getLogger(MiniAfirmaApplet.class.getName()).log(Level.SEVERE, null, printersWindow);
            }
            catch (UnsupportedEncodingException string92) {
                Logger.getLogger(MiniAfirmaApplet.class.getName()).log(Level.SEVERE, null, string92);
            }
            catch (IOException printPdfAction) {
                Logger.getLogger(MiniAfirmaApplet.class.getName()).log(Level.SEVERE, null, printPdfAction);
            }
            for (n2 = 1; n2 < stringArray.length; n2 += 4) {
                Printers.instance().addJob(stringArray[n2 + 1], stringArray[n2 + 2]);
            }
            final PrintersWindow printersWindow = new PrintersWindow();
            Printers.instance().addListener(new PrintersListener(){

                @Override
                public void endJobs() {
                    printersWindow.close();
                }
            });
            printersWindow.start();
        } else if (string4.equals("PrintPDF")) {
            miniAfirmaApplet.setTitle("Imprimiendo PDFs");
            if (string9 == null) {
                string9 = n3 > 1 ? "IMPRIMIENDO DOCUMENTOS (%index / %size)" : "IMPRIMIENDO DOCUMENTO";
            }
            miniAfirmaApplet.startProcess(n3, string9);
            String privilegedActionException = null;
            for (n2 = 1; n2 < stringArray.length; n2 += 3) {
                privilegedActionException = miniAfirmaApplet.printPDF(stringArray[n2 + 1], string, privilegedActionException);
            }
            File privilegedActionException2 = new File(privilegedActionException);
            if (privilegedActionException2.exists() && miniAfirmaApplet.isValidPDF(privilegedActionException2)) {
                PrintPdfAction privilegedActionException3 = new PrintPdfAction(false);
                privilegedActionException3.setFile(privilegedActionException2);
                try {
                    AccessController.doPrivileged(privilegedActionException3);
                }
                catch (PrivilegedActionException privilegedActionException4) {
                    Logger.getLogger(MiniAfirmaApplet.class.getName()).log(Level.SEVERE, null, privilegedActionException4);
                }
            }
        } else if (string4.equals("PrintInstantPDF")) {
            miniAfirmaApplet.setTitle("Imprimiendo PDFs");
            if (string9 == null) {
                string9 = n3 > 1 ? "IMPRIMIENDO DOCUMENTOS (%index / %size)" : "IMPRIMIENDO DOCUMENTO";
            }
            miniAfirmaApplet.startProcess(n3, string9);
            PrintPdfAction iOException = new PrintPdfAction(true);
            String iOException2 = null;
            for (n2 = 1; n2 < stringArray.length; n2 += 3) {
                try {
                    iOException2 = miniAfirmaApplet.downloadPDF(stringArray[n2 + 1], string);
                    File file = new File(iOException2);
                    if (!file.exists() || !miniAfirmaApplet.isValidPDF(file)) continue;
                    iOException.setFile(file);
                    AccessController.doPrivileged(iOException);
                    continue;
                }
                catch (DownloadActionException downloadActionException) {
                    miniAfirmaApplet.addError(downloadActionException.getMessage());
                    continue;
                }
                catch (PrivilegedActionException privilegedActionException) {
                    Logger.getLogger(MiniAfirmaApplet.class.getName()).log(Level.SEVERE, null, privilegedActionException);
                }
            }
        } else if (string4.equals("AEAT")) {
            miniAfirmaApplet.setTitle("AEAT");
            if (string9 == null) {
                string9 = n3 > 1 ? "Obteniendo datos (%index / %size)" : "Obteniendo datos";
            }
            miniAfirmaApplet.startProcess(n3, string9);
            for (n2 = 1; n2 < stringArray.length; n2 += 3) {
                try {
                    if (string.contains("aeat=NRE")) {
                        miniAfirmaApplet.getNRE(stringArray[n2 + 1], stringArray[n2 + 2], string);
                        continue;
                    }
                    if (string.contains("aeat=CEM")) {
                        miniAfirmaApplet.getCEM(stringArray[n2 + 1], stringArray[n2 + 2], string);
                        continue;
                    }
                    System.out.println("operaci\u00f3n aeat desconocida...");
                    continue;
                }
                catch (PrivilegedActionException stringArray2) {
                    Logger.getLogger(MiniAfirmaApplet.class.getName()).log(Level.SEVERE, null, stringArray2);
                    continue;
                }
                catch (IOException iOException) {
                    Logger.getLogger(MiniAfirmaApplet.class.getName()).log(Level.SEVERE, null, iOException);
                    continue;
                }
                catch (AOException aOException) {
                    Logger.getLogger(MiniAfirmaApplet.class.getName()).log(Level.SEVERE, null, aOException);
                }
            }
        } else if (string4.equals("XAdES") || string4.equals("PAdES") || string4.equals("CMS/PKCS#7") || string4.equals("CAdES")) {
            miniAfirmaApplet.setTitle("Firmando");
            if (string9 == null) {
                string9 = n3 > 1 ? "FIRMANDO DOCUMENTOS (%index / %size)" : "FIRMANDO DOCUMENTO";
            }
            miniAfirmaApplet.startProcess(n3, string9);
            n2 = 1;
            do {
                n = Integer.parseInt(stringArray[n2]);
                String[] stringArray2 = new String[n];
                for (int aOException = 0; aOException < n; ++aOException) {
                    stringArray2[aOException] = stringArray[n2 + 1 + aOException];
                }
                try {
                    miniAfirmaApplet.signAndPost(stringArray2, stringArray[n2 + n + 1], string);
                }
                catch (PrivilegedActionException privilegedActionException) {
                    Logger.getLogger(MiniAfirmaApplet.class.getName()).log(Level.SEVERE, null, privilegedActionException);
                }
                catch (IOException iOException) {
                    Logger.getLogger(MiniAfirmaApplet.class.getName()).log(Level.SEVERE, null, iOException);
                }
                catch (AOException aOException) {
                    Logger.getLogger(MiniAfirmaApplet.class.getName()).log(Level.SEVERE, null, aOException);
                }
            } while ((n2 += n + 2) < stringArray.length);
        } else if (string4.equals("INTEVE")) {
            n3 *= 3;
            if (string9 == null) {
                string9 = "OBTENIENDO INFORME (%index / %size)";
            }
            miniAfirmaApplet.startProcess(n3, string9);
            for (n2 = 1; n2 < stringArray.length; n2 += 3) {
                miniAfirmaApplet.getReportAndPost(stringArray[n2 + 1], stringArray[n2 + 2], properties);
            }
        }
        miniAfirmaApplet.destroy();
    }

    public boolean isValidPDF(File file) {
        try {
            PDDocument pDDocument = PDDocument.load(file);
            PDPageTree pDPageTree = pDDocument.getDocumentCatalog().getPages();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void logger(Exception exception) {
        Logger.getLogger(MiniAfirmaApplet.class.getName()).log(Level.SEVERE, null, exception);
        this.addError("Se produjo un error durante el proceso.", true);
    }

    public void getReportAndPost(String string, String string2, Properties properties) {
        try {
            if (properties.getProperty("ssl") != null) {
                properties.setProperty("filter", properties.getProperty("ssl"));
            } else {
                properties.setProperty("filter", "issuer.contains:FNMT");
            }
            KeyStore.PrivateKeyEntry privateKeyEntry = this.selectPrivateKey(properties);
            DescargaInformeAction descargaInformeAction = new DescargaInformeAction(privateKeyEntry, string, properties.getProperty(APPLET_PARAM_USER_AGENT), this);
            Integer n = AccessController.doPrivileged(descargaInformeAction);
            String string3 = descargaInformeAction.getB64Document();
            this.stickySignatory = false;
            properties.setProperty("filter", properties.getProperty("https"));
            privateKeyEntry = this.selectPrivateKey(properties);
            HttpPostAction httpPostAction = string2.startsWith("https") ? new HttpsPostAction(privateKeyEntry) : new HttpPostAction();
            httpPostAction.setConnection(string2, properties.getProperty(APPLET_PARAM_USER_SESSION_NAME), properties.getProperty(APPLET_PARAM_USER_SESSION_ID), properties.getProperty(APPLET_PARAM_USER_AGENT), properties.getProperty(APPLET_PARAM_USER_CSRF), properties.getProperty(APPLET_PARAM_OPERATION), properties.getProperty(APPLET_PARAM_USER_ROOT), properties.getProperty(APPLET_PARAM_USER_LAST_REFRESH), properties.getProperty(APPLET_PARAM_USER_LAST_REFRESH_NAME));
            if (n == 0) {
                httpPostAction.addDocAndSignature(string3, "");
            } else {
                httpPostAction.addDocAndSignature("", descargaInformeAction.getB64ConsoleLog());
            }
            httpPostAction.setStatus(n.toString());
            httpPostAction.setStatusError(DescargaInformeAction.getErrorTextFromStatus(n));
            httpPostAction.addPostAction(new Runnable(){

                @Override
                public void run() {
                    MiniAfirmaApplet.this.nextElement();
                }
            });
            AccessController.doPrivileged(httpPostAction);
        }
        catch (PrivilegedActionException privilegedActionException) {
            Logger.getLogger(MiniAfirmaApplet.class.getName()).log(Level.SEVERE, null, privilegedActionException);
        }
        catch (IOException iOException) {
            Logger.getLogger(MiniAfirmaApplet.class.getName()).log(Level.SEVERE, null, iOException);
        }
    }

    public String printPDF(String string, String string2, String string3) {
        try {
            String string4 = this.downloadPDF(string, string2);
            if (string3 == null) {
                string3 = string4;
            } else {
                try {
                    PDFMergerUtility pDFMergerUtility = new PDFMergerUtility();
                    pDFMergerUtility.addSource(string3);
                    pDFMergerUtility.addSource(string4);
                    string3 = System.getProperty("user.home") + System.getProperty("file.separator") + ".downloads" + System.getProperty("file.separator") + UUID.randomUUID().toString() + ".pdf";
                    pDFMergerUtility.setDestinationFileName(string3);
                    pDFMergerUtility.mergeDocuments();
                }
                catch (FileNotFoundException fileNotFoundException) {
                    Logger.getLogger(MiniAfirmaApplet.class.getName()).log(Level.SEVERE, null, fileNotFoundException);
                }
                catch (IOException iOException) {
                    Logger.getLogger(MiniAfirmaApplet.class.getName()).log(Level.SEVERE, null, iOException);
                }
            }
        }
        catch (DownloadActionException downloadActionException) {
            this.addError(downloadActionException.getMessage());
        }
        this.nextElement();
        return string3;
    }

    public String downloadPDF(String string, String string2) throws DownloadActionException {
        Properties properties = ExtraParamsProcessor.convertToProperties(string2);
        String string3 = System.getProperty("user.home") + System.getProperty("file.separator") + ".downloads" + System.getProperty("file.separator") + UUID.randomUUID().toString() + ".pdf";
        File file = new File(string3);
        properties.setProperty("filter", properties.getProperty("https"));
        try {
            HttpDownloadAction httpDownloadAction;
            if (string.startsWith("https")) {
                KeyStore.PrivateKeyEntry privateKeyEntry = this.selectPrivateKey(properties);
                httpDownloadAction = new HttpsDownloadAction(privateKeyEntry);
            } else {
                httpDownloadAction = new HttpDownloadAction();
            }
            httpDownloadAction.setConnection(string, properties.getProperty(APPLET_PARAM_USER_SESSION_NAME), properties.getProperty(APPLET_PARAM_USER_SESSION_ID), properties.getProperty(APPLET_PARAM_USER_AGENT), properties.getProperty(APPLET_PARAM_USER_LAST_REFRESH), properties.getProperty(APPLET_PARAM_USER_LAST_REFRESH_NAME));
            httpDownloadAction.setFile(file);
            AccessController.doPrivileged(httpDownloadAction);
            if (properties.getProperty("pdfbox.rotation") != null && !properties.getProperty("pdfbox.rotation").isEmpty() || properties.getProperty("pdfbox.scale") != null && !properties.getProperty("pdfbox.scale").isEmpty() || properties.getProperty("pdfbox.offsetX") != null && !properties.getProperty("pdfbox.offsetX").isEmpty() || properties.getProperty("pdfbox.offsetY") != null && !properties.getProperty("pdfbox.offsetY").isEmpty() || properties.getProperty("pdfbox.paper") != null && !properties.getProperty("pdfbox.paper").isEmpty()) {
                int n = properties.getProperty("pdfbox.offsetX") != null && properties.getProperty("pdfbox.offsetX").isEmpty() ? 0 : Integer.parseInt(properties.getProperty("pdfbox.offsetX"));
                int n2 = properties.getProperty("pdfbox.offsetY") != null && properties.getProperty("pdfbox.offsetY").isEmpty() ? 0 : Integer.parseInt(properties.getProperty("pdfbox.offsetY"));
                float f = properties.getProperty("pdfbox.scale") != null && properties.getProperty("pdfbox.scale").isEmpty() ? 1.0f : Float.parseFloat(properties.getProperty("pdfbox.scale"));
                int n3 = properties.getProperty("pdfbox.rotation") != null && properties.getProperty("pdfbox.rotation").isEmpty() ? 0 : Integer.parseInt(properties.getProperty("pdfbox.rotation"));
                String string4 = properties.getProperty("pdfbox.paper");
                PDDocument pDDocument = new PDDocument();
                PDPage pDPage = new PDPage();
                if (string4 == null) {
                    pDPage.setCropBox(PDRectangle.A4);
                } else if (string4.equals("A0")) {
                    pDPage.setCropBox(PDRectangle.A0);
                } else if (string4.equals("A1")) {
                    pDPage.setCropBox(PDRectangle.A1);
                } else if (string4.equals("A2")) {
                    pDPage.setCropBox(PDRectangle.A2);
                } else if (string4.equals("A3")) {
                    pDPage.setCropBox(PDRectangle.A3);
                } else if (string4.equals("A4")) {
                    pDPage.setCropBox(PDRectangle.A4);
                } else if (string4.equals("A5")) {
                    pDPage.setCropBox(PDRectangle.A5);
                } else if (string4.equals("A6")) {
                    pDPage.setCropBox(PDRectangle.A6);
                } else if (string4.equals("LETTER")) {
                    pDPage.setCropBox(PDRectangle.LETTER);
                } else if (string4.equals("LEGAL")) {
                    pDPage.setCropBox(PDRectangle.LEGAL);
                } else {
                    pDPage.setCropBox(PDRectangle.A4);
                }
                PDDocument pDDocument2 = PDDocument.load(file);
                PDPageTree pDPageTree = pDDocument2.getDocumentCatalog().getPages();
                pDPage.setRotation(n3);
                pDDocument.addPage(pDPage);
                PDFormXObject pDFormXObject = MiniAfirmaApplet.importAsXObject(pDDocument, pDPageTree.get(0));
                pDPage.setResources(pDPageTree.get(0).getResources());
                pDPage.getResources().add(pDFormXObject, "X");
                PDPageContentStream pDPageContentStream = new PDPageContentStream(pDDocument, pDPage);
                pDFormXObject.setMatrix(new AffineTransform(f, 0.0f, 0.0f, f, n, n2));
                pDPageContentStream.drawForm(pDFormXObject);
                pDPageContentStream.close();
                pDDocument.save(file);
                pDDocument.close();
                pDDocument2.close();
            }
        }
        catch (PrivilegedActionException privilegedActionException) {
            if (privilegedActionException.getException() instanceof DownloadActionException) {
                this.addError(privilegedActionException.getException().getMessage());
            }
            Logger.getLogger(MiniAfirmaApplet.class.getName()).log(Level.SEVERE, null, privilegedActionException);
        }
        catch (IOException iOException) {
            this.addError("Ha ocurrido un error en la descarga del fichero");
            Logger.getLogger(MiniAfirmaApplet.class.getName()).log(Level.SEVERE, null, iOException);
        }
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static PDFormXObject importAsXObject(PDDocument pDDocument, PDPage pDPage) throws IOException {
        InputStream inputStream = pDPage.getContents();
        if (inputStream != null) {
            PDFormXObject pDFormXObject = new PDFormXObject(pDDocument);
            OutputStream outputStream = pDFormXObject.getPDStream().createOutputStream();
            try {
                IOUtils.copy(inputStream, outputStream);
            }
            finally {
                IOUtils.closeQuietly(inputStream);
                IOUtils.closeQuietly(outputStream);
            }
            pDFormXObject.setResources(pDPage.getResources());
            pDFormXObject.setBBox(pDPage.getCropBox());
            return pDFormXObject;
        }
        return null;
    }

    public String sendSOAP(String string, String string2, String string3) throws PrivilegedActionException, IOException, AOException {
        String string4 = this.sign(string, string2, string3);
        SendSoapAction sendSoapAction = new SendSoapAction(this.stickyKeyEntry);
        sendSoapAction.setPayload(string4);
        AccessController.doPrivileged(sendSoapAction);
        return "";
    }

    public String[] signAndPost(String[] stringArray, String string, String string2) throws PrivilegedActionException, IOException, AOException {
        Properties properties = ExtraParamsProcessor.convertToProperties(string2);
        String[] stringArray2 = new String[stringArray.length];
        try {
            HttpPostAction httpPostAction;
            Object object;
            properties.setProperty("filter", properties.getProperty("https"));
            if (string.startsWith("https")) {
                object = this.selectPrivateKey(properties);
                httpPostAction = new HttpsPostAction((KeyStore.PrivateKeyEntry)object);
            } else {
                httpPostAction = new HttpPostAction();
            }
            object = Base64.encode(this.myKeyEntry.getCertificate().getEncoded());
            httpPostAction.setConnection(string, properties.getProperty(APPLET_PARAM_USER_SESSION_NAME), properties.getProperty(APPLET_PARAM_USER_SESSION_ID), properties.getProperty(APPLET_PARAM_USER_AGENT), properties.getProperty(APPLET_PARAM_USER_CSRF), properties.getProperty(APPLET_PARAM_OPERATION), properties.getProperty(APPLET_PARAM_USER_ROOT), properties.getProperty(APPLET_PARAM_USER_LAST_REFRESH), properties.getProperty(APPLET_PARAM_USER_LAST_REFRESH_NAME));
            httpPostAction.setSubAction(properties.getProperty(APPLET_PARAM_SUB_OPERATION));
            String string3 = properties.getProperty(APPLET_PARAM_USER_CSRF_NAME);
            if (string3 != null && !string3.isEmpty()) {
                httpPostAction.setCsrfName(string3);
            }
            httpPostAction.setCert((String)object);
            httpPostAction.setStatus("0");
            httpPostAction.setStatusError("");
            httpPostAction.addPostAction(new Runnable(){

                @Override
                public void run() {
                    MiniAfirmaApplet.this.nextElement();
                }
            });
            for (int i = 0; i < stringArray.length; ++i) {
                Object object2;
                String string4 = null;
                String string5 = properties.getProperty(APPLET_PARAM_DOCUMENT_SOURCE);
                if (string5 == null || string5.equals("URL")) {
                    System.out.println("SOURCE URL: " + string5);
                    try {
                        HttpDownloadAction httpDownloadAction;
                        properties.setProperty("filter", properties.getProperty("https"));
                        if (stringArray[i].startsWith("https")) {
                            object2 = this.selectPrivateKey(properties);
                            httpDownloadAction = new HttpsDownloadAction((KeyStore.PrivateKeyEntry)object2);
                        } else {
                            httpDownloadAction = new HttpDownloadAction();
                        }
                        object2 = new ByteArrayOutputStream();
                        httpDownloadAction.setConnection(stringArray[i], properties.getProperty(APPLET_PARAM_USER_SESSION_NAME), properties.getProperty(APPLET_PARAM_USER_SESSION_ID), properties.getProperty(APPLET_PARAM_USER_AGENT), properties.getProperty(APPLET_PARAM_USER_LAST_REFRESH), properties.getProperty(APPLET_PARAM_USER_LAST_REFRESH_NAME));
                        httpDownloadAction.setOutputStream((OutputStream)object2);
                        AccessController.doPrivileged(httpDownloadAction);
                        string4 = ((ByteArrayOutputStream)object2).toString();
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        Logger.getLogger(MiniAfirmaApplet.class.getName()).log(Level.SEVERE, null, privilegedActionException);
                    }
                    catch (IOException iOException) {
                        Logger.getLogger(MiniAfirmaApplet.class.getName()).log(Level.SEVERE, null, iOException);
                    }
                } else if (string5.equals("FILE")) {
                    System.out.println("SOURCE URL: " + string5);
                    object2 = new JFileChooser();
                    ((JFileChooser)object2).setFileFilter(new FileNameExtensionFilter("Ficheros PDF", "pdf", "pdf"));
                    int n = ((JFileChooser)object2).showOpenDialog(this);
                    if (n == 0) {
                        try {
                            byte[] byArray = Files.readAllBytes(((JFileChooser)object2).getSelectedFile().toPath());
                            string4 = Base64.encode(byArray);
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            System.out.println("File not found" + fileNotFoundException);
                        }
                        catch (IOException iOException) {
                            System.out.println("Exception while reading the file " + iOException);
                        }
                    } else {
                        System.exit(-1);
                    }
                } else {
                    System.out.println("SOURCE BASE64 XML: " + string5);
                    string4 = stringArray[i];
                }
                this.dataStore.delete(0, this.dataStore.length());
                this.dataStore.setLength(0);
                this.dataStore.append(string4);
                stringArray2[i] = this.sign(properties.getProperty(APPLET_PARAM_SIGNATURE_ALGORITHM), properties.getProperty(APPLET_PARAM_OPERATION), string2);
                httpPostAction.addDocAndSignature(string4, stringArray2[i]);
            }
            AccessController.doPrivileged(httpPostAction);
        }
        catch (PrivilegedActionException privilegedActionException) {
            Logger.getLogger(MiniAfirmaApplet.class.getName()).log(Level.SEVERE, null, privilegedActionException);
        }
        catch (CertificateEncodingException certificateEncodingException) {
            Logger.getLogger(MiniAfirmaApplet.class.getName()).log(Level.SEVERE, null, certificateEncodingException);
        }
        catch (IOException iOException) {
            Logger.getLogger(MiniAfirmaApplet.class.getName()).log(Level.SEVERE, null, iOException);
        }
        return stringArray2;
    }

    public void setModeloAEAT(String string) {
        this.modeloAEAT = string;
    }

    public String getModeloAEAT() {
        return this.modeloAEAT;
    }

    public void getCEM(String string, String string2, String string3) throws PrivilegedActionException, IOException, AOException {
        final Properties properties = ExtraParamsProcessor.convertToProperties(string3);
        Object var9_5 = null;
        KeyStore.PrivateKeyEntry privateKeyEntry = null;
        final CookieManager cookieManager = new CookieManager();
        try {
            HttpIPostAction httpIPostAction;
            HttpIPostAction httpIPostAction2;
            HttpIPostAction httpIPostAction3;
            HttpIPostAction httpIPostAction4;
            if (string.startsWith("https")) {
                this.stickySignatory = false;
                privateKeyEntry = this.selectPrivateKey(properties);
                httpIPostAction4 = new HttpsIPostAction(privateKeyEntry);
                httpIPostAction3 = new HttpsIPostAction(privateKeyEntry);
                properties.setProperty("filter", properties.getProperty("https"));
                privateKeyEntry = this.selectPrivateKey(properties);
                httpIPostAction2 = new HttpsIPostAction(privateKeyEntry);
                httpIPostAction = new HttpsIPostAction(privateKeyEntry);
            } else {
                httpIPostAction2 = new HttpIPostAction();
                httpIPostAction4 = new HttpIPostAction();
                httpIPostAction3 = new HttpIPostAction();
                httpIPostAction = new HttpIPostAction();
            }
            final String string4 = string2;
            System.out.println("1. URL source: " + string);
            httpIPostAction2.setConnection(string, properties.getProperty(APPLET_PARAM_USER_SESSION_NAME), properties.getProperty(APPLET_PARAM_USER_SESSION_ID), properties.getProperty(APPLET_PARAM_USER_AGENT), properties.getProperty(APPLET_PARAM_USER_LAST_REFRESH), properties.getProperty(APPLET_PARAM_USER_LAST_REFRESH_NAME));
            httpIPostAction2.addPostAction(new HttpIPostListener(){

                @Override
                public boolean code(URLConnection uRLConnection, int n) {
                    if (n == 500) {
                        MiniAfirmaApplet.this.addError("Thempus: Respuesta con errores.");
                        MiniAfirmaApplet.this.nextElement();
                        return false;
                    }
                    return true;
                }

                @Override
                public void recv(String string) {
                    try {
                        String string2 = string;
                        System.out.println("2. Obteniendo URL AEAT y POST");
                        String string3 = "";
                        String string42 = "";
                        String string5 = "";
                        int n = string2.indexOf("@|@");
                        if (n >= 0) {
                            string3 = string2.substring(0, n);
                            string5 = string2.substring(n + 3, n + 6);
                            MiniAfirmaApplet.this.setModeloAEAT(string5);
                            string42 = string2.substring(n + 6);
                        }
                        if (string3.isEmpty() || string42.isEmpty()) {
                            MiniAfirmaApplet.this.addError("No se recibieron los datos desde el servidor.");
                            MiniAfirmaApplet.this.nextElement();
                            return;
                        }
                        System.out.println("urlAEAT: " + string3);
                        System.out.println("modeloAEAT: " + MiniAfirmaApplet.this.getModeloAEAT());
                        System.out.println("3. Obteniendo Cookies");
                        httpIPostAction4.setConnection(string3);
                        httpIPostAction3.addPostAction(new HttpIPostListener(){

                            @Override
                            public void beforeSend(URLConnection uRLConnection) {
                                uRLConnection.setRequestProperty("Content-Type", "text/html");
                            }

                            @Override
                            public void afterSend(URLConnection uRLConnection) {
                                try {
                                    cookieManager.storeCookies(uRLConnection);
                                }
                                catch (IOException iOException) {
                                    MiniAfirmaApplet.this.logger(iOException);
                                }
                            }
                        });
                        System.out.println("4. Enviando POST a la AEAT: " + string3);
                        httpIPostAction3.setConnection(string3);
                        httpIPostAction3.setPost(string42);
                        httpIPostAction3.addPostAction(new HttpIPostListener(){

                            @Override
                            public boolean code(URLConnection uRLConnection, int n) {
                                if (n == 500) {
                                    MiniAfirmaApplet.this.addError("AEAT: Respuesta con errores.");
                                    MiniAfirmaApplet.this.nextElement();
                                    return false;
                                }
                                return true;
                            }

                            @Override
                            public void beforeSend(URLConnection uRLConnection) {
                                ((HttpURLConnection)uRLConnection).setInstanceFollowRedirects(true);
                                uRLConnection.setRequestProperty("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8");
                                uRLConnection.setRequestProperty("Accept-Encoding", "gzip, deflate");
                                uRLConnection.setRequestProperty("Accept-Language", "es-ES,es;q=0.8,en-US;q=0.5,en;q=0.3");
                                uRLConnection.setRequestProperty("Connection", "Keep-Alive");
                                String string = MiniAfirmaApplet.this.getModeloAEAT();
                                if (string.equals("576") || string.equals("005")) {
                                    uRLConnection.setRequestProperty("Content-Type", "application/json;charset=UTF-8");
                                } else {
                                    uRLConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                                }
                                uRLConnection.setRequestProperty("Host", "www1.agenciatributaria.gob.es");
                                uRLConnection.setRequestProperty("User-Agent", properties.getProperty(MiniAfirmaApplet.APPLET_PARAM_USER_AGENT));
                                try {
                                    cookieManager.setCookies(uRLConnection);
                                }
                                catch (IOException iOException) {
                                    MiniAfirmaApplet.this.logger(iOException);
                                }
                            }

                            @Override
                            public void recv(String string) {
                                try {
                                    System.out.println("5. Enviando respuesta a Thempus: " + string4);
                                    String string2 = new String(string.getBytes(Charset.forName("Windows-1252")), Charset.forName("UTF-8"));
                                    String string3 = MiniAfirmaApplet.this.getModeloAEAT();
                                    if (string3.equals("576") || string3.equals("005")) {
                                        string = string2;
                                    }
                                    String string4 = "data=" + URLEncoder.encode(string, "UTF-8");
                                    String string5 = properties.getProperty(MiniAfirmaApplet.APPLET_PARAM_OPERATION);
                                    String string6 = properties.getProperty(MiniAfirmaApplet.APPLET_PARAM_USER_CSRF);
                                    String string7 = properties.getProperty("aeat");
                                    if (string5 != null && !string5.equals("")) {
                                        string4 = string4 + "&oak_action=" + string5;
                                    }
                                    if (string6 != null && !string6.equals("")) {
                                        string4 = string4 + "&oak_csrf_token=" + string6;
                                    }
                                    if (string7 != null && !string7.equals("")) {
                                        string4 = string4 + "&aeat=" + string7;
                                    }
                                    httpIPostAction.setConnection(string4, properties.getProperty(MiniAfirmaApplet.APPLET_PARAM_USER_SESSION_NAME), properties.getProperty(MiniAfirmaApplet.APPLET_PARAM_USER_SESSION_ID), properties.getProperty(MiniAfirmaApplet.APPLET_PARAM_USER_AGENT), properties.getProperty(MiniAfirmaApplet.APPLET_PARAM_USER_ROOT), properties.getProperty(MiniAfirmaApplet.APPLET_PARAM_USER_LAST_REFRESH), properties.getProperty(MiniAfirmaApplet.APPLET_PARAM_USER_LAST_REFRESH_NAME));
                                    httpIPostAction.setPost(string4);
                                    httpIPostAction.addPostAction(new HttpIPostListener(){

                                        @Override
                                        public boolean code(URLConnection uRLConnection, int n) {
                                            if (n == 500) {
                                                MiniAfirmaApplet.this.addError("Se produjo un error al guardar el CEM.");
                                                MiniAfirmaApplet.this.nextElement();
                                                return false;
                                            }
                                            return true;
                                        }

                                        @Override
                                        public void recv(String string) {
                                            System.out.println("recv: " + string);
                                            if (!string.isEmpty()) {
                                                String[] stringArray;
                                                for (String string2 : stringArray = string.split("\n")) {
                                                    MiniAfirmaApplet.this.addError(string2);
                                                }
                                            }
                                            MiniAfirmaApplet.this.nextElement();
                                        }
                                    });
                                    AccessController.doPrivileged(httpIPostAction);
                                }
                                catch (UnsupportedEncodingException unsupportedEncodingException) {
                                    MiniAfirmaApplet.this.logger(unsupportedEncodingException);
                                }
                                catch (IOException iOException) {
                                    MiniAfirmaApplet.this.logger(iOException);
                                }
                                catch (PrivilegedActionException privilegedActionException) {
                                    MiniAfirmaApplet.this.logger(privilegedActionException);
                                }
                            }
                        });
                        AccessController.doPrivileged(httpIPostAction3);
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        MiniAfirmaApplet.this.logger(privilegedActionException);
                    }
                    catch (IOException iOException) {
                        MiniAfirmaApplet.this.logger(iOException);
                    }
                }
            });
            AccessController.doPrivileged(httpIPostAction2);
        }
        catch (PrivilegedActionException privilegedActionException) {
            this.logger(privilegedActionException);
        }
        catch (IOException iOException) {
            this.logger(iOException);
        }
    }

    public void getNRE(String string, String string2, String string3) throws PrivilegedActionException, IOException, AOException {
        System.out.println("getNRE()");
        final Properties properties = ExtraParamsProcessor.convertToProperties(string3);
        Object var9_5 = null;
        KeyStore.PrivateKeyEntry privateKeyEntry = null;
        final CookieManager cookieManager = new CookieManager();
        try {
            HttpIPostAction httpIPostAction;
            HttpIPostAction httpIPostAction2;
            HttpIPostAction httpIPostAction3;
            HttpIPostAction httpIPostAction4;
            if (string.startsWith("https")) {
                this.stickySignatory = false;
                privateKeyEntry = this.selectPrivateKey(properties);
                httpIPostAction4 = new HttpsIPostAction(privateKeyEntry);
                httpIPostAction3 = new HttpsIPostAction(privateKeyEntry);
                properties.setProperty("filter", properties.getProperty("https"));
                privateKeyEntry = this.selectPrivateKey(properties);
                httpIPostAction2 = new HttpsIPostAction(privateKeyEntry);
                httpIPostAction = new HttpsIPostAction(privateKeyEntry);
            } else {
                httpIPostAction2 = new HttpIPostAction();
                httpIPostAction4 = new HttpIPostAction();
                httpIPostAction3 = new HttpIPostAction();
                httpIPostAction = new HttpIPostAction();
            }
            final String string4 = string2;
            System.out.println("1. URL source: " + string);
            httpIPostAction2.setConnection(string, properties.getProperty(APPLET_PARAM_USER_SESSION_NAME), properties.getProperty(APPLET_PARAM_USER_SESSION_ID), properties.getProperty(APPLET_PARAM_USER_AGENT), properties.getProperty(APPLET_PARAM_USER_LAST_REFRESH), properties.getProperty(APPLET_PARAM_USER_LAST_REFRESH_NAME));
            httpIPostAction2.addPostAction(new HttpIPostListener(){

                @Override
                public boolean code(URLConnection uRLConnection, int n) {
                    if (n == 500) {
                        MiniAfirmaApplet.this.addError("Thempus: Respuesta con errores.");
                        MiniAfirmaApplet.this.nextElement();
                        return false;
                    }
                    return true;
                }

                @Override
                public void recv(String string) {
                    try {
                        String string2 = string;
                        System.out.println("2. Obteniendo URL AEAT y POST");
                        String string3 = "";
                        String string42 = "";
                        int n = string2.indexOf("@|@");
                        if (n >= 0) {
                            string3 = string2.substring(0, n);
                            string42 = string2.substring(n + 3);
                        }
                        if (string3.isEmpty() || string42.isEmpty()) {
                            MiniAfirmaApplet.this.addError("No se recibieron los datos desde el servidor.");
                            MiniAfirmaApplet.this.nextElement();
                            return;
                        }
                        System.out.println("3. Obteniendo Cookies");
                        httpIPostAction4.setConnection(string3);
                        httpIPostAction3.addPostAction(new HttpIPostListener(){

                            @Override
                            public void beforeSend(URLConnection uRLConnection) {
                                uRLConnection.setRequestProperty("Content-Type", "text/html");
                            }

                            @Override
                            public void afterSend(URLConnection uRLConnection) {
                                try {
                                    cookieManager.storeCookies(uRLConnection);
                                }
                                catch (IOException iOException) {
                                    MiniAfirmaApplet.this.logger(iOException);
                                }
                            }
                        });
                        System.out.println("4. Enviando POST a la AEAT: " + string3);
                        httpIPostAction3.setConnection(string3);
                        httpIPostAction3.setPost(string42);
                        httpIPostAction3.addPostAction(new HttpIPostListener(){

                            @Override
                            public boolean code(URLConnection uRLConnection, int n) {
                                if (n == 500) {
                                    MiniAfirmaApplet.this.addError("AEAT: Respuesta con errores.");
                                    MiniAfirmaApplet.this.nextElement();
                                    return false;
                                }
                                return true;
                            }

                            @Override
                            public void beforeSend(URLConnection uRLConnection) {
                                ((HttpURLConnection)uRLConnection).setInstanceFollowRedirects(true);
                                uRLConnection.setRequestProperty("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8");
                                uRLConnection.setRequestProperty("Accept-Encoding", "gzip, deflate");
                                uRLConnection.setRequestProperty("Accept-Language", "es-ES,es;q=0.8,en-US;q=0.5,en;q=0.3");
                                uRLConnection.setRequestProperty("Connection", "Keep-Alive");
                                uRLConnection.setRequestProperty("Content-Type", "application/json;charset=UTF-8");
                                uRLConnection.setRequestProperty("Host", "www1.agenciatributaria.gob.es");
                                uRLConnection.setRequestProperty("User-Agent", properties.getProperty(MiniAfirmaApplet.APPLET_PARAM_USER_AGENT));
                                try {
                                    cookieManager.setCookies(uRLConnection);
                                }
                                catch (IOException iOException) {
                                    MiniAfirmaApplet.this.logger(iOException);
                                }
                            }

                            @Override
                            public void recv(String string) {
                                try {
                                    String string2;
                                    System.out.println("5. Enviando respuesta a Thempus: " + string4);
                                    string = string2 = new String(string.getBytes(Charset.forName("Windows-1252")), Charset.forName("UTF-8"));
                                    String string3 = "data=" + URLEncoder.encode(string, "UTF-8");
                                    String string4 = properties.getProperty(MiniAfirmaApplet.APPLET_PARAM_OPERATION);
                                    String string5 = properties.getProperty(MiniAfirmaApplet.APPLET_PARAM_USER_CSRF);
                                    String string6 = properties.getProperty("aeat");
                                    if (string4 != null && !string4.equals("")) {
                                        string3 = string3 + "&oak_action=" + string4;
                                    }
                                    if (string5 != null && !string5.equals("")) {
                                        string3 = string3 + "&oak_csrf_token=" + string5;
                                    }
                                    if (string6 != null && !string6.equals("")) {
                                        string3 = string3 + "&aeat=" + string6;
                                    }
                                    httpIPostAction.setConnection(string4, properties.getProperty(MiniAfirmaApplet.APPLET_PARAM_USER_SESSION_NAME), properties.getProperty(MiniAfirmaApplet.APPLET_PARAM_USER_SESSION_ID), properties.getProperty(MiniAfirmaApplet.APPLET_PARAM_USER_AGENT), properties.getProperty(MiniAfirmaApplet.APPLET_PARAM_USER_ROOT), properties.getProperty(MiniAfirmaApplet.APPLET_PARAM_USER_LAST_REFRESH), properties.getProperty(MiniAfirmaApplet.APPLET_PARAM_USER_LAST_REFRESH_NAME));
                                    httpIPostAction.setPost(string3);
                                    httpIPostAction.addPostAction(new HttpIPostListener(){

                                        @Override
                                        public boolean code(URLConnection uRLConnection, int n) {
                                            if (n == 500) {
                                                MiniAfirmaApplet.this.addError("Se produjo un error al guardar el CEM.");
                                                MiniAfirmaApplet.this.nextElement();
                                                return false;
                                            }
                                            return true;
                                        }

                                        @Override
                                        public void recv(String string) {
                                            System.out.println("recv: " + string);
                                            if (!string.isEmpty()) {
                                                String[] stringArray;
                                                for (String string2 : stringArray = string.split("\n")) {
                                                    MiniAfirmaApplet.this.addError(string2);
                                                }
                                            }
                                            MiniAfirmaApplet.this.nextElement();
                                        }
                                    });
                                    AccessController.doPrivileged(httpIPostAction);
                                }
                                catch (UnsupportedEncodingException unsupportedEncodingException) {
                                    MiniAfirmaApplet.this.logger(unsupportedEncodingException);
                                }
                                catch (IOException iOException) {
                                    MiniAfirmaApplet.this.logger(iOException);
                                }
                                catch (PrivilegedActionException privilegedActionException) {
                                    MiniAfirmaApplet.this.logger(privilegedActionException);
                                }
                            }
                        });
                        AccessController.doPrivileged(httpIPostAction3);
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        MiniAfirmaApplet.this.logger(privilegedActionException);
                    }
                    catch (IOException iOException) {
                        MiniAfirmaApplet.this.logger(iOException);
                    }
                }
            });
            AccessController.doPrivileged(httpIPostAction2);
        }
        catch (PrivilegedActionException privilegedActionException) {
            this.logger(privilegedActionException);
        }
        catch (IOException iOException) {
            this.logger(iOException);
        }
    }

    @Override
    public String sign(String string, String string2, String string3) throws PrivilegedActionException, IOException, AOException {
        byte[] byArray;
        this.clearError();
        if (this.dataStore.length() > 0) {
            try {
                byArray = Base64.decode(this.dataStore.toString());
            }
            catch (IOException iOException) {
                this.setError(iOException, "Los datos proporcionados est\u00e1n mal codificados en base 64");
                throw iOException;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                this.setError(outOfMemoryError, "Error de falta de memoria durante la carga de los datos");
                throw outOfMemoryError;
            }
            finally {
                this.dataStore.setLength(0);
            }
        }
        try {
            byArray = AccessController.doPrivileged(new GetFileContentAction(MiniAppletMessages.getString("MiniAfirmaApplet.0"), null, MiniAppletMessages.getString("MiniAfirmaApplet.1"), this));
        }
        catch (AOCancelledOperationException aOCancelledOperationException) {
            this.setError(aOCancelledOperationException);
            throw aOCancelledOperationException;
        }
        catch (CancellationException cancellationException) {
            AOCancelledOperationException aOCancelledOperationException = new AOCancelledOperationException("Operacion cancelada por el usuario", cancellationException);
            this.setError(aOCancelledOperationException);
            throw aOCancelledOperationException;
        }
        catch (PrivilegedActionException privilegedActionException) {
            this.setError(privilegedActionException);
            throw privilegedActionException;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.setError(outOfMemoryError, "Error de falta de memoria durante la carga del fichero de datos");
            throw outOfMemoryError;
        }
        catch (Error error) {
            this.setError(error);
            throw error;
        }
        if (byArray != null && byArray.length > 0) {
            Properties properties = ExtraParamsProcessor.convertToProperties(string3);
            try {
                String string4 = string2;
                AOSigner aOSigner = MiniAfirmaApplet.selectSigner(MiniAfirmaApplet.cleanParam(string4), null);
                if (SIGNATURE_FORMAT_AUTO.equalsIgnoreCase(string4)) {
                    string4 = ExtraParamsProcessor.updateFormat(aOSigner);
                }
                return this.chunkReturn(Base64.encode(AccessController.doPrivileged(new SignAction(aOSigner, byArray, MiniAfirmaApplet.cleanParam(string), this.selectPrivateKey(properties), ExtraParamsProcessor.expandProperties(properties, byArray, string4)))));
            }
            catch (AOFormatFileException aOFormatFileException) {
                this.setError(aOFormatFileException);
                throw aOFormatFileException;
            }
            catch (PrivilegedActionException privilegedActionException) {
                this.setError(privilegedActionException);
                throw privilegedActionException;
            }
            catch (RuntimeException runtimeException) {
                this.setError(runtimeException);
                throw runtimeException;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                this.setError(outOfMemoryError, "Error de falta de memoria durante la operaci\u00f3n de firma");
                throw outOfMemoryError;
            }
            catch (Error error) {
                this.setError(error);
                throw new AOException("Ocurrio un error grave durante la operaci\u00f3n de firma", error);
            }
        }
        AOException aOException = new AOException("No se indic\u00f3 un documento para firmar");
        this.setError(aOException);
        throw aOException;
    }

    @Override
    public String coSign(String string, String string2, String string3, String string4) throws PrivilegedActionException, IOException, AOException {
        byte[] byArray;
        byte[] byArray2;
        this.clearError();
        if (this.dataStore.length() > 0) {
            try {
                byArray2 = Base64.decode(this.dataStore.toString());
            }
            catch (IOException iOException) {
                this.setError(iOException, "La firma proporcionada est\u00e1 mal codificada en base 64");
                throw iOException;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                this.setError(outOfMemoryError, "Error de falta de memoria durante la carga de la firma");
                throw outOfMemoryError;
            }
            finally {
                this.dataStore.setLength(0);
            }
        }
        try {
            byArray2 = AccessController.doPrivileged(new GetFileContentAction(MiniAppletMessages.getString("MiniAfirmaApplet.2"), null, MiniAppletMessages.getString("MiniAfirmaApplet.1"), this));
        }
        catch (AOCancelledOperationException aOCancelledOperationException) {
            this.setError(aOCancelledOperationException);
            throw aOCancelledOperationException;
        }
        catch (CancellationException cancellationException) {
            AOCancelledOperationException aOCancelledOperationException = new AOCancelledOperationException("Operacion cancelada por el usuario", cancellationException);
            this.setError(aOCancelledOperationException);
            throw aOCancelledOperationException;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.setError(outOfMemoryError, "Error de falta de memoria durante la carga del fichero de firma");
            throw outOfMemoryError;
        }
        catch (PrivilegedActionException privilegedActionException) {
            this.setError(privilegedActionException);
            throw privilegedActionException;
        }
        catch (Error error) {
            this.setError(error);
            throw new AOException("Ocurrio un error grave durante la operaci\u00f3n de firma", error);
        }
        Properties properties = ExtraParamsProcessor.convertToProperties(string4);
        try {
            byArray = string == null ? null : Base64.decode(string);
        }
        catch (IOException iOException) {
            this.setError(iOException, "Los datos proporcionados est\u00e1n mal codificados en base 64");
            throw iOException;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.setError(outOfMemoryError, "Error de falta de memoria durante la carga de los datos");
            throw outOfMemoryError;
        }
        catch (Error error) {
            this.setError(error);
            throw new AOException("Ocurrio un error grave durante la operaci\u00f3n de firma", error);
        }
        try {
            String string5 = string3;
            AOSigner aOSigner = MiniAfirmaApplet.selectSigner(MiniAfirmaApplet.cleanParam(string5), byArray2);
            if (SIGNATURE_FORMAT_AUTO.equalsIgnoreCase(string5)) {
                string5 = ExtraParamsProcessor.updateFormat(aOSigner);
            }
            return this.chunkReturn(Base64.encode(AccessController.doPrivileged(new CoSignAction(aOSigner, byArray2, byArray, MiniAfirmaApplet.cleanParam(string2), this.selectPrivateKey(properties), ExtraParamsProcessor.expandProperties(properties, byArray, string5)))));
        }
        catch (AOFormatFileException aOFormatFileException) {
            this.setError(aOFormatFileException);
            throw aOFormatFileException;
        }
        catch (PrivilegedActionException privilegedActionException) {
            this.setError(privilegedActionException);
            throw privilegedActionException;
        }
        catch (RuntimeException runtimeException) {
            this.setError(runtimeException);
            throw runtimeException;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.setError(outOfMemoryError, "Error de falta de memoria durante la operaci\u00f3n de cofirma");
            throw outOfMemoryError;
        }
        catch (Error error) {
            this.setError(error);
            throw new AOException("Ocurrio un error grave durante la operaci\u00f3n de cofirma", error);
        }
    }

    @Override
    public String counterSign(String string, String string2, String string3) throws PrivilegedActionException, IOException, AOException {
        byte[] byArray;
        this.clearError();
        if (this.dataStore.length() > 0) {
            try {
                byArray = Base64.decode(this.dataStore.toString());
            }
            catch (IOException iOException) {
                this.setError(iOException, "La firma proporcionada est\u00e1 mal codificada en base 64");
                throw iOException;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                this.setError(outOfMemoryError, "Error de falta de memoria durante la carga de la firma");
                throw outOfMemoryError;
            }
            finally {
                this.dataStore.setLength(0);
            }
        }
        try {
            byArray = AccessController.doPrivileged(new GetFileContentAction(MiniAppletMessages.getString("MiniAfirmaApplet.2"), null, MiniAppletMessages.getString("MiniAfirmaApplet.1"), this));
        }
        catch (AOCancelledOperationException aOCancelledOperationException) {
            this.setError(aOCancelledOperationException);
            throw aOCancelledOperationException;
        }
        catch (CancellationException cancellationException) {
            AOCancelledOperationException aOCancelledOperationException = new AOCancelledOperationException("Operacion cancelada por el usuario", cancellationException);
            this.setError(aOCancelledOperationException);
            throw aOCancelledOperationException;
        }
        catch (PrivilegedActionException privilegedActionException) {
            this.setError(privilegedActionException);
            throw privilegedActionException;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.setError(outOfMemoryError, "Error de falta de memoria durante la carga del fichero de firma");
            throw outOfMemoryError;
        }
        Properties properties = ExtraParamsProcessor.convertToProperties(string3);
        try {
            String string4 = string2;
            AOSigner aOSigner = MiniAfirmaApplet.selectSigner(MiniAfirmaApplet.cleanParam(string4), byArray);
            if (SIGNATURE_FORMAT_AUTO.equalsIgnoreCase(string4)) {
                string4 = ExtraParamsProcessor.updateFormat(aOSigner);
            }
            return this.chunkReturn(Base64.encode(AccessController.doPrivileged(new CounterSignAction(aOSigner, byArray, MiniAfirmaApplet.cleanParam(string), this.selectPrivateKey(properties), ExtraParamsProcessor.expandProperties(properties, null, string4)))));
        }
        catch (AOFormatFileException aOFormatFileException) {
            this.setError(aOFormatFileException);
            throw aOFormatFileException;
        }
        catch (PrivilegedActionException privilegedActionException) {
            this.setError(privilegedActionException);
            throw privilegedActionException;
        }
        catch (RuntimeException runtimeException) {
            this.setError(runtimeException);
            throw runtimeException;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.setError(outOfMemoryError, "Error de falta de memoria durante la operaci\u00f3n de contrafirma");
            throw outOfMemoryError;
        }
        catch (Error error) {
            this.setError(error);
            throw new AOException("Ocurrio un error grave durante la operaci\u00f3n de contrafirma", error);
        }
    }

    @Override
    public boolean saveDataToFile(String string, String string2, String string3, String string4) throws PrivilegedActionException, IOException {
        String[] stringArray;
        this.clearError();
        if (this.dataStore.length() < 1) {
            LOGGER.warning("Se ha solicitado guardar en disco un contenido nulo, se ignorara la peticion");
            return false;
        }
        String string5 = MiniAfirmaApplet.cleanParam(string);
        String string6 = MiniAfirmaApplet.cleanParam(string3);
        if (string6 == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = string6;
        }
        String[] stringArray3 = stringArray;
        String string7 = MiniAfirmaApplet.cleanParam(string4);
        try {
            AccessController.doPrivileged(new SaveFileAction(string5, Base64.decode(this.dataStore.toString()), stringArray3, string7, MiniAfirmaApplet.cleanParam(string2), this));
            boolean bl = true;
            return bl;
        }
        catch (AOCancelledOperationException aOCancelledOperationException) {
            boolean bl = false;
            return bl;
        }
        catch (CancellationException cancellationException) {
            boolean bl = false;
            return bl;
        }
        catch (IOException iOException) {
            this.setError(iOException, "Los datos proporcionados est\u00e1n mal codificados en base 64");
            throw iOException;
        }
        catch (PrivilegedActionException privilegedActionException) {
            this.setError(privilegedActionException);
            throw privilegedActionException;
        }
        catch (RuntimeException runtimeException) {
            this.setError(runtimeException);
            throw runtimeException;
        }
        finally {
            this.dataStore.setLength(0);
        }
    }

    @Override
    public String getFileNameContentBase64(String string, String string2, String string3, String string4) throws PrivilegedActionException, IOException {
        this.clearError();
        return this.chunkReturn(this.getFileNameContent(string, string2, string3, string4, true));
    }

    private String getFileNameContent(String string, String string2, String string3, String string4, boolean bl) throws PrivilegedActionException {
        this.clearError();
        String string5 = MiniAfirmaApplet.cleanParam(string);
        String string6 = MiniAfirmaApplet.cleanParam(string2);
        String[] stringArray = string6 == null ? null : string6.split(",");
        String string7 = MiniAfirmaApplet.cleanParam(string3);
        String string8 = MiniAfirmaApplet.cleanParam(string4);
        try {
            return AccessController.doPrivileged(new GetFileNameContentAction(string5, stringArray, string7, string8, false, bl, this))[0];
        }
        catch (AOCancelledOperationException aOCancelledOperationException) {
            this.setError(aOCancelledOperationException);
            throw aOCancelledOperationException;
        }
        catch (CancellationException cancellationException) {
            AOCancelledOperationException aOCancelledOperationException = new AOCancelledOperationException("Operacion cancelada por el usuario", cancellationException);
            this.setError(aOCancelledOperationException);
            throw aOCancelledOperationException;
        }
        catch (PrivilegedActionException privilegedActionException) {
            this.setError(privilegedActionException);
            throw privilegedActionException;
        }
        catch (RuntimeException runtimeException) {
            this.setError(runtimeException);
            throw runtimeException;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.setError(outOfMemoryError, "Error de falta de memoria durante la carga del fichero");
            throw outOfMemoryError;
        }
    }

    @Override
    public String[] getMultiFileNameContentBase64(String string, String string2, String string3, String string4) throws IOException, PrivilegedActionException {
        return this.getMultiFileNameContent(string, string2, string3, string4, true);
    }

    private String[] getMultiFileNameContent(String string, String string2, String string3, String string4, boolean bl) throws PrivilegedActionException {
        this.clearError();
        String string5 = MiniAfirmaApplet.cleanParam(string);
        String string6 = MiniAfirmaApplet.cleanParam(string2);
        String[] stringArray = string6 == null ? null : string6.split(",");
        String string7 = MiniAfirmaApplet.cleanParam(string3);
        String string8 = MiniAfirmaApplet.cleanParam(string4);
        try {
            return AccessController.doPrivileged(new GetFileNameContentAction(string5, stringArray, string7, string8, true, bl, this));
        }
        catch (AOCancelledOperationException aOCancelledOperationException) {
            this.setError(aOCancelledOperationException);
            throw aOCancelledOperationException;
        }
        catch (CancellationException cancellationException) {
            AOCancelledOperationException aOCancelledOperationException = new AOCancelledOperationException("Operacion cancelada por el usuario", cancellationException);
            this.setError(aOCancelledOperationException);
            throw aOCancelledOperationException;
        }
        catch (PrivilegedActionException privilegedActionException) {
            this.setError(privilegedActionException);
            throw privilegedActionException;
        }
        catch (RuntimeException runtimeException) {
            this.setError(runtimeException);
            throw runtimeException;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.setError(outOfMemoryError, "Error de falta de memoria durante la carga de los ficheros");
            throw outOfMemoryError;
        }
    }

    @Override
    public String getTextFromBase64(String string, String string2) throws IOException {
        this.clearError();
        if (string == null) {
            return null;
        }
        String string3 = MiniAfirmaApplet.getCharset(MiniAfirmaApplet.cleanParam(string2), string);
        try {
            return this.chunkReturn(new String(Base64.decode(string), string3));
        }
        catch (IOException iOException) {
            this.setError(iOException);
            throw iOException;
        }
    }

    @Override
    public String getBase64FromText(String string, String string2) throws UnsupportedEncodingException {
        this.clearError();
        if (string == null) {
            return null;
        }
        String string3 = MiniAfirmaApplet.getCharset(MiniAfirmaApplet.cleanParam(string2), null);
        try {
            return Base64.encode(string.getBytes(string3));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.setError(unsupportedEncodingException);
            throw unsupportedEncodingException;
        }
    }

    public void destroy() {
    }

    public void init(String string, String string2) {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    JarSignatureCertExtractor.insertJarSignerOnCACerts(this);
                    return null;
                }
            });
        }
        catch (Exception exception) {
            LOGGER.warning("No se ha podido insertar la cadena de confianza del certificado de firma del applet en el almacen de confianza de Java: " + exception);
        }
        this.userAgent = string2;
        if (string != null && !string.equals("null")) {
            int n = string.indexOf(58);
            try {
                if (n == -1) {
                    this.keystoreType = AOKeyStore.valueOf(string);
                } else if (string.length() > 1) {
                    this.keystoreType = AOKeyStore.valueOf(string.substring(0, n).trim());
                    if (n < string.length() - 1 && string.substring(n + 1).trim().length() > 0) {
                        this.keystoreLib = string.substring(n + 1).trim();
                    }
                }
            }
            catch (Exception exception) {
                LOGGER.warning("Se ha intentado cargar un almacen de certificados no soportado, se cargara el por defecto: " + exception);
            }
        }
        AccessController.doPrivileged(new PrivilegedAction<String[]>(){

            @Override
            public String[] run() {
                try {
                    MiniAfirmaApplet.configureLookAndFeel();
                    return new String[0];
                }
                catch (Exception exception) {
                    LOGGER.info("No se pudo establecer Look&Feel");
                    return new String[0];
                }
            }
        });
        LOGGER.info("Miniapplet Afirma " + MiniAfirmaApplet.getVersion());
        LOGGER.info("Sistema operativo: " + System.getProperty("os.name"));
        LOGGER.info("Version del SO: " + System.getProperty("os.version"));
        LOGGER.info("Version de Java: " + System.getProperty("java.version"));
        LOGGER.info("Arquitectura del JRE: " + Platform.getJavaArch());
        LOGGER.info("Java Vendor: " + System.getProperty("java.vm.vendor"));
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    File file = new File(System.getProperty("user.home") + System.getProperty("file.separator") + ".downloads");
                    if (!file.exists()) {
                        file.mkdir();
                    } else {
                        for (File file2 : file.listFiles()) {
                            if (file2.isDirectory()) continue;
                            file2.delete();
                        }
                    }
                }
                catch (Exception exception) {
                    Logger.getLogger(MiniAfirmaApplet.class.getName()).log(Level.SEVERE, null, exception);
                }
                return null;
            }
        });
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public String getErrorType() {
        return this.errorType;
    }

    private void setError(Throwable throwable) {
        this.setError(throwable, null);
    }

    private void setError(Throwable throwable, String string) {
        Throwable throwable2 = throwable;
        if (throwable instanceof PrivilegedActionException && throwable.getCause() != null) {
            throwable2 = throwable.getCause();
        }
        this.errorMessage = string != null ? string : (throwable2.getLocalizedMessage() != null ? throwable2.getLocalizedMessage() : (throwable2.getMessage() != null ? throwable2.getMessage() : throwable2.toString()));
        this.errorType = throwable2.getClass().getCanonicalName();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);
        throwable.printStackTrace(printWriter);
        printWriter.flush();
        printWriter.close();
        LOGGER.severe(new String(byteArrayOutputStream.toByteArray()));
    }

    private void clearError() {
        this.errorType = null;
        this.errorMessage = null;
    }

    public KeyStore.PrivateKeyEntry selectPrivateKey(Properties properties) throws PrivilegedActionException, FileNotFoundException, UnsupportedEncodingException, IOException {
        if (this.stickySignatory && this.stickyKeyEntry != null) {
            return this.stickyKeyEntry;
        }
        KeyStore.PrivateKeyEntry privateKeyEntry = null;
        Path path = Paths.get(System.getProperty("user.home") + System.getProperty("file.separator") + "pkcs11.cfg", new String[0]);
        if (path.toFile().exists()) {
            SelectPrivateKeyAction selectPrivateKeyAction = new SelectPrivateKeyAction(AOKeyStore.PKCS11, new String(Files.readAllBytes(path), "UTF-8"), new CertFilterManager(properties), (Component)this);
            System.out.println("Using PKCS#11 configuration");
            try {
                privateKeyEntry = AccessController.doPrivileged(selectPrivateKeyAction);
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
        } else {
            SelectPrivateKeyAction selectPrivateKeyAction = this.keystoreType == null ? new SelectPrivateKeyAction(Platform.getOS(), Platform.getBrowser(this.userAgent), new CertFilterManager(properties), (Component)this) : new SelectPrivateKeyAction(this.keystoreType, this.keystoreLib, new CertFilterManager(properties), (Component)this);
            privateKeyEntry = AccessController.doPrivileged(selectPrivateKeyAction);
        }
        if (this.stickySignatory) {
            this.stickyKeyEntry = privateKeyEntry;
        }
        this.myKeyEntry = privateKeyEntry;
        return privateKeyEntry;
    }

    public static AOSigner selectSigner(String string, byte[] byArray) throws AOFormatFileException, PrivilegedActionException, IOException {
        AOSigner aOSigner;
        if (string != null && !SIGNATURE_FORMAT_AUTO.equalsIgnoreCase(string)) {
            aOSigner = MiniAfirmaApplet.getSigner(string);
            if (aOSigner == null) {
                throw new AOFormatFileException("No esta soportado el formato de firma: " + string);
            }
        } else if (byArray != null) {
            aOSigner = MiniAfirmaApplet.getSigner(byArray);
            if (aOSigner == null) {
                throw new IllegalArgumentException("Los datos introducidos no se corresponden con una firma soportada");
            }
        } else {
            throw new IllegalArgumentException("No se ha indicado el formato para la operacion de firma");
        }
        return aOSigner;
    }

    private static AOSigner getSigner(String string) throws PrivilegedActionException {
        return AccessController.doPrivileged(new SelectSignerAction(string));
    }

    private static AOSigner getSigner(byte[] byArray) throws PrivilegedActionException {
        return AccessController.doPrivileged(new SelectSignerAction(byArray));
    }

    private static void configureLookAndFeel() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            LOGGER.warning("No se ha podido establecer el Look&Feel: " + exception);
        }
        JDialog.setDefaultLookAndFeelDecorated(true);
        JFrame.setDefaultLookAndFeelDecorated(true);
    }

    public static String cleanParam(String string) {
        return string == null || string.trim().length() < 1 ? null : string.trim();
    }

    private static String getCharset(String string, String string2) {
        if ("auto".equalsIgnoreCase(string)) {
            String string3;
            byte[] byArray;
            if (string2 == null) {
                LOGGER.warning("No se puede detectar el juego de caracteres de un texto nulo, se devolvera la codificacion por defecto");
                return MiniAfirmaApplet.getCharset("default", null);
            }
            try {
                byArray = Base64.decode(string2);
            }
            catch (IOException iOException) {
                LOGGER.warning("Los datos proporcionados est\u00e1n mal codificados en base 64");
                return MiniAfirmaApplet.getCharset("default", null);
            }
            UniversalDetector universalDetector = new UniversalDetector();
            universalDetector.handleData(byArray, 0, byArray.length);
            universalDetector.dataEnd();
            if (universalDetector.isDone() && (string3 = universalDetector.getDetectedCharset()) != null) {
                return string3;
            }
            LOGGER.warning("No se ha podido autodetectar el juego de caracteres, se devolvera el por defecto del sistema");
            return MiniAfirmaApplet.getCharset("default", null);
        }
        if ("default".equalsIgnoreCase(string) || string == null) {
            return AccessController.doPrivileged(new GetPropertyAction("file.encoding"));
        }
        return string;
    }

    @Override
    public String echo() {
        LOGGER.info("AAAAAAAAAAAAA MiniApplet cargado y en ejecuci\u00f3n");
        return "";
    }

    private byte[] readChunk() throws IOException {
        byte[] byArray;
        if (this.chunkedReturnStream == null) {
            return new byte[0];
        }
        boolean bl = false;
        int n = this.chunkedReturnStream.available();
        if (n > 0x100000) {
            byArray = new byte[0x100000];
        } else if (n > 0) {
            byArray = new byte[n];
            bl = true;
        } else {
            this.chunkedReturnStream = null;
            return new byte[0];
        }
        int n2 = this.chunkedReturnStream.read(byArray);
        if (n2 != byArray.length) {
            this.chunkedReturnStream = null;
            throw new IOException("Lectura incompleta de la porcion de datos resultantes");
        }
        if (bl) {
            this.chunkedReturnStream.close();
            this.chunkedReturnStream = null;
        }
        return byArray;
    }

    private String chunkReturn(String string) throws IOException {
        if (string == null || string.length() <= 0x100000) {
            return string;
        }
        LOGGER.info("El resultado es demasiado grande (" + string.length() + " caracteres), se ha devuelto un resultado parcial y debe solicitarse el resto en llamadas adicionales");
        this.chunkedReturnStream = new ByteArrayInputStream(string.getBytes(DEFAULT_CHUNK_ENCODING));
        return new String(this.readChunk(), DEFAULT_CHUNK_ENCODING);
    }

    @Override
    public String getRemainingData() throws IOException {
        byte[] byArray = this.readChunk();
        if (byArray == null) {
            throw new IOException("Se ha producido una lectura parcial nula");
        }
        if (byArray.length == 0) {
            LOGGER.info("Se ha terminado de devolver un resultado grande");
            return EOF;
        }
        LOGGER.info("Devolucion parcial de " + byArray.length + " caracteres");
        return new String(byArray, DEFAULT_CHUNK_ENCODING);
    }

    @Override
    public void addData(String string) {
        if (string == null) {
            this.dataStore.setLength(0);
        } else {
            this.dataStore.append(string);
            LOGGER.info("Anadida porcion de datos de longitud: " + string.length());
        }
    }

    private static String getVersion() {
        try {
            InputStream inputStream = MiniAfirmaApplet.class.getClassLoader().getResourceAsStream("/META-INF/MANIFEST.MF");
            Properties properties = new Properties();
            properties.load(inputStream);
            inputStream.close();
            return properties.getProperty("Specification-Version", "");
        }
        catch (Exception exception) {
            LOGGER.warning("No se ha podido identificar el numero de version del MiniApplet a partir del Manifest: " + exception);
            return "";
        }
    }
}

