/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.miniapplet;

import es.gob.afirma.miniapplet.HttpDownloadAction;
import es.gob.afirma.miniapplet.HttpIPostListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.hccp.net.CookieManager;

public class HttpIPostAction
implements PrivilegedExceptionAction<Integer> {
    protected URL url;
    protected String sessionName;
    protected String sessionId;
    protected String userAgent;
    protected String htmlRoot;
    String lastRefresh;
    String lastRefreshName;
    protected String data = "";
    private final ArrayList<HttpIPostListener> listeners = new ArrayList();
    protected URLConnection connection;
    protected CookieManager cm = null;
    protected String method = "GET";

    public void setConnection(String string, String string2, String string3, String string4, String string5, String string6) throws MalformedURLException {
        this.url = new URL(string);
        this.sessionName = string2;
        this.sessionId = string3;
        this.userAgent = string4;
        this.lastRefresh = string5;
        this.lastRefreshName = string6;
    }

    public void setConnection(String string, String string2, String string3, String string4, String string5, String string6, String string7) throws MalformedURLException, IOException {
        this.url = new URL(string);
        this.sessionName = string2;
        this.sessionId = string3;
        this.userAgent = string4;
        this.htmlRoot = string5;
        this.lastRefresh = string6;
        this.lastRefreshName = string7;
    }

    public void setConnection(String string) throws MalformedURLException, IOException {
        this.url = new URL(string);
        this.sessionName = "";
        this.sessionId = "";
        this.userAgent = "";
        this.htmlRoot = "";
    }

    public void openConnection() throws IOException {
        this.connection = this.url.openConnection();
    }

    public void setPost(String string) {
        this.method = "POST";
        this.data = string;
    }

    public void setCookieManager(CookieManager cookieManager) {
        this.cm = cookieManager;
    }

    public synchronized void addPostAction(HttpIPostListener httpIPostListener) {
        this.listeners.add(httpIPostListener);
    }

    public synchronized void removePostAction(HttpIPostListener httpIPostListener) {
        this.listeners.remove(httpIPostListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public Integer run() throws IOException {
        void var3_9;
        this.openConnection();
        if (this.cm != null) {
            this.cm.setCookies(this.connection);
        }
        this.connection.setDoOutput(true);
        ((HttpURLConnection)this.connection).setInstanceFollowRedirects(false);
        ((HttpURLConnection)this.connection).setRequestMethod(this.method);
        if (this.method.equals("POST")) {
            this.connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        }
        String string = "";
        if (this.sessionName != null && !this.sessionName.equals("") && this.sessionId != null && !this.sessionId.equals("")) {
            if (!string.equals("")) {
                string = string + "; ";
            }
            string = string + URLEncoder.encode(this.sessionName, "UTF-8") + "=" + URLEncoder.encode(this.sessionId, "UTF-8");
        }
        if (this.lastRefreshName != null && !this.lastRefreshName.equals("") && this.lastRefresh != null && !this.lastRefresh.equals("")) {
            if (!string.equals("")) {
                string = string + "; ";
            }
            string = string + URLEncoder.encode(this.lastRefreshName, "UTF-8") + "=" + URLEncoder.encode(this.lastRefresh, "UTF-8");
        }
        if (!string.equals("")) {
            this.connection.setRequestProperty("Cookie", string);
        }
        if (this.userAgent != null && !this.userAgent.equals("")) {
            this.connection.setRequestProperty("User-Agent", this.userAgent);
        }
        if (this.htmlRoot != null && !this.htmlRoot.equals("")) {
            this.connection.setRequestProperty("Html-Root", this.htmlRoot);
        }
        for (HttpIPostListener object : this.listeners) {
            object.beforeSend(this.connection);
        }
        this.connection.setUseCaches(false);
        this.connection.setDoOutput(true);
        System.out.println(this.method);
        if (this.method.equals("POST")) {
            Object object2 = this.data.getBytes();
            System.out.println(this.data);
            this.connection.setRequestProperty("Content-Length", Integer.toString(((Object)object2).length));
            OutputStream n2 = this.connection.getOutputStream();
            n2.write((byte[])object2);
            n2.close();
        }
        int n = ((HttpURLConnection)this.connection).getResponseCode();
        for (HttpIPostListener httpIPostListener : this.listeners) {
            if (httpIPostListener.code(this.connection, n)) continue;
            return 0;
        }
        System.out.println(((HttpURLConnection)this.connection).getHeaderField("Location"));
        System.out.println(n);
        boolean bl = false;
        try {
            int n2;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            InputStream inputStream = this.connection.getInputStream();
            byte[] byArray = new byte[1024];
            while ((n2 = inputStream.read(byArray, 0, 1024)) >= 0) {
                byteArrayOutputStream.write(byArray, 0, n2);
                var3_9 += n2;
            }
            inputStream.close();
            byteArrayOutputStream.close();
            for (HttpIPostListener httpIPostListener : this.listeners) {
                httpIPostListener.recv(byteArrayOutputStream.toString());
            }
            for (HttpIPostListener httpIPostListener : this.listeners) {
                httpIPostListener.afterSend(this.connection);
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(HttpDownloadAction.class.getName()).log(Level.SEVERE, null, iOException);
        }
        return (int)var3_9;
    }
}

