/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.miniapplet;

import es.gob.afirma.miniapplet.exceptions.DownloadActionException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.security.PrivilegedExceptionAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;

public class HttpDownloadAction
implements PrivilegedExceptionAction<Integer> {
    URL url;
    String sessionName;
    String sessionId;
    String userAgent;
    String lastRefresh;
    String lastRefreshName;
    URLConnection connection;
    File file;
    OutputStream outputStream;

    public void setConnection(String string, String string2, String string3, String string4, String string5, String string6) throws MalformedURLException, IOException {
        this.url = new URL(string);
        this.sessionName = string2;
        this.sessionId = string3;
        this.userAgent = string4;
        this.lastRefresh = string5;
        this.lastRefreshName = string6;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public void openConnection() throws IOException {
        this.connection = this.url.openConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer run() throws IOException, DownloadActionException {
        this.openConnection();
        this.connection.setRequestProperty("Accept", "text/html");
        String string = "";
        if (this.sessionName != null && !this.sessionName.equals("") && this.sessionId != null && !this.sessionId.equals("")) {
            if (!string.equals("")) {
                string = string + "; ";
            }
            string = string + URLEncoder.encode(this.sessionName, "UTF-8") + "=" + URLEncoder.encode(this.sessionId, "UTF-8");
        }
        if (this.lastRefreshName != null && !this.lastRefreshName.equals("") && this.lastRefresh != null && !this.lastRefresh.equals("")) {
            if (!string.equals("")) {
                string = string + "; ";
            }
            string = string + URLEncoder.encode(this.lastRefreshName, "UTF-8") + "=" + URLEncoder.encode(this.lastRefresh, "UTF-8");
        }
        if (!string.equals("")) {
            this.connection.setRequestProperty("Cookie", string);
        }
        if (this.userAgent != null && !this.userAgent.equals("")) {
            this.connection.setRequestProperty("User-Agent", this.userAgent);
        }
        this.connection.setUseCaches(false);
        this.connection.setRequestProperty("Accept-Encoding", "gzip");
        this.connection.setDoOutput(true);
        int n = 0;
        String string2 = this.connection.getContentEncoding();
        InputStream inputStream = null;
        try {
            Object object;
            int n2;
            if (this.connection instanceof HttpURLConnection && (n2 = ((HttpURLConnection)(object = (HttpURLConnection)this.connection)).getResponseCode()) == 500) {
                throw new DownloadActionException(((HttpURLConnection)object).getResponseMessage());
            }
            inputStream = this.connection.getInputStream();
            if (string2 != null && string2.indexOf("gzip") != -1) {
                System.out.println("**************************************");
                System.out.println("content encoding: gzip");
                System.out.println("**************************************");
                inputStream = new GZIPInputStream(inputStream);
            }
            object = new byte[1024];
            if (this.outputStream == null && this.file != null) {
                this.outputStream = new FileOutputStream(this.file);
            }
            while ((n2 = inputStream.read((byte[])object, 0, 1024)) >= 0) {
                this.outputStream.write((byte[])object, 0, n2);
                n += n2;
            }
            inputStream.close();
            this.outputStream.close();
        }
        catch (IOException iOException) {
            Logger.getLogger(HttpDownloadAction.class.getName()).log(Level.SEVERE, null, iOException);
        }
        return new Integer(n);
    }
}

