/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.miniapplet;

import es.gob.afirma.core.signers.AOSigner;
import es.gob.afirma.miniapplet.PolicyPropertiesManager;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Logger;

public final class ExtraParamsProcessor {
    private static final int SIZE_1MB = 0x100000;
    private static final String EXPANDIBLE_POLICY_KEY = "expPolicy";

    private ExtraParamsProcessor() {
    }

    public static Properties convertToProperties(String string) {
        Properties properties = new Properties();
        if (string == null) {
            return properties;
        }
        try {
            properties.load(new ByteArrayInputStream(string.getBytes()));
        }
        catch (Exception exception) {
            Logger.getLogger("es.gob.afirma").warning("Se han encontrado entradas no validas en la configuracion de la operacion: " + exception);
            return properties;
        }
        return properties;
    }

    public static Properties expandProperties(Properties properties) {
        return ExtraParamsProcessor.expandProperties(properties, null, null);
    }

    static Properties expandProperties(Properties properties, byte[] byArray, String string) {
        Properties properties2 = new Properties();
        for (String string2 : properties.keySet().toArray(new String[0])) {
            properties2.setProperty(string2, properties.getProperty(string2));
        }
        ExtraParamsProcessor.expandPolicyKeys(properties2, byArray, string);
        return properties2;
    }

    static String updateFormat(AOSigner aOSigner) {
        String string = aOSigner.getClass().getName();
        if (string.equals("es.gob.afirma.signers.xades.AOXAdESSigner")) {
            return "XAdES";
        }
        if (string.equals("es.gob.afirma.signers.cades.AOCAdESSigner")) {
            return "CAdES";
        }
        if (string.equals("es.gob.afirma.signers.pades.AOPDFSigner")) {
            return "PAdES";
        }
        if (string.equals("es.gob.afirma.signers.xades.AOFacturaESigner")) {
            return "FacturaE";
        }
        return null;
    }

    static void expandPolicyKeys(Properties properties, byte[] byArray, String string) {
        if (properties.containsKey(EXPANDIBLE_POLICY_KEY)) {
            if ("FirmaAGE".equals(properties.getProperty(EXPANDIBLE_POLICY_KEY))) {
                String string2 = null;
                if (string != null) {
                    if (string.startsWith("XAdES")) {
                        string2 = "XAdES";
                        if (!"XAdES Detached".equals(properties.getProperty("format")) && !"XAdES Enveloped".equals(properties.getProperty("format"))) {
                            properties.setProperty("format", "XAdES Detached");
                        }
                    } else if (string.equals("CAdES")) {
                        string2 = "CAdES";
                        if (!properties.containsKey("mode") && byArray != null) {
                            properties.setProperty("mode", byArray.length < 0x100000 ? "implicit" : "explicit");
                        }
                    } else if (string.equals("Adobe PDF") || string.equals("PAdES") || string.equals("Adobe PDF TriPhase")) {
                        string2 = "PAdES";
                    }
                }
                try {
                    PolicyPropertiesManager.setProperties(properties, "FirmaAGE", string2);
                }
                catch (IOException iOException) {
                    Logger.getLogger("es.gob.afirma").warning("No se han encontrado podido cargar el fichero de propiedades: " + iOException);
                }
            }
            properties.remove(EXPANDIBLE_POLICY_KEY);
        }
    }
}

