/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.miniapplet;

import es.gob.afirma.core.misc.Base64;
import es.gob.afirma.miniapplet.BadConformedFormException;
import es.gob.afirma.miniapplet.HttpsDownloadAction;
import es.gob.afirma.miniapplet.MiniAfirmaWindow;
import es.gob.afirma.ssl.KeyManager;
import es.gob.afirma.ssl.SslSocketFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.CookieHandler;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.KeyStore;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import org.hccp.net.CookieManager;

public class DescargaInformeAction
implements PrivilegedAction<Integer> {
    private static final String NO_REFERER_URL = "";
    private static final String COMPLETE_REPORT_URL_STEP_0 = "https://sedeapl.dgt.gob.es:9443/WEB_INTV_INTER/xhtml/acciones/iniciarSolicitudInforme.jsf";
    private static final String COMPLETE_REPORT_URL_STEP_1 = "https://sedeapl.dgt.gob.es:9443/WEB_INTV_INTER/xhtml/acciones/iniciarSolicitudInforme.jsf";
    private static final String COMPLETE_REPORT_URL_STEP_2 = "https://sedeapl.dgt.gob.es:9443/WEB_INTV_INTER/xhtml/acciones/datosPago.jsf ";
    private static final String COMPLETE_REPORT_URL_STEP_3 = "https://sedeapl.dgt.gob.es:9443/WEB_INTV_INTER/xhtml/acciones/solicitarResumenSolicitud.jsf";
    private static final String COMPLETE_REPORT_URL_STEP_4 = "https://sedeapl.dgt.gob.es:9443/WEB_INTV_INTER/xhtml/acciones/descargarInforme.jsf";
    private static final String BRIEF_REPORT_URL_STEP_0 = "https://sedeapl.dgt.gob.es:9443/WEB_INTV_INTER/xhtml/acciones/iniciarDatosVerificacion.jsf";
    private static final String BRIEF_REPORT_URL_STEP_1 = "https://sedeapl.dgt.gob.es:9443/WEB_INTV_INTER/xhtml/acciones/iniciarDatosVerificacion.jsf";
    public static final int DESCARGA_INFORME_NUMBER_OF_STEPS = 3;
    private static final String MESSAGE_STEP_1_GETTING_REPORT_FOR_PLATE = "Solicitando informe para matr\u00edcula";
    private static final String MESSAGE_STEP_1_GETTING_REPORT_FOR_CHASSIS_NUMBER = "Solicitando informe para bastidor";
    private static final String MESSAGE_STEP_2_APPLYING_TAX = "Aplicando tasa";
    private static final String MESSAGE_STEP_2_RECOVERING_PREVIOUS_REPORT = "Recuperando informe previo";
    private static final String MESSAGE_STEP_3_DOWNLOADING_REPORT = "Descargando informe";
    public static final int DESCARGA_INFORME_ACTION_STATUS_SUCCESS = 0;
    public static final int DESCARGA_INFORME_ACTION_STATUS_PREVIOUS_REPORT = 1;
    public static final int DESCARGA_INFORME_ACTION_STATUS_ERROR_TAX_BAD_CONFORMED = 2;
    public static final int DESCARGA_INFORME_ACTION_STATUS_ERROR_TAX_NOT_APPLICABLE = 3;
    public static final int DESCARGA_INFORME_ACTION_STATUS_ERROR_TAX_INVALID = 4;
    public static final int DESCARGA_INFORME_ACTION_STATUS_ERROR_BAD_CONFORMED_PLATE = 5;
    public static final int DESCARGA_INFORME_ACTION_STATUS_ERROR_PLATE_WITH_INCIDENCES = 6;
    public static final int DESCARGA_INFORME_ACTION_STATUS_ERROR_INVALID_PLATE = 7;
    public static final int DESCARGA_INFORME_ACTION_STATUS_ERROR_INVALID_CHASSIS_NUMBER = 8;
    public static final int DESCARGA_INFORME_ACTION_STATUS_ERROR_CHASSIS_REPORT_NOT_AVAILABLE = 9;
    public static final int DESCARGA_INFORME_ACTION_STATUS_ERROR_BAD_CONFORMED_CHASSIS_NUMBER = 10;
    public static final int DESCARGA_INFORME_ACTION_STATUS_ERROR_NETWORK_ERROR = 11;
    public static final int DESCARGA_INFORME_ACTION_STATUS_ERROR_WEB_DGT = 12;
    public static final int DESCARGA_INFORME_ACTION_STATUS_ERROR_WEB_DGT_WITH_RETRY_MESSAGE = 13;
    public static final int DESCARGA_INFORME_ACTION_STATUS_ERROR_REPORT_REQUEST_CANCEL_BY_USER = 14;
    public static final int DESCARGA_INFORME_ACTION_STATUS_ERROR_UNDEFINED_REPORT_IDENTIFIER = 15;
    public static final int DESCARGA_INFORME_ACTION_STATUS_ERROR_PRICE_MISMATCH = 16;
    public static final int DESCARGA_INFORME_ACTION_STATUS_ERROR_BAD_CONFORMED_FORM = 17;
    public static final int DESCARGA_INFORME_ACTION_STATUS_ERROR_UNDEFINED = 100;
    public static final int OPTION_SELECTED_CANCEL = 0;
    public static final int OPTION_SELECTED_DOWNLOAD_PREVIOUS_REPORT = 1;
    public static final int OPTION_SELECTED_REQUEST_NEW_REPORT = 2;
    KeyStore.PrivateKeyEntry k;
    String userAgent;
    URLConnection connection;
    CookieManager cm;
    String b64Document;
    String htmlDocument;
    String tipo;
    String matricula;
    String tasa;
    String tipoInforme;
    String nrc;
    MiniAfirmaWindow window;
    int stepCount;
    String consoleLog;

    DescargaInformeAction(KeyStore.PrivateKeyEntry privateKeyEntry, String string, String string2, MiniAfirmaWindow miniAfirmaWindow) {
        this.k = privateKeyEntry;
        this.userAgent = string2;
        String[] stringArray = string.split(";");
        this.tipo = stringArray.length == 3 ? stringArray[2] : "M";
        this.matricula = stringArray[1];
        this.tasa = stringArray[0];
        this.tipoInforme = "INTEVE";
        this.nrc = NO_REFERER_URL;
        this.window = miniAfirmaWindow;
        this.stepCount = 1;
        this.consoleLog = NO_REFERER_URL;
    }

    public InputStream sendPostWithParameters(String string, String string2, String string3, String string4) throws MalformedURLException, IOException, Exception {
        if (!this.verifyUrlParameters(string2, string3)) {
            this.printDebugMessage("No se puede enviar el formulario (posible fallo DGT)", 12);
            throw new BadConformedFormException();
        }
        this.prepareConnectionToUrlWithReferer(string, string4);
        this.connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        this.connection.setDoOutput(true);
        this.cm.setCookies(this.connection);
        this.connection.connect();
        byte[] byArray = string3.getBytes();
        OutputStream outputStream = this.connection.getOutputStream();
        outputStream.write(byArray);
        outputStream.close();
        this.showOnConsoleAndLog("Returned code: " + ((HttpURLConnection)this.connection).getResponseCode());
        if (((HttpURLConnection)this.connection).getResponseCode() > 399) {
            throw new IOException();
        }
        return this.getInputStream();
    }

    public void prepareConnectionToUrlWithReferer(String string, String string2) throws IOException, Exception {
        URL uRL = new URL(string);
        this.connection = uRL.openConnection();
        ((HttpsURLConnection)this.connection).setSSLSocketFactory(new SslSocketFactory(new KeyManager(this.k)));
        this.connection.setRequestProperty("Accept", "text/html, application/xhtml+xml, image/jxr, */*");
        this.connection.setRequestProperty("Accept-Encoding", "gzip, deflate");
        this.connection.setRequestProperty("Cache-Control", "no-cache");
        this.connection.setRequestProperty("Accept-Language", "es-ES, es; q=0.8, en-US; q=0.5, en; q=0.3");
        this.connection.setRequestProperty("Connection", "Keep-Alive");
        if (string2 != null && string2 != NO_REFERER_URL) {
            this.connection.setRequestProperty("Referer", string2);
        }
        ((HttpURLConnection)this.connection).setInstanceFollowRedirects(false);
        if (this.userAgent != null && !this.userAgent.equals(NO_REFERER_URL)) {
            this.connection.setRequestProperty("User-Agent", this.userAgent);
        }
    }

    public void configureCookies() throws Exception {
        CookieHandler.setDefault(null);
        this.cm = new CookieManager();
    }

    public void prepareSslConnection() throws Exception {
        HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String string, SSLSession sSLSession) {
                return true;
            }
        });
    }

    public InputStream getInputStream() throws IOException, Exception {
        InputStream inputStream = this.connection.getInputStream();
        this.cm.storeCookies(this.connection);
        this.showConnectionReceivedHeaders();
        return inputStream;
    }

    public String getHtmlFromInputStream(InputStream inputStream) throws IOException, Exception {
        int n;
        if (inputStream == null) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[16384];
        byteArrayOutputStream.reset();
        while ((n = inputStream.read(byArray, 0, byArray.length)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        inputStream.close();
        byteArrayOutputStream.flush();
        String string = new String(byteArrayOutputStream.toByteArray());
        this.b64Document = Base64.encode(byteArrayOutputStream.toByteArray());
        System.out.println(this.b64Document);
        this.htmlDocument = string;
        return string;
    }

    public void showConnectionReceivedHeaders() {
        Map<String, List<String>> map = this.connection.getHeaderFields();
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            System.out.println("Key : " + entry.getKey() + " ,Value : " + entry.getValue());
        }
    }

    public String getB64Document() {
        return this.b64Document;
    }

    public String getB64ConsoleLog() {
        this.consoleLog = String.format(this.consoleLog, new Object[0]);
        return Base64.encode((this.htmlDocument + this.consoleLog).getBytes());
    }

    public Boolean isPresent(String string, String string2) {
        if (string.toLowerCase().indexOf(string2.toLowerCase()) > -1) {
            return true;
        }
        return false;
    }

    public String getDateOfPreviousReportFromHtml(String string) {
        String string2 = NO_REFERER_URL;
        if (this.isPresent(string, "fechaRegistroText").booleanValue()) {
            string2 = string.substring(string.indexOf("fechaRegistroText") + 19, string.indexOf("fechaRegistroText") + 29);
        }
        return string2;
    }

    public static String getErrorTextFromStatus(int n) {
        switch (n) {
            case 0: {
                return "ok (sin error)";
            }
            case 1: {
                return "Informe previo (sin error)";
            }
            case 2: {
                return "Tasa no v\u00e1lida";
            }
            case 3: {
                return "Tasa no aplicable";
            }
            case 4: {
                return "Tasa no encontrada";
            }
            case 5: {
                return "Matr\u00edcula incorrecta";
            }
            case 6: {
                return "Matr\u00edcula con incidencias";
            }
            case 7: {
                return "La matr\u00edcula no existe";
            }
            case 8: {
                return "El bastidor no existe";
            }
            case 9: {
                return "No se puede obtener el informe con el bastidor para este veh\u00edculo. Debe solicitarlo con la matr\u00edcula";
            }
            case 10: {
                return "Bastidor incorrecto";
            }
            case 11: {
                return "Error de comunicaci\u00f3n con la DGT";
            }
            case 12: {
                return "Error de comunicaci\u00f3n con la DGT";
            }
            case 13: {
                return "Error DGT: No se ha podido recuperar el informe correctamente. Por favor, vuelva a intentarlo pasados unos minutos";
            }
            case 14: {
                return "Descarga de informe cancelada por el usuario";
            }
            case 16: {
                return "El importe de la tasa recibida no coincide con el precio actual de la tasa";
            }
            case 15: {
                return "Tipo de identificador no v\u00e1lido (debe ser matr\u00edcula o bastidor)";
            }
        }
        return "Error t\u00e9cnico";
    }

    public void printDebugMessage(String string, int n) {
        this.showOnConsoleAndLog("**********************************************");
        this.showOnConsoleAndLog("STATUS: " + n + " | " + string);
        this.showOnConsoleAndLog("**********************************************");
    }

    public void showOnConsoleAndLog(String string) {
        System.out.println(string);
        this.consoleLog = this.consoleLog + string + "%n";
    }

    public void printSelectedOption(int n, Object[] objectArray) {
        if (n < 0) {
            this.showOnConsoleAndLog("Opci\u00f3n elegida: " + n + " - Cancel");
        } else if (n > objectArray.length - 1) {
            this.showOnConsoleAndLog("Opci\u00f3n elegida: " + n + " - !!!");
        } else {
            this.showOnConsoleAndLog("Opci\u00f3n elegida: " + n + " - " + objectArray[n]);
        }
    }

    public Boolean didConfirmToExit() {
        this.showOnConsoleAndLog("Se pregunta si se quiere cancelar la solicitud de informe...");
        Object[] objectArray = new Object[]{"Volver", "Cancelar solicitud"};
        int n = JOptionPane.showOptionDialog(null, "\u00bfDesea cancelar la solicitud de informe?", "Cancelaci\u00f3n de informe", 0, 3, null, objectArray, objectArray[0]);
        this.printSelectedOption(n, objectArray);
        if (n == 1) {
            return true;
        }
        return false;
    }

    public int getUserOptionForPreviousReport(Boolean bl, String string) {
        if (!bl.booleanValue()) {
            String string2 = this.getDateOfPreviousReportFromHtml(string);
            return this.getUserOptionForPreviousReportWithoutNrc(string2);
        }
        return this.getUserOptionForPreviousReportWithNrc();
    }

    public int getUserOptionForPreviousReportWithoutNrc(String string) {
        this.showOnConsoleAndLog("Se pregunta si se quiere descargar informe previo o solicitar uno nuevo...");
        int n = -1;
        Object[] objectArray = new Object[]{"Informe previo", "Solicitar nuevo"};
        while (n != 0 && n != 1) {
            n = JOptionPane.showOptionDialog(null, "Se ha detectado un informe previo con fecha " + string + "\n\u00bfDesea descargar el informe previo o solicitar uno nuevo?\n(si solicita un informe nuevo, el informe previo ser\u00e1 descartado)", "Existe un informe previo " + string, 0, 3, null, objectArray, objectArray[0]);
            this.printSelectedOption(n, objectArray);
            if (n == -1) {
                if (!this.didConfirmToExit().booleanValue()) continue;
                return 0;
            }
            if (n != 1) continue;
            return 2;
        }
        return 1;
    }

    public int getUserOptionForPreviousReportWithNrc() {
        this.showOnConsoleAndLog("Se solicita NRC...");
        Object[] objectArray = new Object[]{"Informe previo", "Solicitar nuevo"};
        JTextField jTextField = new JTextField(10);
        String string = "<html>Se ha detectado que ud. ya solicit\u00f3 y pag\u00f3 un informe de este mismo veh\u00edculo.<br />Si la primera vez que lo solicit\u00f3 no lo pudo obtener, seleccione 'Informe previo' e<br />introduzca el NRC facilitado por su entidad bancaria para recuperarlo. Si lo que<br />solicita es un informe nuevo, pulse 'Solicitar nuevo'<br /></html>";
        String string2 = "<html><br />NRC (N\u00famero de Referencia Completo del pago): </html>";
        Object[] objectArray2 = new Object[]{string, string2, jTextField};
        String string3 = NO_REFERER_URL;
        while (string3.equals(NO_REFERER_URL)) {
            this.showOnConsoleAndLog("nrcValue: " + string3);
            int n = JOptionPane.showOptionDialog(null, objectArray2, "Por favor, introduzca el NRC del pago", 0, -1, null, objectArray, null);
            this.printSelectedOption(n, objectArray);
            if (n == -1) {
                if (!this.didConfirmToExit().booleanValue()) continue;
                return 0;
            }
            if (n == 0) {
                this.nrc = string3 = jTextField.getText().trim();
                if (!string3.equals(NO_REFERER_URL)) continue;
                JOptionPane.showMessageDialog(null, "Por favor, para descargar el informe previo introduzca el NRC del pago");
                continue;
            }
            this.nrc = NO_REFERER_URL;
            return 2;
        }
        this.showOnConsoleAndLog("Valor nrc: " + string3);
        return 1;
    }

    public void advanceStep() {
        ++this.stepCount;
        this.window.finishElement();
    }

    public void advanceAllPendingSteps() {
        while (this.stepCount < 3) {
            this.advanceStep();
        }
    }

    public int verifyReportIdentifierType() {
        if (!this.tipo.toUpperCase().equals("M") && !this.tipo.toUpperCase().equals("B")) {
            return 15;
        }
        return 0;
    }

    public boolean verifyUrlParameters(String string, String string2) {
        String[] stringArray = string2.split("&");
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i].split("=");
            try {
                if (this.isPresent(string, URLDecoder.decode(stringArray2[0], "UTF-8")).booleanValue()) continue;
                this.showOnConsoleAndLog("No se encuentra el par\u00e1metro: " + stringArray2[0]);
                return false;
            }
            catch (Exception exception) {
                this.showOnConsoleAndLog("Error al decodificar el par\u00e1metro: " + stringArray2[0]);
                return false;
            }
        }
        return true;
    }

    public Integer getBriefReport() throws IOException, Exception {
        if (!this.tipo.toUpperCase().equals("M")) {
            this.advanceAllPendingSteps();
            return 15;
        }
        this.showOnConsoleAndLog("START BRIEF REPORT");
        this.configureCookies();
        this.prepareSslConnection();
        this.showOnConsoleAndLog("*** STEP 0");
        this.prepareConnectionToUrlWithReferer("https://sedeapl.dgt.gob.es:9443/WEB_INTV_INTER/xhtml/acciones/iniciarDatosVerificacion.jsf", NO_REFERER_URL);
        this.connection.connect();
        String string = this.getHtmlFromInputStream(this.getInputStream());
        this.cm.storeCookies(this.connection);
        this.window.setMessage("Solicitando informe para matr\u00edcula: " + this.matricula);
        this.advanceStep();
        this.showOnConsoleAndLog("*** STEP 1");
        String string2 = "javax.faces.ViewState=j_id24&verificarMatriculaForm=verificarMatriculaForm&verificarMatriculaForm%3Ahabilitar=true&verificarMatriculaForm%3AiTextMatricula=" + URLEncoder.encode(this.matricula, "UTF-8") + "&verificarMatriculaForm%3Aj_id26=Consultar";
        string = this.getHtmlFromInputStream(this.sendPostWithParameters("https://sedeapl.dgt.gob.es:9443/WEB_INTV_INTER/xhtml/acciones/iniciarDatosVerificacion.jsf", string, string2, "https://sedeapl.dgt.gob.es:9443/WEB_INTV_INTER/xhtml/acciones/iniciarDatosVerificacion.jsf"));
        this.window.setMessage(MESSAGE_STEP_3_DOWNLOADING_REPORT);
        this.advanceStep();
        if (this.isPresent(string, "sin incidencias").booleanValue()) {
            this.printDebugMessage("La matr\u00edcula " + this.matricula + " no tiene incidencias", 0);
            return 0;
        }
        if (this.isPresent(string, "con incidencias").booleanValue()) {
            this.printDebugMessage("La matr\u00edcula " + this.matricula + " tiene alguna incidencia", 6);
            return 6;
        }
        if (this.isPresent(string, "Se ha producido un error interno en el servicio").booleanValue()) {
            this.printDebugMessage("Se ha producido un error interno (probalemente no existe la matr\u00edcula (" + this.matricula + "))", 7);
            return 7;
        }
        if (this.isPresent(string, "El campo Matr&iacute;cula no es v&aacute;lido").booleanValue()) {
            this.printDebugMessage("El campo Matr\u00edcula (" + this.matricula + ") no es v\u00e1lido", 5);
            return 5;
        }
        this.printDebugMessage("Error no identificado (probalemente no existe la matr\u00edcula (" + this.matricula + "))", 100);
        return 100;
    }

    public Integer getCompleteReport() throws IOException, Exception {
        String string;
        Boolean bl = false;
        Boolean bl2 = false;
        Boolean bl3 = false;
        Boolean bl4 = false;
        this.showOnConsoleAndLog("START COMPLETE REPORT");
        this.showOnConsoleAndLog("URLS: ");
        this.showOnConsoleAndLog("https://sedeapl.dgt.gob.es:9443/WEB_INTV_INTER/xhtml/acciones/iniciarSolicitudInforme.jsf");
        this.showOnConsoleAndLog("https://sedeapl.dgt.gob.es:9443/WEB_INTV_INTER/xhtml/acciones/iniciarSolicitudInforme.jsf");
        this.showOnConsoleAndLog(COMPLETE_REPORT_URL_STEP_2);
        this.showOnConsoleAndLog(COMPLETE_REPORT_URL_STEP_3);
        this.showOnConsoleAndLog(COMPLETE_REPORT_URL_STEP_4);
        this.configureCookies();
        this.prepareSslConnection();
        this.showOnConsoleAndLog("*** STEP 0");
        this.prepareConnectionToUrlWithReferer("https://sedeapl.dgt.gob.es:9443/WEB_INTV_INTER/xhtml/acciones/iniciarSolicitudInforme.jsf", NO_REFERER_URL);
        this.connection.connect();
        System.out.println("*****************************************");
        System.out.println("connection.connect() cipherSuite: " + ((HttpsURLConnection)this.connection).getCipherSuite());
        System.out.println("*****************************************");
        String string2 = this.getHtmlFromInputStream(this.getInputStream());
        if (this.isPresent(string2, "Se ha producido un error").booleanValue()) {
            this.printDebugMessage("Se ha producido un error", 12);
            return 12;
        }
        this.showOnConsoleAndLog("*** STEP 1");
        if (this.tipo.toUpperCase().equals("M")) {
            this.window.setMessage("Solicitando informe para matr\u00edcula: " + this.matricula);
            this.showOnConsoleAndLog("Se solicita informe para la matr\u00edcula: " + this.matricula);
            string = "javax.faces.ViewState=j_id2&radioSelec=matricula&solicitarInformeForm=solicitarInformeForm&solicitarInformeForm%3Ahabilitar=true&solicitarInformeForm%3AiTextBastidor=&solicitarInformeForm%3AiTextMatricula=" + URLEncoder.encode(this.matricula, "UTF-8") + "&solicitarInformeForm%3AiTextNive=&solicitarInformeForm%3AmotivoSolicitudSelect=0&solicitarInformeForm%3AradioIdVehiculo=matricula&solicitarInformeForm%3AsolicitarInformeButton=Solicitar+informe&solicitarInformeForm%3AtipoInformeSelect=0&solicitarInformeForm%3Averificada=false&tipoIdentificador=matricula";
        } else {
            this.window.setMessage("Solicitando informe para bastidor: " + this.matricula);
            this.showOnConsoleAndLog("Se solicita informe para el bastidor: " + this.matricula);
            string = "javax.faces.ViewState=j_id2&radioSelec=bastidor&solicitarInformeForm=solicitarInformeForm&solicitarInformeForm%3Ahabilitar=true&solicitarInformeForm%3AiTextBastidor=" + URLEncoder.encode(this.matricula, "UTF-8") + "&solicitarInformeForm%3AiTextMatricula=&solicitarInformeForm%3AiTextNive=&solicitarInformeForm%3AmotivoSolicitudSelect=0&solicitarInformeForm%3AradioIdVehiculo=bastidor&solicitarInformeForm%3AsolicitarInformeButton=Solicitar+informe&solicitarInformeForm%3AtipoInformeSelect=0&solicitarInformeForm%3Averificada=false&tipoIdentificador=bastidor";
        }
        string2 = this.getHtmlFromInputStream(this.sendPostWithParameters("https://sedeapl.dgt.gob.es:9443/WEB_INTV_INTER/xhtml/acciones/iniciarSolicitudInforme.jsf", string2, string, "https://sedeapl.dgt.gob.es:9443/WEB_INTV_INTER/xhtml/acciones/iniciarSolicitudInforme.jsf"));
        if (this.isPresent(string2, "Informe previo").booleanValue()) {
            this.printDebugMessage("Existe informe previo", 1);
            bl = true;
            if (this.isPresent(string2, "mero de referencia completo de un pago").booleanValue()) {
                this.printDebugMessage("Se solicita NRC", 13);
                bl3 = true;
            }
        } else {
            if (this.isPresent(string2, "El campo Matr&iacute;cula no es v&aacute;lido").booleanValue()) {
                this.printDebugMessage("El campo matr\u00edcula no es v\u00e1lido", 7);
                return 7;
            }
            if (this.isPresent(string2, "El campo Identificaci&oacute;n del veh&iacute;culo es obligatorio").booleanValue()) {
                this.printDebugMessage("El campo de matr\u00edcula se ha recibido vac\u00edo", 7);
                return 7;
            }
            if (this.isPresent(string2, "Se ha producido un error interno en el servicio").booleanValue()) {
                this.printDebugMessage("Se ha producido un error interno (probalemente no existe la matr\u00edcula (" + this.matricula + "))", 7);
                return 7;
            }
            if (this.isPresent(string2, "El campo Bastidor es obligatorio").booleanValue()) {
                this.printDebugMessage("El campo Bastidor se ha recibido vac\u00edo", 8);
                return 7;
            }
            if (this.isPresent(string2, "El campo Bastidor no es v&aacute;lido").booleanValue()) {
                this.printDebugMessage("El campo Bastidor (" + this.matricula + ") no es v\u00e1lido", 10);
                return 10;
            }
            if (this.isPresent(string2, "El veh&iacute;culo informado tiene asociadas m&aacute;s de una matr&iacute;cula. S&oacute;lo es posible obtener el informe a trav&eacute;s de la matr&iacute;cula").booleanValue()) {
                this.printDebugMessage("El veh\u00edculo informado tiene asociadas m\u00e1s de una matr\u00edcula. S\u00f3lo es posible obtener el informe a trav\u00e9s de la matr\u00edcula", 9);
                return 9;
            }
            if (this.isPresent(string2, "No se puede facilitar informaci&oacute;n del bastidor").booleanValue()) {
                this.printDebugMessage("No se puede facilitar informaci\u00f3n (probalemente no existe el bastidor (" + this.matricula + "))", 8);
                return 8;
            }
            if (this.isPresent(string2, "IllegalArgumentException").booleanValue()) {
                this.printDebugMessage("Excepci\u00f3n por argumento ilegal (STEP_1)", 100);
                return 100;
            }
            if (this.isPresent(string2, "Se ha producido un error").booleanValue()) {
                this.printDebugMessage("Se ha producido un error", 12);
                return 12;
            }
            if (this.isPresent(string2, "mensajesErrorListaINTV").booleanValue()) {
                this.printDebugMessage("mensajesErrorListaINTV: ", 100);
                return 100;
            }
        }
        this.advanceStep();
        if (bl.booleanValue()) {
            this.showOnConsoleAndLog("*** STEP 1B (existe informe previo)");
            int n = this.getUserOptionForPreviousReport(bl3, string2);
            switch (n) {
                case 2: {
                    bl2 = true;
                    break;
                }
                case 1: {
                    if (this.nrc.equals(NO_REFERER_URL)) break;
                    bl4 = true;
                    break;
                }
                default: {
                    this.advanceAllPendingSteps();
                    this.printDebugMessage("Descarga de informe cancelada por el usuario ", 14);
                    return 14;
                }
            }
            if (bl2.booleanValue()) {
                this.showOnConsoleAndLog("Se solicita informe nuevo");
                this.window.setMessage("Aplicando tasa: " + this.tasa);
                string = "javax.faces.ViewState=j_id2&solicitarInformeForm=solicitarInformeForm&solicitarInformeForm%3Aj_id136=Continuar";
            } else if (!bl4.booleanValue()) {
                this.showOnConsoleAndLog("Se descarga informe previo");
                this.window.setMessage(MESSAGE_STEP_2_RECOVERING_PREVIOUS_REPORT);
                string = "javax.faces.ViewState=j_id2&solicitarInformeForm=solicitarInformeForm&solicitarInformeForm%3Aj_id136=Continuar&solicitarInformeForm%3AlistadoPagoNRC%3A0%3AinformePrevioCheck=on";
            } else {
                this.showOnConsoleAndLog("Se descarga informe previo con NRC: " + this.nrc);
                this.window.setMessage(MESSAGE_STEP_2_RECOVERING_PREVIOUS_REPORT);
                string = "javax.faces.ViewState=j_id2&solicitarInformeForm=solicitarInformeForm&solicitarInformeForm%3Aj_id136=Continuar&solicitarInformeForm%3AlistadoPagoNRC%3A0%3AinformePrevioCheck=on&solicitarInformeForm%3Anrc=" + URLEncoder.encode(this.nrc, "UTF-8");
            }
            string2 = this.getHtmlFromInputStream(this.sendPostWithParameters(COMPLETE_REPORT_URL_STEP_2, string2, string, "https://sedeapl.dgt.gob.es:9443/WEB_INTV_INTER/xhtml/acciones/iniciarSolicitudInforme.jsf"));
            if (this.isPresent(string2, "IllegalArgumentException").booleanValue()) {
                this.printDebugMessage("Excepci\u00f3n por argumento ilegal (STEP_1B)", 100);
                return 100;
            }
            if (this.isPresent(string2, "mensajesErrorListaINTV").booleanValue()) {
                this.printDebugMessage("mensajesErrorListaINTV: ", 100);
                return 100;
            }
        }
        this.showOnConsoleAndLog("*** STEP 2");
        if (!bl.booleanValue() || bl2.booleanValue()) {
            this.window.setMessage("Aplicando tasa: " + this.tasa);
            this.showOnConsoleAndLog("Se env\u00eda la tasa: " + this.tasa);
            string = "javax.faces.ViewState=j_id3&solicitarInformeForm=solicitarInformeForm&solicitarInformeForm%3AiTextTasa=" + URLEncoder.encode(this.tasa, "UTF-8") + "&solicitarInformeForm%3AsolicitarInformeButton=Solicitar&solicitarInformeForm%3AtipoPago=tasa&tipoIdentificador=tasa";
            if (!bl.booleanValue()) {
                string2 = this.getHtmlFromInputStream(this.sendPostWithParameters(COMPLETE_REPORT_URL_STEP_2, string2, string, "https://sedeapl.dgt.gob.es:9443/WEB_INTV_INTER/xhtml/acciones/iniciarSolicitudInforme.jsf"));
            } else if (bl2.booleanValue()) {
                string2 = this.getHtmlFromInputStream(this.sendPostWithParameters(COMPLETE_REPORT_URL_STEP_2, string2, string, COMPLETE_REPORT_URL_STEP_2));
            }
            if (this.isPresent(string2, "IllegalArgumentException").booleanValue()) {
                this.printDebugMessage("Excepci\u00f3n por argumento ilegal (STEP_2)", 100);
                return 100;
            }
            if (this.isPresent(string2, "Se ha producido un error").booleanValue()) {
                this.printDebugMessage("Se ha producido un error", 12);
                return 12;
            }
            if (this.isPresent(string2, "mensajesErrorListaINTV").booleanValue()) {
                this.printDebugMessage("mensajesErrorListaINTV: ", 100);
                return 100;
            }
        }
        this.advanceStep();
        if (!bl.booleanValue() || bl2.booleanValue()) {
            this.showOnConsoleAndLog("*** STEP 3");
            this.showOnConsoleAndLog("Se confirma la solicitud");
            string = "javax.faces.ViewState=j_id4&solicitarPagoInformeForm=solicitarPagoInformeForm&solicitarPagoInformeForm%3AdatosAfirmar=&solicitarPagoInformeForm%3AdatosFirmados=&solicitarPagoInformeForm%3Aj_id117=Solicitar";
            string2 = this.getHtmlFromInputStream(this.sendPostWithParameters(COMPLETE_REPORT_URL_STEP_3, string2, string, COMPLETE_REPORT_URL_STEP_2));
            if (this.isPresent(string2, " no es aplicable").booleanValue()) {
                this.printDebugMessage("La tasa no es aplicable", 3);
                return 3;
            }
            if (this.isPresent(string2, " no existente en el sistema").booleanValue()) {
                this.printDebugMessage("La tasa no existe en el sistema", 4);
                return 4;
            }
            if (this.isPresent(string2, "no autorizado para aplicar el tipo de tasa").booleanValue()) {
                this.printDebugMessage("Tr\u00e1mite no autorizado para aplicar el tipo de tasa solicitado", 2);
                return 2;
            }
            if (this.isPresent(string2, "El campo N&uacute;mero de Tasa no es v&aacute;lido").booleanValue()) {
                this.printDebugMessage("El n\u00famero de tasa no es v\u00e1lido", 2);
                return 2;
            }
            if (this.isPresent(string2, "El campo N&uacute;mero de Tasa es obligatorio").booleanValue()) {
                this.printDebugMessage("El n\u00famero de tasa no es v\u00e1lido", 2);
                return 2;
            }
            if (this.isPresent(string2, "no coincide con el precio actual de la tasa").booleanValue()) {
                this.printDebugMessage("El importe de la tasa recibida no coincide con el precio actual de la tasa", 16);
                return 16;
            }
            if (this.isPresent(string2, "El campo Justificante es obligatorio").booleanValue()) {
                this.printDebugMessage("El n\u00famero de tasa no es v\u00e1lido", 2);
                return 2;
            }
            if (this.isPresent(string2, "Pasados unos minutos vuelva a intentarlo introduciendo los mismos datos").booleanValue()) {
                this.printDebugMessage("Error web DGT (reintente en unos minutos): ", 13);
                return 13;
            }
            if (this.isPresent(string2, "IllegalArgumentException").booleanValue()) {
                this.printDebugMessage("Excepci\u00f3n por argumento ilegal (STEP_3)", 100);
                return 100;
            }
            if (this.isPresent(string2, "Se ha producido un error").booleanValue()) {
                this.printDebugMessage("Se ha producido un error", 12);
                return 12;
            }
            if (this.isPresent(string2, "mensajesErrorListaINTV").booleanValue()) {
                this.printDebugMessage("mensajesErrorListaINTV: ", 100);
                return 100;
            }
        }
        this.showOnConsoleAndLog("*** STEP 4");
        this.window.setMessage(MESSAGE_STEP_3_DOWNLOADING_REPORT);
        this.showOnConsoleAndLog("Se descarga el informe");
        if (!bl.booleanValue() || bl2.booleanValue()) {
            string = "botoneraForm=botoneraForm&botoneraForm%3Aj_id48=Descargar+informe&javax.faces.ViewState=j_id5";
            string2 = this.getHtmlFromInputStream(this.sendPostWithParameters(COMPLETE_REPORT_URL_STEP_4, string2, string, COMPLETE_REPORT_URL_STEP_3));
        } else {
            string = "botoneraForm=botoneraForm&botoneraForm%3Aj_id48=Descargar+informe&javax.faces.ViewState=j_id3";
            string2 = this.getHtmlFromInputStream(this.sendPostWithParameters(COMPLETE_REPORT_URL_STEP_4, string2, string, COMPLETE_REPORT_URL_STEP_2));
        }
        if (this.isPresent(string2, "Se ha producido un error").booleanValue()) {
            this.printDebugMessage("Se ha producido un error", 12);
            return 12;
        }
        if (this.isPresent(string2, "IllegalArgumentException").booleanValue()) {
            this.printDebugMessage("Excepci\u00f3n por argumento ilegal (STEP_4)", 100);
            return 100;
        }
        if (this.isPresent(string2, "mensajesErrorListaINTV").booleanValue()) {
            this.printDebugMessage("mensajesErrorListaINTV: ", 100);
            return 100;
        }
        return 0;
    }

    public Integer testConnection() {
        try {
            this.configureCookies();
            this.prepareSslConnection();
            this.prepareConnectionToUrlWithReferer("https://sedeapl.dgt.gob.es:9443/WEB_INTV_INTER/xhtml/acciones/iniciarSolicitudInforme.jsf", NO_REFERER_URL);
            this.connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            this.connection.setDoOutput(true);
            this.cm.setCookies(this.connection);
            this.connection.connect();
            OutputStream outputStream = this.connection.getOutputStream();
            outputStream.close();
            this.showOnConsoleAndLog("Returned code: " + ((HttpURLConnection)this.connection).getResponseCode());
            if (((HttpURLConnection)this.connection).getResponseCode() > 399) {
                throw new IOException();
            }
            this.showConnectionReceivedHeaders();
            this.cm.storeCookies(this.connection);
            InputStream inputStream = ((HttpURLConnection)this.connection).getInputStream();
            this.showOnConsoleAndLog(this.getHtmlFromInputStream(inputStream));
        }
        catch (MalformedURLException malformedURLException) {
            Logger.getLogger(DescargaInformeAction.class.getName()).log(Level.SEVERE, null, malformedURLException);
        }
        catch (IOException iOException) {
            Logger.getLogger(DescargaInformeAction.class.getName()).log(Level.SEVERE, null, iOException);
        }
        catch (Exception exception) {
            Logger.getLogger(DescargaInformeAction.class.getName()).log(Level.SEVERE, null, exception);
        }
        return 1;
    }

    @Override
    public Integer run() {
        this.showOnConsoleAndLog("run");
        int n = 0;
        this.showOnConsoleAndLog("Recibido identificador tipo: " + this.tipo);
        this.showOnConsoleAndLog("             indentificador: " + this.matricula);
        this.showOnConsoleAndLog("                       tasa: " + this.tasa);
        int n2 = this.verifyReportIdentifierType();
        if (n2 > 0) {
            this.advanceAllPendingSteps();
            return n2;
        }
        try {
            if (this.tipoInforme == "INTEVE") {
                n = this.getCompleteReport();
                for (int i = 10; n == 12 && i > 0; --i) {
                    while (this.stepCount > 1) {
                        this.window.previousElement();
                        --this.stepCount;
                    }
                    n = this.getCompleteReport();
                }
            } else {
                n = this.tipoInforme == "INTEVE_REDUCIDO" ? this.getBriefReport() : 100;
            }
        }
        catch (IOException iOException) {
            this.advanceAllPendingSteps();
            Logger.getLogger(HttpsDownloadAction.class.getName()).log(Level.SEVERE, null, iOException);
            n = 11;
        }
        catch (BadConformedFormException badConformedFormException) {
            this.advanceAllPendingSteps();
            Logger.getLogger(HttpsDownloadAction.class.getName()).log(Level.SEVERE, null, badConformedFormException);
            n = 17;
        }
        catch (Exception exception) {
            this.advanceAllPendingSteps();
            Logger.getLogger(DescargaInformeAction.class.getName()).log(Level.SEVERE, null, exception);
            n = 100;
        }
        this.showOnConsoleAndLog("reportResult: " + n + " - " + DescargaInformeAction.getErrorTextFromStatus(n));
        if (n > 0) {
            this.advanceAllPendingSteps();
        }
        return n;
    }
}

