/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.miniapplet;

import es.gob.afirma.core.AOException;
import es.gob.afirma.core.signers.AOSigner;
import es.gob.afirma.core.signers.CounterSignTarget;
import java.io.IOException;
import java.security.KeyStore;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;

final class CounterSignAction
implements PrivilegedExceptionAction<byte[]> {
    private static final String COUNTERSIGN_TARGET_KEY = "target";
    private static final String COUNTERSIGN_TARGET_TREE = "tree";
    private final AOSigner signer;
    private final byte[] sign;
    private final String algorithm;
    private final KeyStore.PrivateKeyEntry keyEntry;
    private final Properties extraParams;

    CounterSignAction(AOSigner aOSigner, byte[] byArray, String string, KeyStore.PrivateKeyEntry privateKeyEntry, Properties properties) {
        this.signer = aOSigner;
        this.sign = byArray != null ? (byte[])byArray.clone() : null;
        this.algorithm = string;
        this.keyEntry = privateKeyEntry;
        this.extraParams = properties;
    }

    @Override
    public byte[] run() throws AOException, IOException {
        String string;
        CounterSignTarget counterSignTarget = CounterSignTarget.LEAFS;
        if (this.extraParams.containsKey(COUNTERSIGN_TARGET_KEY) && COUNTERSIGN_TARGET_TREE.equalsIgnoreCase(string = this.extraParams.getProperty(COUNTERSIGN_TARGET_KEY).trim())) {
            counterSignTarget = CounterSignTarget.TREE;
        }
        return this.signer.countersign(this.sign, this.algorithm, counterSignTarget, null, this.keyEntry.getPrivateKey(), this.keyEntry.getCertificateChain(), this.extraParams);
    }
}

