/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.miniapplet;

import es.gob.afirma.keystores.filters.CertificateFilter;
import es.gob.afirma.keystores.filters.MultipleCertificateFilter;
import es.gob.afirma.keystores.filters.rfc.KeyUsageFilter;
import es.gob.afirma.keystores.filters.rfc.RFC2254CertificateFilter;
import es.gob.afirma.miniapplet.keystores.filters.AuthCertificateFilter;
import es.gob.afirma.miniapplet.keystores.filters.ExpiredCertificateFilter;
import es.gob.afirma.miniapplet.keystores.filters.QualifiedCertificatesFilter;
import es.gob.afirma.miniapplet.keystores.filters.SSLFilter;
import es.gob.afirma.miniapplet.keystores.filters.SignatureDNIeFilter;
import es.gob.afirma.miniapplet.keystores.filters.SigningCertificateFilter;
import es.gob.afirma.miniapplet.keystores.filters.TextContainedCertificateFilter;
import es.gob.afirma.miniapplet.keystores.filters.ThumprintCertificateFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;

final class CertFilterManager {
    private static final String HEADLESS_PREFIX_KEY = "headless";
    private static final String FILTER_PREFIX_KEY = "filter";
    private static final String FILTERS_PREFIX_KEY = "filters";
    private static final String FILTERS_ENUM_SEPARATOR = ".";
    private static final String FILTERS_SEPARATOR = ";";
    private static final String FILTER_TYPE_DNIE = "dnie:";
    private static final String FILTER_TYPE_SSL = "ssl:";
    private static final String FILTER_TYPE_QUALIFIED = "qualified:";
    private static final String FILTER_TYPE_SIGNING_CERTIFICATE = "signingcert:";
    private static final String FILTER_TYPE_AUTHENTICATION_CERTIFICATE = "authcert:";
    private static final String FILTER_TYPE_NON_EXPIRED = "nonexpired:";
    private static final String FILTER_TYPE_SUBJECT_RFC2254 = "subject.rfc2254:";
    private static final String FILTER_TYPE_SUBJECT_CONTAINS = "subject.contains:";
    private static final String FILTER_TYPE_ISSUER_RFC2254 = "issuer.rfc2254:";
    private static final String FILTER_TYPE_ISSUER_CONTAINS = "issuer.contains:";
    private static final String FILTER_PREFIX_KEYUSAGE = "keyusage.";
    private static final String FILTER_TYPE_KEYUSAGE_DIGITAL_SIGNATURE = "keyusage.digitalsignature:";
    private static final String FILTER_TYPE_KEYUSAGE_NON_REPUDIATION = "keyusage.nonrepudiation:";
    private static final String FILTER_TYPE_KEYUSAGE_KEY_ENCIPHERMENT = "keyusage.keyencipherment:";
    private static final String FILTER_TYPE_KEYUSAGE_DATA_ENCIPHERMENT = "keyusage.dataencipherment:";
    private static final String FILTER_TYPE_KEYUSAGE_KEY_AGREEMENT = "keyusage.keyagreement:";
    private static final String FILTER_TYPE_KEYUSAGE_KEY_CERT_SIGN = "keyusage.keycertsign:";
    private static final String FILTER_TYPE_KEYUSAGE_CRL_SIGN = "keyusage.crlsign:";
    private static final String FILTER_TYPE_KEYUSAGE_ENCIPHER_ONLY = "keyusage.encipheronly:";
    private static final String FILTER_TYPE_KEYUSAGE_DECIPHER_ONLY = "keyusage.decipheronly:";
    private static final String FILTER_TYPE_THUMBPRINT = "thumbprint:";
    private boolean mandatoryCertificate = false;
    private final ArrayList<CertificateFilter> filters = new ArrayList();

    CertFilterManager(Properties properties) {
        this.mandatoryCertificate = Boolean.parseBoolean(properties.getProperty(HEADLESS_PREFIX_KEY));
        List<String> list = CertFilterManager.getFilterValues(properties);
        if (list.isEmpty()) {
            return;
        }
        for (String string : list) {
            this.filters.add(CertFilterManager.parseFilter(string));
        }
    }

    private static List<String> getFilterValues(Properties properties) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (properties.containsKey(FILTER_PREFIX_KEY)) {
            arrayList.add(properties.getProperty(FILTER_PREFIX_KEY));
        } else if (properties.containsKey(FILTERS_PREFIX_KEY)) {
            arrayList.add(properties.getProperty(FILTERS_PREFIX_KEY));
        } else if (properties.containsKey("filters.1")) {
            int n = 1;
            while (properties.containsKey("filters." + n)) {
                arrayList.add(properties.getProperty("filters." + n));
                ++n;
            }
        }
        return arrayList;
    }

    private static CertificateFilter parseFilter(String string) {
        ArrayList<CertificateFilter> arrayList = new ArrayList<CertificateFilter>();
        Object[] objectArray = string.split(FILTERS_SEPARATOR);
        Arrays.sort(objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            Object[] objectArray2;
            Object object = objectArray[i];
            if (((String)object).toLowerCase().startsWith(FILTER_TYPE_DNIE)) {
                arrayList.add(new SignatureDNIeFilter());
                continue;
            }
            if (((String)object).toLowerCase().startsWith(FILTER_TYPE_SSL)) {
                arrayList.add(new SSLFilter(((String)object).substring(FILTER_TYPE_SSL.length())));
                continue;
            }
            if (((String)object).toLowerCase().startsWith(FILTER_TYPE_QUALIFIED)) {
                arrayList.add(new QualifiedCertificatesFilter(((String)object).substring(FILTER_TYPE_QUALIFIED.length())));
                continue;
            }
            if (((String)object).toLowerCase().startsWith(FILTER_TYPE_SIGNING_CERTIFICATE)) {
                arrayList.add(new SigningCertificateFilter());
                continue;
            }
            if (((String)object).toLowerCase().startsWith(FILTER_TYPE_AUTHENTICATION_CERTIFICATE)) {
                arrayList.add(new AuthCertificateFilter());
                continue;
            }
            if (((String)object).toLowerCase().startsWith(FILTER_PREFIX_KEYUSAGE)) {
                objectArray2 = new Boolean[9];
                do {
                    CertFilterManager.processKeyUsageFilterDeclaration((String)object, (Boolean[])objectArray2);
                } while (objectArray.length > i + 1 && ((String)objectArray[i + 1]).startsWith(FILTER_PREFIX_KEYUSAGE) && ((String)(object = objectArray[++i])).toLowerCase().startsWith(FILTER_PREFIX_KEYUSAGE));
                arrayList.add(new KeyUsageFilter((Boolean[])objectArray2));
                continue;
            }
            if (((String)object).toLowerCase().startsWith(FILTER_TYPE_NON_EXPIRED)) {
                arrayList.add(new ExpiredCertificateFilter());
                continue;
            }
            if (((String)object).toLowerCase().startsWith(FILTER_TYPE_SUBJECT_RFC2254)) {
                arrayList.add(new RFC2254CertificateFilter(((String)object).substring(FILTER_TYPE_SUBJECT_RFC2254.length()), null));
                continue;
            }
            if (((String)object).toLowerCase().startsWith(FILTER_TYPE_SUBJECT_CONTAINS)) {
                arrayList.add(new TextContainedCertificateFilter(new String[]{((String)object).substring(FILTER_TYPE_SUBJECT_CONTAINS.length())}, null));
                continue;
            }
            if (((String)object).toLowerCase().startsWith(FILTER_TYPE_ISSUER_RFC2254)) {
                arrayList.add(new RFC2254CertificateFilter(null, ((String)object).substring(FILTER_TYPE_ISSUER_RFC2254.length())));
                continue;
            }
            if (((String)object).toLowerCase().startsWith(FILTER_TYPE_ISSUER_CONTAINS)) {
                arrayList.add(new TextContainedCertificateFilter(null, new String[]{((String)object).substring(FILTER_TYPE_ISSUER_CONTAINS.length())}));
                continue;
            }
            if (!((String)object).toLowerCase().startsWith(FILTER_TYPE_THUMBPRINT) || (objectArray2 = ((String)object).substring(FILTER_TYPE_THUMBPRINT.length()).split(":")).length != 2) continue;
            arrayList.add(new ThumprintCertificateFilter((String)objectArray2[0], (String)(objectArray2.length > 1 ? objectArray2[1] : null)));
        }
        return arrayList.size() == 1 ? (CertificateFilter)arrayList.get(0) : new MultipleCertificateFilter(arrayList.toArray(new CertificateFilter[arrayList.size()]));
    }

    private static void processKeyUsageFilterDeclaration(String string, Boolean[] booleanArray) {
        int n;
        if (string.toLowerCase().startsWith(FILTER_TYPE_KEYUSAGE_DIGITAL_SIGNATURE)) {
            n = 0;
        } else if (string.toLowerCase().startsWith(FILTER_TYPE_KEYUSAGE_NON_REPUDIATION)) {
            n = 1;
        } else if (string.toLowerCase().startsWith(FILTER_TYPE_KEYUSAGE_KEY_ENCIPHERMENT)) {
            n = 2;
        } else if (string.toLowerCase().startsWith(FILTER_TYPE_KEYUSAGE_DATA_ENCIPHERMENT)) {
            n = 3;
        } else if (string.toLowerCase().startsWith(FILTER_TYPE_KEYUSAGE_KEY_AGREEMENT)) {
            n = 4;
        } else if (string.toLowerCase().startsWith(FILTER_TYPE_KEYUSAGE_KEY_CERT_SIGN)) {
            n = 5;
        } else if (string.toLowerCase().startsWith(FILTER_TYPE_KEYUSAGE_CRL_SIGN)) {
            n = 6;
        } else if (string.toLowerCase().startsWith(FILTER_TYPE_KEYUSAGE_ENCIPHER_ONLY)) {
            n = 7;
        } else if (string.toLowerCase().startsWith(FILTER_TYPE_KEYUSAGE_DECIPHER_ONLY)) {
            n = 8;
        } else {
            return;
        }
        String string2 = string.substring(string.indexOf(":") + 1);
        booleanArray[n] = string2.equalsIgnoreCase("null") ? null : Boolean.valueOf(string2);
    }

    List<CertificateFilter> getFilters() {
        return this.filters != null ? new ArrayList<CertificateFilter>(this.filters) : null;
    }

    boolean isMandatoryCertificate() {
        return this.mandatoryCertificate;
    }
}

