/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.keystores.pkcs12;

import es.gob.afirma.keystores.AOKeyStore;
import es.gob.afirma.keystores.AOKeyStoreManager;
import es.gob.afirma.keystores.AOKeyStoreManagerException;
import es.gob.afirma.keystores.callbacks.CachePasswordCallback;
import es.gob.afirma.keystores.callbacks.NullPasswordCallback;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableEntryException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.crypto.BadPaddingException;
import javax.security.auth.callback.PasswordCallback;

public final class Pkcs12KeyStoreManager
extends AOKeyStoreManager {
    private PasswordCallback cachePasswordCallback;

    @Override
    public void init(AOKeyStore aOKeyStore, InputStream inputStream, PasswordCallback passwordCallback, Object[] objectArray, boolean bl) throws AOKeyStoreManagerException, IOException {
        this.setKeyStoreType(AOKeyStore.PKCS12);
        this.setKeyStore(this.init(inputStream, passwordCallback));
    }

    private KeyStore init(InputStream inputStream, PasswordCallback passwordCallback) throws AOKeyStoreManagerException, IOException {
        KeyStore keyStore;
        if (inputStream == null) {
            throw new IllegalArgumentException("Es necesario proporcionar el fichero PKCS12 / PFX");
        }
        try {
            keyStore = KeyStore.getInstance(this.getType().getProviderName());
        }
        catch (Exception exception) {
            throw new AOKeyStoreManagerException("No se ha podido obtener el almacen PKCS#12 / PFX", exception);
        }
        this.cachePasswordCallback = passwordCallback != null ? new CachePasswordCallback(passwordCallback.getPassword()) : NullPasswordCallback.getInstance();
        try {
            keyStore.load(inputStream, this.cachePasswordCallback.getPassword());
        }
        catch (IOException iOException) {
            if (iOException.getCause() instanceof UnrecoverableKeyException || iOException.getCause() instanceof BadPaddingException || iOException.getCause() instanceof ArithmeticException) {
                throw new IOException("Contrasena invalida: " + iOException, iOException);
            }
        }
        catch (CertificateException certificateException) {
            throw new AOKeyStoreManagerException("No se han podido cargar los certificados del almacen PKCS#12 / PFX solicitado.", certificateException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AOKeyStoreManagerException("No se ha podido verificar la integridad del almacen PKCS#12 / PFX solicitado.", noSuchAlgorithmException);
        }
        try {
            inputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return keyStore;
    }

    @Override
    public AOKeyStore getType() {
        return AOKeyStore.PKCS12;
    }

    @Override
    public KeyStore.PrivateKeyEntry getKeyEntry(String string, PasswordCallback passwordCallback) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableEntryException {
        if (this.lacksKeyStores()) {
            throw new IllegalStateException("Se han pedido claves a un almacen no inicializado");
        }
        try {
            return super.getKeyEntry(string, this.cachePasswordCallback);
        }
        catch (Exception exception) {
            try {
                return super.getKeyEntry(string, NullPasswordCallback.getInstance());
            }
            catch (Exception exception2) {
                return super.getKeyEntry(string, passwordCallback);
            }
        }
    }
}

