/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.keystores.mozilla;

import es.gob.afirma.core.AOCancelledOperationException;
import es.gob.afirma.keystores.AOKeyStore;
import es.gob.afirma.keystores.AOKeyStoreManager;
import es.gob.afirma.keystores.AOKeyStoreManagerException;
import es.gob.afirma.keystores.callbacks.UIPasswordCallback;
import es.gob.afirma.keystores.mozilla.FirefoxKeyStoreMessages;
import es.gob.afirma.keystores.mozilla.MozillaKeyStoreUtilities;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.Provider;
import javax.security.auth.callback.PasswordCallback;

final class NssKeyStoreManager
extends AOKeyStoreManager {
    private static Provider nssProvider = null;
    private final Object parentComponent;

    NssKeyStoreManager(Object object) {
        this.setKeyStoreType(AOKeyStore.MOZ_UNI);
        this.parentComponent = object;
    }

    @Override
    public void init(AOKeyStore aOKeyStore, InputStream inputStream, PasswordCallback passwordCallback, Object[] objectArray, boolean bl) throws AOKeyStoreManagerException {
        Provider provider = NssKeyStoreManager.getNssProvider();
        KeyStore keyStore = null;
        if (provider != null) {
            try {
                keyStore = KeyStore.getInstance("PKCS11", provider);
            }
            catch (Exception exception) {
                LOGGER.warning("No se ha podido obtener el KeyStore PKCS#11 NSS del proveedor SunPKCS11: " + exception);
                keyStore = null;
            }
        }
        if (keyStore != null) {
            try {
                keyStore.load(null, new char[0]);
            }
            catch (Exception exception) {
                try {
                    keyStore.load(null, passwordCallback != null ? passwordCallback.getPassword() : new UIPasswordCallback(FirefoxKeyStoreMessages.getString("MozillaUnifiedKeyStoreManager.0"), this.parentComponent).getPassword());
                }
                catch (AOCancelledOperationException aOCancelledOperationException) {
                    keyStore = null;
                    throw aOCancelledOperationException;
                }
                catch (Exception exception2) {
                    LOGGER.warning("No se ha podido abrir el almacen PKCS#11 NSS del proveedor SunPKCS11: " + exception2);
                    keyStore = null;
                }
            }
        }
        if (keyStore != null) {
            this.setKeyStore(keyStore);
        }
    }

    private static Provider getNssProvider() {
        if (nssProvider != null) {
            return nssProvider;
        }
        try {
            nssProvider = MozillaKeyStoreUtilities.loadNSS();
        }
        catch (Exception exception) {
            LOGGER.severe("Error inicializando el proveedor NSS: " + exception);
            nssProvider = null;
        }
        return nssProvider;
    }
}

