/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.keystores.mozilla;

import es.gob.afirma.core.AOCancelledOperationException;
import es.gob.afirma.keystores.AOKeyStore;
import es.gob.afirma.keystores.AOKeyStoreManager;
import es.gob.afirma.keystores.AOKeyStoreManagerException;
import es.gob.afirma.keystores.AOKeyStoreManagerFactory;
import es.gob.afirma.keystores.AggregatedKeyStoreManager;
import es.gob.afirma.keystores.callbacks.UIPasswordCallback;
import es.gob.afirma.keystores.mozilla.FirefoxKeyStoreMessages;
import es.gob.afirma.keystores.mozilla.MozillaKeyStoreUtilities;
import es.gob.afirma.keystores.mozilla.NssKeyStoreManager;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.security.auth.callback.PasswordCallback;

public final class MozillaUnifiedKeyStoreManager
extends AggregatedKeyStoreManager {
    @Override
    public void init(AOKeyStore aOKeyStore, InputStream inputStream, PasswordCallback passwordCallback, Object[] objectArray, boolean bl) throws AOKeyStoreManagerException, IOException {
        Object object;
        Object object2 = objectArray != null && objectArray.length > 0 ? objectArray[0] : null;
        NssKeyStoreManager nssKeyStoreManager = new NssKeyStoreManager(object2);
        ((AOKeyStoreManager)nssKeyStoreManager).init(aOKeyStore, inputStream, passwordCallback, objectArray, bl);
        this.addKeyStoreManager(nssKeyStoreManager);
        Map<String, String> map = MozillaKeyStoreUtilities.getMozillaPKCS11Modules(true, true);
        if (map.size() > 0) {
            object = new StringBuilder("Encontrados los siguientes modulos PKCS#11 externos instalados en Mozilla / Firefox: ");
            for (String exception : map.keySet()) {
                ((StringBuilder)object).append("'");
                ((StringBuilder)object).append(map.get(exception));
                ((StringBuilder)object).append("' ");
            }
            LOGGER.info(((StringBuilder)object).toString());
        } else {
            LOGGER.info("No se han encontrado modulos PKCS#11 externos instalados en Firefox");
        }
        for (String string : map.keySet()) {
            try {
                AOKeyStoreManager aOKeyStoreManager = new AOKeyStoreManager();
                aOKeyStoreManager.init(AOKeyStore.PKCS11, null, new UIPasswordCallback(FirefoxKeyStoreMessages.getString("MozillaUnifiedKeyStoreManager.1") + " " + MozillaKeyStoreUtilities.getMozModuleName(string.toString()), object2), new String[]{map.get(string), string.toString()}, bl);
                this.addKeyStoreManager(aOKeyStoreManager);
            }
            catch (AOCancelledOperationException aOCancelledOperationException) {
                LOGGER.warning("Se cancelo el acceso al almacen externo  '" + string + "', se continuara con el siguiente: " + aOCancelledOperationException);
                continue;
            }
            catch (Exception exception) {
                LOGGER.severe("No se ha podido inicializar el PKCS#11 '" + string + "': " + exception);
                continue;
            }
            LOGGER.info("El almacen externo '" + string + "' ha podido inicializarse, se anadiran sus entradas");
        }
        try {
            object = AOKeyStoreManagerFactory.getAOKeyStoreManager(AOKeyStore.DNIEJAVA, null, null, null, object2);
            LOGGER.info("El DNIe 100% Java ha podido inicializarse, se anadiran sus entradas");
            this.addKeyStoreManager((AOKeyStoreManager)object);
        }
        catch (AOCancelledOperationException aOCancelledOperationException) {
            LOGGER.warning("Se cancelo el acceso al almacen DNIe 100% Java: " + aOCancelledOperationException);
        }
        catch (Exception exception) {
            LOGGER.warning("No se ha podido inicializar el controlador DNIe 100% Java: " + exception);
        }
        if (this.lacksKeyStores()) {
            throw new AOKeyStoreManagerException("No se ha podido inicializar ningun almacen, interno o externo, de Firefox");
        }
    }
}

