/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.keystores.mozilla;

import es.gob.afirma.core.AOException;
import es.gob.afirma.core.misc.AOUtil;
import es.gob.afirma.core.misc.Platform;
import es.gob.afirma.keystores.KeyStoreUtilities;
import es.gob.afirma.keystores.mozilla.MozillaKeyStoreUtilities;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.logging.Logger;

final class MozillaKeyStoreUtilitiesWindows {
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");
    private static final String P11_CONFIG_VALID_CHARS = ":\\0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ-_.~";
    private static final String SOFTOKN3_DLL = "softokn3.dll";
    private static final String MSVCR100_DLL = "msvcr100.dll";
    private static final String MSVCP100_DLL = "msvcp100.dll";
    private static final String PLC4_DLL = "plc4.dll";
    private static final String PLDS4_DLL = "plds4.dll";
    private static final String NSPR4_DLL = "nspr4.dll";
    private static final String MOZSQLITE3_DLL = "mozsqlite3.dll";
    private static final String MOZCRT19_DLL = "mozcrt19.dll";
    private static final String NSSUTIL3_DLL = "nssutil3.dll";
    private static final String FREEBL3_DLL = "freebl3.dll";
    private static final String NSSDBM3_DLL = "nssdbm3.dll";
    private static final String SQLITE3_DLL = "sqlite3.dll";
    private static final String MOZUTILS_DLL = "mozutils.dll";
    private static final String MOZGLUE_DLL = "mozglue.dll";
    private static final String NSS3_DLL = "nss3.dll";
    private static String appData = null;

    private MozillaKeyStoreUtilitiesWindows() {
    }

    static String cleanMozillaUserProfileDirectoryWindows(String string) {
        String string2 = string;
        for (char c : string2.toCharArray()) {
            if (P11_CONFIG_VALID_CHARS.indexOf(c) != -1) continue;
            string2 = string2.replace(Platform.getUserHome(), KeyStoreUtilities.getShort(Platform.getUserHome()));
            break;
        }
        return string2.replace('\\', '/');
    }

    static String getSystemNSSLibDirWindows() throws IOException {
        String string = MozillaKeyStoreUtilities.getNssPathFromCompatibilityFile();
        if (string == null) {
            throw new FileNotFoundException("No se encuentra el dierctorio de NSS en Windows");
        }
        boolean bl = false;
        for (char c : string.toCharArray()) {
            if (P11_CONFIG_VALID_CHARS.indexOf(c) != -1) continue;
            bl = true;
            break;
        }
        if (bl) {
            try {
                File file = new File(new File(Platform.getSystemLibDir()).getParent(), "Temp");
                Object object = file.isDirectory() && file.canWrite() && file.canRead() ? File.createTempFile("nss", null, file) : (Object)File.createTempFile("nss", null);
                ((File)object).delete();
                if (!((File)object).mkdir()) {
                    throw new AOException("No se ha creado el directorio temporal");
                }
                MozillaKeyStoreUtilitiesWindows.copyFile(new String[]{SOFTOKN3_DLL, MOZSQLITE3_DLL, SQLITE3_DLL, NSS3_DLL, PLDS4_DLL, NSPR4_DLL, PLC4_DLL, MOZCRT19_DLL, NSSUTIL3_DLL, FREEBL3_DLL, NSSDBM3_DLL, MOZUTILS_DLL, MOZGLUE_DLL}, string, ((File)object).getCanonicalPath());
                string = ((File)object).getCanonicalPath();
            }
            catch (Exception exception) {
                LOGGER.warning("No se ha podido duplicar NSS en un directorio temporal, si esta version de JRE esta afectada por el error 6581254 de Java es posible que no pueda cargarse: " + exception);
            }
        }
        if (string != null) {
            return string;
        }
        throw new FileNotFoundException("No se ha encontrado un NSS compatible en Windows");
    }

    static String[] getSoftkn3DependenciesWindows(String string) {
        return new String[]{string + MSVCR100_DLL, string + MSVCP100_DLL, string + MOZGLUE_DLL, string + NSS3_DLL, string + MOZUTILS_DLL, string + MOZCRT19_DLL, string + NSPR4_DLL, string + PLDS4_DLL, string + PLC4_DLL, string + NSSUTIL3_DLL, string + MOZSQLITE3_DLL, string + SQLITE3_DLL, string + NSSDBM3_DLL, string + FREEBL3_DLL};
    }

    static String getWindowsAppDataDir() {
        String string;
        if (appData == null && (string = System.getenv("AppData")) != null) {
            LOGGER.info("Se ha comprobado la situacion del directorio 'AppData' de Windows a traves de la variable de entorno");
            appData = string;
        }
        if (appData != null) {
            return appData;
        }
        string = "C:\\Users\\" + System.getProperty("user.name") + "\\AppData\\Roaming";
        File file = new File(string);
        if (file.exists() && file.isDirectory()) {
            appData = string;
            LOGGER.info("Se ha comprobado la situacion del directorio 'AppData' de Windows manualmente");
            return appData;
        }
        appData = null;
        throw new IllegalStateException("No se ha podido determinar la situacion del directorio 'AppData' de Windows");
    }

    private static void copyFile(String[] stringArray, String string, String string2) {
        if (stringArray != null) {
            for (String string3 : stringArray) {
                File file = new File(string, string3);
                if (!file.exists()) continue;
                try {
                    AOUtil.copyFile(file, new File(string2, string3));
                }
                catch (IOException iOException) {
                    LOGGER.warning("No se ha podido copiar '" + string3 + "' a '" + string2 + "': " + iOException);
                }
            }
        }
    }
}

