/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.keystores.mozilla;

import es.gob.afirma.core.AOException;
import es.gob.afirma.core.misc.Platform;
import es.gob.afirma.keystores.mozilla.AOSecMod;
import es.gob.afirma.keystores.mozilla.MozillaKeyStoreUtilitiesWindows;
import es.gob.afirma.keystores.mozilla.NSPreferences;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import javax.script.ScriptEngineManager;

final class MozillaKeyStoreUtilities {
    private static final String LIB_NSPR4_SO = "/lib/libnspr4.so";
    private static final String SOFTOKN3_SO = "libsoftokn3.so";
    private static final String SOFTOKN3_DLL = "softokn3.dll";
    private static final String AFIRMA_NSS_HOME = "AFIRMA_NSS_HOME";
    private static final String AFIRMA_PROFILES_INI = "AFIRMA_PROFILES_INI";
    private static final String USE_ENV_VARS = "es.gob.afirma.keystores.mozilla.UseEnvironmentVariables";
    private static final String[] DNI_P11_NAMES = new String[]{"libopensc-dnie.dylib", "libopensc-dnie.so", "usrpkcs11.dll", "dnie_p11_priv.dll", "dnie_p11_pub.dll", "opensc-pkcs11.dll", "FNMT_P11.dll"};
    private static final String[][] KNOWN_MODULES = new String[][]{{"FNMT-RCM CERES (preinstalado)", "FNMT_P11.dll"}, {"Atos CardOS (preinstalado)", "siecap11.dll"}};
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");
    private static String nssLibDir = null;

    private MozillaKeyStoreUtilities() {
    }

    static String createPKCS11NSSConfigFile(String string, String string2) {
        String string3 = Platform.getOS().equals((Object)Platform.OS.WINDOWS) ? SOFTOKN3_DLL : (Platform.getOS().equals((Object)Platform.OS.MACOSX) ? "libsoftokn3.dylib" : SOFTOKN3_SO);
        StringBuilder stringBuilder = new StringBuilder("name=NSSCrypto-AFirma\r\n");
        stringBuilder.append("library=").append(string2).append(File.separator).append(string3).append("\n").append("attributes=compatibility\n").append("slot=2\n").append("showInfo=false\n").append("allowSingleThreadedModules=true\n").append("nssArgs=\"").append("configdir='").append(string).append("' ").append("certPrefix='' ").append("keyPrefix='' ").append("secmod='secmod.db' ").append("flags='readOnly'").append("\"");
        return stringBuilder.toString();
    }

    private static String getSystemNSSLibDirMacOsX() throws FileNotFoundException {
        String[] stringArray;
        for (String string : stringArray = new String[]{"/Applications/Firefox.app/Contents/MacOS", "/lib", "/usr/lib", "/usr/lib/nss", "/Applications/Minefield.app/Contents/MacOS"}) {
            if (!new File(string + "/libsoftokn3.dylib").exists()) continue;
            nssLibDir = string;
        }
        if (nssLibDir == null) {
            throw new FileNotFoundException("No se ha podido determinar la localizacion de NSS en Mac OS X");
        }
        return nssLibDir;
    }

    private static String getSystemNSSLibDirUnix() throws FileNotFoundException {
        String[] stringArray;
        if (nssLibDir != null && !"".equals(nssLibDir)) {
            return nssLibDir;
        }
        if (new File("/usr/lib/libsoftokn3.so").exists() && new File(LIB_NSPR4_SO).exists()) {
            try {
                System.load(LIB_NSPR4_SO);
                nssLibDir = "/usr/lib";
            }
            catch (Exception exception) {
                nssLibDir = null;
                LOGGER.warning("Descartamos el NSS situado entre /lib y /usr/lib porque no puede cargarse adecuadamente: " + exception);
            }
            if (nssLibDir != null) {
                return nssLibDir;
            }
        }
        for (String string : stringArray = new String[]{"/usr/lib/firefox", "/usr/lib/firefox-" + MozillaKeyStoreUtilities.searchLastFirefoxVersion("/usr/lib/"), "/opt/firefox", "/opt/firefox-" + MozillaKeyStoreUtilities.searchLastFirefoxVersion("/opt/"), "/lib", "/usr/lib", "/usr/lib/nss", "/usr/lib/i386-linux-gnu/nss", "/opt/fedora-ds/clients/lib", "/opt/google/chrome", "/usr/lib/thunderbird", "/usr/lib64"}) {
            String string2 = "/libnspr4.so";
            if (new File(string + "/mozsqlite3.so").exists()) {
                string2 = "/mozsqlite3.so";
            } else if (new File(string + "/libmozsqlite3.so").exists()) {
                string2 = "/libmozsqlite3.so";
            }
            if (!new File(string + "/" + SOFTOKN3_SO).exists() || !new File(string + string2).exists()) continue;
            try {
                System.load(string + string2);
                nssLibDir = string;
            }
            catch (Exception exception) {
                nssLibDir = null;
                LOGGER.warning("Descartamos el NSS situado en '" + string + "' porque no puede cargarse adecuadamente: " + exception);
            }
            if (nssLibDir == null) continue;
            return nssLibDir;
        }
        if (nssLibDir == null) {
            throw new FileNotFoundException("No se ha podido determinar la localizacion de NSS en UNIX");
        }
        return nssLibDir;
    }

    static String getNssPathFromCompatibilityFile() throws IOException {
        File file = new File(MozillaKeyStoreUtilities.getMozillaUserProfileDirectory(), "compatibility.ini");
        if (file.exists() && file.canRead()) {
            String string;
            FileInputStream fileInputStream = new FileInputStream(file);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
            String string2 = null;
            while ((string = bufferedReader.readLine()) != null) {
                if (!string.startsWith("LastPlatformDir=")) continue;
                string2 = string.replace("LastPlatformDir=", "").trim();
                break;
            }
            bufferedReader.close();
            if (string2 != null) {
                return string2;
            }
        }
        throw new FileNotFoundException("No se ha podido deternimar el directorio de NSS en Windows a partir de 'compatibility.ini' de Firefox");
    }

    private static String getSystemNSSLibDir() throws IOException {
        File file;
        if (nssLibDir != null) {
            return nssLibDir;
        }
        if (Boolean.getBoolean(USE_ENV_VARS)) {
            try {
                nssLibDir = System.getenv(AFIRMA_NSS_HOME);
            }
            catch (Exception exception) {
                LOGGER.warning("No se tiene acceso a la variable de entorno 'AFIRMA_NSS_HOME': " + exception);
            }
            if (nssLibDir != null) {
                file = new File(nssLibDir);
                if (file.isDirectory() && file.canRead()) {
                    LOGGER.info("Directorio de NSS determinado a partir de la variable de entorno 'AFIRMA_NSS_HOME'");
                    return nssLibDir;
                }
                LOGGER.warning("La variable de entorno 'AFIRMA_NSS_HOME' apunta a un directorio que no existe o sobre el que no se tienen permisos de lectura, se ignorara");
            }
        }
        if (Platform.getOS().equals((Object)Platform.OS.WINDOWS)) {
            return MozillaKeyStoreUtilitiesWindows.getSystemNSSLibDirWindows();
        }
        if (Platform.OS.WINDOWS.equals((Object)Platform.getOS()) || Platform.OS.MACOSX.equals((Object)Platform.getOS())) {
            try {
                nssLibDir = MozillaKeyStoreUtilities.getNssPathFromCompatibilityFile();
                LOGGER.info("Directorio de NSS determinado a partir de 'compatibility.ini' de Firefox");
            }
            catch (Exception exception) {
                LOGGER.warning("No se ha podido acceder a 'compatibility.ini' de Mozilla: " + exception);
            }
            if (nssLibDir != null) {
                file = new File(nssLibDir);
                if (file.isDirectory() && file.canRead()) {
                    LOGGER.info("Directorio de NSS determinado a partir de 'compatibility.ini' de Mozilla");
                    return nssLibDir;
                }
                LOGGER.warning("'compatibility.ini' de Mozilla apunta a un directorio que no existe o sobre el que no se tienen permisos de lectura, se ignorara");
            }
        }
        if (Platform.getOS().equals((Object)Platform.OS.LINUX) || Platform.getOS().equals((Object)Platform.OS.SOLARIS)) {
            return MozillaKeyStoreUtilities.getSystemNSSLibDirUnix();
        }
        if (Platform.getOS().equals((Object)Platform.OS.MACOSX)) {
            return MozillaKeyStoreUtilities.getSystemNSSLibDirMacOsX();
        }
        throw new FileNotFoundException("No se han encontrado bibliotecas NSS instaladas en su sistema operativo");
    }

    private static String searchLastFirefoxVersion(String string) {
        File file = new File(string);
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string2 : stringArray) {
                if (!string2.startsWith("firefox-")) continue;
                arrayList.add(string2.replace("firefox-", ""));
            }
            if (arrayList.isEmpty()) {
                return "";
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                try {
                    Integer.getInteger((String)arrayList.get(i));
                    continue;
                }
                catch (Exception exception) {
                    arrayList.remove(i);
                }
            }
            if (arrayList.size() == 1) {
                return (String)arrayList.get(0);
            }
            Collections.sort(arrayList, new Comparator<String>(){

                @Override
                public int compare(String string, String string2) {
                    return string.compareTo(string2);
                }
            });
            return (String)arrayList.get(0);
        }
        return "";
    }

    static Map<String, String> getMozillaPKCS11Modules(boolean bl, boolean bl2) {
        List<AOSecMod.ModuleName> list;
        ConcurrentHashMap<String, String> concurrentHashMap = new ConcurrentHashMap<String, String>();
        try {
            list = AOSecMod.getModules(MozillaKeyStoreUtilities.getMozillaUserProfileDirectory());
        }
        catch (Exception exception) {
            LOGGER.severe("No se han podido obtener los modulos externos de Mozilla, se devolvera una lista vacia o unicamente con el DNIe: " + exception);
            return new ConcurrentHashMap<String, String>(0);
        }
        for (AOSecMod.ModuleName stringArray : list) {
            String string = stringArray.getLib();
            if (bl && MozillaKeyStoreUtilities.isDniePkcs11Library(string)) continue;
            concurrentHashMap.put(stringArray.getDescription(), string);
        }
        ConcurrentHashMap concurrentHashMap2 = new ConcurrentHashMap(concurrentHashMap.size());
        concurrentHashMap2.putAll(concurrentHashMap);
        if (bl2) {
            for (String[] stringArray : KNOWN_MODULES) {
                String string;
                if (MozillaKeyStoreUtilities.isModuleIncluded(concurrentHashMap2, stringArray[1]) || !new File(string = MozillaKeyStoreUtilities.getWindowsSystemDirWithFinalSlash() + stringArray[1]).exists()) continue;
                concurrentHashMap.put(stringArray[0], stringArray[1]);
            }
        }
        return MozillaKeyStoreUtilities.purgeStoresTable(concurrentHashMap);
    }

    static String getMozModuleName(String string) {
        int n = string.indexOf(40);
        if (n > 0) {
            return string.substring(0, n).trim();
        }
        return string;
    }

    static void loadNSSDependencies(String string) {
        String[] stringArray;
        if (Platform.OS.LINUX.equals((Object)Platform.getOS()) && new File("/usr/lib/libsoftokn3.so").exists() && new File(LIB_NSPR4_SO).exists()) {
            stringArray = new String[]{"/lib/libmozglue.so", "/usr/lib/libmozglue.so", LIB_NSPR4_SO, "/lib/libplds4.so", "/usr/lib/libplds4.so", "/lib/libplc4.so", "/usr/lib/libplc4.so", "/lib/libnssutil3.so", "/usr/lib/libnssutil3.so", "/lib/libsqlite3.so", "/usr/lib/libsqlite3.so", "/lib/libmozsqlite3.so", "/usr/lib/libmozsqlite3.so"};
        } else {
            String[] stringArray2 = string + (string.endsWith(File.separator) ? "" : File.separator);
            stringArray = MozillaKeyStoreUtilities.getSoftkn3Dependencies((String)stringArray2);
        }
        for (String string2 : stringArray) {
            try {
                if (!new File(string2).exists()) continue;
                System.load(string2);
            }
            catch (Error error) {
                LOGGER.warning("Error al cargar la biblioteca " + string2 + " para el acceso al almacen de claves de Mozilla: " + error);
            }
        }
    }

    private static String[] getSoftkn3Dependencies(String string) {
        String string2;
        if (string == null) {
            return new String[0];
        }
        if (Platform.getOS().equals((Object)Platform.OS.MACOSX)) {
            return new String[0];
        }
        String string3 = string2 = !string.endsWith(File.separator) ? string + File.separator : string;
        if (Platform.getOS().equals((Object)Platform.OS.WINDOWS)) {
            return MozillaKeyStoreUtilitiesWindows.getSoftkn3DependenciesWindows(string2);
        }
        if (Platform.getOS().equals((Object)Platform.OS.LINUX) || Platform.getOS().equals((Object)Platform.OS.SOLARIS)) {
            return new String[]{string2 + "libnspr4.so", string2 + "libplds4.so", string2 + "libplc4.so", string2 + "libnssutil3.so", string2 + "libsqlite3.so", string2 + "libmozsqlite3.so"};
        }
        LOGGER.warning("Plataforma no soportada para la precarga de las bibliotecas NSS: " + (Object)((Object)Platform.getOS()));
        return new String[0];
    }

    private static String getProfilesIniPath() {
        String string = null;
        if (Boolean.getBoolean(USE_ENV_VARS)) {
            try {
                string = System.getenv(AFIRMA_PROFILES_INI);
            }
            catch (Exception exception) {
                LOGGER.warning("No se tiene acceso a la variable de entorno 'AFIRMA_PROFILES_INI': " + exception);
            }
            if (string != null) {
                File file;
                int n = string.toUpperCase().indexOf("%APPDATA%");
                if (n != -1) {
                    string = string.replace(string.substring(n, n + "%APPDATA%".length()), MozillaKeyStoreUtilitiesWindows.getWindowsAppDataDir());
                }
                if ((file = new File(string)).isFile() && file.canRead()) {
                    LOGGER.info("'profiles.ini' de Firefox determinado a partir de la variable de entorno 'AFIRMA_PROFILES_INI'");
                    return string;
                }
                LOGGER.warning("La variable de entorno 'AFIRMA_PROFILES_INI' apunta a un fichero que no existe o sobre el que no se tienen permisos de lectura, se ignorara: " + string);
            }
        }
        if (Platform.OS.WINDOWS.equals((Object)Platform.getOS())) {
            return MozillaKeyStoreUtilitiesWindows.getWindowsAppDataDir() + "\\Mozilla\\Firefox\\profiles.ini";
        }
        if (Platform.getOS().equals((Object)Platform.OS.MACOSX)) {
            return Platform.getUserHome() + "/Library/Application Support/Firefox/profiles.ini";
        }
        return Platform.getUserHome() + "/.mozilla/firefox/profiles.ini";
    }

    static String getMozillaUserProfileDirectory() throws IOException {
        String string = NSPreferences.getFireFoxUserProfileDirectory(new File(MozillaKeyStoreUtilities.getProfilesIniPath()));
        if (Platform.OS.WINDOWS.equals((Object)Platform.getOS())) {
            return MozillaKeyStoreUtilitiesWindows.cleanMozillaUserProfileDirectoryWindows(string);
        }
        return string;
    }

    static void configureMacNSS(String string) throws AOException {
        if (!Platform.OS.MACOSX.equals((Object)Platform.getOS())) {
            return;
        }
        if (string == null) {
            LOGGER.severe("El directorio de NSS para configurar proporcionado es nulo, no se realizara ninguna accion");
            return;
        }
        String string2 = string.endsWith("/") ? string : string + "/";
        try {
            System.load(string2 + "libsoftokn3.dylib");
            return;
        }
        catch (Exception exception) {
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
        String[] stringArray = new String[]{"libmozglue.dylib", "libmozutils.dylib", "libnspr4.dylib", "libplds4.dylib", "libplc4.dylib", "libnssutil3.dylib", "libmozsqlite3.dylib"};
        StringBuilder stringBuilder = new StringBuilder();
        for (String string3 : stringArray) {
            if (!new File(string2 + string3).exists()) continue;
            stringBuilder.append("ln -s ");
            stringBuilder.append(string2);
            stringBuilder.append(string3);
            stringBuilder.append(" /usr/lib/");
            stringBuilder.append(string3);
            stringBuilder.append("; ");
        }
        try {
            new ScriptEngineManager().getEngineByName("AppleScript").eval("do shell script \"" + stringBuilder.toString() + "\" with administrator privileges");
        }
        catch (Exception exception) {
            LOGGER.severe("No se ha podido crear los enlaces simbolicos para NSS: " + exception);
        }
        try {
            System.load(string2 + "libsoftokn3.dylib");
        }
        catch (Exception exception) {
            throw new AOException("La configuracion de NSS para Mac OS X ha fallado por motivos de seguridad: " + exception);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            throw new AOException("La configuracion de NSS para Mac OS X ha fallado: " + unsatisfiedLinkError);
        }
    }

    static Provider loadNSS() throws IOException, AOException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, ClassNotFoundException {
        String string = MozillaKeyStoreUtilities.getSystemNSSLibDir();
        String string2 = MozillaKeyStoreUtilities.createPKCS11NSSConfigFile(MozillaKeyStoreUtilities.getMozillaUserProfileDirectory(), string);
        LOGGER.info("Configuracion de NSS para SunPKCS11:\n" + string2.replace(Platform.getUserHome(), "USERHOME"));
        Provider provider = null;
        try {
            provider = (Provider)Class.forName("sun.security.pkcs11.SunPKCS11").getConstructor(InputStream.class).newInstance(new ByteArrayInputStream(string2.getBytes()));
        }
        catch (Exception exception) {
            if (Platform.OS.MACOSX.equals((Object)Platform.getOS())) {
                MozillaKeyStoreUtilities.configureMacNSS(string);
            } else {
                MozillaKeyStoreUtilities.loadNSSDependencies(string);
            }
            try {
                provider = (Provider)Class.forName("sun.security.pkcs11.SunPKCS11").getConstructor(InputStream.class).newInstance(new ByteArrayInputStream(string2.getBytes()));
            }
            catch (Exception exception2) {
                provider = (Provider)Class.forName("sun.security.pkcs11.SunPKCS11").getConstructor(InputStream.class).newInstance(new ByteArrayInputStream(string2.getBytes()));
            }
        }
        Security.addProvider(provider);
        LOGGER.info("Proveedor PKCS#11 para Firefox anadido");
        return provider;
    }

    private static boolean isDniePkcs11Library(String string) {
        if (string == null) {
            return false;
        }
        for (String string2 : DNI_P11_NAMES) {
            if (!string.toLowerCase().endsWith(string2.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    private static String getWindowsSystemDirWithFinalSlash() {
        if (!Platform.OS.WINDOWS.equals((Object)Platform.getOS())) {
            return "";
        }
        String string = System.getenv("SystemRoot");
        if (string == null) {
            return "";
        }
        if ("64".equals(Platform.getJavaArch())) {
            return string + "\\System32\\";
        }
        if (new File(string + "\\SysWOW64\\").exists()) {
            return string + "\\SysWOW64\\";
        }
        return string + "\\System32\\";
    }

    private static boolean isModuleIncluded(Map<String, String> map, String string) {
        if (map == null || string == null) {
            throw new IllegalArgumentException("Ni la lista de almacenes ni el modulo a comprobar pueden ser nulos");
        }
        for (String string2 : map.keySet()) {
            if (!map.get(string2).toLowerCase().endsWith(string.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    private static Map<String, String> purgeStoresTable(Map<String, String> map) {
        String[] stringArray;
        if (map == null) {
            return new ConcurrentHashMap<String, String>(0);
        }
        ConcurrentHashMap<String, String> concurrentHashMap = new ConcurrentHashMap<String, String>();
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : stringArray = map.keySet().toArray(new String[0])) {
            String string2 = map.get(string);
            if (string2.toLowerCase().endsWith(".dll")) {
                string2 = string2.toLowerCase();
            }
            if (!hashSet.contains(string2) && !string2.toLowerCase().contains("nssckbi")) {
                concurrentHashMap.put(string, map.get(string));
                hashSet.add(string2);
                continue;
            }
            LOGGER.warning("Se eliminara el modulo '" + string + "' porque ya existe uno con la misma biblioteca o es un modulo de certificados raiz: " + map.get(string));
        }
        return concurrentHashMap;
    }
}

