/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.keystores.mozilla;

import es.gob.afirma.core.misc.Platform;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Logger;

final class ExternalStoresHelper {
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");
    private static final String[] DNI_P11_NAMES = new String[]{"libopensc-dnie.dylib", "libopensc-dnie.so", "usrpkcs11.dll", "dnie_p11_priv.dll", "dnie_p11_pub.dll", "opensc-pkcs11.dll"};
    private static final String[][] KNOWN_MODULES = new String[][]{{"FNMT-RCM CERES (preinstalado)", "FNMT_P11.dll"}};

    private ExternalStoresHelper() {
    }

    static Map<String, String> cleanExternalStores(Map<String, String> map) {
        if (map == null) {
            return new HashMap<String, String>(0);
        }
        for (String string : map.keySet()) {
            if (!ExternalStoresHelper.isDniePkcs11LibraryForWindows(map.get(string))) continue;
            map.remove(string);
        }
        return ExternalStoresHelper.purgeStoresTable(ExternalStoresHelper.addMissingCommonModules(map));
    }

    private static Map<String, String> addMissingCommonModules(Map<String, String> map) {
        for (String[] stringArray : KNOWN_MODULES) {
            String string;
            if (ExternalStoresHelper.isModuleIncluded(map, stringArray[1]) || !new File(string = ExternalStoresHelper.getWindowsSystemDirWithFinalSlash() + stringArray[1]).exists()) continue;
            map.put(stringArray[0], stringArray[1]);
        }
        return map;
    }

    private static boolean isDniePkcs11LibraryForWindows(String string) {
        if (string == null) {
            return false;
        }
        for (String string2 : DNI_P11_NAMES) {
            if (!string.toLowerCase().endsWith(string2)) continue;
            return true;
        }
        return false;
    }

    private static boolean isModuleIncluded(Map<String, String> map, String string) {
        if (map == null || string == null) {
            throw new IllegalArgumentException("Ni la lista de almacenes ni el modulo a comprobar pueden ser nulos");
        }
        for (String string2 : map.keySet()) {
            if (!map.get(string2).toLowerCase().endsWith(string.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    private static Map<String, String> purgeStoresTable(Map<String, String> map) {
        if (map == null) {
            return new Hashtable<String, String>(0);
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : map.keySet()) {
            String string2 = map.get(string);
            if (string2.toLowerCase().endsWith(".dll")) {
                string2 = string2.toLowerCase();
            }
            if (!hashSet.contains(string2) && !string2.toLowerCase().contains("nssckbi")) {
                hashtable.put(string, map.get(string));
                hashSet.add(string2);
                continue;
            }
            LOGGER.warning("Se eliminara el modulo '" + string + "' porque ya existe uno con la misma biblioteca o es un modulo de certificados raiz: " + map.get(string));
        }
        return hashtable;
    }

    private static String getWindowsSystemDirWithFinalSlash() {
        if (!Platform.OS.WINDOWS.equals((Object)Platform.getOS())) {
            return "";
        }
        String string = System.getenv("SystemRoot");
        if (string == null) {
            return "";
        }
        if ("64".equals(Platform.getJavaArch())) {
            return string + "\\System32\\";
        }
        if (new File(string + "\\SysWOW64\\").exists()) {
            return string + "\\SysWOW64\\";
        }
        return string + "\\System32\\";
    }
}

