/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.keystores.mozilla;

import es.gob.afirma.core.AOException;
import es.gob.afirma.core.misc.AOUtil;
import es.gob.afirma.core.misc.Platform;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;

final class AOSecMod {
    private static List<ModuleName> modules = null;

    private AOSecMod() {
    }

    private static ModuleName processNames(byte[] byArray, int n) {
        String string;
        int n2 = n;
        int n3 = AOSecMod.getShort(byArray, n2 + 0);
        String string2 = new String(byArray, n2 + 2, n3);
        n2 += n3 + 2;
        n3 = AOSecMod.getShort(byArray, n2);
        String string3 = new String(byArray, n2 + 2, n3);
        if ((Platform.OS.WINDOWS.equals((Object)Platform.getOS()) && (string3.endsWith(".DLL") || string3.endsWith(".dll")) || !Platform.OS.WINDOWS.equals((Object)Platform.getOS()) && (string3.endsWith(".so") || string3.contains(".so.") || string3.endsWith(".dylib"))) && (string = AOSecMod.searchPathForFile(new String[]{string3})) != null) {
            return new ModuleName(string, string2);
        }
        throw new UnsupportedOperationException("Intento fallido: " + string3);
    }

    static List<ModuleName> getModules(String string) throws AOException {
        if (string == null || "".equals(string)) {
            throw new IllegalArgumentException("El directorio del perfil de Mozilla no puede ser nulo");
        }
        String string2 = string;
        if (modules == null) {
            byte[] byArray;
            File file;
            if (!(string2 = string2.replace("\\ ", " ")).endsWith("/")) {
                string2 = string2 + "/";
            }
            if (!(file = new File(string2, "secmod.db")).exists()) {
                throw new AOException("El directorio del perfil de Mozilla proporcionado no contiene una base de datos de modulos (secmod.db)");
            }
            try {
                byArray = AOUtil.getDataFromInputStream(AOUtil.loadFile(AOUtil.createURI(file.getAbsolutePath())));
            }
            catch (Exception exception) {
                throw new AOException("Error leyendo la base de datos de modulos (secmod.db)", exception);
            }
            modules = new ArrayList<ModuleName>();
            HashSet<String> hashSet = new HashSet<String>();
            for (int i = 0; i < byArray.length; ++i) {
                try {
                    ModuleName moduleName = AOSecMod.processNames(byArray, i);
                    if (hashSet.contains(moduleName.getLib())) continue;
                    hashSet.add(moduleName.getLib());
                    modules.add(moduleName);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return modules;
    }

    private static int getShort(byte[] byArray, int n) {
        return byArray[n + 0] << 8 | byArray[n + 1];
    }

    private static String searchPathForFile(String[] stringArray) {
        if (stringArray == null || stringArray.length < 1) {
            return null;
        }
        if (new File(stringArray[0]).exists()) {
            return stringArray[0];
        }
        StringTokenizer stringTokenizer = new StringTokenizer(Platform.getJavaLibraryPath(), File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            if (!string.endsWith(File.separator)) {
                string = string + File.separator;
            }
            for (String string2 : stringArray) {
                File file = new File(string, string2);
                if (!file.exists() || file.isDirectory()) continue;
                return string + string2;
            }
        }
        return null;
    }

    static class ModuleName {
        private final String lib;
        private final String description;

        ModuleName(String string, String string2) {
            this.lib = string;
            this.description = string2;
        }

        String getLib() {
            return this.lib;
        }

        String getDescription() {
            return this.description;
        }

        public String toString() {
            return this.description + " (EXTERNAL, " + this.lib + ", slot 0)";
        }
    }
}

