/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.keystores.misc;

import es.gob.afirma.core.misc.AOUtil;
import es.gob.afirma.core.ui.AOUIFactory;
import es.gob.afirma.keystores.misc.JarSignatureCertExtractorMessages;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.CodeSource;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXParameters;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import sun.security.pkcs.PKCS7;

public final class JarSignatureCertExtractor {
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");
    private static final int BUFFER_SIZE = 1024;
    private static final String SIGNATURE_DIR_PATH = "META-INF/";
    private static final String SIGNATURE_EXT = ".RSA";
    private static final String USER_HOME = "$USER_HOME";
    private static final String DEFAULT_PASSWORD = "";
    private static final String[] CACERTS_DEFAULT_PASSWORDS = new String[]{"", "changeit", "changeme"};
    private static String keystorePassword = null;

    private JarSignatureCertExtractor() {
    }

    private static X509Certificate[] getJarSignatureCertChain() throws IOException {
        byte[] byArray = JarSignatureCertExtractor.getJarSignature();
        if (byArray == null) {
            return null;
        }
        return new PKCS7(byArray).getCertificates();
    }

    private static byte[] getJarSignature() throws IOException {
        ZipEntry zipEntry;
        CodeSource codeSource = JarSignatureCertExtractor.class.getProtectionDomain().getCodeSource();
        if (codeSource == null) {
            throw new IOException("No se ha podido acceder a los recursos del JAR");
        }
        int n = 0;
        ByteArrayOutputStream byteArrayOutputStream = null;
        byte[] byArray = new byte[1024];
        ZipInputStream zipInputStream = new ZipInputStream(codeSource.getLocation().openStream());
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            String string = zipEntry.getName();
            if (!string.startsWith(SIGNATURE_DIR_PATH) || !string.endsWith(SIGNATURE_EXT)) continue;
            byteArrayOutputStream = new ByteArrayOutputStream();
            while ((n = zipInputStream.read(byArray)) > 0) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            break block0;
        }
        return byteArrayOutputStream == null ? null : byteArrayOutputStream.toByteArray();
    }

    private static File getUsersJavaCaKeyStoreFile() {
        String string = System.getProperty("deployment.user.security.trusted.cacerts");
        if (string != null && string.contains(USER_HOME)) {
            string = string.replace(USER_HOME, System.getProperty("user.home"));
        }
        File file = string != null ? new File(string) : null;
        return file != null && file.getParentFile().exists() ? file : null;
    }

    private static File getSystemsJavaCaKeyStoreFile() {
        String string = System.getProperty("deployment.system.security.cacerts");
        if (string == null) {
            return null;
        }
        File file = new File(string);
        return file.exists() ? file : null;
    }

    private static KeyStore getJavaCaKeyStore(File file) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        KeyStore keyStore = KeyStore.getInstance("JKS");
        for (String string : CACERTS_DEFAULT_PASSWORDS) {
            try {
                keyStore.load(fileInputStream, string.toCharArray());
                keystorePassword = string;
                break;
            }
            catch (IOException iOException) {
                if (iOException.getCause() instanceof UnrecoverableKeyException) continue;
                fileInputStream.close();
                throw iOException;
            }
        }
        fileInputStream.close();
        return keyStore;
    }

    private static void checkCertChain(X509Certificate[] x509CertificateArray, KeyStore keyStore) throws CertPathValidatorException, KeyStoreException, InvalidAlgorithmParameterException, CertificateException, NoSuchAlgorithmException {
        if (keyStore.size() == 0) {
            throw new CertPathValidatorException("No hay certificados en el almacen de confianza");
        }
        X509Certificate x509Certificate = x509CertificateArray[x509CertificateArray.length - 1];
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            if (!x509Certificate.getSerialNumber().equals(((X509Certificate)keyStore.getCertificate(enumeration.nextElement())).getSerialNumber())) continue;
            LOGGER.info("El extremo de la cadena de certificados esta en el truststore de Java");
            return;
        }
        PKIXParameters pKIXParameters = new PKIXParameters(keyStore);
        pKIXParameters.setRevocationEnabled(false);
        CertPathValidator.getInstance(CertPathValidator.getDefaultType()).validate(CertificateFactory.getInstance("X.509").generateCertPath(Arrays.asList(x509CertificateArray)), pKIXParameters);
    }

    public static void insertJarSignerOnCACerts(Object object) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, InvalidAlgorithmParameterException {
        KeyStore keyStore;
        File file;
        X509Certificate[] x509CertificateArray = JarSignatureCertExtractor.getJarSignatureCertChain();
        if (x509CertificateArray == null || x509CertificateArray.length < 1) {
            LOGGER.warning("La aplicacion no esta firmada");
            return;
        }
        File file2 = JarSignatureCertExtractor.getSystemsJavaCaKeyStoreFile();
        if (file2 != null) {
            try {
                JarSignatureCertExtractor.checkCertChain(x509CertificateArray, JarSignatureCertExtractor.getJavaCaKeyStore(file2));
                LOGGER.warning("Los certificados de firma del JAR son de confianza en Java");
                return;
            }
            catch (Exception exception) {
                LOGGER.warning("Error en la validacion de los certificados contra el almacen de Java");
            }
        }
        if ((file = JarSignatureCertExtractor.getUsersJavaCaKeyStoreFile()) == null) {
            LOGGER.warning("No se puede localizar el almacen de confianza del usuario, se suspende la validacion");
            return;
        }
        if (!file.exists()) {
            keystorePassword = DEFAULT_PASSWORD;
            keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null, keystorePassword.toCharArray());
            LOGGER.info("Creamos el truststore ya que no existia previamente");
        } else {
            try {
                keyStore = JarSignatureCertExtractor.getJavaCaKeyStore(file);
            }
            catch (Exception exception) {
                LOGGER.warning("No se ha podido cargar el almacen de certificados de CA de confianza del usuario, no se agregara el certificado: " + exception);
                return;
            }
        }
        try {
            JarSignatureCertExtractor.checkCertChain(x509CertificateArray, keyStore);
            LOGGER.info("Los certificados de firma del JAR ya son de confianza para el usuario");
            return;
        }
        catch (CertPathValidatorException certPathValidatorException) {
            LOGGER.warning("Debemos agregar el certificado al truststore del usuario para que sea de confianza: " + certPathValidatorException);
            StringBuilder stringBuilder = new StringBuilder("<br>");
            for (X509Certificate x509Certificate : x509CertificateArray) {
                stringBuilder.append("&nbsp;- ");
                stringBuilder.append(AOUtil.getCN(x509Certificate));
                stringBuilder.append("<br>");
            }
            if (AOUIFactory.showConfirmDialog(object, "<html><p>" + JarSignatureCertExtractorMessages.getString("JarSignatureCertExtractor.0") + "</p><p>" + JarSignatureCertExtractorMessages.getString("JarSignatureCertExtractor.1") + "</p><p>&nbsp;<br>" + JarSignatureCertExtractorMessages.getString("JarSignatureCertExtractor.2") + stringBuilder.toString() + "&nbsp;</p></html>", JarSignatureCertExtractorMessages.getString("JarSignatureCertExtractor.3"), AOUIFactory.YES_NO_OPTION, AOUIFactory.WARNING_MESSAGE) == AOUIFactory.NO_OPTION) {
                return;
            }
            for (X509Certificate x509Certificate : x509CertificateArray) {
                keyStore.setCertificateEntry(AOUtil.getCN(x509Certificate) + x509Certificate.getSerialNumber(), x509Certificate);
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            keyStore.store(fileOutputStream, keystorePassword.toCharArray());
            fileOutputStream.close();
            LOGGER.info("Se han insertado correctamente certificados en el cacerts del usuario");
            return;
        }
    }
}

