/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.keystores.filters.rfc;

import com.sun.jndi.toolkit.dir.SearchFilter;
import es.gob.afirma.keystores.filters.CertificateFilter;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.logging.Logger;
import javax.naming.directory.BasicAttributes;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;

public final class RFC2254CertificateFilter
extends CertificateFilter {
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");
    private final String rfc2254IssuerFilter;
    private final String rfc2254SubjectFilter;

    @Override
    public boolean matches(X509Certificate x509Certificate) {
        return RFC2254CertificateFilter.filterSubjectByRFC2254(this.rfc2254SubjectFilter, x509Certificate) && RFC2254CertificateFilter.filterIssuerByRFC2254(this.rfc2254IssuerFilter, x509Certificate);
    }

    public RFC2254CertificateFilter(String string, String string2) {
        if (string == null && string2 == null) {
            throw new IllegalArgumentException("Al menos uno de los criterios de filtrado debe no ser nulo");
        }
        this.rfc2254IssuerFilter = string2;
        this.rfc2254SubjectFilter = string;
    }

    private static boolean filterSubjectByRFC2254(String string, X509Certificate x509Certificate) {
        if (x509Certificate == null || string == null) {
            return true;
        }
        return RFC2254CertificateFilter.filterRFC2254(string, x509Certificate.getSubjectDN().toString());
    }

    private static boolean filterIssuerByRFC2254(String string, X509Certificate x509Certificate) {
        if (x509Certificate == null || string == null) {
            return true;
        }
        return RFC2254CertificateFilter.filterRFC2254(string, x509Certificate.getIssuerDN().toString());
    }

    private static boolean filterRFC2254(String string, String string2) {
        try {
            return RFC2254CertificateFilter.filterRFC2254(string, new LdapName(string2));
        }
        catch (Exception exception) {
            LOGGER.warning("No ha sido posible filtrar el certificado (filtro: '" + string + "', nombre: '" + string2 + "'), no se eliminara del listado: " + exception);
            return true;
        }
    }

    private static boolean filterRFC2254(String string, LdapName ldapName) {
        if (string == null || ldapName == null) {
            return true;
        }
        try {
            List<Rdn> list = ldapName.getRdns();
            if (list == null || list.isEmpty()) {
                LOGGER.warning("El nombre proporcionado para filtrar no contiene atributos, no se mostrara el certificado en el listado");
                return false;
            }
            BasicAttributes basicAttributes = new BasicAttributes(true);
            for (Rdn rdn : list) {
                basicAttributes.put(rdn.getType(), rdn.getValue());
            }
            return new SearchFilter(string).check(basicAttributes);
        }
        catch (Exception exception) {
            LOGGER.warning("No ha sido posible filtrar el certificado (filtro: '" + string + "', nombre: '" + ldapName + "'), no se eliminara del listado: " + exception);
            return true;
        }
    }
}

