/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.keystores.filters;

import es.gob.afirma.keystores.AOKeyStoreManager;
import es.gob.afirma.keystores.filters.CertificateFilter;
import java.security.cert.X509Certificate;

public final class MultipleCertificateFilter
extends CertificateFilter {
    private final CertificateFilter[] filters;

    public MultipleCertificateFilter(CertificateFilter[] certificateFilterArray) {
        if (certificateFilterArray == null) {
            throw new IllegalArgumentException("Listado nulo de filtros de certificados");
        }
        this.filters = (CertificateFilter[])certificateFilterArray.clone();
    }

    @Override
    public boolean matches(X509Certificate x509Certificate) {
        for (CertificateFilter certificateFilter : this.filters) {
            if (certificateFilter.matches(x509Certificate)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String[] matches(String[] stringArray, AOKeyStoreManager aOKeyStoreManager) {
        String[] stringArray2 = (String[])stringArray.clone();
        for (CertificateFilter certificateFilter : this.filters) {
            stringArray2 = certificateFilter.matches(stringArray2, aOKeyStoreManager);
        }
        return stringArray2;
    }
}

