/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.keystores.dnie;

import es.gob.afirma.keystores.AOKeyStore;
import es.gob.afirma.keystores.AOKeyStoreManager;
import es.gob.afirma.keystores.AOKeyStoreManagerException;
import es.gob.afirma.keystores.AOKeyStoreManagerFactory;
import es.gob.afirma.keystores.callbacks.NullPasswordCallback;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableEntryException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.x500.X500Principal;

public class DnieUnifiedKeyStoreManager
extends AOKeyStoreManager {
    private static X509Certificate dnieRootCertificate;
    private static final int DNIE_CERTCHAIN_LENGTH = 2;
    private static final List<String> DNIE_ALIASES;
    private final String[] aliases;
    private static final X500Principal DNIE_ISSUER;
    private final AOKeyStoreManager originalKsm;
    private AOKeyStoreManager dnieKsm = null;

    public DnieUnifiedKeyStoreManager(AOKeyStoreManager aOKeyStoreManager, Object object) {
        if (aOKeyStoreManager == null) {
            throw new IllegalArgumentException("Es necesario un almacen al que anadir los certificados de DNIe, no puede ser nulo");
        }
        this.originalKsm = aOKeyStoreManager;
        boolean bl = true;
        for (String string : aOKeyStoreManager.getAliases()) {
            if (!aOKeyStoreManager.getCertificate(string).getIssuerX500Principal().equals(DNIE_ISSUER)) continue;
            bl = false;
            break;
        }
        if (bl) {
            try {
                this.dnieKsm = AOKeyStoreManagerFactory.getAOKeyStoreManager(AOKeyStore.DNIEJAVA, null, (Object)((Object)aOKeyStoreManager.getType()) + "_PLUS_DNIE", NullPasswordCallback.getInstance(), object);
            }
            catch (Exception exception) {
                Logger.getLogger("es.gob.afirma").info("No se puede usar DNIe con controlador 100% Java: " + exception);
            }
        }
        String[] stringArray = aOKeyStoreManager.getAliases();
        this.aliases = new String[stringArray.length + (this.dnieKsm != null ? 2 : 0)];
        System.arraycopy(stringArray, 0, this.aliases, 0, stringArray.length);
        if (this.dnieKsm != null) {
            this.aliases[this.aliases.length - 1] = DNIE_ALIASES.get(0);
            this.aliases[this.aliases.length - 2] = DNIE_ALIASES.get(1);
        }
    }

    @Override
    public String[] getAliases() {
        return this.aliases;
    }

    @Override
    public X509Certificate getCertificate(String string) {
        if (!DNIE_ALIASES.contains(string) || this.dnieKsm == null) {
            return this.originalKsm.getCertificate(string);
        }
        return this.dnieKsm.getCertificate(string);
    }

    @Override
    public X509Certificate[] getCertificateChain(String string) {
        if (!DNIE_ALIASES.contains(string) || this.dnieKsm == null) {
            return this.originalKsm.getCertificateChain(string);
        }
        X509Certificate[] x509CertificateArray = new X509Certificate[2];
        X509Certificate[] x509CertificateArray2 = this.dnieKsm.getCertificateChain(string);
        x509CertificateArray[0] = x509CertificateArray2[0];
        x509CertificateArray[1] = x509CertificateArray2[1];
        x509CertificateArray[2] = dnieRootCertificate;
        return x509CertificateArray;
    }

    @Override
    public KeyStore.PrivateKeyEntry getKeyEntry(String string, PasswordCallback passwordCallback) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableEntryException {
        if (!DNIE_ALIASES.contains(string) || this.dnieKsm == null) {
            return this.originalKsm.getKeyEntry(string, passwordCallback);
        }
        return new KeyStore.PrivateKeyEntry(this.dnieKsm.getKeyEntry(string, null).getPrivateKey(), this.getCertificateChain(string));
    }

    @Override
    public KeyStore getKeyStore() {
        if (this.dnieKsm == null) {
            return this.originalKsm.getKeyStore();
        }
        return this.originalKsm.getKeyStore();
    }

    @Override
    public AOKeyStore getType() {
        return this.originalKsm.getType();
    }

    @Override
    public void init(AOKeyStore aOKeyStore, InputStream inputStream, PasswordCallback passwordCallback, Object[] objectArray, boolean bl) throws AOKeyStoreManagerException, IOException {
        throw new UnsupportedOperationException();
    }

    static {
        try {
            dnieRootCertificate = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(ClassLoader.getSystemResourceAsStream("ACRAIZ-SHA2.crt"));
        }
        catch (CertificateException certificateException) {
            Logger.getLogger("es.gob.afirma").warning("No se ha podido cargal el certificado raiz del DNIe, la cadena de confianza puede estar incompleta: " + certificateException);
            dnieRootCertificate = null;
        }
        DNIE_ALIASES = new ArrayList<String>(2);
        DNIE_ALIASES.add("CertAutenticacion");
        DNIE_ALIASES.add("CertFirmaDigital");
        DNIE_ISSUER = new X500Principal("CN=AC DNIE 001, OU=DNIE, O=DIRECCION GENERAL DE LA POLICIA, C=ES");
    }
}

