/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.keystores;

import es.gob.afirma.core.AOCancelledOperationException;
import es.gob.afirma.core.keystores.NameCertificateBean;
import es.gob.afirma.core.misc.AOUtil;
import es.gob.afirma.core.misc.Platform;
import es.gob.afirma.core.ui.AOUIFactory;
import es.gob.afirma.keystores.AOCertificatesNotFoundException;
import es.gob.afirma.keystores.AOKeyStoreManager;
import es.gob.afirma.keystores.AOKeyStoreManagerException;
import es.gob.afirma.keystores.KeyStoreMessages;
import es.gob.afirma.keystores.callbacks.CachePasswordCallback;
import es.gob.afirma.keystores.filters.CertificateFilter;
import java.io.File;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.security.auth.x500.X500Principal;

public final class KeyStoreUtilities {
    static final Logger LOGGER = Logger.getLogger("es.gob.afirma");
    private static final String OPENSC_USR_LIB_LINUX = "/usr/lib/opensc-pkcs11.so";
    private static final X500Principal DNIE_ISSUER = new X500Principal("CN=AC DNIE 001, OU=DNIE, O=DIRECCION GENERAL DE LA POLICIA, C=ES");
    private static final String[] FNMT_PKCS11_LIBS_WITHOUT_SHA1 = new String[]{"DNIe_P11_priv.dll", "DNIe_P11_pub.dll", "FNMT_P11.dll", "UsrPkcs11.dll", "UsrPubPkcs11.dll"};
    private static final int ALIAS_MAX_LENGTH = 120;

    private KeyStoreUtilities() {
    }

    static String createPKCS11ConfigFile(String string, String string2, Integer n) {
        StringBuilder stringBuilder = new StringBuilder("library=");
        if (string.contains(")") || string.contains("(")) {
            stringBuilder.append(KeyStoreUtilities.getShort(string));
        } else {
            stringBuilder.append(string);
        }
        stringBuilder.append("\r\n").append("name=").append(string2 != null ? string2 : "AFIRMA-PKCS11").append("\r\nshowInfo=false\r\n");
        if (n != null) {
            stringBuilder.append("slot=").append(n).append("\r\n");
        }
        for (String string3 : FNMT_PKCS11_LIBS_WITHOUT_SHA1) {
            if (!string3.equalsIgnoreCase(new File(string).getName())) continue;
            stringBuilder.append("disabledMechanisms={ CKM_SHA1_RSA_PKCS }\r\n");
            break;
        }
        LOGGER.info("Creada configuracion PKCS#11:\r\n" + stringBuilder.toString());
        return stringBuilder.toString();
    }

    public static Map<String, String> getAliasesByFriendlyName(String[] stringArray, AOKeyStoreManager aOKeyStoreManager, boolean bl, boolean bl2, List<CertificateFilter> list) {
        String[] stringArray2 = (String[])stringArray.clone();
        Hashtable<String, String> hashtable = new Hashtable<String, String>(stringArray2.length);
        for (String string : stringArray2) {
            hashtable.put(string, string);
        }
        if (aOKeyStoreManager != null) {
            for (String string : hashtable.keySet().toArray(new String[hashtable.size()])) {
                X509Certificate x509Certificate = null;
                try {
                    x509Certificate = aOKeyStoreManager.getCertificate(string);
                }
                catch (RuntimeException runtimeException) {
                    if ("es.gob.jmulticard.ui.passwordcallback.CancelledOperationException".equals(runtimeException.getClass().getName()) || "es.gob.jmulticard.card.AuthenticationModeLockedException".equals(runtimeException.getClass().getName()) || "es.gob.jmulticard.jse.provider.BadPasswordProviderException".equals(runtimeException.getClass().getName()) || "es.gob.jmulticard.jse.provider.SignatureAuthException".equals(runtimeException.getClass().getName())) {
                        throw runtimeException;
                    }
                    LOGGER.warning("No se ha inicializado el KeyStore indicado: " + runtimeException);
                    continue;
                }
                if (x509Certificate == null) {
                    LOGGER.warning("El KeyStore no permite extraer el certificado publico para el siguiente alias: " + string);
                    continue;
                }
                if (!bl2) {
                    try {
                        x509Certificate.checkValidity();
                    }
                    catch (Exception exception) {
                        LOGGER.info("Se ocultara el certificado '" + string + "' por no ser valido: " + exception);
                        hashtable.remove(string);
                        continue;
                    }
                }
                if (!bl) continue;
                try {
                    if (aOKeyStoreManager.getKeyEntry(string, new CachePasswordCallback(new char[0])) != null) continue;
                    hashtable.remove(string);
                    LOGGER.info("El certificado '" + string + "' no era tipo trusted pero su clave tampoco era de tipo privada, no se mostrara");
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    hashtable.remove(string);
                    LOGGER.info("Se ha ocultado un certificado por no soportar operaciones de clave privada: " + unsupportedOperationException);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (list != null && list.size() > 0) {
                Hashtable hashtable2 = new Hashtable();
                for (CertificateFilter certificateFilter : list) {
                    for (String string : certificateFilter.matches(hashtable.keySet().toArray(new String[0]), aOKeyStoreManager)) {
                        hashtable2.put(string, hashtable.get(string));
                    }
                }
                hashtable.clear();
                hashtable.putAll(hashtable2);
            }
            for (String string : hashtable.keySet().toArray(new String[0])) {
                String string2 = AOUtil.getCN(aOKeyStoreManager.getCertificate(string));
                if (string2 != null) {
                    hashtable.put(string, string2);
                    continue;
                }
                hashtable.put(string, string.trim());
            }
        } else {
            for (String string : hashtable.keySet().toArray(new String[hashtable.size()])) {
                String string3 = (String)hashtable.get(string);
                if (string3.length() > 120) {
                    String string4 = AOUtil.getCN(string3);
                    if (string4 != null) {
                        hashtable.put(string, string4);
                        continue;
                    }
                    hashtable.put(string, string3.substring(0, 120 - "...".length()) + "...");
                    continue;
                }
                hashtable.put(string, string3.trim());
            }
        }
        return hashtable;
    }

    public static String showCertSelectionDialog(String[] stringArray, AOKeyStoreManager aOKeyStoreManager, Object object, boolean bl, boolean bl2, boolean bl3) throws AOCertificatesNotFoundException {
        return KeyStoreUtilities.showCertSelectionDialog(stringArray, aOKeyStoreManager, object, bl, bl2, bl3, null, false);
    }

    public static String showCertSelectionDialog(String[] stringArray, AOKeyStoreManager aOKeyStoreManager, Object object, boolean bl, boolean bl2, boolean bl3, List<CertificateFilter> list, boolean bl4) throws AOCertificatesNotFoundException {
        if (stringArray == null && aOKeyStoreManager == null || stringArray != null && stringArray.length == 0) {
            throw new AOCertificatesNotFoundException("El almacen no contenia entradas");
        }
        Map<String, String> map = KeyStoreUtilities.getAliasesByFriendlyName(stringArray != null ? stringArray : aOKeyStoreManager.getAliases(), aOKeyStoreManager, bl, bl3, list);
        if (map.size() == 0) {
            throw new AOCertificatesNotFoundException("El almacen no contenia entradas validas");
        }
        if (bl4 && map.size() == 1) {
            return map.keySet().toArray()[0].toString();
        }
        int n = 0;
        NameCertificateBean[] nameCertificateBeanArray = new NameCertificateBean[map.size()];
        for (String string : map.keySet().toArray(new String[0])) {
            nameCertificateBeanArray[n++] = new NameCertificateBean(string, map.get(string), aOKeyStoreManager.getCertificate(string));
        }
        Arrays.sort(nameCertificateBeanArray, new Comparator<NameCertificateBean>(){

            @Override
            public int compare(NameCertificateBean nameCertificateBean, NameCertificateBean nameCertificateBean2) {
                if (nameCertificateBean == null && nameCertificateBean2 == null) {
                    return 0;
                }
                if (nameCertificateBean == null) {
                    return 1;
                }
                if (nameCertificateBean2 == null) {
                    return -1;
                }
                return nameCertificateBean.getName().compareToIgnoreCase(nameCertificateBean2.getName());
            }
        });
        String string = (String)AOUIFactory.showCertificateSelectionDialog(object, nameCertificateBeanArray);
        if (string == null) {
            throw new AOCancelledOperationException("Operacion de seleccion de certificado cancelada");
        }
        if (bl2 && aOKeyStoreManager != null) {
            String string2 = null;
            try {
                aOKeyStoreManager.getCertificate(string).checkValidity();
            }
            catch (CertificateExpiredException certificateNotYetValidException) {
                string2 = KeyStoreMessages.getString("KeyStoreUtilities.2");
            }
            catch (CertificateNotYetValidException exception) {
                string2 = KeyStoreMessages.getString("KeyStoreUtilities.3");
            }
            catch (Exception bl5) {
                string2 = KeyStoreMessages.getString("KeyStoreUtilities.4");
            }
            boolean bl5 = false;
            if (string2 != null) {
                LOGGER.warning("Error durante la validacion: " + string2);
                if (AOUIFactory.showConfirmDialog(object, string2, KeyStoreMessages.getString("KeyStoreUtilities.5"), AOUIFactory.YES_NO_OPTION, AOUIFactory.WARNING_MESSAGE) == AOUIFactory.YES_OPTION) {
                    return string;
                }
                bl5 = true;
            }
            if (bl5) {
                throw new AOCancelledOperationException("Se ha reusado un certificado probablemente no valido");
            }
        }
        return string;
    }

    static String getPKCS11DNIeLib() throws AOKeyStoreManagerException {
        if (Platform.OS.WINDOWS.equals((Object)Platform.getOS())) {
            String string = Platform.getSystemLibDir();
            if (new File(string + "\\DNIe_P11_priv.dll").exists()) {
                return string + "\\DNIe_P11_priv.dll";
            }
            if (new File(string + "\\UsrPkcs11.dll").exists()) {
                return string + "\\UsrPkcs11.dll";
            }
            if (new File(string + "\\opensc-pkcs11.dll").exists()) {
                return string + "\\opensc-pkcs11.dll";
            }
            throw new AOKeyStoreManagerException("No hay controlador PKCS#11 de DNIe instalado en este sistema Windows");
        }
        if (Platform.OS.MACOSX.equals((Object)Platform.getOS())) {
            if (new File("/Library/OpenSC/lib/libopensc-dnie.dylib").exists()) {
                return "/Library/OpenSC/lib/libopensc-dnie.dylib";
            }
            if (new File("/Library/OpenSC/lib/opensc-pkcs11.so").exists()) {
                return "/Library/OpenSC/lib/opensc-pkcs11.so";
            }
            if (new File("/Library/OpenSC/lib/libopensc-dnie.1.0.3.dylib").exists()) {
                return "/Library/OpenSC/lib/libopensc-dnie.1.0.3.dylib";
            }
            if (new File(OPENSC_USR_LIB_LINUX).exists()) {
                return OPENSC_USR_LIB_LINUX;
            }
            throw new AOKeyStoreManagerException("No hay controlador PKCS#11 de DNIe instalado en este sistema Mac OS X");
        }
        if (new File("/usr/local/lib/libopensc-dnie.so").exists()) {
            return "/usr/local/lib/libopensc-dnie.so";
        }
        if (new File("/usr/lib/libopensc-dnie.so").exists()) {
            return "/usr/lib/libopensc-dnie.so";
        }
        if (new File("/lib/libopensc-dnie.so").exists()) {
            return "/lib/libopensc-dnie.so";
        }
        if (new File(OPENSC_USR_LIB_LINUX).exists()) {
            return OPENSC_USR_LIB_LINUX;
        }
        if (new File("/lib/opensc-pkcs11.so").exists()) {
            return "/lib/opensc-pkcs11.so";
        }
        if (new File("/usr/local/lib/opensc-pkcs11.so").exists()) {
            return "/usr/local/lib/opensc-pkcs11.so";
        }
        throw new AOKeyStoreManagerException("No hay controlador PKCS#11 de DNIe instalado en este sistema");
    }

    public static String getShort(String string) {
        if (string == null || !Platform.OS.WINDOWS.equals((Object)Platform.getOS())) {
            return string;
        }
        File file = new File(string);
        if (!file.exists()) {
            return string;
        }
        try {
            Process process = new ProcessBuilder("cmd.exe", "/c", "for %f in (\"" + string + "\") do @echo %~sf").start();
            return new String(AOUtil.getDataFromInputStream(process.getInputStream())).trim();
        }
        catch (Exception exception) {
            LOGGER.warning("No se ha podido obtener el nombre corto de " + string + ": " + exception);
            return string;
        }
    }

    static boolean containsDnie(AOKeyStoreManager aOKeyStoreManager) {
        for (String string : aOKeyStoreManager.getAliases()) {
            if (!aOKeyStoreManager.getCertificate(string).getIssuerX500Principal().equals(DNIE_ISSUER)) continue;
            return true;
        }
        return false;
    }
}

