/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.keystores;

import es.gob.afirma.core.InvalidOSException;
import es.gob.afirma.core.misc.Platform;
import es.gob.afirma.keystores.AOKeyStore;
import es.gob.afirma.keystores.AOKeyStoreManager;
import es.gob.afirma.keystores.AOKeyStoreManagerException;
import es.gob.afirma.keystores.MissingSunMSCAPIException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableEntryException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import javax.security.auth.callback.PasswordCallback;

public final class CAPIKeyStoreManager
extends AOKeyStoreManager {
    private static KeyStore capiKsMy = null;

    @Override
    public KeyStore.PrivateKeyEntry getKeyEntry(String string, PasswordCallback passwordCallback) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableEntryException {
        if (capiKsMy == null) {
            throw new IllegalStateException("Se han pedido claves a un almacen no inicializado");
        }
        return (KeyStore.PrivateKeyEntry)capiKsMy.getEntry(string, new KeyStore.PasswordProtection("dummy".toCharArray()));
    }

    @Override
    public void init(AOKeyStore aOKeyStore, InputStream inputStream, PasswordCallback passwordCallback, Object[] objectArray, boolean bl) throws AOKeyStoreManagerException, IOException {
        this.resetCachedAliases();
        if (AOKeyStore.WINDOWS.equals((Object)aOKeyStore)) {
            if (bl) {
                capiKsMy = null;
            }
        } else {
            throw new AOKeyStoreManagerException("Tipo de almacen no soportado, este gestor es exclusivo CAPI: " + aOKeyStore.getName());
        }
        this.setKeyStoreType(AOKeyStore.WINDOWS);
        this.setKeyStore(CAPIKeyStoreManager.initCapi());
    }

    private static KeyStore initCapi() throws AOKeyStoreManagerException, IOException {
        if (capiKsMy == null) {
            if (!Platform.getOS().equals((Object)Platform.OS.WINDOWS)) {
                throw new InvalidOSException("Microsoft Windows");
            }
            if (Security.getProvider("SunMSCAPI") == null) {
                try {
                    Security.addProvider((Provider)Class.forName("sun.security.mscapi.SunMSCAPI").newInstance());
                }
                catch (Exception exception) {
                    LOGGER.severe("No se ha podido instanciar 'sun.security.mscapi.SunMSCAPI': " + exception);
                    throw new MissingSunMSCAPIException(exception);
                }
            }
            try {
                capiKsMy = KeyStore.getInstance(AOKeyStore.WINDOWS.getProviderName());
            }
            catch (Exception exception) {
                throw new AOKeyStoreManagerException("No se ha podido obtener el almacen Windows.MY: " + exception, exception);
            }
            LOGGER.info("Cargando KeyStore de Windows");
            try {
                capiKsMy.load(null, null);
            }
            catch (CertificateException certificateException) {
                throw new AOKeyStoreManagerException("No se han podido cargar los certificados del almacen Windows.MY: " + certificateException, certificateException);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new AOKeyStoreManagerException("No se ha podido verificar la integridad del almacen Windows.MY: " + noSuchAlgorithmException, noSuchAlgorithmException);
            }
            try {
                CAPIKeyStoreManager.cleanCAPIDuplicateAliases(capiKsMy);
            }
            catch (Exception exception) {
                LOGGER.warning("No se han podido tratar los alias duplicados: " + exception);
            }
        }
        return capiKsMy;
    }

    @Override
    public X509Certificate getCertificate(String string) {
        if (string == null) {
            LOGGER.warning("El alias del certificado es nulo, se devolvera null");
            return null;
        }
        if (capiKsMy == null) {
            LOGGER.warning("No se ha podido recuperar el certificado con alias '" + string + "' porque el KeyStore no estaba inicializado, se devolvera null");
            return null;
        }
        X509Certificate x509Certificate = null;
        try {
            x509Certificate = (X509Certificate)capiKsMy.getCertificate(string);
        }
        catch (Exception exception) {
            LOGGER.warning("No se ha podido recuperar el certificado con alias '" + string + "', se devolvera null: " + exception);
            return null;
        }
        if (x509Certificate == null) {
            LOGGER.warning("No se ha podido recuperar el certificado con alias '" + string + "', se devolvera null");
            return null;
        }
        return x509Certificate;
    }

    @Override
    public X509Certificate[] getCertificateChain(String string) {
        if (capiKsMy == null) {
            LOGGER.warning("El KeyStore actual no esta inicializado, por lo que no se pudo recuperar el certificado para el alias '" + string + "'");
            return null;
        }
        try {
            return (X509Certificate[])capiKsMy.getCertificateChain(string);
        }
        catch (Exception exception) {
            LOGGER.severe("Error al obtener la cadena de certificados para el alias '" + string + "', se devolvera una cadena vacia: " + exception);
            return new X509Certificate[0];
        }
    }

    @Override
    public String[] getAliases() {
        if (capiKsMy == null) {
            throw new IllegalStateException("Se han pedido los alias de un almacen no inicializado");
        }
        if (this.getCachedAliases() != null) {
            return this.getCachedAliases();
        }
        LOGGER.info("Solicitando los alias al KeyStore (" + capiKsMy.getProvider() + ")");
        try {
            this.setCachedAliases(Collections.list(capiKsMy.aliases()).toArray(new String[0]));
        }
        catch (Exception exception) {
            LOGGER.severe("Error intentando obtener los alias del almacen de claves, se devolvera una enumeracion vacia: " + exception);
            return new String[0];
        }
        return this.getCachedAliases();
    }

    @Override
    public String toString() {
        return "Gestor del almacen Windows.MY de CAPI via SunMSCAPI";
    }

    private static void cleanCAPIDuplicateAliases(KeyStore keyStore) throws NoSuchFieldException, IllegalAccessException {
        Field field = keyStore.getClass().getDeclaredField("keyStoreSpi");
        field.setAccessible(true);
        KeyStoreSpi keyStoreSpi = (KeyStoreSpi)field.get(keyStore);
        if ("sun.security.mscapi.KeyStore$MY".equals(keyStoreSpi.getClass().getName())) {
            field = keyStoreSpi.getClass().getEnclosingClass().getDeclaredField("entries");
            field.setAccessible(true);
            Object object = field.get(keyStoreSpi);
            ArrayList arrayList = object instanceof HashMap ? new ArrayList(((HashMap)object).values()) : (ArrayList)object;
            for (Object e : arrayList) {
                field = e.getClass().getDeclaredField("certChain");
                field.setAccessible(true);
                X509Certificate[] x509CertificateArray = (X509Certificate[])field.get(e);
                try {
                    String string = Integer.toString(x509CertificateArray[0].hashCode());
                    field = e.getClass().getDeclaredField("alias");
                    field.setAccessible(true);
                    String string2 = (String)field.get(e);
                    if (string2.equals(string)) continue;
                    field.set(e, string2.concat(" - ").concat(string));
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    System.out.println(x509CertificateArray.length);
                    arrayIndexOutOfBoundsException.printStackTrace(System.out);
                }
            }
        }
    }
}

