/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.keystores;

import es.gob.afirma.keystores.AOKeyStore;
import es.gob.afirma.keystores.AOKeyStoreManager;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableEntryException;
import javax.security.auth.callback.PasswordCallback;

final class AppleKeyStoreManager
extends AOKeyStoreManager {
    AppleKeyStoreManager() {
        this.setKeyStoreType(AOKeyStore.APPLE);
    }

    @Override
    public KeyStore.PrivateKeyEntry getKeyEntry(String string, PasswordCallback passwordCallback) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableEntryException {
        if (this.getKeyStore() == null) {
            throw new IllegalStateException("Se han pedido claves a un almacen no inicializado");
        }
        if (string == null) {
            throw new IllegalArgumentException("El alias no puede ser nulo");
        }
        if (this.getKeyStore().containsAlias(string)) {
            PrivateKey privateKey = null;
            try {
                LOGGER.info("Llavero de Mac OS X, se tratan directamente las claves privadas");
                privateKey = (PrivateKey)this.getKeyStore().getKey(string, "dummy".toCharArray());
            }
            catch (Exception exception) {
                LOGGER.warning("Error recuperando directamente la clave privada en Mac OS X: " + exception);
            }
            if (privateKey == null) {
                throw new UnsupportedOperationException("La entrada no tiene clave privada");
            }
            return new KeyStore.PrivateKeyEntry(privateKey, this.getCertificateChain(string));
        }
        LOGGER.warning("El almacen no contiene ninguna clave con el alias '" + string + "', se devolvera null");
        return null;
    }
}

