/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.keystores;

import es.gob.afirma.keystores.AOKeyStoreManager;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableEntryException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.security.auth.callback.PasswordCallback;

public class AggregatedKeyStoreManager
extends AOKeyStoreManager {
    private final List<AOKeyStoreManager> ksms = new ArrayList<AOKeyStoreManager>();

    AggregatedKeyStoreManager(AOKeyStoreManager aOKeyStoreManager) {
        if (aOKeyStoreManager == null) {
            throw new IllegalArgumentException("El gestor principal de almacenes no puede ser nulo");
        }
        this.addKeyStoreManager(aOKeyStoreManager);
        this.setKeyStoreType(aOKeyStoreManager.getType());
    }

    protected AggregatedKeyStoreManager() {
    }

    public void addKeyStoreManager(AOKeyStoreManager aOKeyStoreManager) {
        if (aOKeyStoreManager != null) {
            this.ksms.add(aOKeyStoreManager);
        }
    }

    @Override
    public String[] getAliases() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (AOKeyStoreManager aOKeyStoreManager : this.ksms) {
            arrayList.addAll(Arrays.asList(aOKeyStoreManager.getAliases()));
        }
        return arrayList.toArray(new String[0]);
    }

    @Override
    public X509Certificate getCertificate(String string) {
        for (AOKeyStoreManager aOKeyStoreManager : this.ksms) {
            if (!Arrays.asList(aOKeyStoreManager.getAliases()).contains(string)) continue;
            return aOKeyStoreManager.getCertificate(string);
        }
        LOGGER.warning("El almacen no contiene ningun certificado con alias '" + string + "', se devolvera null");
        return null;
    }

    @Override
    public KeyStore.PrivateKeyEntry getKeyEntry(String string, PasswordCallback passwordCallback) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableEntryException {
        for (AOKeyStoreManager aOKeyStoreManager : this.ksms) {
            if (!Arrays.asList(aOKeyStoreManager.getAliases()).contains(string)) continue;
            return aOKeyStoreManager.getKeyEntry(string, passwordCallback);
        }
        LOGGER.warning("El almacen no contiene ninguna clave con alias '" + string + "', se devolvera null");
        return null;
    }

    @Override
    public X509Certificate[] getCertificateChain(String string) {
        for (AOKeyStoreManager aOKeyStoreManager : this.ksms) {
            if (!Arrays.asList(aOKeyStoreManager.getAliases()).contains(string)) continue;
            return aOKeyStoreManager.getCertificateChain(string);
        }
        LOGGER.warning("El almacen no contiene ninguna cadena de certificados con alias '" + string + "', se devolvera null");
        return null;
    }

    @Override
    public void refresh() throws IOException {
        for (AOKeyStoreManager aOKeyStoreManager : this.ksms) {
            aOKeyStoreManager.refresh();
        }
    }

    @Override
    protected boolean lacksKeyStores() {
        return this.ksms.isEmpty();
    }
}

