/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.keystores;

import es.gob.afirma.keystores.AOKeyStore;
import es.gob.afirma.keystores.AOKeyStoreManagerException;
import es.gob.afirma.keystores.KeyStoreUtilities;
import es.gob.afirma.keystores.MissingSunPKCS11Exception;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.logging.Logger;
import javax.crypto.BadPaddingException;
import javax.security.auth.callback.PasswordCallback;

final class AOKeyStoreManagerHelperPkcs11 {
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");

    private AOKeyStoreManagerHelperPkcs11() {
    }

    static KeyStore initPKCS11(PasswordCallback passwordCallback, Object[] objectArray) throws AOKeyStoreManagerException, IOException {
        Object object;
        if (objectArray == null || objectArray.length < 2) {
            throw new IOException("No se puede acceder al KeyStore PKCS#11 si no se especifica la biblioteca");
        }
        if (objectArray[0] == null) {
            throw new IllegalArgumentException("No se puede acceder al KeyStore PKCS#11 si se especifica una biblioteca nula");
        }
        String string = objectArray[0].toString();
        Integer n = null;
        if (objectArray.length >= 3 && objectArray[2] instanceof Integer) {
            n = (Integer)objectArray[2];
        }
        String string2 = new File(string).getName().replace('.', '_').replace(' ', '_');
        Provider provider = Security.getProvider("SunPKCS11-" + string2);
        if (provider == null) {
            try {
                object = Class.forName("sun.security.pkcs11.SunPKCS11").getConstructor(InputStream.class);
            }
            catch (Exception exception) {
                throw new MissingSunPKCS11Exception(exception);
            }
            byte[] byArray = KeyStoreUtilities.createPKCS11ConfigFile(string, string2, n).getBytes();
            try {
                provider = (Provider)((Constructor)object).newInstance(new ByteArrayInputStream(byArray));
            }
            catch (Exception exception) {
                try {
                    provider = (Provider)((Constructor)object).newInstance(new ByteArrayInputStream(byArray));
                }
                catch (Exception exception2) {
                    throw new AOKeyStoreManagerException("No se ha podido instanciar el proveedor SunPKCS11 para la la biblioteca " + string, exception2);
                }
            }
            Security.addProvider(provider);
        } else {
            LOGGER.info("El proveedor SunPKCS11 solicitado ya estaba instanciado, se reutilizara esa instancia: " + provider.getName());
        }
        try {
            object = KeyStore.getInstance(AOKeyStore.PKCS11.getProviderName(), provider);
        }
        catch (Exception exception) {
            Security.removeProvider(provider.getName());
            provider = null;
            throw new AOKeyStoreManagerException("No se ha podido obtener el almacen PKCS#11", exception);
        }
        try {
            ((KeyStore)object).load(null, passwordCallback != null ? passwordCallback.getPassword() : null);
        }
        catch (IOException iOException) {
            if (iOException.getCause() instanceof UnrecoverableKeyException || iOException.getCause() instanceof BadPaddingException) {
                throw new IOException("Contrasena invalida: " + iOException, iOException);
            }
            throw new AOKeyStoreManagerException("No se ha podido obtener el almacen PKCS#11 solicitado", iOException);
        }
        catch (CertificateException certificateException) {
            Security.removeProvider(provider.getName());
            provider = null;
            throw new AOKeyStoreManagerException("No se han podido cargar los certificados del almacen PKCS#11 solicitado", certificateException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Security.removeProvider(provider.getName());
            provider = null;
            throw new AOKeyStoreManagerException("No se ha podido verificar la integridad del almacen PKCS#11 solicitado", noSuchAlgorithmException);
        }
        return object;
    }
}

