/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.keystores;

import es.gob.afirma.keystores.AOKeyStore;
import es.gob.afirma.keystores.AOKeyStoreManagerException;
import java.awt.Component;
import java.io.IOException;
import java.lang.reflect.Method;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateException;
import java.util.logging.Logger;
import javax.security.auth.callback.PasswordCallback;

final class AOKeyStoreManagerHelperDnieJava {
    protected static final Logger LOGGER = Logger.getLogger("es.gob.afirma");

    private AOKeyStoreManagerHelperDnieJava() {
    }

    static KeyStore initDnieJava(PasswordCallback passwordCallback, Object object) throws AOKeyStoreManagerException, IOException {
        Object object2;
        if (Security.getProvider(AOKeyStore.DNIEJAVA.getProviderName()) == null) {
            try {
                Provider provider = (Provider)Class.forName("es.gob.jmulticard.jse.provider.DnieProvider").newInstance();
                Security.addProvider(provider);
            }
            catch (Exception exception) {
                throw new AOKeyStoreManagerException("No se ha podido instanciar e instalar el proveedor 100% Java para DNIe de Afirma: " + exception, exception);
            }
        }
        try {
            object2 = Class.forName("es.gob.jmulticard.ui.passwordcallback.PasswordCallbackManager");
            Method method = ((Class)object2).getMethod("setDialogOwner", Component.class);
            method.invoke(null, object);
        }
        catch (Exception exception) {
            LOGGER.warning("No se ha podido establecer el componente padre para los dialogos del almacen: " + exception);
        }
        try {
            object2 = KeyStore.getInstance(AOKeyStore.DNIEJAVA.getProviderName());
        }
        catch (Exception exception) {
            throw new AOKeyStoreManagerException("No se ha podido obtener el almacen DNIe 100% Java: " + exception, exception);
        }
        LOGGER.info("Cargando KeyStore DNIe 100% Java");
        try {
            ((KeyStore)object2).load(null, passwordCallback == null ? null : passwordCallback.getPassword());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AOKeyStoreManagerException("Error de algoritmo al obtener el almacen DNIe 100% Java: " + noSuchAlgorithmException, noSuchAlgorithmException);
        }
        catch (CertificateException certificateException) {
            throw new AOKeyStoreManagerException("Error de certificado al obtener el almacen DNIe 100% Java: " + certificateException, certificateException);
        }
        return object2;
    }
}

