/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.keystores;

import es.gob.afirma.core.AOCancelledOperationException;
import es.gob.afirma.core.AOException;
import es.gob.afirma.core.misc.Platform;
import es.gob.afirma.core.ui.AOUIFactory;
import es.gob.afirma.keystores.AOKeyStore;
import es.gob.afirma.keystores.AOKeyStoreManager;
import es.gob.afirma.keystores.AOKeyStoreManagerException;
import es.gob.afirma.keystores.AOKeystoreAlternativeException;
import es.gob.afirma.keystores.AggregatedKeyStoreManager;
import es.gob.afirma.keystores.AppleKeyStoreManager;
import es.gob.afirma.keystores.CAPIKeyStoreManager;
import es.gob.afirma.keystores.KeyStoreMessages;
import es.gob.afirma.keystores.KeyStoreUtilities;
import es.gob.afirma.keystores.callbacks.NullPasswordCallback;
import es.gob.afirma.keystores.pkcs12.Pkcs12KeyStoreManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import javax.security.auth.callback.PasswordCallback;

public final class AOKeyStoreManagerFactory {
    private static final String FORCE_STORE_RESET = "es.gob.afirma.keystores.ForceReset";

    private AOKeyStoreManagerFactory() {
    }

    public static AggregatedKeyStoreManager getAOKeyStoreManager(AOKeyStore aOKeyStore, String string, String string2, PasswordCallback passwordCallback, Object object) throws AOKeystoreAlternativeException, IOException {
        boolean bl = Boolean.getBoolean(FORCE_STORE_RESET);
        if (bl) {
            Logger.getLogger("es.gob.afirma").info("No se mantendran los almacenes de claves precargados (es.gob.afirma.keystores.ForceReset=true)");
        }
        if (AOKeyStore.PKCS12.equals((Object)aOKeyStore)) {
            return new AggregatedKeyStoreManager(AOKeyStoreManagerFactory.getPkcs12KeyStoreManager(string, passwordCallback, bl, object));
        }
        if (AOKeyStore.PKCS12.equals((Object)aOKeyStore) || AOKeyStore.JAVA.equals((Object)aOKeyStore) || AOKeyStore.SINGLE.equals((Object)aOKeyStore) || AOKeyStore.JAVACE.equals((Object)aOKeyStore) || AOKeyStore.JCEKS.equals((Object)aOKeyStore)) {
            return new AggregatedKeyStoreManager(AOKeyStoreManagerFactory.getFileKeyStoreManager(aOKeyStore, string, passwordCallback, bl, object));
        }
        if (AOKeyStore.PKCS11.equals((Object)aOKeyStore)) {
            return new AggregatedKeyStoreManager(AOKeyStoreManagerFactory.getPkcs11KeyStoreManager(string, string2, passwordCallback, bl, object));
        }
        if (Platform.getOS().equals((Object)Platform.OS.WINDOWS) && AOKeyStore.WINDOWS.equals((Object)aOKeyStore)) {
            return new AggregatedKeyStoreManager(AOKeyStoreManagerFactory.getWindowsMyCapiKeyStoreManager(bl));
        }
        if (Platform.getOS().equals((Object)Platform.OS.WINDOWS) && (AOKeyStore.WINADDRESSBOOK.equals((Object)aOKeyStore) || AOKeyStore.WINCA.equals((Object)aOKeyStore))) {
            return new AggregatedKeyStoreManager(AOKeyStoreManagerFactory.getWindowsAddressBookKeyStoreManager(aOKeyStore, bl));
        }
        if (AOKeyStore.MOZ_UNI.equals((Object)aOKeyStore)) {
            return AOKeyStoreManagerFactory.getMozillaUnifiedKeyStoreManager(passwordCallback, bl, object);
        }
        if (Platform.getOS().equals((Object)Platform.OS.MACOSX) && AOKeyStore.APPLE.equals((Object)aOKeyStore)) {
            return AOKeyStoreManagerFactory.getMacOSXKeyStoreManager(aOKeyStore, string, passwordCallback, bl, object);
        }
        if (AOKeyStore.DNIEJAVA.equals((Object)aOKeyStore)) {
            return new AggregatedKeyStoreManager(AOKeyStoreManagerFactory.getDnieJavaKeyStoreManager(passwordCallback, bl, object));
        }
        throw new AOKeystoreAlternativeException(AOKeyStoreManagerFactory.getAlternateKeyStoreType(aOKeyStore), "La plataforma de navegador '" + aOKeyStore.getName() + "' mas sistema operativo '" + (Object)((Object)Platform.getOS()) + "' no esta soportada");
    }

    private static AOKeyStoreManager getPkcs12KeyStoreManager(String string, PasswordCallback passwordCallback, boolean bl, Object object) throws IOException, AOKeystoreAlternativeException {
        Object object2;
        Pkcs12KeyStoreManager pkcs12KeyStoreManager = new Pkcs12KeyStoreManager();
        String string2 = null;
        if (string != null && !"".equals(string) && new File(string).exists()) {
            string2 = string;
        }
        if (string2 == null) {
            object2 = null;
            String[] stringArray = new String[]{"pfx", "p12"};
            object2 = KeyStoreMessages.getString("AOKeyStoreManagerFactory.0");
            string2 = AOUIFactory.getLoadFiles(KeyStoreMessages.getString("AOKeyStoreManagerFactory.4") + " PKCS#12", null, null, stringArray, (String)object2, false, false, object)[0].getAbsolutePath();
            if (string2 == null) {
                throw new AOCancelledOperationException("No se ha seleccionado el almacen de certificados");
            }
        }
        object2 = null;
        try {
            object2 = new FileInputStream(string2);
            ((AOKeyStoreManager)pkcs12KeyStoreManager).init(null, (InputStream)object2, passwordCallback, null, bl);
        }
        catch (AOException aOException) {
            throw new AOKeystoreAlternativeException(AOKeyStore.JAVA, "No se ha podido abrir el almacen de tipo PKCS#12 para el fichero " + string, aOException);
        }
        finally {
            if (object2 != null) {
                ((InputStream)object2).close();
            }
        }
        return pkcs12KeyStoreManager;
    }

    private static AOKeyStoreManager getDnieJavaKeyStoreManager(PasswordCallback passwordCallback, boolean bl, Object object) throws AOKeystoreAlternativeException, IOException {
        AOKeyStoreManager aOKeyStoreManager = new AOKeyStoreManager();
        try {
            aOKeyStoreManager.init(AOKeyStore.DNIEJAVA, null, passwordCallback, new Object[]{object}, bl);
        }
        catch (AOKeyStoreManagerException aOKeyStoreManagerException) {
            throw new AOKeystoreAlternativeException(AOKeyStoreManagerFactory.getAlternateKeyStoreType(AOKeyStore.DNIEJAVA), "Error al inicializar el modulo DNIe 100% Java: " + aOKeyStoreManagerException, aOKeyStoreManagerException);
        }
        return aOKeyStoreManager;
    }

    private static AOKeyStoreManager getFileKeyStoreManager(AOKeyStore aOKeyStore, String string, PasswordCallback passwordCallback, boolean bl, Object object) throws IOException, AOKeystoreAlternativeException {
        Object object2;
        AOKeyStoreManager aOKeyStoreManager = new AOKeyStoreManager();
        String string2 = null;
        if (string != null && !"".equals(string) && new File(string).exists()) {
            string2 = string;
        }
        if (string2 == null) {
            object2 = null;
            String[] stringArray = null;
            if (aOKeyStore == AOKeyStore.PKCS12) {
                stringArray = new String[]{"pfx", "p12"};
                object2 = KeyStoreMessages.getString("AOKeyStoreManagerFactory.0");
            }
            if (aOKeyStore == AOKeyStore.JAVA) {
                stringArray = new String[]{"jks"};
                object2 = KeyStoreMessages.getString("AOKeyStoreManagerFactory.1");
            }
            if (aOKeyStore == AOKeyStore.SINGLE) {
                stringArray = new String[]{"cer", "p7b"};
                object2 = KeyStoreMessages.getString("AOKeyStoreManagerFactory.2");
            }
            if (aOKeyStore == AOKeyStore.JCEKS) {
                stringArray = new String[]{"jceks", "jks"};
                object2 = KeyStoreMessages.getString("AOKeyStoreManagerFactory.3");
            }
            if ((string2 = AOUIFactory.getLoadFiles(KeyStoreMessages.getString("AOKeyStoreManagerFactory.4") + " " + aOKeyStore.getName(), null, null, stringArray, (String)object2, false, false, object)[0].getAbsolutePath()) == null) {
                throw new AOCancelledOperationException("No se ha seleccionado el almacen de certificados");
            }
        }
        object2 = null;
        try {
            object2 = new FileInputStream(string2);
            aOKeyStoreManager.init(aOKeyStore, (InputStream)object2, passwordCallback, null, bl);
        }
        catch (AOException aOException) {
            throw new AOKeystoreAlternativeException(AOKeyStoreManagerFactory.getAlternateKeyStoreType(aOKeyStore), "No se ha podido abrir el almacen de tipo " + aOKeyStore.getName(), aOException);
        }
        finally {
            if (object2 != null) {
                ((InputStream)object2).close();
            }
        }
        return aOKeyStoreManager;
    }

    private static AOKeyStoreManager getPkcs11KeyStoreManager(String string, String string2, PasswordCallback passwordCallback, boolean bl, Object object) throws IOException, AOKeystoreAlternativeException {
        AOKeyStoreManager aOKeyStoreManager = new AOKeyStoreManager();
        String string3 = null;
        if (string != null && !"".equals(string)) {
            string3 = string;
        }
        if (string3 != null && !new File(string3).exists()) {
            throw new IOException("La biblioteca '" + string3 + "' no existe");
        }
        if (string3 == null) {
            String[] stringArray;
            String string4 = KeyStoreMessages.getString("AOKeyStoreManagerFactory.6");
            if (Platform.OS.WINDOWS.equals((Object)Platform.getOS())) {
                stringArray = new String[]{"dll"};
                string4 = string4 + " (*.dll)";
            } else if (Platform.OS.MACOSX.equals((Object)Platform.getOS())) {
                stringArray = new String[]{"so", "dylib"};
                string4 = string4 + " (*.dylib, *.so)";
            } else {
                stringArray = new String[]{"so"};
                string4 = string4 + " (*.so)";
            }
            string3 = AOUIFactory.getLoadFiles(KeyStoreMessages.getString("AOKeyStoreManagerFactory.7"), null, null, stringArray, string4, false, false, object)[0].getAbsolutePath();
        }
        if (string3 == null) {
            throw new AOCancelledOperationException("No se ha seleccionado el controlador PKCS#11");
        }
        try {
            aOKeyStoreManager.init(AOKeyStore.PKCS11, null, passwordCallback, new String[]{string3, string2}, bl);
        }
        catch (AOException aOException) {
            throw new AOKeystoreAlternativeException(AOKeyStoreManagerFactory.getAlternateKeyStoreType(AOKeyStore.PKCS11), "Error al inicializar el modulo PKCS#11", aOException);
        }
        return aOKeyStoreManager;
    }

    private static AOKeyStoreManager getWindowsAddressBookKeyStoreManager(AOKeyStore aOKeyStore, boolean bl) throws IOException, AOKeystoreAlternativeException {
        AOKeyStoreManager aOKeyStoreManager = new AOKeyStoreManager();
        try {
            aOKeyStoreManager.init(aOKeyStore, null, NullPasswordCallback.getInstance(), null, bl);
        }
        catch (AOException aOException) {
            throw new AOKeystoreAlternativeException(AOKeyStoreManagerFactory.getAlternateKeyStoreType(aOKeyStore), "Error al inicializar el almacen " + aOKeyStore.getName(), aOException);
        }
        return aOKeyStoreManager;
    }

    private static AOKeyStoreManager getWindowsMyCapiKeyStoreManager(boolean bl) throws AOKeystoreAlternativeException, IOException {
        CAPIKeyStoreManager cAPIKeyStoreManager = new CAPIKeyStoreManager();
        try {
            ((AOKeyStoreManager)cAPIKeyStoreManager).init(AOKeyStore.WINDOWS, null, null, null, bl);
        }
        catch (AOKeyStoreManagerException aOKeyStoreManagerException) {
            throw new AOKeystoreAlternativeException(AOKeyStoreManagerFactory.getAlternateKeyStoreType(AOKeyStore.WINDOWS), "Error al obtener almacen WINDOWS: " + aOKeyStoreManagerException, aOKeyStoreManagerException);
        }
        return cAPIKeyStoreManager;
    }

    private static AggregatedKeyStoreManager getMozillaUnifiedKeyStoreManager(PasswordCallback passwordCallback, boolean bl, Object object) throws AOKeystoreAlternativeException, IOException {
        AggregatedKeyStoreManager aggregatedKeyStoreManager;
        try {
            aggregatedKeyStoreManager = (AggregatedKeyStoreManager)Class.forName("es.gob.afirma.keystores.mozilla.MozillaUnifiedKeyStoreManager").newInstance();
        }
        catch (Exception exception) {
            throw new AOKeystoreAlternativeException(AOKeyStoreManagerFactory.getAlternateKeyStoreType(AOKeyStore.MOZ_UNI), "Error al obtener dinamicamente el almacen NSS unificado de Mozilla Firefox: " + exception, exception);
        }
        try {
            aggregatedKeyStoreManager.init(AOKeyStore.MOZ_UNI, null, passwordCallback, new Object[]{object}, bl);
        }
        catch (AOException aOException) {
            throw new AOKeystoreAlternativeException(AOKeyStoreManagerFactory.getAlternateKeyStoreType(AOKeyStore.MOZ_UNI), "Error al inicializar el almacen NSS unificado de Mozilla Firefox: " + aOException, aOException);
        }
        return aggregatedKeyStoreManager;
    }

    private static AggregatedKeyStoreManager getMacOSXKeyStoreManager(AOKeyStore aOKeyStore, String string, PasswordCallback passwordCallback, boolean bl, Object object) throws IOException, AOKeystoreAlternativeException {
        AppleKeyStoreManager appleKeyStoreManager = new AppleKeyStoreManager();
        try {
            appleKeyStoreManager.init(aOKeyStore, string == null || "".equals(string) ? null : new FileInputStream(string), NullPasswordCallback.getInstance(), null, bl);
        }
        catch (AOException aOException) {
            throw new AOKeystoreAlternativeException(AOKeyStoreManagerFactory.getAlternateKeyStoreType(aOKeyStore), "Error al inicializar el Llavero de Mac OS X", aOException);
        }
        AggregatedKeyStoreManager aggregatedKeyStoreManager = new AggregatedKeyStoreManager(appleKeyStoreManager);
        if (!KeyStoreUtilities.containsDnie(appleKeyStoreManager)) {
            try {
                aggregatedKeyStoreManager.addKeyStoreManager(AOKeyStoreManagerFactory.getDnieJavaKeyStoreManager(passwordCallback, bl, object));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return aggregatedKeyStoreManager;
    }

    private static AOKeyStore getAlternateKeyStoreType(AOKeyStore aOKeyStore) {
        if (AOKeyStore.PKCS12.equals((Object)aOKeyStore)) {
            return null;
        }
        if (Platform.OS.WINDOWS.equals((Object)Platform.getOS()) && !AOKeyStore.WINDOWS.equals((Object)aOKeyStore)) {
            return AOKeyStore.WINDOWS;
        }
        if (Platform.OS.MACOSX.equals((Object)Platform.getOS()) && !AOKeyStore.APPLE.equals((Object)aOKeyStore)) {
            return AOKeyStore.APPLE;
        }
        return AOKeyStore.PKCS12;
    }
}

