/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.keystores;

import es.gob.afirma.core.keystores.KeyStoreRefresher;
import es.gob.afirma.keystores.AOKeyStore;
import es.gob.afirma.keystores.AOKeyStoreManagerException;
import es.gob.afirma.keystores.AOKeyStoreManagerHelperApple;
import es.gob.afirma.keystores.AOKeyStoreManagerHelperCapiAddressBook;
import es.gob.afirma.keystores.AOKeyStoreManagerHelperDnieJava;
import es.gob.afirma.keystores.AOKeyStoreManagerHelperJava;
import es.gob.afirma.keystores.AOKeyStoreManagerHelperPkcs11;
import es.gob.afirma.keystores.AOKeyStoreManagerHelperSingle;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableEntryException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Logger;
import javax.security.auth.callback.PasswordCallback;

public class AOKeyStoreManager
implements KeyStoreRefresher {
    protected static final Logger LOGGER = Logger.getLogger("es.gob.afirma");
    private String[] cachedAliases = null;
    private AOKeyStore ksType;
    private KeyStore ks;
    private InputStream storeIs;
    private PasswordCallback callBack;
    private Object[] storeParams;

    protected void resetCachedAliases() {
        this.cachedAliases = null;
    }

    protected String[] getCachedAliases() {
        return this.cachedAliases;
    }

    protected void setCachedAliases(String[] stringArray) {
        this.cachedAliases = (String[])stringArray.clone();
    }

    protected void setKeyStore(KeyStore keyStore) {
        if (keyStore == null) {
            throw new IllegalArgumentException("El almacen no puede ser nulo");
        }
        this.ks = keyStore;
    }

    public KeyStore getKeyStore() {
        return this.ks;
    }

    @Override
    public void refresh() throws IOException {
        this.resetCachedAliases();
        try {
            this.init(this.ksType, this.storeIs, this.callBack, this.storeParams, true);
        }
        catch (AOKeyStoreManagerException aOKeyStoreManagerException) {
            throw new IOException("Error al refrescar el almacen: " + aOKeyStoreManagerException, aOKeyStoreManagerException);
        }
    }

    protected boolean lacksKeyStores() {
        return this.ks == null;
    }

    protected void setKeyStoreType(AOKeyStore aOKeyStore) {
        this.ksType = aOKeyStore;
    }

    public AOKeyStore getType() {
        return this.ksType;
    }

    public void init(AOKeyStore aOKeyStore, InputStream inputStream, PasswordCallback passwordCallback, Object[] objectArray, boolean bl) throws AOKeyStoreManagerException, IOException {
        if (aOKeyStore == null) {
            throw new IllegalArgumentException("Se ha solicitado inicializar un AOKeyStore nulo");
        }
        LOGGER.info("Inicializamos el almacen de tipo: " + (Object)((Object)aOKeyStore));
        this.resetCachedAliases();
        this.ksType = aOKeyStore;
        this.storeIs = inputStream;
        this.callBack = passwordCallback;
        if (objectArray == null) {
            this.storeParams = null;
        } else {
            this.storeParams = new Object[objectArray.length];
            System.arraycopy(objectArray, 0, this.storeParams, 0, objectArray.length);
        }
        switch (this.ksType) {
            case SINGLE: {
                this.ks = AOKeyStoreManagerHelperSingle.initSingle(inputStream, passwordCallback);
                break;
            }
            case DNIEJAVA: {
                this.ks = AOKeyStoreManagerHelperDnieJava.initDnieJava(passwordCallback, objectArray != null && objectArray.length > 0 ? objectArray[0] : null);
                break;
            }
            case JAVA: 
            case JAVACE: 
            case JCEKS: {
                this.ks = AOKeyStoreManagerHelperJava.initJava(inputStream, passwordCallback, this.ksType);
                break;
            }
            case WINCA: 
            case WINADDRESSBOOK: {
                this.ks = AOKeyStoreManagerHelperCapiAddressBook.initCAPIAddressBook(this.ksType);
                break;
            }
            case PKCS11: {
                Object[] objectArray2;
                if (objectArray != null) {
                    objectArray2 = new Object[objectArray.length];
                    System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
                } else {
                    objectArray2 = null;
                }
                this.ks = AOKeyStoreManagerHelperPkcs11.initPKCS11(passwordCallback, objectArray2);
                break;
            }
            case APPLE: {
                this.ks = AOKeyStoreManagerHelperApple.initApple(inputStream);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Tipo de almacen no soportado: " + inputStream);
            }
        }
    }

    public KeyStore.PrivateKeyEntry getKeyEntry(String string, PasswordCallback passwordCallback) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableEntryException {
        if (this.ks == null) {
            throw new IllegalStateException("Se han pedido claves a un almacen no inicializado");
        }
        if (string == null) {
            throw new IllegalArgumentException("El alias no puede ser nulo");
        }
        return (KeyStore.PrivateKeyEntry)this.ks.getEntry(string, passwordCallback != null ? new KeyStore.PasswordProtection(passwordCallback.getPassword()) : null);
    }

    public X509Certificate getCertificate(String string) {
        if (string == null) {
            LOGGER.warning("El alias del certificado es nulo, se devolvera null");
            return null;
        }
        if (this.ks == null) {
            LOGGER.warning("No se ha podido recuperar el certificado con alias '" + string + "' porque el KeyStore no estaba inicializado, se devolvera null");
            return null;
        }
        try {
            return (X509Certificate)this.ks.getCertificate(string);
        }
        catch (Exception exception) {
            LOGGER.severe("Error intentando recuperar el certificado con el alias '" + string + "', se devolvera null: " + exception);
            return null;
        }
    }

    public X509Certificate[] getCertificateChain(String string) {
        if (string == null) {
            LOGGER.warning("El alias del certificado es nulo, se devolvera una cadena vacia");
            return new X509Certificate[0];
        }
        if (this.ks == null) {
            LOGGER.warning("No se ha podido recuperar el certificado con alias '" + string + "' porque el KeyStore no estaba inicializado, se devolvera una cadena vacia");
            return new X509Certificate[0];
        }
        try {
            Certificate[] certificateArray = this.ks.getCertificateChain(string);
            if (certificateArray == null) {
                return new X509Certificate[0];
            }
            ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
            for (Certificate certificate : certificateArray) {
                if (!(certificate instanceof X509Certificate)) continue;
                arrayList.add((X509Certificate)certificate);
            }
            return arrayList.toArray(new X509Certificate[0]);
        }
        catch (Exception exception) {
            LOGGER.severe("Error intentando recuperar la cadena del certificado con alias '" + string + "', se continuara con el siguiente almacen: " + exception);
            LOGGER.warning("El almacen no contiene ningun certificado con el alias '" + string + "', se devolvera una cadena vacia");
            return new X509Certificate[0];
        }
    }

    public String[] getAliases() {
        if (this.ks == null) {
            throw new IllegalStateException("Se han pedido alias a un almacen no inicializado");
        }
        if (this.cachedAliases != null) {
            return this.cachedAliases;
        }
        try {
            this.cachedAliases = Collections.list(this.ks.aliases()).toArray(new String[0]);
        }
        catch (KeyStoreException keyStoreException) {
            LOGGER.severe("Error intentando recuperar los alias, se devolvera una lista vacia: " + keyStoreException);
            return new String[0];
        }
        return this.cachedAliases;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("Gestor de almacenes de claves");
        if (this.ksType != null) {
            String string = this.ksType.getName();
            if (string != null) {
                stringBuilder.append(" de tipo ");
                stringBuilder.append(string);
            }
            if ((string = this.ksType.getName()) != null) {
                stringBuilder.append(" con nombre ");
                stringBuilder.append(string);
            }
            stringBuilder.append(" de clase ");
            stringBuilder.append(this.ksType.toString());
        }
        return stringBuilder.toString();
    }
}

