/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.keystores;

import es.gob.afirma.keystores.KeyStoreMessages;
import es.gob.afirma.keystores.callbacks.CachePasswordCallback;
import es.gob.afirma.keystores.callbacks.NullPasswordCallback;
import es.gob.afirma.keystores.callbacks.UIPasswordCallback;
import javax.security.auth.callback.PasswordCallback;

public enum AOKeyStore {
    WINDOWS("Windows / Internet Explorer", 0, "Windows-MY", new CachePasswordCallback("winmydummy".toCharArray()), NullPasswordCallback.getInstance()),
    APPLE("Mac OS X / Safari", 1, "KeychainStore", new CachePasswordCallback("osxdummy".toCharArray()), new CachePasswordCallback("osxdummy".toCharArray())),
    PKCS12("PKCS#12 / PFX", 3, "PKCS12", new UIPasswordCallback(KeyStoreMessages.getString("AOKeyStore.0")), new UIPasswordCallback(KeyStoreMessages.getString("AOKeyStore.1"))),
    JAVA("Java KeyStore / JKS", 4, "JKS", new UIPasswordCallback(KeyStoreMessages.getString("AOKeyStore.2")), new UIPasswordCallback(KeyStoreMessages.getString("AOKeyStore.3"))),
    PKCS11("PKCS#11", 5, "PKCS11", NullPasswordCallback.getInstance(), new UIPasswordCallback(KeyStoreMessages.getString("AOKeyStore.4"))),
    SINGLE("PKCS#7 / X.509", 6, "PKCS7", NullPasswordCallback.getInstance(), NullPasswordCallback.getInstance()),
    MOZ_UNI("Mozilla / Firefox (unificado)", 7, "PKCS11", NullPasswordCallback.getInstance(), new UIPasswordCallback(KeyStoreMessages.getString("AOKeyStore.5"))),
    JCEKS("Java Cryptography Extension KeyStore (JCEKS)", 8, "JCEKS", new UIPasswordCallback(KeyStoreMessages.getString("AOKeyStore.6")), new UIPasswordCallback(KeyStoreMessages.getString("AOKeyStore.7"))),
    JAVACE("Java KeyStore / JKS (Case Exact)", 9, "CaseExactJKS", new UIPasswordCallback(KeyStoreMessages.getString("AOKeyStore.8")), new UIPasswordCallback(KeyStoreMessages.getString("AOKeyStore.9"))),
    WINADDRESSBOOK("Windows / Internet Explorer (otras personas / libreta de direcciones)", 11, "Windows-ADDRESSBOOK", new CachePasswordCallback("winotherdummy".toCharArray()), NullPasswordCallback.getInstance()),
    WINCA("Windows / Internet Explorer (CA intermedias)", 12, "Windows-CA", new CachePasswordCallback("wincadummy".toCharArray()), NullPasswordCallback.getInstance()),
    DNIEJAVA("DNIe 100% Java", 14, "DNI", null, null);

    private final String name;
    private final int ordinal;
    private final String providerName;
    private final PasswordCallback certificatePasswordCallback;
    private final PasswordCallback storePasswordCallback;

    private AOKeyStore(String string2, int n2, String string3, PasswordCallback passwordCallback, PasswordCallback passwordCallback2) {
        this.name = string2;
        this.ordinal = n2;
        this.providerName = string3;
        this.certificatePasswordCallback = passwordCallback;
        this.storePasswordCallback = passwordCallback2;
    }

    public String toString() {
        return this.getName();
    }

    public String getProviderName() {
        return this.providerName;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public String getName() {
        return this.name;
    }

    public static AOKeyStore getKeyStore(String string) {
        for (AOKeyStore aOKeyStore : AOKeyStore.values()) {
            if (!aOKeyStore.getName().equals(string)) continue;
            return aOKeyStore;
        }
        return null;
    }

    public PasswordCallback getCertificatePasswordCallback(Object object) {
        if (this.certificatePasswordCallback instanceof UIPasswordCallback) {
            ((UIPasswordCallback)this.certificatePasswordCallback).setParent(object);
        }
        return this.certificatePasswordCallback;
    }

    public PasswordCallback getStorePasswordCallback(Object object) {
        if (this.certificatePasswordCallback instanceof UIPasswordCallback) {
            ((UIPasswordCallback)this.certificatePasswordCallback).setParent(object);
        }
        return this.storePasswordCallback;
    }
}

