/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.core.signers;

import es.gob.afirma.core.misc.AOUtil;
import es.gob.afirma.core.misc.Base64;
import es.gob.afirma.core.signers.AOSignConstants;
import java.net.URL;
import java.security.MessageDigest;
import java.util.Properties;

public final class AdESPolicy {
    private String policyIdentifier = null;
    private String policyIdentifierHash = null;
    private String policyIdentifierHashAlgorithm = null;
    private URL policyQualifier = null;

    private void setValues(String string, String string2, String string3, String string4) {
        if (string == null || "".equals(string)) {
            throw new IllegalArgumentException("El identificador de politica no puede ser nulo ni vacio");
        }
        this.policyIdentifier = string;
        if (string2 != null && !"0".equals(string2) && (string3 == null || "".equals(string3))) {
            throw new IllegalArgumentException("Si se indica la huella digital del identificador de politica es obligatorio indicar tambien el algoritmo");
        }
        if (string2 == null) {
            try {
                this.policyIdentifierHash = Base64.encode(MessageDigest.getInstance("SHA-512").digest(AOUtil.getDataFromInputStream(new URL(string).openStream())));
                this.policyIdentifierHashAlgorithm = "SHA-512";
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Si no se especifica la huella digital de la politica es necesario que el identificador sea una URL accesible universalmente: " + exception, exception);
            }
        }
        if ("0".equals(string2)) {
            this.policyIdentifierHash = null;
        } else {
            if (!AOUtil.isBase64(string2.getBytes())) {
                throw new IllegalArgumentException("La huella digital de la politica debe estar en formato Base64");
            }
            try {
                this.policyIdentifierHashAlgorithm = AOSignConstants.getDigestAlgorithmName(string3);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("El algoritmo de huella digital no esta soportado: " + string3, exception);
            }
            this.policyIdentifierHash = string2;
        }
        if (string4 != null && !"".equals(string4)) {
            try {
                this.policyQualifier = new URL(string4);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("El calificador de la politica debe ser una URL valida", exception);
            }
        }
    }

    public AdESPolicy(Properties properties) {
        if (properties == null) {
            throw new IllegalArgumentException("Es necesario proporciona las propiedades de la politica");
        }
        String string = properties.getProperty("policyIdentifier");
        if (string != null) {
            this.setValues(string, properties.getProperty("policyIdentifierHash"), properties.getProperty("policyIdentifierHashAlgorithm"), properties.getProperty("policyQualifier"));
        }
    }

    public AdESPolicy(String string, String string2, String string3, String string4) {
        this.setValues(string, string2, string3, string4);
    }

    public String getPolicyIdentifier() {
        return this.policyIdentifier;
    }

    public String getPolicyIdentifierHash() {
        return this.policyIdentifierHash;
    }

    public String getPolicyIdentifierHashAlgorithm() {
        return this.policyIdentifierHashAlgorithm;
    }

    public URL getPolicyQualifier() {
        return this.policyQualifier;
    }

    public boolean equals(Object object) {
        if (!(object instanceof AdESPolicy)) {
            return false;
        }
        AdESPolicy adESPolicy = (AdESPolicy)object;
        return adESPolicy.getPolicyIdentifier().equals(this.getPolicyIdentifier()) && adESPolicy.getPolicyIdentifierHash().equals(this.getPolicyIdentifierHash()) && adESPolicy.getPolicyIdentifierHashAlgorithm().equals(this.getPolicyIdentifierHashAlgorithm());
    }

    public int hashCode() {
        return this.getPolicyIdentifier().hashCode();
    }
}

