/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.core.signers;

import es.gob.afirma.core.signers.AOSigner;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public final class AOSignerFactory {
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");
    private static final Map<String, AOSigner> SIGNERS = new HashMap<String, AOSigner>(20);
    private static final String SIGNER_CLASS_CADES = "es.gob.afirma.signers.cades.AOCAdESSigner";
    private static final String SIGNER_CLASS_CADES_TRI = "es.gob.afirma.signers.cadestri.client.AOCAdESTriPhaseSigner";
    private static final String SIGNER_CLASS_CMS = "es.gob.afirma.signers.cms.AOCMSSigner";
    private static final String SIGNER_CLASS_FACTURAE = "es.gob.afirma.signers.xades.AOFacturaESigner";
    private static final String SIGNER_CLASS_XADES = "es.gob.afirma.signers.xades.AOXAdESSigner";
    private static final String SIGNER_CLASS_XADES_TRI = "es.gob.afirma.signers.xadestri.client.AOXAdESTriPhaseSigner";
    private static final String SIGNER_CLASS_XMLDSIG = "es.gob.afirma.signers.xmldsig.AOXMLDSigSigner";
    private static final String SIGNER_CLASS_PADES = "es.gob.afirma.signers.pades.AOPDFSigner";
    private static final String SIGNER_CLASS_PADES_TRI = "es.gob.afirma.signers.padestri.client.AOPDFTriPhaseSigner";
    private static final String SIGNER_CLASS_ODF = "es.gob.afirma.signers.odf.AOODFSigner";
    private static final String SIGNER_CLASS_OOXML = "es.gob.afirma.signers.ooxml.AOOOXMLSigner";
    private static final String[][] SIGNERS_CLASSES = new String[][]{{"CAdES", "es.gob.afirma.signers.cades.AOCAdESSigner", Boolean.TRUE.toString()}, {"CAdEStri", "es.gob.afirma.signers.cadestri.client.AOCAdESTriPhaseSigner", Boolean.FALSE.toString()}, {"CMS/PKCS#7", "es.gob.afirma.signers.cms.AOCMSSigner", Boolean.TRUE.toString()}, {"FacturaE", "es.gob.afirma.signers.xades.AOFacturaESigner", Boolean.TRUE.toString()}, {"Factura-e", "es.gob.afirma.signers.xades.AOFacturaESigner", Boolean.FALSE.toString()}, {"XAdES", "es.gob.afirma.signers.xades.AOXAdESSigner", Boolean.TRUE.toString()}, {"XAdEStri", "es.gob.afirma.signers.xadestri.client.AOXAdESTriPhaseSigner", Boolean.FALSE.toString()}, {"XAdES Detached", "es.gob.afirma.signers.xades.AOXAdESSigner", Boolean.FALSE.toString()}, {"XAdES Enveloped", "es.gob.afirma.signers.xades.AOXAdESSigner", Boolean.FALSE.toString()}, {"XAdES Enveloping", "es.gob.afirma.signers.xades.AOXAdESSigner", Boolean.FALSE.toString()}, {"XMLDSig", "es.gob.afirma.signers.xmldsig.AOXMLDSigSigner", Boolean.TRUE.toString()}, {"XMLDSig Detached", "es.gob.afirma.signers.xmldsig.AOXMLDSigSigner", Boolean.FALSE.toString()}, {"XMLDSig Enveloped", "es.gob.afirma.signers.xmldsig.AOXMLDSigSigner", Boolean.FALSE.toString()}, {"XMLDSig Enveloping", "es.gob.afirma.signers.xmldsig.AOXMLDSigSigner", Boolean.FALSE.toString()}, {"Adobe PDF", "es.gob.afirma.signers.pades.AOPDFSigner", Boolean.FALSE.toString()}, {"Adobe PDF TriPhase", "es.gob.afirma.signers.padestri.client.AOPDFTriPhaseSigner", Boolean.FALSE.toString()}, {"PAdES", "es.gob.afirma.signers.pades.AOPDFSigner", Boolean.TRUE.toString()}, {"PAdEStri", "es.gob.afirma.signers.padestri.client.AOPDFTriPhaseSigner", Boolean.FALSE.toString()}, {"ODF (Open Document Format)", "es.gob.afirma.signers.odf.AOODFSigner", Boolean.TRUE.toString()}, {"ODF", "es.gob.afirma.signers.odf.AOODFSigner", Boolean.FALSE.toString()}, {"OOXML (Office Open XML)", "es.gob.afirma.signers.ooxml.AOOOXMLSigner", Boolean.TRUE.toString()}, {"OOXML", "es.gob.afirma.signers.ooxml.AOOOXMLSigner", Boolean.FALSE.toString()}};

    private AOSignerFactory() {
    }

    public static AOSigner getSigner(byte[] byArray) throws IOException {
        if (byArray == null) {
            throw new IllegalArgumentException("No se han indicado datos de firma");
        }
        for (String[] stringArray : SIGNERS_CLASSES) {
            AOSigner aOSigner;
            if (!Boolean.parseBoolean(stringArray[2])) continue;
            if (SIGNERS.get(stringArray[0]) == null) {
                try {
                    SIGNERS.put(stringArray[0], (AOSigner)Class.forName(stringArray[1]).newInstance());
                }
                catch (Exception exception) {
                    LOGGER.warning("No se ha podido instanciar un manejador para el formato de firma '" + stringArray[0] + "': " + exception);
                    continue;
                }
            }
            if ((aOSigner = SIGNERS.get(stringArray[0])) == null || !aOSigner.isSign(byArray)) continue;
            return aOSigner;
        }
        return null;
    }

    public static AOSigner getSigner(String string) {
        String string2 = null;
        for (String[] stringArray : SIGNERS_CLASSES) {
            if (!stringArray[0].equalsIgnoreCase(string)) continue;
            string2 = stringArray[1];
            break;
        }
        if (string2 == null) {
            LOGGER.warning("El formato de firma '" + string + "' no esta soportado, se devolvera null");
            return null;
        }
        if (SIGNERS.get(string) == null) {
            try {
                SIGNERS.put(string, (AOSigner)Class.forName(string2).newInstance());
            }
            catch (Exception exception) {
                LOGGER.severe("No se ha podido instanciar un manejador para el formato de firma '" + string + "', se devolvera null: " + exception);
            }
        }
        return SIGNERS.get(string);
    }

    public static String[] getSupportedFormats() {
        int n = 0;
        String[] stringArray = new String[SIGNERS_CLASSES.length];
        for (String[] stringArray2 : SIGNERS_CLASSES) {
            stringArray[n++] = stringArray2[0];
        }
        return stringArray;
    }
}

