/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.core.signers;

import es.gob.afirma.core.AOException;
import es.gob.afirma.core.signers.AOSimpleSigner;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.util.Properties;
import java.util.logging.Logger;

public final class AOPkcs1Signer
implements AOSimpleSigner {
    @Override
    public byte[] sign(byte[] byArray, String string, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) throws AOException {
        Signature signature;
        try {
            if ("com.aet.android.providerPKCS15.SEPrivateKey".equals(privateKey.getClass().getName())) {
                signature = Signature.getInstance(string, "AETProvider");
            } else if ("es.gob.jmulticard.jse.provider.DniePrivateKey".equals(privateKey.getClass().getName())) {
                Logger.getLogger("es.gob.afirma").info("Detectada clave privada DNIe 100% Java");
                signature = Signature.getInstance(string, "DNIeJCAProvider");
            } else {
                signature = Signature.getInstance(string);
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AOException("No se soporta el algoritmo de firma (" + string + "): " + noSuchAlgorithmException, noSuchAlgorithmException);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new AOException("No hay un proveedor para el algoritmo '" + string + "' con el tipo de clave '" + privateKey.getAlgorithm() + "': " + noSuchProviderException, noSuchProviderException);
        }
        try {
            signature.initSign(privateKey);
        }
        catch (Exception exception) {
            throw new AOException("Error al inicializar la firma con la clave privada: " + exception, exception);
        }
        try {
            signature.update(byArray);
        }
        catch (SignatureException signatureException) {
            throw new AOException("Error al configurar los datos a firmar: " + signatureException, signatureException);
        }
        try {
            return signature.sign();
        }
        catch (SignatureException signatureException) {
            throw new AOException("Error durante el proceso de firma: " + signatureException, signatureException);
        }
    }
}

