/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.core.misc.protocol;

import es.gob.afirma.core.misc.Base64;
import es.gob.afirma.core.misc.Platform;
import es.gob.afirma.core.misc.protocol.ParameterException;
import es.gob.afirma.core.misc.protocol.UrlParametersToSave;
import es.gob.afirma.core.misc.protocol.UrlParametersToSign;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class ProtocolInvocationUriParser {
    private static final Set<String> SUPPORTED_SIGNATURE_ALGORITHMS = new HashSet<String>();
    private static final Set<String> SUPPORTED_SIGNATURE_FORMATS;
    private static final String DEFAULT_URL_ENCODING = "UTF-8";
    private static final String SERVLET_NAME_STORAGE = "StorageService";
    private static final String SERVLET_NAME_RETRIEVE = "RetrieveService";
    private static final int MAX_ID_LENGTH = 20;
    private static final int CIPHER_KEY_LENGTH = 8;
    private static final String BROWSER_USER_AGENT = "agent";
    private static final String OPERATION_PARAM = "op";
    private static final String FORMAT_PARAM = "format";
    private static final String ALGORITHM_PARAM = "algorithm";
    private static final String DATA_PARAM = "dat";
    private static final String FILE_ID_PARAM = "fileid";
    private static final String STORAGE_SERVLET_PARAM = "stservlet";
    private static final String RETRIEVE_SERVLET_PARAM = "rtservlet";
    private static final String ID_PARAM = "id";
    private static final String KEY_PARAM = "key";
    private static final String PROPERTIES_PARAM = "properties";
    private static final String TITLE_PARAM = "title";
    private static final String FILETYPE_DESCRIPTION = "desc";
    private static final String FILENAME_EXTS = "exts";
    private static final String FILENAME_PARAM = "filename";
    private static final String OP_ID_SIGN = "sign";
    private static final String OP_ID_COSIGN = "cosign";
    private static final String OP_ID_COUNTERSIGN = "countersign";

    private ProtocolInvocationUriParser() {
    }

    private static Map<String, String> parserUri(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String[] stringArray = string.substring(string.indexOf(63) + 1).split("&");
        for (String string2 : stringArray) {
            if (string2.indexOf(61) <= 0) continue;
            hashMap.put(string2.substring(0, string2.indexOf(61)), string2.indexOf(61) == string2.length() - 1 ? "" : string2.substring(string2.indexOf(61) + 1));
        }
        Object object = string.substring(string.indexOf("://") + "://".length(), string.indexOf(63));
        if (((String)object).endsWith("/")) {
            object = ((String)object).substring(0, ((String)object).length() - 1);
        }
        hashMap.put(OPERATION_PARAM, ((String)object).substring(((String)object).lastIndexOf(47) + 1));
        return hashMap;
    }

    private static Map<String, String> parseXml(byte[] byArray) throws ParameterException {
        NodeList nodeList;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            Element element = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(byArray)).getDocumentElement();
            hashMap.put(OPERATION_PARAM, OPERATION_PARAM.equalsIgnoreCase(element.getNodeName()) ? OP_ID_SIGN : element.getNodeName());
            nodeList = element.getChildNodes();
        }
        catch (Exception exception) {
            throw new ParameterException("Ocurrio un error grave durante el analisis del XML", exception);
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!"e".equals(node.getNodeName())) {
                throw new ParameterException("El XML no tiene la forma esperada");
            }
            NamedNodeMap namedNodeMap = node.getAttributes();
            Node node2 = namedNodeMap.getNamedItem("k");
            Node node3 = namedNodeMap.getNamedItem("v");
            if (node2 == null || node3 == null) {
                throw new ParameterException("El XML no tiene la forma esperada");
            }
            hashMap.put(node2.getNodeValue(), node3.getNodeValue());
        }
        return hashMap;
    }

    public static UrlParametersToSign getParametersToSign(String string) throws ParameterException, UnsupportedEncodingException {
        return ProtocolInvocationUriParser.getParametersToSign(ProtocolInvocationUriParser.parserUri(string));
    }

    public static UrlParametersToSign getParametersToSign(byte[] byArray) throws ParameterException, UnsupportedEncodingException {
        return ProtocolInvocationUriParser.getParametersToSign(ProtocolInvocationUriParser.parseXml(byArray));
    }

    private static UrlParametersToSign getParametersToSign(Map<String, String> map) throws ParameterException, UnsupportedEncodingException {
        URL uRL;
        String string;
        UrlParametersToSign urlParametersToSign = new UrlParametersToSign();
        if (!map.containsKey(ID_PARAM) && !map.containsKey(FILE_ID_PARAM)) {
            throw new ParameterException("No se ha recibido el identificador del documento");
        }
        String string2 = string = map.containsKey(ID_PARAM) ? map.get(ID_PARAM) : map.get(FILE_ID_PARAM);
        if (string.length() > 20) {
            throw new ParameterException("La longitud del identificador para la firma es mayor de 20 caracteres.");
        }
        Object object = string.toLowerCase(Locale.ENGLISH).toCharArray();
        int n = ((char[])object).length;
        for (int i = 0; i < n; ++i) {
            char c = object[i];
            if (c >= 'a' && c <= 'z' || c >= '0' && c <= '9') continue;
            throw new ParameterException("El identificador de la firma debe ser alfanumerico.");
        }
        urlParametersToSign.setSessionId(string);
        urlParametersToSign.setDesKey(ProtocolInvocationUriParser.verifyCipherKey(map));
        if (!map.containsKey(DATA_PARAM)) {
            if (map.containsKey(FILE_ID_PARAM)) {
                urlParametersToSign.setFileId(map.get(FILE_ID_PARAM));
                if (!map.containsKey(RETRIEVE_SERVLET_PARAM)) {
                    throw new ParameterException("No se ha recibido la direccion del servlet para la recuperacion de los datos a firmar");
                }
                try {
                    object = ProtocolInvocationUriParser.validateURL(map.get(RETRIEVE_SERVLET_PARAM));
                }
                catch (ParameterException parameterException) {
                    throw new ParameterException("Error al validar la URL del servlet de recuperacion: " + parameterException, parameterException);
                }
                urlParametersToSign.setRetrieveServletUrl((URL)object);
            }
        } else {
            try {
                object = Base64.decode(URLDecoder.decode(map.get(DATA_PARAM), DEFAULT_URL_ENCODING).replace("_", "/").replace("-", "+"));
            }
            catch (Exception exception) {
                throw new ParameterException("Los datos introducidos no se pueden tratar como base 64: " + exception);
            }
            urlParametersToSign.setData((byte[])object);
        }
        if (!OP_ID_SIGN.equalsIgnoreCase((String)(object = (Object)map.get(OPERATION_PARAM))) && OP_ID_COSIGN.equalsIgnoreCase((String)object) && OP_ID_COUNTERSIGN.equalsIgnoreCase((String)object)) {
            throw new ParameterException("Se ha indicado un codigo de operacion incorrecto");
        }
        if (OP_ID_SIGN.equalsIgnoreCase((String)object)) {
            urlParametersToSign.setOperation(1);
        } else if (OP_ID_COSIGN.equalsIgnoreCase((String)object)) {
            urlParametersToSign.setOperation(2);
        } else {
            urlParametersToSign.setOperation(3);
        }
        if (urlParametersToSign.getFileId() != null) {
            return urlParametersToSign;
        }
        if (!map.containsKey(STORAGE_SERVLET_PARAM)) {
            throw new ParameterException("No se ha recibido la direccion del servlet para el envio de la firma");
        }
        try {
            uRL = ProtocolInvocationUriParser.validateURL(map.get(STORAGE_SERVLET_PARAM));
        }
        catch (ParameterException parameterException) {
            throw new ParameterException("Error al validar la URL del servlet de guardado: " + parameterException, parameterException);
        }
        urlParametersToSign.setStorageServletUrl(uRL);
        if (!map.containsKey(FORMAT_PARAM)) {
            throw new ParameterException("No se ha recibido el formato de firma");
        }
        String string3 = URLDecoder.decode(map.get(FORMAT_PARAM), DEFAULT_URL_ENCODING);
        if (!SUPPORTED_SIGNATURE_FORMATS.contains(string3.toLowerCase(Locale.ENGLISH))) {
            throw new ParameterException("Formato de firma no soportado: " + string3);
        }
        urlParametersToSign.setSignFormat(string3);
        if (!map.containsKey(ALGORITHM_PARAM)) {
            throw new ParameterException("No se ha recibido el algoritmo de firma");
        }
        String string4 = URLDecoder.decode(map.get(ALGORITHM_PARAM), DEFAULT_URL_ENCODING);
        if (!SUPPORTED_SIGNATURE_ALGORITHMS.contains(string4)) {
            throw new ParameterException("Algoritmo de firma no soportado: " + string4);
        }
        urlParametersToSign.setSignAlgorithm(string4);
        String string5 = null;
        if (map.containsKey(PROPERTIES_PARAM)) {
            string5 = URLDecoder.decode(map.get(PROPERTIES_PARAM), DEFAULT_URL_ENCODING);
        }
        try {
            urlParametersToSign.setExtraParams(ProtocolInvocationUriParser.parseB64Properties(string5));
        }
        catch (Exception exception) {
            urlParametersToSign.setExtraParams(new Properties());
        }
        urlParametersToSign.setDefaultKeyStore(ProtocolInvocationUriParser.verifyDefaultKeyStoreName(map));
        return urlParametersToSign;
    }

    private static String verifyDefaultKeyStoreName(Map<String, String> map) throws UnsupportedEncodingException {
        if (map.containsKey(BROWSER_USER_AGENT) && URLDecoder.decode(map.get(BROWSER_USER_AGENT), DEFAULT_URL_ENCODING).contains("Firefox")) {
            return "Mozilla / Firefox (unificado)";
        }
        if (Platform.OS.WINDOWS.equals((Object)Platform.getOS())) {
            return "Windows / Internet Explorer";
        }
        if (Platform.OS.MACOSX.equals((Object)Platform.getOS())) {
            return "Mac OS X / Safari";
        }
        if (Platform.OS.LINUX.equals((Object)Platform.getOS()) || Platform.OS.SOLARIS.equals((Object)Platform.getOS())) {
            return "Mozilla / Firefox (unificado)";
        }
        return null;
    }

    public static UrlParametersToSave getParametersToSave(byte[] byArray) throws ParameterException, UnsupportedEncodingException {
        return ProtocolInvocationUriParser.getParametersToSave(ProtocolInvocationUriParser.parseXml(byArray));
    }

    public static UrlParametersToSave getParametersToSave(String string) throws ParameterException, UnsupportedEncodingException {
        return ProtocolInvocationUriParser.getParametersToSave(ProtocolInvocationUriParser.parserUri(string));
    }

    private static UrlParametersToSave getParametersToSave(Map<String, String> map) throws ParameterException, UnsupportedEncodingException {
        if (!map.containsKey(FILE_ID_PARAM) && !map.containsKey(DATA_PARAM)) {
            throw new ParameterException("Error al validar la URL del servlet de recuperacion: La URI debe contener o un identificador de fichero o los datos a guardar");
        }
        UrlParametersToSave urlParametersToSave = new UrlParametersToSave();
        urlParametersToSave.setDesKey(ProtocolInvocationUriParser.verifyCipherKey(map));
        urlParametersToSave.setData(ProtocolInvocationUriParser.verifyData(map));
        urlParametersToSave.setFileId(ProtocolInvocationUriParser.verifyFileId(map));
        if (urlParametersToSave.getData() == null && urlParametersToSave.getFileId() != null) {
            urlParametersToSave.setRetrieveServletUrl(ProtocolInvocationUriParser.verifyRetrieveServletUrl(map));
        }
        urlParametersToSave.setTitle(ProtocolInvocationUriParser.verifyTitle(map));
        urlParametersToSave.setFilename(ProtocolInvocationUriParser.verifyFilename(map));
        urlParametersToSave.setExtensions(ProtocolInvocationUriParser.verifyExtensions(map));
        urlParametersToSave.setFileTypeDescription(ProtocolInvocationUriParser.verifyFileTypeDescription(map));
        return urlParametersToSave;
    }

    private static String verifyFileTypeDescription(Map<String, String> map) throws UnsupportedEncodingException {
        String string = null;
        if (map.containsKey(FILETYPE_DESCRIPTION)) {
            string = URLDecoder.decode(map.get(FILETYPE_DESCRIPTION), DEFAULT_URL_ENCODING);
            if (map.containsKey(FILENAME_EXTS) && !string.endsWith(")")) {
                StringBuilder stringBuilder = new StringBuilder(string).append(" (");
                for (String string2 : URLDecoder.decode(map.get(FILENAME_EXTS), DEFAULT_URL_ENCODING).split(",")) {
                    stringBuilder.append("*.");
                    stringBuilder.append(string2);
                }
                stringBuilder.append(")");
                string = stringBuilder.toString();
            }
        }
        return string;
    }

    private static String verifyFilename(Map<String, String> map) throws UnsupportedEncodingException, ParameterException {
        String string = null;
        if (map.containsKey(FILENAME_PARAM)) {
            string = URLDecoder.decode(map.get(FILENAME_PARAM), DEFAULT_URL_ENCODING);
            for (char c : "\\/:*?\"<>|".toCharArray()) {
                if (string.indexOf(c) == -1) continue;
                throw new ParameterException("Se ha indicado un nombre de fichero con el caracter invalido: " + c);
            }
        }
        return string;
    }

    private static String verifyExtensions(Map<String, String> map) throws UnsupportedEncodingException, ParameterException {
        String string = null;
        if (map.containsKey(FILENAME_EXTS)) {
            string = URLDecoder.decode(map.get(FILENAME_EXTS), DEFAULT_URL_ENCODING);
            for (char c : "\\/:*?\"<>|; ".toCharArray()) {
                if (string.indexOf(c) == -1) continue;
                throw new ParameterException("Se ha indicado una lista de extensiones de nombre de fichero con caracteres invalidos: " + c);
            }
        }
        return string;
    }

    private static String verifyTitle(Map<String, String> map) throws UnsupportedEncodingException {
        if (map.containsKey(TITLE_PARAM)) {
            return URLDecoder.decode(map.get(TITLE_PARAM), DEFAULT_URL_ENCODING);
        }
        return null;
    }

    private static URL verifyRetrieveServletUrl(Map<String, String> map) throws ParameterException {
        if (!map.containsKey(RETRIEVE_SERVLET_PARAM)) {
            return null;
        }
        return ProtocolInvocationUriParser.validateURL(map.get(RETRIEVE_SERVLET_PARAM));
    }

    private static String verifyFileId(Map<String, String> map) throws ParameterException {
        String string = map.get(FILE_ID_PARAM);
        if (string != null) {
            if (!map.containsKey(RETRIEVE_SERVLET_PARAM)) {
                throw new ParameterException("No se ha recibido la direccion del servlet para la recuperacion de los datos a firmar");
            }
            if (!map.containsKey(KEY_PARAM)) {
                throw new ParameterException("No se ha recibido la clave para el descifrado de los datos remotos");
            }
        }
        return string;
    }

    private static byte[] verifyData(Map<String, String> map) throws ParameterException {
        byte[] byArray = null;
        if (map.containsKey(DATA_PARAM)) {
            try {
                byArray = Base64.decode(URLDecoder.decode(map.get(DATA_PARAM), DEFAULT_URL_ENCODING).replace("_", "/").replace("-", "+"));
            }
            catch (Exception exception) {
                throw new ParameterException("Los datos introducidos no se pueden tratar como base 64: " + exception);
            }
        }
        return byArray;
    }

    private static byte[] verifyCipherKey(Map<String, String> map) throws ParameterException {
        if (!map.containsKey(KEY_PARAM)) {
            return null;
        }
        String string = map.get(KEY_PARAM);
        if (string == null || string.length() != 8) {
            throw new ParameterException("La longitud de la clave de cifrado no es correcta");
        }
        return string.getBytes();
    }

    private static URL validateURL(String string) throws ParameterException {
        URL uRL;
        try {
            uRL = new URL(string);
        }
        catch (Exception exception) {
            throw new ParameterException("La URL proporcionada para el servlet no es valida (" + string + "): " + exception);
        }
        if (!"http".equals(uRL.getProtocol()) && !"https".equals(uRL.getProtocol())) {
            throw new ParameterException("El protocolo de la URL proporcionada para el servlet no esta soportado: " + uRL.getProtocol());
        }
        if ("localhost".equals(uRL.getHost()) || "127.0.0.1".equals(uRL.getHost())) {
            throw new ParameterException("El host de la URL proporcionada para el Servlet es local");
        }
        if (!uRL.toString().endsWith(SERVLET_NAME_STORAGE) && !uRL.toString().endsWith(SERVLET_NAME_RETRIEVE)) {
            throw new ParameterException("El protocolo de la URL proporcionada para el servlet no apunta a un servlet declarado");
        }
        if (uRL.toString().indexOf(63) != -1 || uRL.toString().indexOf(61) != -1) {
            throw new ParameterException("Se han encontrado parametros en la URL del servlet");
        }
        return uRL;
    }

    private static Properties parseB64Properties(String string) throws IOException {
        Properties properties = new Properties();
        if (string != null) {
            properties.load(new ByteArrayInputStream(Base64.decode(string)));
        }
        return properties;
    }

    static {
        SUPPORTED_SIGNATURE_ALGORITHMS.add("SHA1withRSA");
        SUPPORTED_SIGNATURE_ALGORITHMS.add("SHA256withRSA");
        SUPPORTED_SIGNATURE_ALGORITHMS.add("SHA384withRSA");
        SUPPORTED_SIGNATURE_ALGORITHMS.add("SHA512withRSA");
        SUPPORTED_SIGNATURE_FORMATS = new HashSet<String>();
        SUPPORTED_SIGNATURE_FORMATS.add("cades");
        SUPPORTED_SIGNATURE_FORMATS.add("pades");
        SUPPORTED_SIGNATURE_FORMATS.add("cadestri");
        SUPPORTED_SIGNATURE_FORMATS.add("xadestri");
        SUPPORTED_SIGNATURE_FORMATS.add("padestri");
    }
}

