/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.core.misc;

import es.gob.afirma.core.misc.AOUtil;
import es.gob.afirma.core.misc.UrlHttpManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public final class UrlHttpManagerImpl
implements UrlHttpManager {
    private static final int DEFAULT_TIMEOUT = -1;
    private static final String HTTPS = "https";
    private static final HostnameVerifier DEFAULT_HOSTNAME_VERIFIER = HttpsURLConnection.getDefaultHostnameVerifier();
    private static final SSLSocketFactory DEFAULT_SSL_SOCKET_FACTORY = HttpsURLConnection.getDefaultSSLSocketFactory();
    private static final TrustManager[] DUMMY_TRUST_MANAGER = new TrustManager[]{new X509TrustManager(){

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) {
        }
    }};

    UrlHttpManagerImpl() {
    }

    @Override
    public byte[] readUrlByPost(String string) throws IOException {
        return this.readUrlByPost(string, -1);
    }

    @Override
    public byte[] readUrlByPost(String string, int n) throws IOException {
        if (string == null) {
            throw new IllegalArgumentException("La URL a leer no puede ser nula");
        }
        if (!string.contains("?")) {
            return this.readUrlByGet(string);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "?");
        String string2 = stringTokenizer.nextToken();
        String string3 = stringTokenizer.nextToken();
        URL uRL = new URL(string2);
        if (uRL.getProtocol().equals(HTTPS)) {
            try {
                UrlHttpManagerImpl.disableSslChecks();
            }
            catch (Exception exception) {
                Logger.getLogger("es.gob.afirma").warning("No se ha podido ajustar la confianza SSL, es posible que no se pueda completar la conexion: " + exception);
            }
        }
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection(Proxy.NO_PROXY);
        httpURLConnection.setRequestMethod("POST");
        httpURLConnection.addRequestProperty("Accept", "*/*");
        httpURLConnection.addRequestProperty("Connection", "keep-alive");
        httpURLConnection.addRequestProperty("Content-type", "application/x-www-form-urlencoded");
        httpURLConnection.addRequestProperty("Host", uRL.getHost());
        httpURLConnection.addRequestProperty("Origin", uRL.getProtocol() + "://" + uRL.getHost());
        if (n != -1) {
            httpURLConnection.setConnectTimeout(n);
            httpURLConnection.setReadTimeout(n);
        }
        httpURLConnection.setDoOutput(true);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(httpURLConnection.getOutputStream());
        outputStreamWriter.write(string3);
        outputStreamWriter.flush();
        outputStreamWriter.close();
        InputStream inputStream = httpURLConnection.getInputStream();
        byte[] byArray = AOUtil.getDataFromInputStream(inputStream);
        inputStream.close();
        if (uRL.getProtocol().equals(HTTPS)) {
            UrlHttpManagerImpl.enableSslChecks();
        }
        return byArray;
    }

    @Override
    public byte[] readUrlByGet(String string) throws IOException {
        URL uRL = new URL(string);
        if (uRL.getProtocol().equals(HTTPS)) {
            try {
                UrlHttpManagerImpl.disableSslChecks();
            }
            catch (Exception exception) {
                Logger.getLogger("es.gob.afirma").warning("No se ha podido ajustar la confianza SSL, es posible que no se pueda completar la conexion: " + exception);
            }
        }
        InputStream inputStream = uRL.openStream();
        byte[] byArray = AOUtil.getDataFromInputStream(inputStream);
        inputStream.close();
        if (uRL.getProtocol().equals(HTTPS)) {
            UrlHttpManagerImpl.enableSslChecks();
        }
        return byArray;
    }

    private static void enableSslChecks() {
        HttpsURLConnection.setDefaultSSLSocketFactory(DEFAULT_SSL_SOCKET_FACTORY);
        HttpsURLConnection.setDefaultHostnameVerifier(DEFAULT_HOSTNAME_VERIFIER);
    }

    private static void disableSslChecks() throws KeyManagementException, NoSuchAlgorithmException {
        SSLContext sSLContext = SSLContext.getInstance("SSL");
        sSLContext.init(null, DUMMY_TRUST_MANAGER, new SecureRandom());
        HttpsURLConnection.setDefaultSSLSocketFactory(sSLContext.getSocketFactory());
        HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String string, SSLSession sSLSession) {
                return true;
            }
        });
    }
}

