/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.core.misc;

import java.io.File;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.logging.Logger;

public final class Platform {
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");
    private static OS os = null;
    private static String javaArch = null;
    private static String javaHome = null;
    private static String javaLibraryPath = null;
    private static String userHome = null;

    private Platform() {
    }

    private static OS recoverOsName() {
        String string = System.getProperty("os.name");
        if (string.contains("indows")) {
            return OS.WINDOWS;
        }
        if (string.contains("inux")) {
            if ("Dalvik".equals(System.getProperty("java.vm.name"))) {
                return OS.ANDROID;
            }
            return OS.LINUX;
        }
        if (string.contains("SunOS") || string.contains("olaris")) {
            return OS.SOLARIS;
        }
        if (string.startsWith("Mac OS X")) {
            return OS.MACOSX;
        }
        LOGGER.warning("No se ha podido determinar el sistema operativo");
        return OS.OTHER;
    }

    public static BROWSER getBrowser(String string) {
        if (string == null) {
            return BROWSER.OTHER;
        }
        if (string.toLowerCase(Locale.US).contains("msie")) {
            return BROWSER.INTERNET_EXPLORER;
        }
        if (string.toLowerCase(Locale.US).contains("firefox")) {
            return BROWSER.FIREFOX;
        }
        if (string.toLowerCase(Locale.US).contains("chrome")) {
            return BROWSER.CHROME;
        }
        if (string.toLowerCase(Locale.US).contains("safari")) {
            return BROWSER.SAFARI;
        }
        if (string.toLowerCase(Locale.US).contains("opera")) {
            return BROWSER.OPERA;
        }
        return BROWSER.OTHER;
    }

    public static OS getOS() {
        if (os == null) {
            os = Platform.recoverOsName();
        }
        return os;
    }

    public static String getJavaArch() {
        if (javaArch == null && (javaArch = System.getProperty("sun.arch.data.model")) == null) {
            javaArch = System.getProperty("com.ibm.vm.bitmode");
        }
        return javaArch;
    }

    public static String getJavaHome() {
        if (javaHome == null) {
            javaHome = Platform.recoverJavaHome();
        }
        return javaHome;
    }

    public static String getJavaLibraryPath() {
        if (javaLibraryPath == null) {
            javaLibraryPath = System.getProperty("java.library.path");
        }
        return javaLibraryPath;
    }

    public static String getUserHome() {
        if (userHome == null) {
            userHome = System.getProperty("user.home");
        }
        return userHome;
    }

    private static String recoverJavaHome() {
        String string = null;
        try {
            string = System.getProperty("jnlpx.home");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string != null) {
            return string.substring(0, string.lastIndexOf(File.separator));
        }
        try {
            return System.getProperty("java.home");
        }
        catch (Exception exception) {
            LOGGER.warning("No se ha podido identificar el directorio de java");
            return null;
        }
    }

    public static String getITextVersion() {
        try {
            Class<?> clazz = Class.forName("com.lowagie.text.Document");
            Method method = clazz.getDeclaredMethod("getRelease", new Class[0]);
            return (String)method.invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String getSystemRoot() {
        File file;
        if (!Platform.getOS().equals((Object)OS.WINDOWS)) {
            return File.separator;
        }
        String string = System.getProperty("SystemRoot");
        if (string == null && (file = new File("C:\\WINDOWS\\SYSTEM32")).exists() && file.isDirectory()) {
            return "C:\\WINDOWS";
        }
        if (string == null) {
            LOGGER.warning("No se ha encontrado el directorio ra&iacute;z del sistema, se devolver&aacute;: " + File.separator);
            string = File.separator;
        }
        return string;
    }

    public static String getSystemLibDir() {
        if (Platform.getOS().equals((Object)OS.WINDOWS)) {
            String string = Platform.getSystemRoot();
            if (string == null) {
                LOGGER.warning("No se ha podido determinar el directorio de Windows accediendo al registro, se usara 'C:\\WINDOWS\\'");
                string = "c:\\windows\\";
            }
            if (!string.endsWith("\\")) {
                string = string + "\\";
            }
            return string + "System32";
        }
        return "/usr/lib";
    }

    public static enum JREVER {
        J4,
        J5,
        J6,
        J7;

    }

    public static enum BROWSER {
        INTERNET_EXPLORER,
        FIREFOX,
        CHROME,
        SAFARI,
        OPERA,
        OTHER;

    }

    public static enum OS {
        WINDOWS,
        LINUX,
        SOLARIS,
        MACOSX,
        ANDROID,
        OTHER;

    }
}

