/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.core.misc;

import es.gob.afirma.core.misc.AOFileUtils;
import es.gob.afirma.core.misc.AOUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class OfficeAnalizer {
    private static final String ZIP_MIMETYPE = "application/zip";
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");
    private static final Set<String> OOXML_MIMETYPES = new HashSet<String>(17);
    private static final Set<String> ODF_MIMETYPES = new HashSet<String>(15);
    private static final Map<String, String> FILE_EXTENSIONS = new HashMap<String, String>();

    private OfficeAnalizer() {
    }

    static String getMimeType(byte[] byArray) throws IOException {
        ZipFile zipFile;
        String string = new String(byArray);
        if (string.contains("Microsoft Excel")) {
            return "application/vnd.ms-excel";
        }
        if (string.contains("Microsoft Office Word")) {
            return "application/msword";
        }
        if (string.contains("Microsoft Office PowerPoint")) {
            return "application/vnd.ms-powerpoint";
        }
        if (string.contains("Microsoft Project")) {
            return "application/vnd.ms-project";
        }
        if (string.contains("Microsoft Visio")) {
            return "application/vnd.visio";
        }
        try {
            zipFile = AOFileUtils.createTempZipFile(byArray);
        }
        catch (ZipException zipException) {
            LOGGER.warning("El fichero indicado no es un ZIP");
            return null;
        }
        String string2 = ZIP_MIMETYPE;
        String string3 = null;
        if (OfficeAnalizer.isODFFile(zipFile)) {
            string3 = OfficeAnalizer.getODFMimeType(zipFile.getInputStream(zipFile.getEntry("mimetype")));
        } else if (OfficeAnalizer.isOOXMLFile(zipFile)) {
            string3 = OfficeAnalizer.getOOXMLMimeType(zipFile.getInputStream(zipFile.getEntry("[Content_Types].xml")));
        }
        if (string3 != null) {
            string2 = string3;
        }
        zipFile.close();
        return string2;
    }

    static String getExtension(byte[] byArray) throws IOException {
        String string = OfficeAnalizer.getMimeType(byArray);
        if (string == null) {
            return null;
        }
        return FILE_EXTENSIONS.get(string);
    }

    public static boolean isOOXMLDocument(byte[] byArray) throws IOException {
        ZipFile zipFile = AOFileUtils.createTempZipFile(byArray);
        boolean bl = OfficeAnalizer.isOOXMLFile(zipFile);
        zipFile.close();
        return bl;
    }

    private static boolean isOOXMLFile(ZipFile zipFile) {
        return zipFile.getEntry("[Content_Types].xml") != null && zipFile.getEntry("_rels/.rels") != null && zipFile.getEntry("docProps/app.xml") != null && zipFile.getEntry("docProps/core.xml") != null;
    }

    public static String getOOXMLMimeType(InputStream inputStream) {
        Document document;
        try {
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(inputStream);
        }
        catch (Exception exception) {
            return null;
        }
        Element element = document.getDocumentElement();
        if (!element.getNodeName().equalsIgnoreCase("Types")) {
            return null;
        }
        Node node = null;
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            node = nodeList.item(i);
            if (!node.getNodeName().equalsIgnoreCase("Override")) continue;
            NamedNodeMap namedNodeMap = node.getAttributes();
            Node node2 = null;
            for (int j = 0; j < namedNodeMap.getLength(); ++j) {
                if (!namedNodeMap.item(j).getNodeName().equalsIgnoreCase("ContentType")) continue;
                node2 = namedNodeMap.item(j);
                break;
            }
            if (node2 == null) continue;
            String string = node2.getNodeValue();
            if (string.indexOf(46) != -1) {
                string = string.substring(0, string.lastIndexOf(46));
            }
            if (!OOXML_MIMETYPES.contains(string)) continue;
            return string;
        }
        return null;
    }

    public static boolean isODFDocument(byte[] byArray) throws IOException {
        ZipFile zipFile = AOFileUtils.createTempZipFile(byArray);
        boolean bl = OfficeAnalizer.isODFFile(zipFile);
        zipFile.close();
        return bl;
    }

    private static boolean isODFFile(ZipFile zipFile) {
        return zipFile.getEntry("mimetype") != null && zipFile.getEntry("content.xml") != null && zipFile.getEntry("meta.xml") != null && zipFile.getEntry("settings.xml") != null && zipFile.getEntry("styles.xml") != null && zipFile.getEntry("META-INF/manifest.xml") != null;
    }

    private static String getODFMimeType(InputStream inputStream) {
        String string;
        try {
            string = new String(AOUtil.getDataFromInputStream(inputStream));
        }
        catch (Exception exception) {
            return null;
        }
        if (ODF_MIMETYPES.contains(string)) {
            return string;
        }
        return null;
    }

    static {
        OOXML_MIMETYPES.add("application/vnd.ms-word.document.macroEnabled.12");
        OOXML_MIMETYPES.add("application/vnd.openxmlformats-officedocument.wordprocessingml.document");
        OOXML_MIMETYPES.add("application/vnd.ms-word.template.macroEnabled.12");
        OOXML_MIMETYPES.add("application/vnd.openxmlformats-officedocument.wordprocessingml.template");
        OOXML_MIMETYPES.add("application/vnd.ms-powerpoint.template.macroEnabled.12");
        OOXML_MIMETYPES.add("application/vnd.openxmlformats-officedocument.presentationml.template");
        OOXML_MIMETYPES.add("application/vnd.ms-powerpoint.addin.macroEnabled.12");
        OOXML_MIMETYPES.add("application/vnd.ms-powerpoint.slideshow.macroEnabled.12");
        OOXML_MIMETYPES.add("application/vnd.openxmlformats-officedocument.presentationml.slideshow");
        OOXML_MIMETYPES.add("application/vnd.ms-powerpoint.presentation.macroEnabled.12");
        OOXML_MIMETYPES.add("application/vnd.openxmlformats-officedocument.presentationml.presentation");
        OOXML_MIMETYPES.add("application/vnd.ms-excel.addin.macroEnabled.12");
        OOXML_MIMETYPES.add("application/vnd.ms-excel.sheet.binary.macroEnabled.12");
        OOXML_MIMETYPES.add("application/vnd.ms-excel.sheet.macroEnabled.12");
        OOXML_MIMETYPES.add("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        OOXML_MIMETYPES.add("application/vnd.ms-excel.template.macroEnabled.12");
        OOXML_MIMETYPES.add("application/vnd.openxmlformats-officedocument.spreadsheetml.template");
        ODF_MIMETYPES.add("application/vnd.oasis.opendocument.text");
        ODF_MIMETYPES.add("application/vnd.oasis.opendocument.text-template");
        ODF_MIMETYPES.add("application/vnd.oasis.opendocument.text-web");
        ODF_MIMETYPES.add("application/vnd.oasis.opendocument.text-master");
        ODF_MIMETYPES.add("application/vnd.oasis.opendocument.graphics");
        ODF_MIMETYPES.add("application/vnd.oasis.opendocument.graphics-template");
        ODF_MIMETYPES.add("application/vnd.oasis.opendocument.presentation");
        ODF_MIMETYPES.add("application/vnd.oasis.opendocument.presentation-template");
        ODF_MIMETYPES.add("application/vnd.oasis.opendocument.spreadsheet");
        ODF_MIMETYPES.add("application/vnd.oasis.opendocument.spreadsheet-template");
        ODF_MIMETYPES.add("application/vnd.oasis.opendocument.chart");
        ODF_MIMETYPES.add("application/vnd.oasis.opendocument.formula");
        ODF_MIMETYPES.add("application/vnd.oasis.opendocument.database");
        ODF_MIMETYPES.add("application/vnd.oasis.opendocument.image");
        ODF_MIMETYPES.add("application/vnd.openofficeorg.extension");
        FILE_EXTENSIONS.put(ZIP_MIMETYPE, "zip");
        FILE_EXTENSIONS.put("application/vnd.openxmlformats-officedocument.wordprocessingml.document", "docx");
        FILE_EXTENSIONS.put("application/vnd.openxmlformats-officedocument.presentationml.presentation", "pptx");
        FILE_EXTENSIONS.put("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "xlsx");
        FILE_EXTENSIONS.put("application/vnd.oasis.opendocument.text", "odt");
        FILE_EXTENSIONS.put("application/vnd.oasis.opendocument.presentation", "odp");
        FILE_EXTENSIONS.put("application/vnd.oasis.opendocument.spreadsheet", "ods");
        FILE_EXTENSIONS.put("application/vnd.oasis.opendocument.graphics", "odg");
        FILE_EXTENSIONS.put("application/vnd.oasis.opendocument.chart", "odc");
        FILE_EXTENSIONS.put("application/vnd.oasis.opendocument.formula", "odf");
        FILE_EXTENSIONS.put("application/vnd.oasis.opendocument.database", "odb");
        FILE_EXTENSIONS.put("application/vnd.oasis.opendocument.image", "odi");
        FILE_EXTENSIONS.put("application/vnd.oasis.opendocument.text-master", "odm");
    }
}

