/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.core.misc;

import es.gob.afirma.core.misc.OfficeAnalizer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Properties;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public final class MimeHelper {
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");
    public static final String DEFAULT_MIMETYPE = "application/octet-stream";
    public static final String DEFAULT_CONTENT_DESCRIPTION = "binary";
    public static final String DEFAULT_CONTENT_OID_DATA = "1.2.840.113549.1.7.1";
    private static Properties oidMimetypeProp = null;
    private static Properties mimetypeOidProp = null;
    private MimeInfo mimeInfo = null;
    private final byte[] data;
    private String mimeType = null;

    public MimeHelper(byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("No se han indicado los datos que se desean analizar");
        }
        this.data = (byte[])byArray.clone();
        this.mimeInfo = new MimeInfo();
        try {
            Method method = Class.forName("net.sf.jmimemagic.Magic").getMethod("getMagicMatch", byte[].class);
            Object object = method.invoke(null, new Object[]{this.data});
            Class<?> clazz = Class.forName("net.sf.jmimemagic.MagicMatch");
            this.mimeInfo.setMimeType((String)clazz.getMethod("getMimeType", null).invoke(object, (Object[])null));
            this.mimeInfo.setExtension((String)clazz.getMethod("getExtension", null).invoke(object, (Object[])null));
            this.mimeInfo.setDescription((String)clazz.getMethod("getDescription", null).invoke(object, (Object[])null));
        }
        catch (ClassNotFoundException classNotFoundException) {
            LOGGER.warning("No se encontro la biblioteca JMimeMagic para la deteccion del tipo de dato");
        }
        catch (Exception exception) {
            try {
                Class<?> clazz = Class.forName("net.sf.jmimemagic.MagicMatchNotFoundException");
                if (exception.getCause() != null && clazz.isInstance(exception.getCause())) {
                    LOGGER.warning("No se pudo detectar el formato de los datos");
                } else {
                    LOGGER.warning("Error durante el analisis de la cabecera de los datos: " + exception);
                }
            }
            catch (Exception exception2) {
                LOGGER.warning("Error al cargar las bibliotecas de deteccion del tipo de dato: " + exception2);
            }
        }
    }

    public static String transformMimeTypeToOid(String string) throws IOException {
        if (mimetypeOidProp == null) {
            MimeHelper.loadMimetypeOidProperties();
        }
        return string == null ? DEFAULT_CONTENT_OID_DATA : mimetypeOidProp.getProperty(string, DEFAULT_CONTENT_OID_DATA);
    }

    public static String transformOidToMimeType(String string) throws IOException {
        if (oidMimetypeProp == null) {
            MimeHelper.loadOidMimetypeProperties();
        }
        return string == null ? DEFAULT_MIMETYPE : oidMimetypeProp.getProperty(string, DEFAULT_MIMETYPE);
    }

    private static void loadOidMimetypeProperties() throws IOException {
        oidMimetypeProp = new Properties();
        InputStream inputStream = MimeHelper.class.getClassLoader().getResourceAsStream("resources/mimetypes_oids.properties");
        if (inputStream == null) {
            throw new IOException("No se ha encontrado el fichero de recursos para la relacion entre OIDs y MimeTypes");
        }
        oidMimetypeProp.load(inputStream);
        inputStream.close();
    }

    private static void loadMimetypeOidProperties() throws IOException {
        if (oidMimetypeProp == null) {
            MimeHelper.loadOidMimetypeProperties();
        }
        mimetypeOidProp = new Properties();
        for (String string : oidMimetypeProp.keySet().toArray(new String[0])) {
            mimetypeOidProp.put(oidMimetypeProp.get(string), string);
        }
    }

    public String getMimeType() throws IOException {
        if (this.mimeType == null) {
            if (this.mimeInfo != null) {
                this.mimeType = this.mimeInfo.getMimeType();
            }
            if (this.mimeInfo == null || "text/xml".equals(this.mimeType)) {
                try {
                    DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(this.data));
                    this.mimeType = "text/xml";
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    LOGGER.severe("No se ha podido crear un DocumentBuilder XML, no se comprobara si es XML: " + parserConfigurationException);
                }
                catch (SAXException sAXException) {
                    // empty catch block
                }
            }
            if ("application/zip".equals(this.mimeType) || "application/msword".equals(this.mimeType)) {
                this.mimeType = OfficeAnalizer.getMimeType(this.data);
            }
            if (this.mimeType == null) {
                this.mimeType = DEFAULT_MIMETYPE;
            }
        }
        return this.mimeType;
    }

    public String getExtension() {
        String string = null;
        try {
            DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(this.data));
            string = "xml";
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string == null && this.mimeInfo != null) {
            string = this.mimeInfo.getExtension();
        }
        if (string != null && string.equals("zip")) {
            try {
                string = OfficeAnalizer.getExtension(this.data);
            }
            catch (IOException iOException) {
                LOGGER.severe("No se ha podido comprobar si el ZIP corresponde a un ODF o a un OOXML, se tomara como ZIP: " + iOException);
            }
        }
        return string;
    }

    public String getDescription() {
        String string = null;
        if (this.mimeInfo != null) {
            string = this.mimeInfo.getDescription();
        }
        return string == null || string.length() == 0 ? DEFAULT_CONTENT_DESCRIPTION : string;
    }

    static class MimeInfo {
        private String mType = null;
        private String extension = null;
        private String description = null;

        MimeInfo() {
        }

        void setMimeType(String string) {
            this.mType = string;
        }

        String getMimeType() {
            return this.mType;
        }

        String getExtension() {
            return this.extension;
        }

        void setExtension(String string) {
            this.extension = string;
        }

        String getDescription() {
            return this.description;
        }

        void setDescription(String string) {
            this.description = string;
        }
    }
}

