/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.core.ciphers;

import es.gob.afirma.core.ciphers.CipherConstants;
import java.security.NoSuchAlgorithmException;

public final class AOCipherConfig {
    private CipherConstants.AOCipherAlgorithm algo;
    private CipherConstants.AOCipherBlockMode mode;
    private CipherConstants.AOCipherPadding padding;

    public AOCipherConfig(CipherConstants.AOCipherAlgorithm aOCipherAlgorithm, CipherConstants.AOCipherBlockMode aOCipherBlockMode, CipherConstants.AOCipherPadding aOCipherPadding) {
        CipherConstants.AOCipherPadding aOCipherPadding2;
        CipherConstants.AOCipherAlgorithm aOCipherAlgorithm2 = aOCipherAlgorithm != null ? aOCipherAlgorithm : CipherConstants.AOCipherAlgorithm.getDefault();
        CipherConstants.AOCipherBlockMode aOCipherBlockMode2 = aOCipherBlockMode;
        if (aOCipherBlockMode2 == null) {
            aOCipherBlockMode2 = aOCipherAlgorithm2.equals((Object)CipherConstants.AOCipherAlgorithm.PBEWITHMD5ANDDES) || aOCipherAlgorithm2.equals((Object)CipherConstants.AOCipherAlgorithm.PBEWITHSHA1ANDDESEDE) || aOCipherAlgorithm2.equals((Object)CipherConstants.AOCipherAlgorithm.PBEWITHSHA1ANDRC2_40) ? CipherConstants.AOCipherBlockMode.CBC : CipherConstants.AOCipherBlockMode.ECB;
        }
        if ((aOCipherPadding2 = aOCipherPadding) == null) {
            aOCipherPadding2 = aOCipherAlgorithm2.equals((Object)CipherConstants.AOCipherAlgorithm.ARCFOUR) ? CipherConstants.AOCipherPadding.NOPADDING : CipherConstants.AOCipherPadding.PKCS5PADDING;
        }
        this.algo = aOCipherAlgorithm2;
        this.mode = aOCipherBlockMode2;
        this.padding = aOCipherPadding2;
    }

    public static AOCipherConfig parse(String string) throws NoSuchAlgorithmException {
        CipherConstants.AOCipherAlgorithm aOCipherAlgorithm = null;
        CipherConstants.AOCipherBlockMode aOCipherBlockMode = null;
        CipherConstants.AOCipherPadding aOCipherPadding = null;
        String[] stringArray = string.split("/");
        aOCipherAlgorithm = CipherConstants.AOCipherAlgorithm.getValueOf(stringArray[0]);
        if (aOCipherAlgorithm == null) {
            throw new NoSuchAlgorithmException();
        }
        if (stringArray.length == 3) {
            aOCipherBlockMode = CipherConstants.AOCipherBlockMode.getValueOf(stringArray[1]);
            aOCipherPadding = CipherConstants.AOCipherPadding.getValueOf(stringArray[2]);
        }
        return new AOCipherConfig(aOCipherAlgorithm, aOCipherBlockMode, aOCipherPadding);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.algo.getName());
        if (this.mode != null && this.padding != null) {
            stringBuilder.append("/").append(this.mode.getName()).append("/").append(this.padding.getName());
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof AOCipherConfig)) {
            return false;
        }
        return ((AOCipherConfig)object).algo.equals((Object)this.algo) && ((AOCipherConfig)object).mode.equals((Object)this.mode) && ((AOCipherConfig)object).padding.equals((Object)this.padding);
    }

    public int hashCode() {
        return this.algo.hashCode() + this.mode.hashCode() + this.padding.hashCode();
    }

    public CipherConstants.AOCipherAlgorithm getAlgorithm() {
        return this.algo;
    }

    public CipherConstants.AOCipherBlockMode getBlockMode() {
        return this.mode;
    }

    public CipherConstants.AOCipherPadding getPadding() {
        return this.padding;
    }

    public void setAlgorithm(CipherConstants.AOCipherAlgorithm aOCipherAlgorithm) {
        this.algo = aOCipherAlgorithm;
    }

    public void setBlockMode(CipherConstants.AOCipherBlockMode aOCipherBlockMode) {
        this.mode = aOCipherBlockMode;
    }

    public void setPadding(CipherConstants.AOCipherPadding aOCipherPadding) {
        this.padding = aOCipherPadding;
    }
}

