/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.bdb;

import com.mindbright.util.HexDump;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class DBHash {
    public static final int HASHMAGIC = 398689;
    public static final int HASHVERSION = 2;
    public static final String CHARKEY = "%$sniglet^&";
    public static final int OVFLPAGE = 0;
    public static final int PARTIAL_KEY = 1;
    public static final int FULL_KEY = 2;
    public static final int FULL_KEY_DATA = 3;
    public static final int REAL_KEY = 4;
    private int magic;
    private int version;
    private int lorder;
    private int bsize = 1024;
    private int bshift;
    private int dsize;
    private int ssize;
    private int sshift;
    private int ovfl_point;
    private int last_freed;
    private int max_bucket;
    private int high_mask;
    private int low_mask;
    private int ffactor;
    private int nkeys;
    private int hdrpages;
    private int h_charkey;
    private int[] spares = new int[32];
    private int[] bitmaps = new int[32];
    private Hashtable hashtable = new Hashtable();
    private static final int NCACHED = 32;
    private RandomAccessFile file;

    public void load(String string) throws IOException {
        this.file = new RandomAccessFile(string, "r");
        this.loadHeader();
    }

    public void loadAll(String string) throws IOException {
        this.load(string);
        for (int i = 0; i <= this.max_bucket; ++i) {
            Bucket bucket = this.getBucket(i);
            for (int j = 0; j < bucket.numberOfKeys(); ++j) {
                DBT dBT = bucket.getDBT(j);
                this.hashtable.put(dBT, dBT);
            }
        }
    }

    public long length() throws IOException {
        return this.file.length();
    }

    private void loadHeader() throws IOException {
        int n;
        byte[] byArray = new byte[1024];
        this.file.readFully(byArray);
        Page page = new Page(byArray);
        this.magic = page.readInt();
        this.version = page.readInt();
        if (this.magic != 398689 || this.version != 2) {
            throw new IOException("Type/version not supported: " + this.magic + "/" + this.version);
        }
        this.lorder = page.readInt();
        this.bsize = page.readInt();
        this.bshift = page.readInt();
        this.dsize = page.readInt();
        this.ssize = page.readInt();
        this.sshift = page.readInt();
        this.ovfl_point = page.readInt();
        this.last_freed = page.readInt();
        this.max_bucket = page.readInt();
        this.high_mask = page.readInt();
        this.low_mask = page.readInt();
        this.ffactor = page.readInt();
        this.nkeys = page.readInt();
        this.hdrpages = page.readInt();
        this.h_charkey = page.readInt();
        for (n = 0; n < 32; ++n) {
            this.spares[n] = page.readInt();
        }
        for (n = 0; n < 32; ++n) {
            this.bitmaps[n] = page.readShort();
        }
        if (this.h_charkey != this.hashFunc(CHARKEY)) {
            throw new IOException("Incompatible hash-function used");
        }
    }

    public Page getPage(int n) throws IOException {
        long l = n * this.bsize;
        this.file.seek(l);
        byte[] byArray = new byte[this.bsize];
        this.file.readFully(byArray);
        return new Page(n, byArray);
    }

    public Bucket getBucket(int n) throws IOException {
        Bucket bucket = new Bucket(n);
        bucket.load();
        return bucket;
    }

    public int hashFunc(String string) {
        byte[] byArray = string.getBytes();
        byte[] byArray2 = new byte[byArray.length + 1];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        byArray = byArray2;
        return this.hashFunc(byArray);
    }

    public int hashFunc(byte[] byArray) {
        int n = 0;
        if (byArray.length > 0) {
            for (int i = 0; i < byArray.length; ++i) {
                n = (n << 5) + n + (byArray[i] & 0xFF);
            }
        }
        return n;
    }

    public int __log2(int n) {
        int n2 = 1;
        int n3 = 0;
        while (n2 < n) {
            n2 <<= 1;
            ++n3;
        }
        return n3;
    }

    public int bucketToPage(int n) {
        return n + this.hdrpages + (n != 0 ? this.spares[this.__log2(n + 1) - 1] : 0);
    }

    public int oAddrToPage(int n) {
        return this.bucketToPage((1 << (n >>> 11)) - 1) + (n & 0x7FF);
    }

    public byte[] get(String string) {
        return this.get(string.getBytes());
    }

    public byte[] get(byte[] byArray) {
        DBT dBT = new DBT(byArray, null);
        return this.get(dBT);
    }

    public byte[] get(DBT dBT) {
        DBT dBT2 = (DBT)this.hashtable.get(dBT);
        byte[] byArray = null;
        if (dBT2 != null) {
            byArray = dBT2.data;
        }
        return byArray;
    }

    public Enumeration keys() {
        return this.hashtable.keys();
    }

    public static void main(String[] stringArray) {
        try {
            DBHash dBHash = new DBHash();
            dBHash.loadAll(stringArray[0]);
            System.out.println("magic: " + HexDump.intToString(dBHash.magic));
            System.out.println("version: " + dBHash.version);
            System.out.println("lorder: " + dBHash.lorder);
            System.out.println("nkeys: " + dBHash.nkeys);
            int n = 0;
            Enumeration enumeration = dBHash.keys();
            while (enumeration.hasMoreElements()) {
                DBT dBT = (DBT)enumeration.nextElement();
                System.out.println("key: ");
                HexDump.print(dBT.key);
                System.out.println("data len: " + dBT.data.length);
                ++n;
            }
            System.out.println("Total entries: " + n);
        }
        catch (Exception exception) {
            System.out.println("Error: " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    public class DBT {
        public byte[] key;
        public byte[] data;

        public DBT(byte[] byArray, byte[] byArray2) {
            this.key = byArray;
            this.data = byArray2;
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof DBT)) {
                return false;
            }
            DBT dBT = (DBT)object;
            if (dBT.key.length != this.key.length) {
                return false;
            }
            for (int i = 0; i < this.key.length; ++i) {
                if (dBT.key[i] == this.key[i]) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return DBHash.this.hashFunc(this.key);
        }
    }

    public class Bucket {
        private int bucketId;
        private Vector pages;
        private Vector dbts;

        public Bucket(int n) {
            this.bucketId = n;
            this.pages = new Vector();
            this.dbts = new Vector();
        }

        public void load() throws IOException {
            Page page = DBHash.this.getPage(DBHash.this.bucketToPage(this.bucketId));
            this.pages.addElement(page);
            while (page.isOverflowed()) {
                if ((page = DBHash.this.getPage(DBHash.this.oAddrToPage(page.overflowAddress()))).isEmpty() || page.overflowType() == 0) continue;
                this.pages.addElement(page);
            }
            this.scanPages();
        }

        public int numberOfKeys() {
            return this.dbts.size();
        }

        public DBT getDBT(int n) {
            return (DBT)this.dbts.elementAt(n);
        }

        public void printChain() {
            System.out.print("bucket#" + this.bucketId);
            for (int i = 0; i < this.pages.size(); ++i) {
                Page page = (Page)this.pages.elementAt(i);
                System.out.print("." + page.pageNumber());
            }
            System.out.println("");
        }

        private void scanPages() throws IOException {
            for (int i = 0; i < this.pages.size(); ++i) {
                Page page = (Page)this.pages.elementAt(i);
                boolean bl = page.isOverflowed();
                if (bl && page.overflowType() < 4) {
                    i = this.processPartial(page, i);
                    continue;
                }
                int n = page.numberOfEntries() / 2 - (bl ? 1 : 0);
                for (int j = 0; j < n; ++j) {
                    this.dbts.addElement(new DBT(page.getKey(j), page.getData(j)));
                }
            }
        }

        private int processPartial(Page page, int n) {
            byte[] byArray;
            int n2;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
            ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream(1024);
            if (page.overflowType() == 1) {
                while (page.overflowType() == 1) {
                    n2 = page.keyOffset(0);
                    byArray = page.getBuf();
                    byteArrayOutputStream.write(byArray, n2, byArray.length - n2);
                    page = (Page)this.pages.elementAt(++n);
                }
            } else {
                n2 = page.keyOffset(0);
                byArray = page.getBuf();
                byteArrayOutputStream.write(byArray, n2, byArray.length - n2);
                if (page.overflowType() == 3) {
                    int n3 = page.dataOffset(1);
                    byArray = page.getBuf();
                    byteArrayOutputStream2.write(byArray, n3, n2 - n3);
                    page = (Page)this.pages.elementAt(++n);
                }
            }
            while (page.overflowType() == 2) {
                n2 = page.keyOffset(0);
                byArray = page.getBuf();
                byteArrayOutputStream2.write(byArray, n2, byArray.length - n2);
                page = (Page)this.pages.elementAt(++n);
            }
            n2 = page.keyOffset(0);
            byArray = page.getBuf();
            byteArrayOutputStream2.write(byArray, n2, byArray.length - n2);
            this.dbts.addElement(new DBT(byteArrayOutputStream.toByteArray(), byteArrayOutputStream2.toByteArray()));
            return n;
        }
    }

    public class Page {
        private byte[] data;
        private int pageNumber;
        private int rPos;
        private int numberOfEntries;
        private int freePtr;
        private int freeSpc;
        private int[] offsPtrs;

        public Page(byte[] byArray) {
            this.data = byArray;
        }

        public Page(int n, byte[] byArray) {
            this(byArray);
            this.pageNumber = n;
            this.rPos = 0;
            this.numberOfEntries = this.readShort();
            this.offsPtrs = new int[this.numberOfEntries];
            for (int i = 0; i < this.numberOfEntries; ++i) {
                this.offsPtrs[i] = this.readShort();
            }
            this.freePtr = this.readShort();
            this.freeSpc = this.readShort();
        }

        public int pageNumber() {
            return this.pageNumber;
        }

        public int numberOfEntries() {
            return this.numberOfEntries;
        }

        public int freeSpace() {
            return this.freeSpc;
        }

        public int keyOffset(int n) {
            return this.offsPtrs[n * 2];
        }

        public int dataOffset(int n) {
            return this.offsPtrs[n * 2 + 1];
        }

        public byte[] getKey(int n) throws IOException {
            int n2 = this.keyOffset(n);
            int n3 = n == 0 ? DBHash.this.bsize : this.dataOffset(n - 1);
            byte[] byArray = new byte[n3 - n2];
            System.arraycopy(this.data, n2, byArray, 0, byArray.length);
            return byArray;
        }

        public byte[] getData(int n) throws IOException {
            int n2 = this.dataOffset(n);
            int n3 = this.keyOffset(n);
            byte[] byArray = new byte[n3 - n2];
            System.arraycopy(this.data, n2, byArray, 0, byArray.length);
            return byArray;
        }

        public byte[] getBuf() {
            return this.data;
        }

        public boolean isOverflowed() {
            return !this.isEmpty() && (this.offsPtrs[this.numberOfEntries - 1] == 0 || this.numberOfEntries > 2 && this.offsPtrs[1] < 4);
        }

        public int overflowType() {
            return this.offsPtrs[1];
        }

        public int overflowAddress() {
            return this.offsPtrs[this.numberOfEntries - 2];
        }

        public boolean isEmpty() {
            return this.numberOfEntries == 0;
        }

        public final int readByte() {
            return this.data[this.rPos++] & 0xFF;
        }

        public final int readShort() {
            int n = this.readByte();
            int n2 = this.readByte();
            if (DBHash.this.lorder == 1234) {
                return (n2 << 8) + (n << 0);
            }
            return (n << 8) + (n2 << 0);
        }

        public final int readInt() {
            int n = this.readByte();
            int n2 = this.readByte();
            int n3 = this.readByte();
            int n4 = this.readByte();
            return (n << 24) + (n2 << 16) + (n3 << 8) + (n4 << 0);
        }
    }
}

