/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.xml.xmp;

import com.lowagie.text.pdf.PdfDate;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.xml.xmp.DublinCoreSchema;
import com.lowagie.text.xml.xmp.PdfA1Schema;
import com.lowagie.text.xml.xmp.PdfSchema;
import com.lowagie.text.xml.xmp.XmpBasicSchema;
import com.lowagie.text.xml.xmp.XmpSchema;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class XmpWriter {
    private static final String UTF8 = "UTF-8";
    static final String EXTRASPACE = "                                                                                                   \n";
    private final int extraSpace;
    private final OutputStreamWriter writer;
    private String about;
    static final String XPACKET_PI_BEGIN = "<?xpacket begin=\"\ufeff\" id=\"W5M0MpCehiHzreSzNTczkc9d\"?>\n";
    static final String XPACKET_PI_END_W = "<?xpacket end=\"w\"?>";
    private static final String XPACKET_PI_END_R = "<?xpacket end=\"r\"?>";
    private final char end = (char)119;

    private XmpWriter(OutputStream outputStream, String string, int n) throws IOException {
        this.extraSpace = n;
        this.writer = new OutputStreamWriter(outputStream, string);
        this.writer.write(XPACKET_PI_BEGIN);
        this.writer.write("<x:xmpmeta xmlns:x=\"adobe:ns:meta/\">\n");
        this.writer.write("<rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\">\n");
        this.about = "";
    }

    public XmpWriter(OutputStream outputStream) throws IOException {
        this(outputStream, UTF8, 20);
    }

    public void setAbout(String string) {
        this.about = string;
    }

    public void addRdfDescription(XmpSchema xmpSchema) throws IOException {
        this.writer.write("<rdf:Description rdf:about=\"");
        this.writer.write(this.about);
        this.writer.write("\" ");
        this.writer.write(xmpSchema.getXmlns());
        this.writer.write(">");
        this.writer.write(xmpSchema.toString());
        this.writer.write("</rdf:Description>\n");
    }

    public void close() throws IOException {
        this.writer.write("</rdf:RDF>");
        this.writer.write("</x:xmpmeta>\n");
        for (int i = 0; i < this.extraSpace; ++i) {
            this.writer.write(EXTRASPACE);
        }
        this.writer.write(this.end == 114 ? XPACKET_PI_END_R : XPACKET_PI_END_W);
        this.writer.flush();
        this.writer.close();
    }

    public XmpWriter(OutputStream outputStream, PdfDictionary pdfDictionary, int n) throws IOException {
        this(outputStream);
        if (pdfDictionary != null) {
            DublinCoreSchema dublinCoreSchema = new DublinCoreSchema();
            PdfSchema pdfSchema = new PdfSchema();
            XmpBasicSchema xmpBasicSchema = new XmpBasicSchema();
            for (PdfName pdfName : pdfDictionary.getKeys()) {
                PdfName pdfName2 = pdfName;
                PdfObject pdfObject = pdfDictionary.get(pdfName2);
                if (pdfObject == null) continue;
                if (PdfName.TITLE.equals(pdfName2)) {
                    dublinCoreSchema.addTitle(((PdfString)pdfObject).toUnicodeString());
                }
                if (PdfName.AUTHOR.equals(pdfName2)) {
                    dublinCoreSchema.addAuthor(((PdfString)pdfObject).toUnicodeString());
                }
                if (PdfName.SUBJECT.equals(pdfName2)) {
                    dublinCoreSchema.addSubject(((PdfString)pdfObject).toUnicodeString());
                    dublinCoreSchema.addDescription(((PdfString)pdfObject).toUnicodeString());
                }
                if (PdfName.KEYWORDS.equals(pdfName2)) {
                    pdfSchema.addKeywords(((PdfString)pdfObject).toUnicodeString());
                }
                if (PdfName.CREATOR.equals(pdfName2)) {
                    xmpBasicSchema.addCreatorTool(((PdfString)pdfObject).toUnicodeString());
                }
                if (PdfName.PRODUCER.equals(pdfName2)) {
                    pdfSchema.addProducer(((PdfString)pdfObject).toUnicodeString());
                }
                if (PdfName.CREATIONDATE.equals(pdfName2)) {
                    xmpBasicSchema.addCreateDate(((PdfDate)pdfObject).getW3CDate());
                }
                if (!PdfName.MODDATE.equals(pdfName2)) continue;
                xmpBasicSchema.addModDate(((PdfDate)pdfObject).getW3CDate());
            }
            if (dublinCoreSchema.size() > 0) {
                this.addRdfDescription(dublinCoreSchema);
            }
            if (pdfSchema.size() > 0) {
                this.addRdfDescription(pdfSchema);
            }
            if (xmpBasicSchema.size() > 0) {
                this.addRdfDescription(xmpBasicSchema);
            }
            if (n == 3 || n == 4) {
                PdfA1Schema pdfA1Schema = new PdfA1Schema();
                if (n == 3) {
                    pdfA1Schema.addConformance("A");
                } else {
                    pdfA1Schema.addConformance("B");
                }
                this.addRdfDescription(pdfA1Schema);
            }
        }
    }
}

