/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf.collection;

import com.lowagie.text.pdf.PdfBoolean;
import com.lowagie.text.pdf.PdfDate;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfString;

class PdfCollectionField
extends PdfDictionary {
    private static final int TEXT = 0;
    public static final int DATE = 1;
    public static final int NUMBER = 2;
    protected int fieldType;

    PdfCollectionField() {
    }

    public void setOrder(int n) {
        this.put(PdfName.O, new PdfNumber(n));
    }

    public void setVisible(boolean bl) {
        this.put(PdfName.V, new PdfBoolean(bl));
    }

    public void setEditable(boolean bl) {
        this.put(PdfName.E, new PdfBoolean(bl));
    }

    public boolean isCollectionItem() {
        switch (this.fieldType) {
            case 0: 
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    public PdfObject getValue(String string) {
        switch (this.fieldType) {
            case 0: {
                return new PdfString(string, "UnicodeBig");
            }
            case 1: {
                return new PdfDate(PdfDate.decode(string));
            }
            case 2: {
                return new PdfNumber(string);
            }
        }
        throw new IllegalArgumentException(string + " is not an acceptable value for the field " + this.get(PdfName.N).toString());
    }
}

