/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf.codec.wmf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Image;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.codec.BmpImage;
import com.lowagie.text.pdf.codec.wmf.InputMeta;
import com.lowagie.text.pdf.codec.wmf.MetaBrush;
import com.lowagie.text.pdf.codec.wmf.MetaFont;
import com.lowagie.text.pdf.codec.wmf.MetaObject;
import com.lowagie.text.pdf.codec.wmf.MetaPen;
import com.lowagie.text.pdf.codec.wmf.MetaState;
import java.awt.Color;
import java.awt.Point;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;

public class MetaDo {
    private static final int META_SETBKCOLOR = 513;
    private static final int META_SETBKMODE = 258;
    private static final int META_SETPOLYFILLMODE = 262;
    private static final int META_SETTEXTCOLOR = 521;
    private static final int META_SETWINDOWORG = 523;
    private static final int META_SETWINDOWEXT = 524;
    private static final int META_LINETO = 531;
    private static final int META_MOVETO = 532;
    private static final int META_INTERSECTCLIPRECT = 1046;
    private static final int META_ARC = 2071;
    private static final int META_ELLIPSE = 1048;
    private static final int META_PIE = 2074;
    private static final int META_RECTANGLE = 1051;
    private static final int META_ROUNDRECT = 1564;
    private static final int META_SAVEDC = 30;
    private static final int META_SETPIXEL = 1055;
    private static final int META_TEXTOUT = 1313;
    private static final int META_POLYGON = 804;
    private static final int META_POLYLINE = 805;
    private static final int META_RESTOREDC = 295;
    private static final int META_SELECTOBJECT = 301;
    private static final int META_SETTEXTALIGN = 302;
    private static final int META_CHORD = 2096;
    private static final int META_EXTTEXTOUT = 2610;
    private static final int META_POLYPOLYGON = 1336;
    private static final int META_DIBSTRETCHBLT = 2881;
    private static final int META_DIBCREATEPATTERNBRUSH = 322;
    private static final int META_STRETCHDIB = 3907;
    private static final int META_DELETEOBJECT = 496;
    private static final int META_CREATEPALETTE = 247;
    private static final int META_CREATEPENINDIRECT = 762;
    private static final int META_CREATEFONTINDIRECT = 763;
    private static final int META_CREATEBRUSHINDIRECT = 764;
    private static final int META_CREATEREGION = 1791;
    private final PdfContentByte cb;
    private final InputMeta in;
    private int left;
    private int top;
    private int right;
    private int bottom;
    private int inch;
    private final MetaState state = new MetaState();

    public MetaDo(InputStream inputStream, PdfContentByte pdfContentByte) {
        this.cb = pdfContentByte;
        this.in = new InputMeta(inputStream);
    }

    public void readAll() throws IOException, DocumentException {
        if (this.in.readInt() != -1698247209) {
            throw new DocumentException("Not a placeable windows metafile");
        }
        this.in.readWord();
        this.left = this.in.readShort();
        this.top = this.in.readShort();
        this.right = this.in.readShort();
        this.bottom = this.in.readShort();
        this.inch = this.in.readWord();
        this.state.setScalingX((float)(this.right - this.left) / (float)this.inch * 72.0f);
        this.state.setScalingY((float)(this.bottom - this.top) / (float)this.inch * 72.0f);
        this.state.setOffsetWx(this.left);
        this.state.setOffsetWy(this.top);
        this.state.setExtentWx(this.right - this.left);
        this.state.setExtentWy(this.bottom - this.top);
        this.in.readInt();
        this.in.readWord();
        this.in.skip(18);
        this.cb.setLineCap(1);
        this.cb.setLineJoin(1);
        while (true) {
            int n = this.in.getLength();
            int n2 = this.in.readInt();
            if (n2 < 3) break;
            int n3 = this.in.readWord();
            switch (n3) {
                case 0: {
                    break;
                }
                case 247: 
                case 322: 
                case 1791: {
                    this.state.addMetaObject(new MetaObject());
                    break;
                }
                case 762: {
                    MetaPen metaPen = new MetaPen();
                    metaPen.init(this.in);
                    this.state.addMetaObject(metaPen);
                    break;
                }
                case 764: {
                    MetaBrush metaBrush = new MetaBrush();
                    metaBrush.init(this.in);
                    this.state.addMetaObject(metaBrush);
                    break;
                }
                case 763: {
                    MetaFont metaFont = new MetaFont();
                    metaFont.init(this.in);
                    this.state.addMetaObject(metaFont);
                    break;
                }
                case 301: {
                    int n4 = this.in.readWord();
                    this.state.selectMetaObject(n4, this.cb);
                    break;
                }
                case 496: {
                    int n5 = this.in.readWord();
                    this.state.deleteMetaObject(n5);
                    break;
                }
                case 30: {
                    this.state.saveState(this.cb);
                    break;
                }
                case 295: {
                    int n6 = this.in.readShort();
                    this.state.restoreState(n6, this.cb);
                    break;
                }
                case 523: {
                    this.state.setOffsetWy(this.in.readShort());
                    this.state.setOffsetWx(this.in.readShort());
                    break;
                }
                case 524: {
                    this.state.setExtentWy(this.in.readShort());
                    this.state.setExtentWx(this.in.readShort());
                    break;
                }
                case 532: {
                    int n7 = this.in.readShort();
                    Point point = new Point(this.in.readShort(), n7);
                    this.state.setCurrentPoint(point);
                    break;
                }
                case 531: {
                    int n8 = this.in.readShort();
                    int n9 = this.in.readShort();
                    Point point = this.state.getCurrentPoint();
                    this.cb.moveTo(this.state.transformX(point.x), this.state.transformY(point.y));
                    this.cb.lineTo(this.state.transformX(n9), this.state.transformY(n8));
                    this.cb.stroke();
                    this.state.setCurrentPoint(new Point(n9, n8));
                    break;
                }
                case 805: {
                    this.state.setLineJoinPolygon(this.cb);
                    int n10 = this.in.readWord();
                    int n11 = this.in.readShort();
                    int n12 = this.in.readShort();
                    this.cb.moveTo(this.state.transformX(n11), this.state.transformY(n12));
                    for (int i = 1; i < n10; ++i) {
                        n11 = this.in.readShort();
                        n12 = this.in.readShort();
                        this.cb.lineTo(this.state.transformX(n11), this.state.transformY(n12));
                    }
                    this.cb.stroke();
                    break;
                }
                case 804: {
                    if (this.isNullStrokeFill(false)) break;
                    int n13 = this.in.readWord();
                    int n14 = this.in.readShort();
                    int n15 = this.in.readShort();
                    this.cb.moveTo(this.state.transformX(n14), this.state.transformY(n15));
                    for (int i = 1; i < n13; ++i) {
                        int n16 = this.in.readShort();
                        int n17 = this.in.readShort();
                        this.cb.lineTo(this.state.transformX(n16), this.state.transformY(n17));
                    }
                    this.cb.lineTo(this.state.transformX(n14), this.state.transformY(n15));
                    this.strokeAndFill();
                    break;
                }
                case 1336: {
                    if (this.isNullStrokeFill(false)) break;
                    int n18 = this.in.readWord();
                    int[] nArray = new int[n18];
                    for (int i = 0; i < nArray.length; ++i) {
                        nArray[i] = this.in.readWord();
                    }
                    for (int n19 : nArray) {
                        int n20 = this.in.readShort();
                        int n21 = this.in.readShort();
                        this.cb.moveTo(this.state.transformX(n20), this.state.transformY(n21));
                        for (int i = 1; i < n19; ++i) {
                            int n22 = this.in.readShort();
                            int n23 = this.in.readShort();
                            this.cb.lineTo(this.state.transformX(n22), this.state.transformY(n23));
                        }
                        this.cb.lineTo(this.state.transformX(n20), this.state.transformY(n21));
                    }
                    this.strokeAndFill();
                    break;
                }
                case 1048: {
                    if (this.isNullStrokeFill(this.state.getLineNeutral())) break;
                    int n24 = this.in.readShort();
                    int n25 = this.in.readShort();
                    int n26 = this.in.readShort();
                    int n27 = this.in.readShort();
                    this.cb.arc(this.state.transformX(n27), this.state.transformY(n24), this.state.transformX(n25), this.state.transformY(n26), 0.0f, 360.0f);
                    this.strokeAndFill();
                    break;
                }
                case 2071: {
                    if (this.isNullStrokeFill(this.state.getLineNeutral())) break;
                    float f = this.state.transformY(this.in.readShort());
                    float f2 = this.state.transformX(this.in.readShort());
                    float f3 = this.state.transformY(this.in.readShort());
                    float f4 = this.state.transformX(this.in.readShort());
                    float f5 = this.state.transformY(this.in.readShort());
                    float f6 = this.state.transformX(this.in.readShort());
                    float f7 = this.state.transformY(this.in.readShort());
                    float f8 = this.state.transformX(this.in.readShort());
                    float f9 = (f6 + f8) / 2.0f;
                    float f10 = (f7 + f5) / 2.0f;
                    float f11 = MetaDo.getArc(f9, f10, f4, f3);
                    float f12 = MetaDo.getArc(f9, f10, f2, f);
                    if ((f12 -= f11) <= 0.0f) {
                        f12 += 360.0f;
                    }
                    this.cb.arc(f8, f5, f6, f7, f11, f12);
                    this.cb.stroke();
                    break;
                }
                case 2074: {
                    int n28;
                    ArrayList arrayList;
                    if (this.isNullStrokeFill(this.state.getLineNeutral())) break;
                    float f = this.state.transformY(this.in.readShort());
                    float f13 = this.state.transformX(this.in.readShort());
                    float f14 = this.state.transformY(this.in.readShort());
                    float f15 = this.state.transformX(this.in.readShort());
                    float f16 = this.state.transformY(this.in.readShort());
                    float f17 = this.state.transformX(this.in.readShort());
                    float f7 = this.state.transformY(this.in.readShort());
                    float f8 = this.state.transformX(this.in.readShort());
                    float f9 = (f17 + f8) / 2.0f;
                    float f10 = (f7 + f16) / 2.0f;
                    float f18 = MetaDo.getArc(f9, f10, f15, f14);
                    float f19 = MetaDo.getArc(f9, f10, f13, f);
                    if ((f19 -= f18) <= 0.0f) {
                        f19 += 360.0f;
                    }
                    if ((arrayList = PdfContentByte.bezierArc(f8, f16, f17, f7, f18, f19)).isEmpty()) break;
                    float[] fArray = (float[])arrayList.get(0);
                    this.cb.moveTo(f9, f10);
                    this.cb.lineTo(fArray[0], fArray[1]);
                    for (n28 = 0; n28 < arrayList.size(); ++n28) {
                        fArray = (float[])arrayList.get(n28);
                        this.cb.curveTo(fArray[2], fArray[3], fArray[4], fArray[5], fArray[6], fArray[7]);
                    }
                    this.cb.lineTo(f9, f10);
                    this.strokeAndFill();
                    break;
                }
                case 2096: {
                    int n28;
                    ArrayList arrayList;
                    if (this.isNullStrokeFill(this.state.getLineNeutral())) break;
                    float f = this.state.transformY(this.in.readShort());
                    float f20 = this.state.transformX(this.in.readShort());
                    float f21 = this.state.transformY(this.in.readShort());
                    float f22 = this.state.transformX(this.in.readShort());
                    float f23 = this.state.transformY(this.in.readShort());
                    float f24 = this.state.transformX(this.in.readShort());
                    float f7 = this.state.transformY(this.in.readShort());
                    float f8 = this.state.transformX(this.in.readShort());
                    float f9 = (f24 + f8) / 2.0f;
                    float f10 = (f7 + f23) / 2.0f;
                    float f25 = MetaDo.getArc(f9, f10, f22, f21);
                    float f26 = MetaDo.getArc(f9, f10, f20, f);
                    if ((f26 -= f25) <= 0.0f) {
                        f26 += 360.0f;
                    }
                    if ((arrayList = PdfContentByte.bezierArc(f8, f23, f24, f7, f25, f26)).isEmpty()) break;
                    float[] fArray = (float[])arrayList.get(0);
                    f9 = fArray[0];
                    f10 = fArray[1];
                    this.cb.moveTo(f9, f10);
                    for (n28 = 0; n28 < arrayList.size(); ++n28) {
                        fArray = (float[])arrayList.get(n28);
                        this.cb.curveTo(fArray[2], fArray[3], fArray[4], fArray[5], fArray[6], fArray[7]);
                    }
                    this.cb.lineTo(f9, f10);
                    this.strokeAndFill();
                    break;
                }
                case 1051: {
                    if (this.isNullStrokeFill(true)) break;
                    float f = this.state.transformY(this.in.readShort());
                    float f27 = this.state.transformX(this.in.readShort());
                    float f28 = this.state.transformY(this.in.readShort());
                    float f29 = this.state.transformX(this.in.readShort());
                    this.cb.rectangle(f29, f, f27 - f29, f28 - f);
                    this.strokeAndFill();
                    break;
                }
                case 1564: {
                    if (this.isNullStrokeFill(true)) break;
                    float f = this.state.transformY(0) - this.state.transformY(this.in.readShort());
                    float f30 = this.state.transformX(this.in.readShort()) - this.state.transformX(0);
                    float f31 = this.state.transformY(this.in.readShort());
                    float f32 = this.state.transformX(this.in.readShort());
                    float f33 = this.state.transformY(this.in.readShort());
                    float f34 = this.state.transformX(this.in.readShort());
                    this.cb.roundRectangle(f34, f31, f32 - f34, f33 - f31, (f + f30) / 4.0f);
                    this.strokeAndFill();
                    break;
                }
                case 1046: {
                    float f = this.state.transformY(this.in.readShort());
                    float f35 = this.state.transformX(this.in.readShort());
                    float f36 = this.state.transformY(this.in.readShort());
                    float f37 = this.state.transformX(this.in.readShort());
                    this.cb.rectangle(f37, f, f35 - f37, f36 - f);
                    this.cb.eoClip();
                    this.cb.newPath();
                    break;
                }
                case 2610: {
                    String string;
                    byte by;
                    int n29;
                    int n30 = this.in.readShort();
                    int n31 = this.in.readShort();
                    int n32 = this.in.readWord();
                    int n33 = this.in.readWord();
                    int n34 = 0;
                    int n35 = 0;
                    int n36 = 0;
                    int n37 = 0;
                    if ((n33 & 6) != 0) {
                        n34 = this.in.readShort();
                        n35 = this.in.readShort();
                        n36 = this.in.readShort();
                        n37 = this.in.readShort();
                    }
                    byte[] byArray = new byte[n32];
                    for (n29 = 0; n29 < n32 && (by = (byte)this.in.readByte()) != 0; ++n29) {
                        byArray[n29] = by;
                    }
                    try {
                        string = new String(byArray, 0, n29, "Cp1252");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        string = new String(byArray, 0, n29);
                    }
                    this.outputText(n31, n30, n33, n34, n35, n36, n37, string);
                    break;
                }
                case 1313: {
                    String string;
                    byte by;
                    int n38;
                    int n39 = this.in.readWord();
                    byte[] byArray = new byte[n39];
                    for (n38 = 0; n38 < n39 && (by = (byte)this.in.readByte()) != 0; ++n38) {
                        byArray[n38] = by;
                    }
                    try {
                        string = new String(byArray, 0, n38, "Cp1252");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        string = new String(byArray, 0, n38);
                    }
                    n39 = n39 + 1 & 0xFFFE;
                    this.in.skip(n39 - n38);
                    int n40 = this.in.readShort();
                    int n41 = this.in.readShort();
                    this.outputText(n41, n40, 0, 0, 0, 0, 0, string);
                    break;
                }
                case 513: {
                    this.state.setCurrentBackgroundColor(this.in.readColor());
                    break;
                }
                case 521: {
                    this.state.setCurrentTextColor(this.in.readColor());
                    break;
                }
                case 302: {
                    this.state.setTextAlign(this.in.readWord());
                    break;
                }
                case 258: {
                    this.state.setBackgroundMode(this.in.readWord());
                    break;
                }
                case 262: {
                    this.state.setPolyFillMode(this.in.readWord());
                    break;
                }
                case 1055: {
                    Color color = this.in.readColor();
                    int n42 = this.in.readShort();
                    int n43 = this.in.readShort();
                    this.cb.saveState();
                    this.cb.setColorFill(color);
                    this.cb.rectangle(this.state.transformX(n43), this.state.transformY(n42), 0.2f, 0.2f);
                    this.cb.fill();
                    this.cb.restoreState();
                    break;
                }
                case 2881: 
                case 3907: {
                    int n44 = this.in.readInt();
                    if (n3 == 3907) {
                        this.in.readWord();
                    }
                    int n45 = this.in.readShort();
                    int n46 = this.in.readShort();
                    int n47 = this.in.readShort();
                    int n48 = this.in.readShort();
                    float f = this.state.transformY(this.in.readShort()) - this.state.transformY(0);
                    float f7 = this.state.transformX(this.in.readShort()) - this.state.transformX(0);
                    float f8 = this.state.transformY(this.in.readShort());
                    float f9 = this.state.transformX(this.in.readShort());
                    byte[] byArray = new byte[n2 * 2 - (this.in.getLength() - n)];
                    for (int i = 0; i < byArray.length; ++i) {
                        byArray[i] = (byte)this.in.readByte();
                    }
                    try {
                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                        Image image = BmpImage.getImage(byteArrayInputStream, true, byArray.length);
                        this.cb.saveState();
                        this.cb.rectangle(f9, f8, f7, f);
                        this.cb.clip();
                        this.cb.newPath();
                        image.scaleAbsolute(f7 * image.getWidth() / (float)n46, -f * image.getHeight() / (float)n45);
                        image.setAbsolutePosition(f9 - f7 * (float)n48 / (float)n46, f8 + f * (float)n47 / (float)n45 - image.getScaledHeight());
                        this.cb.addImage(image);
                        this.cb.restoreState();
                    }
                    catch (Exception exception) {}
                    break;
                }
            }
            this.in.skip(n2 * 2 - (this.in.getLength() - n));
        }
        this.state.cleanup(this.cb);
    }

    private void outputText(int n, int n2, int n3, int n4, int n5, int n6, int n7, String string) {
        Color color;
        MetaFont metaFont = this.state.getCurrentFont();
        float f = this.state.transformX(n);
        float f2 = this.state.transformY(n2);
        float f3 = this.state.transformAngle(metaFont.getAngle());
        float f4 = (float)Math.sin(f3);
        float f5 = (float)Math.cos(f3);
        float f6 = metaFont.getFontSize(this.state);
        BaseFont baseFont = metaFont.getFont();
        int n8 = this.state.getTextAlign();
        float f7 = baseFont.getWidthPoint(string, f6);
        float f8 = 0.0f;
        float f9 = 0.0f;
        float f10 = baseFont.getFontDescriptor(3, f6);
        float f11 = baseFont.getFontDescriptor(8, f6);
        this.cb.saveState();
        this.cb.concatCTM(f5, f4, -f4, f5, f, f2);
        if ((n8 & 6) == 6) {
            f8 = -f7 / 2.0f;
        } else if ((n8 & 2) == 2) {
            f8 = -f7;
        }
        f9 = (n8 & 0x18) == 24 ? 0.0f : ((n8 & 8) == 8 ? -f10 : -f11);
        if (this.state.getBackgroundMode() == 2) {
            color = this.state.getCurrentBackgroundColor();
            this.cb.setColorFill(color);
            this.cb.rectangle(f8, f9 + f10, f7, f11 - f10);
            this.cb.fill();
        }
        color = this.state.getCurrentTextColor();
        this.cb.setColorFill(color);
        this.cb.beginText();
        this.cb.setFontAndSize(baseFont, f6);
        this.cb.setTextMatrix(f8, f9);
        this.cb.showText(string);
        this.cb.endText();
        if (metaFont.isUnderline()) {
            this.cb.rectangle(f8, f9 - f6 / 4.0f, f7, f6 / 15.0f);
            this.cb.fill();
        }
        if (metaFont.isStrikeout()) {
            this.cb.rectangle(f8, f9 + f6 / 3.0f, f7, f6 / 15.0f);
            this.cb.fill();
        }
        this.cb.restoreState();
    }

    private boolean isNullStrokeFill(boolean bl) {
        boolean bl2;
        MetaPen metaPen = this.state.getCurrentPen();
        MetaBrush metaBrush = this.state.getCurrentBrush();
        boolean bl3 = metaPen.getStyle() == 5;
        int n = metaBrush.getStyle();
        boolean bl4 = n == 0 || n == 2 && this.state.getBackgroundMode() == 2;
        boolean bl5 = bl2 = bl3 && !bl4;
        if (!bl3) {
            if (bl) {
                this.state.setLineJoinRectangle(this.cb);
            } else {
                this.state.setLineJoinPolygon(this.cb);
            }
        }
        return bl2;
    }

    private void strokeAndFill() {
        MetaPen metaPen = this.state.getCurrentPen();
        MetaBrush metaBrush = this.state.getCurrentBrush();
        int n = metaPen.getStyle();
        int n2 = metaBrush.getStyle();
        if (n == 5) {
            this.cb.closePath();
            if (this.state.getPolyFillMode() == 1) {
                this.cb.eoFill();
            } else {
                this.cb.fill();
            }
        } else {
            boolean bl;
            boolean bl2 = bl = n2 == 0 || n2 == 2 && this.state.getBackgroundMode() == 2;
            if (bl) {
                if (this.state.getPolyFillMode() == 1) {
                    this.cb.closePathEoFillStroke();
                } else {
                    this.cb.closePathFillStroke();
                }
            } else {
                this.cb.closePathStroke();
            }
        }
    }

    private static float getArc(float f, float f2, float f3, float f4) {
        double d = Math.atan2(f4 - f2, f3 - f);
        if (d < 0.0) {
            d += Math.PI * 2;
        }
        return (float)(d / Math.PI * 180.0);
    }

    private static void writeWord(OutputStream outputStream, int n) throws IOException {
        outputStream.write(n & 0xFF);
        outputStream.write(n >>> 8 & 0xFF);
    }

    private static void writeDWord(OutputStream outputStream, int n) throws IOException {
        MetaDo.writeWord(outputStream, n & 0xFFFF);
        MetaDo.writeWord(outputStream, n >>> 16 & 0xFFFF);
    }
}

