/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf.codec.wmf;

import com.lowagie.text.Utilities;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;

public class InputMeta {
    private final InputStream in;
    private int length;

    public InputMeta(InputStream inputStream) {
        this.in = inputStream;
    }

    public int readWord() throws IOException {
        this.length += 2;
        int n = this.in.read();
        if (n < 0) {
            return 0;
        }
        return n + (this.in.read() << 8) & 0xFFFF;
    }

    public int readShort() throws IOException {
        int n = this.readWord();
        if (n > Short.MAX_VALUE) {
            n -= 65536;
        }
        return n;
    }

    public int readInt() throws IOException {
        this.length += 4;
        int n = this.in.read();
        if (n < 0) {
            return 0;
        }
        int n2 = this.in.read() << 8;
        int n3 = this.in.read() << 16;
        return n + n2 + n3 + (this.in.read() << 24);
    }

    int readByte() throws IOException {
        ++this.length;
        return this.in.read() & 0xFF;
    }

    void skip(int n) throws IOException {
        this.length += n;
        Utilities.skip(this.in, n);
    }

    public int getLength() {
        return this.length;
    }

    Color readColor() throws IOException {
        int n = this.readByte();
        int n2 = this.readByte();
        int n3 = this.readByte();
        this.readByte();
        return new Color(n, n2, n3);
    }
}

