/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf.codec;

import com.lowagie.text.pdf.RandomAccessFileOrArray;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

class JBIG2SegmentReader {
    private static final int PAGE_INFORMATION = 48;
    private static final int END_OF_PAGE = 49;
    private static final int END_OF_FILE = 51;
    private final SortedMap segments = new TreeMap();
    private final SortedMap pages = new TreeMap();
    private final SortedSet globals = new TreeSet();
    private final RandomAccessFileOrArray ra;
    private boolean sequential;
    private boolean number_of_pages_known;
    private int number_of_pages = -1;
    private boolean read = false;

    public JBIG2SegmentReader(RandomAccessFileOrArray randomAccessFileOrArray) throws IOException {
        this.ra = randomAccessFileOrArray;
    }

    private static byte[] copyByteArray(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        return byArray2;
    }

    public void read() throws IOException {
        if (this.read) {
            throw new IllegalStateException("already attempted a read() on this Jbig2 File");
        }
        this.read = true;
        this.readFileHeader();
        if (this.sequential) {
            do {
                JBIG2Segment jBIG2Segment = this.readHeader();
                this.readSegment(jBIG2Segment);
                this.segments.put(new Integer(jBIG2Segment.segmentNumber), jBIG2Segment);
            } while (this.ra.getFilePointer() < this.ra.length());
        } else {
            JBIG2Segment jBIG2Segment;
            do {
                jBIG2Segment = this.readHeader();
                this.segments.put(new Integer(jBIG2Segment.segmentNumber), jBIG2Segment);
            } while (jBIG2Segment.type != 51);
            Iterator iterator = this.segments.keySet().iterator();
            while (iterator.hasNext()) {
                this.readSegment((JBIG2Segment)this.segments.get(iterator.next()));
            }
        }
    }

    private void readSegment(JBIG2Segment jBIG2Segment) throws IOException {
        int n = this.ra.getFilePointer();
        if (jBIG2Segment.dataLength == 0xFFFFFFFFL) {
            return;
        }
        byte[] byArray = new byte[(int)jBIG2Segment.dataLength];
        this.ra.read(byArray);
        JBIG2Segment.access$502(jBIG2Segment, byArray);
        if (jBIG2Segment.type == 48) {
            int n2 = this.ra.getFilePointer();
            this.ra.seek(n);
            int n3 = this.ra.readInt();
            int n4 = this.ra.readInt();
            this.ra.seek(n2);
            JBIG2Page jBIG2Page = (JBIG2Page)this.pages.get(new Integer(jBIG2Segment.page));
            if (jBIG2Page == null) {
                throw new IllegalStateException("referring to widht/height of page we havent seen yet? " + jBIG2Segment.page);
            }
            jBIG2Page.pageBitmapWidth = n3;
            jBIG2Page.pageBitmapHeight = n4;
        }
    }

    private JBIG2Segment readHeader() throws IOException {
        int n;
        int n2;
        int n3 = this.ra.getFilePointer();
        int n4 = this.ra.readInt();
        JBIG2Segment jBIG2Segment = new JBIG2Segment(n4);
        int n5 = this.ra.read();
        boolean bl = (n5 & 0x80) == 128;
        jBIG2Segment.deferredNonRetain = bl;
        boolean bl2 = (n5 & 0x40) == 64;
        int n6 = n5 & 0x3F;
        jBIG2Segment.type = n6;
        int n7 = this.ra.read();
        int n8 = (n7 & 0xE0) >> 5;
        int[] nArray = null;
        boolean[] blArray = null;
        if (n8 == 7) {
            this.ra.seek(this.ra.getFilePointer() - 1);
            n8 = this.ra.readInt() & 0x1FFFFFFF;
            blArray = new boolean[n8 + 1];
            n2 = 0;
            n = 0;
            do {
                int n9;
                if ((n9 = n2 % 8) == 0) {
                    n = this.ra.read();
                }
                boolean bl3 = blArray[n2] = (1 << n9 & n) >> n9 == 1;
            } while (++n2 <= n8);
        } else if (n8 <= 4) {
            blArray = new boolean[n8 + 1];
            n7 &= 0x1F;
            for (n2 = 0; n2 <= n8; ++n2) {
                blArray[n2] = (1 << n2 & n7) >> n2 == 1;
            }
        } else if (n8 == 5 || n8 == 6) {
            throw new IllegalStateException("count of referred-to segments had bad value in header for segment " + n4 + " starting at " + n3);
        }
        JBIG2Segment.access$1102(jBIG2Segment, blArray);
        jBIG2Segment.countOfReferredToSegments = n8;
        nArray = new int[n8 + 1];
        for (n2 = 1; n2 <= n8; ++n2) {
            nArray[n2] = n4 <= 256 ? this.ra.read() : (n4 <= 65536 ? this.ra.readUnsignedShort() : (int)this.ra.readUnsignedInt());
        }
        JBIG2Segment.access$1302(jBIG2Segment, nArray);
        n = this.ra.getFilePointer() - n3;
        n2 = bl2 ? this.ra.readInt() : this.ra.read();
        if (n2 < 0) {
            throw new IllegalStateException("page " + n2 + " invalid for segment " + n4 + " starting at " + n3);
        }
        jBIG2Segment.page = n2;
        jBIG2Segment.page_association_size = bl2;
        jBIG2Segment.page_association_offset = n;
        if (n2 > 0 && !this.pages.containsKey(new Integer(n2))) {
            this.pages.put(new Integer(n2), new JBIG2Page(n2, this));
        }
        if (n2 > 0) {
            ((JBIG2Page)this.pages.get(new Integer(n2))).addSegment(jBIG2Segment);
        } else {
            this.globals.add(jBIG2Segment);
        }
        long l = this.ra.readUnsignedInt();
        jBIG2Segment.dataLength = l;
        int n10 = this.ra.getFilePointer();
        this.ra.seek(n3);
        byte[] byArray = new byte[n10 - n3];
        this.ra.read(byArray);
        JBIG2Segment.access$102(jBIG2Segment, byArray);
        return jBIG2Segment;
    }

    private void readFileHeader() throws IOException {
        int n;
        this.ra.seek(0);
        byte[] byArray = new byte[8];
        this.ra.read(byArray);
        byte[] byArray2 = new byte[]{-105, 74, 66, 50, 13, 10, 26, 10};
        for (n = 0; n < byArray.length; ++n) {
            if (byArray[n] == byArray2[n]) continue;
            throw new IllegalStateException("file header idstring not good at byte " + n);
        }
        n = this.ra.read();
        this.sequential = (n & 1) == 1;
        boolean bl = this.number_of_pages_known = (n & 2) == 0;
        if ((n & 0xFC) != 0) {
            throw new IllegalStateException("file header flags bits 2-7 not 0");
        }
        if (this.number_of_pages_known) {
            this.number_of_pages = this.ra.readInt();
        }
    }

    private int numberOfPages() {
        return this.pages.size();
    }

    JBIG2Page getPage(int n) {
        return (JBIG2Page)this.pages.get(new Integer(n));
    }

    byte[] getGlobal(boolean bl) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            for (JBIG2Segment jBIG2Segment : this.globals) {
                if (bl && (jBIG2Segment.type == 51 || jBIG2Segment.type == 49)) continue;
                byteArrayOutputStream.write(jBIG2Segment.headerData);
                byteArrayOutputStream.write(jBIG2Segment.data);
            }
            byteArrayOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (byteArrayOutputStream.size() <= 0) {
            return null;
        }
        return byteArrayOutputStream.toByteArray();
    }

    public String toString() {
        if (this.read) {
            return "Jbig2SegmentReader: number of pages: " + this.numberOfPages();
        }
        return "Jbig2SegmentReader in indeterminate state.";
    }

    public static class JBIG2Page {
        private final JBIG2SegmentReader sr;
        private final SortedMap segs = new TreeMap();
        int pageBitmapWidth = -1;
        int pageBitmapHeight = -1;

        private JBIG2Page(int n, JBIG2SegmentReader jBIG2SegmentReader) {
            this.sr = jBIG2SegmentReader;
        }

        public byte[] getData(boolean bl) throws IOException {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            for (Integer n : this.segs.keySet()) {
                JBIG2Segment jBIG2Segment = (JBIG2Segment)this.segs.get(n);
                if (bl && (jBIG2Segment.type == 51 || jBIG2Segment.type == 49)) continue;
                if (bl) {
                    byte[] byArray = JBIG2SegmentReader.copyByteArray(jBIG2Segment.headerData);
                    if (jBIG2Segment.page_association_size) {
                        byArray[((JBIG2Segment)jBIG2Segment).page_association_offset] = 0;
                        byArray[((JBIG2Segment)jBIG2Segment).page_association_offset + 1] = 0;
                        byArray[((JBIG2Segment)jBIG2Segment).page_association_offset + 2] = 0;
                        byArray[((JBIG2Segment)jBIG2Segment).page_association_offset + 3] = 1;
                    } else {
                        byArray[((JBIG2Segment)jBIG2Segment).page_association_offset] = 1;
                    }
                    byteArrayOutputStream.write(byArray);
                } else {
                    byteArrayOutputStream.write(jBIG2Segment.headerData);
                }
                byteArrayOutputStream.write(jBIG2Segment.data);
            }
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }

        private void addSegment(JBIG2Segment jBIG2Segment) {
            this.segs.put(new Integer(jBIG2Segment.segmentNumber), jBIG2Segment);
        }
    }

    private static class JBIG2Segment
    implements Comparable {
        private final int segmentNumber;
        private long dataLength = -1L;
        private int page = -1;
        private int[] referredToSegmentNumbers = null;
        private boolean[] segmentRetentionFlags = null;
        private int type = -1;
        private boolean deferredNonRetain = false;
        private int countOfReferredToSegments = -1;
        private byte[] data = null;
        private byte[] headerData = null;
        private boolean page_association_size = false;
        private int page_association_offset = -1;

        private JBIG2Segment(int n) {
            this.segmentNumber = n;
        }

        public int compareTo(Object object) {
            return this.compareTo((JBIG2Segment)object);
        }

        private int compareTo(JBIG2Segment jBIG2Segment) {
            return this.segmentNumber - jBIG2Segment.segmentNumber;
        }

        static /* synthetic */ byte[] access$502(JBIG2Segment jBIG2Segment, byte[] byArray) {
            jBIG2Segment.data = byArray;
            return byArray;
        }

        static /* synthetic */ boolean[] access$1102(JBIG2Segment jBIG2Segment, boolean[] blArray) {
            jBIG2Segment.segmentRetentionFlags = blArray;
            return blArray;
        }

        static /* synthetic */ int[] access$1302(JBIG2Segment jBIG2Segment, int[] nArray) {
            jBIG2Segment.referredToSegmentNumbers = nArray;
            return nArray;
        }

        static /* synthetic */ byte[] access$102(JBIG2Segment jBIG2Segment, byte[] byArray) {
            jBIG2Segment.headerData = byArray;
            return byArray;
        }
    }
}

