/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf.codec;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Image;
import com.lowagie.text.ImgRaw;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfString;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;

public class GifImage {
    private DataInputStream in;
    private int width;
    private int height;
    private boolean gctFlag;
    private boolean lctFlag;
    private boolean interlace;
    private int ix;
    private int iy;
    private int iw;
    private int ih;
    private final byte[] block = new byte[256];
    private int blockSize = 0;
    private int dispose = 0;
    private boolean transparency = false;
    private int transIndex;
    private static final int MaxStackSize = 4096;
    private short[] prefix;
    private byte[] suffix;
    private byte[] pixelStack;
    private byte[] m_out;
    private int m_bpc;
    private int m_gbpc;
    private byte[] m_global_table;
    private byte[] m_curr_table;
    private int m_line_stride;
    private byte[] fromData;
    private URL fromUrl;
    private final ArrayList frames = new ArrayList();

    public GifImage(URL uRL) throws IOException {
        this.fromUrl = uRL;
        InputStream inputStream = null;
        try {
            inputStream = uRL.openStream();
            this.process(inputStream);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    public GifImage(byte[] byArray) throws IOException {
        this.fromData = byArray;
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            this.process(byteArrayInputStream);
        }
        finally {
            if (byteArrayInputStream != null) {
                ((InputStream)byteArrayInputStream).close();
            }
        }
    }

    public int getFrameCount() {
        return this.frames.size();
    }

    public Image getImage(int n) {
        GifFrame gifFrame = (GifFrame)this.frames.get(n - 1);
        return gifFrame.image;
    }

    public int[] getLogicalScreen() {
        return new int[]{this.width, this.height};
    }

    private void process(InputStream inputStream) throws IOException {
        this.in = new DataInputStream(new BufferedInputStream(inputStream));
        this.readHeader();
        this.readContents();
        if (this.frames.isEmpty()) {
            throw new IOException("The file does not contain any valid image.");
        }
    }

    private void readHeader() throws IOException {
        String string = "";
        for (int i = 0; i < 6; ++i) {
            string = string + (char)this.in.read();
        }
        if (!string.startsWith("GIF8")) {
            throw new IOException("Gif signature nor found.");
        }
        this.readLSD();
        if (this.gctFlag) {
            this.m_global_table = this.readColorTable(this.m_gbpc);
        }
    }

    private void readLSD() throws IOException {
        this.width = this.readShort();
        this.height = this.readShort();
        int n = this.in.read();
        this.gctFlag = (n & 0x80) != 0;
        this.m_gbpc = (n & 7) + 1;
    }

    private int readShort() throws IOException {
        return this.in.read() | this.in.read() << 8;
    }

    private int readBlock() throws IOException {
        this.blockSize = this.in.read();
        if (this.blockSize <= 0) {
            this.blockSize = 0;
            return 0;
        }
        for (int i = 0; i < this.blockSize; ++i) {
            int n = this.in.read();
            if (n < 0) {
                this.blockSize = i;
                return this.blockSize;
            }
            this.block[i] = (byte)n;
        }
        return this.blockSize;
    }

    private byte[] readColorTable(int n) throws IOException {
        int n2 = 1 << n;
        int n3 = 3 * n2;
        n = GifImage.newBpc(n);
        byte[] byArray = new byte[(1 << n) * 3];
        this.in.readFully(byArray, 0, n3);
        return byArray;
    }

    private static int newBpc(int n) {
        switch (n) {
            case 1: 
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                return 4;
            }
            default: {
                return 8;
            }
        }
        return n;
    }

    private void readContents() throws IOException {
        boolean bl = false;
        block8: while (!bl) {
            int n = this.in.read();
            switch (n) {
                case 44: {
                    this.readImage();
                    continue block8;
                }
                case 33: {
                    n = this.in.read();
                    switch (n) {
                        case 249: {
                            this.readGraphicControlExt();
                            continue block8;
                        }
                        case 255: {
                            this.readBlock();
                            this.skip();
                            continue block8;
                        }
                    }
                    this.skip();
                    continue block8;
                }
            }
            bl = true;
        }
    }

    private void readImage() throws IOException {
        Object object;
        boolean bl;
        this.ix = this.readShort();
        this.iy = this.readShort();
        this.iw = this.readShort();
        this.ih = this.readShort();
        int n = this.in.read();
        this.lctFlag = (n & 0x80) != 0;
        this.interlace = (n & 0x40) != 0;
        this.m_bpc = GifImage.newBpc(this.m_gbpc);
        if (this.lctFlag) {
            this.m_curr_table = this.readColorTable((n & 7) + 1);
            this.m_bpc = GifImage.newBpc((n & 7) + 1);
        } else {
            this.m_curr_table = this.m_global_table;
        }
        if (this.transparency && this.transIndex >= this.m_curr_table.length / 3) {
            this.transparency = false;
        }
        if (this.transparency && this.m_bpc == 1) {
            byte[] byArray = new byte[12];
            System.arraycopy(this.m_curr_table, 0, byArray, 0, 6);
            this.m_curr_table = byArray;
            this.m_bpc = 2;
        }
        if (!(bl = this.decodeImageData())) {
            this.skip();
        }
        ImgRaw imgRaw = null;
        try {
            imgRaw = new ImgRaw(this.iw, this.ih, 1, this.m_bpc, this.m_out);
            object = new PdfArray();
            ((PdfArray)object).add(PdfName.INDEXED);
            ((PdfArray)object).add(PdfName.DEVICERGB);
            int n2 = this.m_curr_table.length;
            ((PdfArray)object).add(new PdfNumber(n2 / 3 - 1));
            ((PdfArray)object).add(new PdfString(this.m_curr_table));
            PdfDictionary pdfDictionary = new PdfDictionary();
            pdfDictionary.put(PdfName.COLORSPACE, (PdfObject)object);
            imgRaw.setAdditional(pdfDictionary);
            if (this.transparency) {
                imgRaw.setTransparency(new int[]{this.transIndex, this.transIndex});
            }
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
        imgRaw.setOriginalType(3);
        imgRaw.setOriginalData(this.fromData);
        imgRaw.setUrl(this.fromUrl);
        object = new GifFrame();
        ((GifFrame)object).image = imgRaw;
        this.frames.add(object);
    }

    private boolean decodeImageData() throws IOException {
        int n;
        int n2 = this.iw * this.ih;
        boolean bl = false;
        if (this.prefix == null) {
            this.prefix = new short[4096];
        }
        if (this.suffix == null) {
            this.suffix = new byte[4096];
        }
        if (this.pixelStack == null) {
            this.pixelStack = new byte[4097];
        }
        this.m_line_stride = (this.iw * this.m_bpc + 7) / 8;
        this.m_out = new byte[this.m_line_stride * this.ih];
        int n3 = 1;
        int n4 = this.interlace ? 8 : 1;
        int n5 = 0;
        int n6 = 0;
        int n7 = this.in.read();
        int n8 = 1 << n7;
        int n9 = n8 + 1;
        int n10 = n8 + 2;
        int n11 = -1;
        int n12 = n7 + 1;
        int n13 = (1 << n12) - 1;
        for (n = 0; n < n8; ++n) {
            this.prefix[n] = 0;
            this.suffix[n] = (byte)n;
        }
        int n14 = 0;
        int n15 = 0;
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        int n19 = 0;
        int n20 = 0;
        while (n20 < n2) {
            if (n15 == 0) {
                if (n18 < n12) {
                    if (n17 == 0) {
                        n17 = this.readBlock();
                        if (n17 <= 0) {
                            bl = true;
                            break;
                        }
                        n14 = 0;
                    }
                    n19 += (this.block[n14] & 0xFF) << n18;
                    n18 += 8;
                    ++n14;
                    --n17;
                    continue;
                }
                n = n19 & n13;
                n19 >>= n12;
                n18 -= n12;
                if (n > n10 || n == n9) break;
                if (n == n8) {
                    n12 = n7 + 1;
                    n13 = (1 << n12) - 1;
                    n10 = n8 + 2;
                    n11 = -1;
                    continue;
                }
                if (n11 == -1) {
                    this.pixelStack[n15++] = this.suffix[n];
                    n11 = n;
                    n16 = n;
                    continue;
                }
                int n21 = n;
                if (n == n10) {
                    this.pixelStack[n15++] = (byte)n16;
                    n = n11;
                }
                while (n > n8) {
                    this.pixelStack[n15++] = this.suffix[n];
                    n = this.prefix[n];
                }
                n16 = this.suffix[n] & 0xFF;
                if (n10 >= 4096) break;
                this.pixelStack[n15++] = (byte)n16;
                this.prefix[n10] = (short)n11;
                this.suffix[n10] = (byte)n16;
                if ((++n10 & n13) == 0 && n10 < 4096) {
                    ++n12;
                    n13 += n10;
                }
                n11 = n21;
            }
            ++n20;
            this.setPixel(n6, n5, this.pixelStack[--n15]);
            if (++n6 < this.iw) continue;
            n6 = 0;
            if ((n5 += n4) < this.ih) continue;
            if (this.interlace) {
                do {
                    switch (++n3) {
                        case 2: {
                            n5 = 4;
                            break;
                        }
                        case 3: {
                            n5 = 2;
                            n4 = 4;
                            break;
                        }
                        case 4: {
                            n5 = 1;
                            n4 = 2;
                            break;
                        }
                        default: {
                            n5 = this.ih - 1;
                            n4 = 0;
                        }
                    }
                } while (n5 >= this.ih);
                continue;
            }
            n5 = this.ih - 1;
            n4 = 0;
        }
        return bl;
    }

    private void setPixel(int n, int n2, int n3) {
        if (this.m_bpc == 8) {
            int n4 = n + this.iw * n2;
            this.m_out[n4] = (byte)n3;
        } else {
            int n5 = this.m_line_stride * n2 + n / (8 / this.m_bpc);
            int n6 = n3 << 8 - this.m_bpc * (n % (8 / this.m_bpc)) - this.m_bpc;
            int n7 = n5;
            this.m_out[n7] = (byte)(this.m_out[n7] | n6);
        }
    }

    private void readGraphicControlExt() throws IOException {
        this.in.read();
        int n = this.in.read();
        this.dispose = (n & 0x1C) >> 2;
        if (this.dispose == 0) {
            this.dispose = 1;
        }
        this.transparency = (n & 1) != 0;
        this.transIndex = this.in.read();
        this.in.read();
    }

    private void skip() throws IOException {
        do {
            this.readBlock();
        } while (this.blockSize > 0);
    }

    private static class GifFrame {
        private Image image;

        private GifFrame() {
        }
    }
}

