/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.pdf.crypto.AESCipher;
import com.lowagie.text.pdf.crypto.ARCFOUREncryption;

class StandardDecryption {
    private ARCFOUREncryption arcfour;
    private AESCipher cipher;
    private byte[] key;
    private static final int AES_128 = 4;
    private final boolean aes;
    private boolean initiated;
    private final byte[] iv = new byte[16];
    private int ivptr;

    StandardDecryption(byte[] byArray, int n, int n2, int n3) {
        boolean bl = this.aes = n3 == 4;
        if (this.aes) {
            this.key = new byte[n2];
            System.arraycopy(byArray, n, this.key, 0, n2);
        } else {
            this.arcfour = new ARCFOUREncryption();
            this.arcfour.prepareARCFOURKey(byArray, n, n2);
        }
    }

    byte[] update(byte[] byArray, int n, int n2) {
        if (this.aes) {
            if (this.initiated) {
                return this.cipher.update(byArray, n, n2);
            }
            int n3 = Math.min(this.iv.length - this.ivptr, n2);
            System.arraycopy(byArray, n, this.iv, this.ivptr, n3);
            n += n3;
            n2 -= n3;
            this.ivptr += n3;
            if (this.ivptr == this.iv.length) {
                this.cipher = new AESCipher(false, this.key, this.iv);
                this.initiated = true;
                if (n2 > 0) {
                    return this.cipher.update(byArray, n, n2);
                }
            }
            return null;
        }
        byte[] byArray2 = new byte[n2];
        this.arcfour.encryptARCFOUR(byArray, n, n2, byArray2, 0);
        return byArray2;
    }

    byte[] finish() {
        if (this.aes) {
            return this.cipher.doFinal();
        }
        return null;
    }
}

