/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNull;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.xml.simpleparser.SimpleXMLDocHandler;
import com.lowagie.text.xml.simpleparser.SimpleXMLParser;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

final class SimpleNamedDestination
implements SimpleXMLDocHandler {
    private HashMap xmlNames;
    private HashMap xmlLast;

    private SimpleNamedDestination() {
    }

    private static void exportToXML(HashMap hashMap, Writer writer, String string, boolean bl) throws IOException {
        writer.write("<?xml version=\"1.0\" encoding=\"");
        writer.write(SimpleXMLParser.escapeXML(string, bl));
        writer.write("\"?>\n<Destination>\n");
        for (Map.Entry entry : hashMap.entrySet()) {
            String string2 = (String)entry.getKey();
            String string3 = (String)entry.getValue();
            writer.write("  <Name Page=\"");
            writer.write(SimpleXMLParser.escapeXML(string3, bl));
            writer.write("\">");
            writer.write(SimpleXMLParser.escapeXML(SimpleNamedDestination.escapeBinaryString(string2), bl));
            writer.write("</Name>\n");
        }
        writer.write("</Destination>\n");
        writer.flush();
    }

    private static PdfArray createDestinationArray(String string, PdfWriter pdfWriter) {
        PdfArray pdfArray = new PdfArray();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n = Integer.parseInt(stringTokenizer.nextToken());
        pdfArray.add(pdfWriter.getPageReference(n));
        if (!stringTokenizer.hasMoreTokens()) {
            pdfArray.add(PdfName.XYZ);
            pdfArray.add(new float[]{0.0f, 10000.0f, 0.0f});
        } else {
            String string2 = stringTokenizer.nextToken();
            if (string2.startsWith("/")) {
                string2 = string2.substring(1);
            }
            pdfArray.add(new PdfName(string2));
            for (int i = 0; i < 4 && stringTokenizer.hasMoreTokens(); ++i) {
                string2 = stringTokenizer.nextToken();
                if (string2.equals("null")) {
                    pdfArray.add(PdfNull.PDFNULL);
                    continue;
                }
                pdfArray.add(new PdfNumber(string2));
            }
        }
        return pdfArray;
    }

    static String escapeBinaryString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (char c : string.toCharArray()) {
            if (c < ' ') {
                stringBuffer.append('\\');
                String string2 = "00" + Integer.toOctalString(c);
                stringBuffer.append(string2.substring(string2.length() - 3));
                continue;
            }
            if (c == '\\') {
                stringBuffer.append("\\\\");
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    static String unEscapeBinaryString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            char c = cArray[i];
            if (c == '\\') {
                if (++i >= n) {
                    stringBuffer.append('\\');
                    break;
                }
                c = cArray[i];
                if (c >= '0' && c <= '7') {
                    int n2 = c - 48;
                    ++i;
                    for (int j = 0; j < 2 && i < n && (c = cArray[i]) >= '0' && c <= '7'; ++i, ++j) {
                        n2 = n2 * 8 + c - 48;
                    }
                    --i;
                    stringBuffer.append((char)n2);
                    continue;
                }
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    @Override
    public void endDocument() {
    }

    @Override
    public void endElement(String string) {
        if (string.equals("Destination")) {
            if (this.xmlLast == null && this.xmlNames != null) {
                return;
            }
            throw new RuntimeException("Destination end tag out of place.");
        }
        if (!string.equals("Name")) {
            throw new RuntimeException("Invalid end tag - " + string);
        }
        if (this.xmlLast == null || this.xmlNames == null) {
            throw new RuntimeException("Name end tag out of place.");
        }
        if (!this.xmlLast.containsKey("Page")) {
            throw new RuntimeException("Page attribute missing.");
        }
        this.xmlNames.put(SimpleNamedDestination.unEscapeBinaryString((String)this.xmlLast.get("Name")), this.xmlLast.get("Page"));
        this.xmlLast = null;
    }

    @Override
    public void startDocument() {
    }

    @Override
    public void startElement(String string, HashMap hashMap) {
        if (this.xmlNames == null) {
            if (string.equals("Destination")) {
                this.xmlNames = new HashMap();
                return;
            }
            throw new RuntimeException("Root element is not Destination.");
        }
        if (!string.equals("Name")) {
            throw new RuntimeException("Tag " + string + " not allowed.");
        }
        if (this.xmlLast != null) {
            throw new RuntimeException("Nested tags are not allowed.");
        }
        this.xmlLast = new HashMap(hashMap);
        this.xmlLast.put("Name", "");
    }

    @Override
    public void text(String string) {
        if (this.xmlLast == null) {
            return;
        }
        String string2 = (String)this.xmlLast.get("Name");
        string2 = string2 + string;
        this.xmlLast.put("Name", string2);
    }
}

