/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;

public class PdfTransition {
    private static final int SPLITVOUT = 1;
    private static final int SPLITHOUT = 2;
    private static final int SPLITVIN = 3;
    private static final int SPLITHIN = 4;
    private static final int BLINDV = 5;
    private static final int BLINDH = 6;
    private static final int INBOX = 7;
    private static final int OUTBOX = 8;
    private static final int LRWIPE = 9;
    private static final int RLWIPE = 10;
    private static final int BTWIPE = 11;
    private static final int TBWIPE = 12;
    private static final int DISSOLVE = 13;
    private static final int LRGLITTER = 14;
    private static final int TBGLITTER = 15;
    private static final int DGLITTER = 16;
    private final int duration;
    private final int type;

    public PdfTransition() {
        this(6);
    }

    private PdfTransition(int n) {
        this(n, 1);
    }

    private PdfTransition(int n, int n2) {
        this.duration = n2;
        this.type = n;
    }

    public int getDuration() {
        return this.duration;
    }

    public int getType() {
        return this.type;
    }

    public PdfDictionary getTransitionDictionary() {
        PdfDictionary pdfDictionary = new PdfDictionary(PdfName.TRANS);
        switch (this.type) {
            case 1: {
                pdfDictionary.put(PdfName.S, PdfName.SPLIT);
                pdfDictionary.put(PdfName.D, new PdfNumber(this.duration));
                pdfDictionary.put(PdfName.DM, PdfName.V);
                pdfDictionary.put(PdfName.M, PdfName.O);
                break;
            }
            case 2: {
                pdfDictionary.put(PdfName.S, PdfName.SPLIT);
                pdfDictionary.put(PdfName.D, new PdfNumber(this.duration));
                pdfDictionary.put(PdfName.DM, PdfName.H);
                pdfDictionary.put(PdfName.M, PdfName.O);
                break;
            }
            case 3: {
                pdfDictionary.put(PdfName.S, PdfName.SPLIT);
                pdfDictionary.put(PdfName.D, new PdfNumber(this.duration));
                pdfDictionary.put(PdfName.DM, PdfName.V);
                pdfDictionary.put(PdfName.M, PdfName.I);
                break;
            }
            case 4: {
                pdfDictionary.put(PdfName.S, PdfName.SPLIT);
                pdfDictionary.put(PdfName.D, new PdfNumber(this.duration));
                pdfDictionary.put(PdfName.DM, PdfName.H);
                pdfDictionary.put(PdfName.M, PdfName.I);
                break;
            }
            case 5: {
                pdfDictionary.put(PdfName.S, PdfName.BLINDS);
                pdfDictionary.put(PdfName.D, new PdfNumber(this.duration));
                pdfDictionary.put(PdfName.DM, PdfName.V);
                break;
            }
            case 6: {
                pdfDictionary.put(PdfName.S, PdfName.BLINDS);
                pdfDictionary.put(PdfName.D, new PdfNumber(this.duration));
                pdfDictionary.put(PdfName.DM, PdfName.H);
                break;
            }
            case 7: {
                pdfDictionary.put(PdfName.S, PdfName.BOX);
                pdfDictionary.put(PdfName.D, new PdfNumber(this.duration));
                pdfDictionary.put(PdfName.M, PdfName.I);
                break;
            }
            case 8: {
                pdfDictionary.put(PdfName.S, PdfName.BOX);
                pdfDictionary.put(PdfName.D, new PdfNumber(this.duration));
                pdfDictionary.put(PdfName.M, PdfName.O);
                break;
            }
            case 9: {
                pdfDictionary.put(PdfName.S, PdfName.WIPE);
                pdfDictionary.put(PdfName.D, new PdfNumber(this.duration));
                pdfDictionary.put(PdfName.DI, new PdfNumber(0));
                break;
            }
            case 10: {
                pdfDictionary.put(PdfName.S, PdfName.WIPE);
                pdfDictionary.put(PdfName.D, new PdfNumber(this.duration));
                pdfDictionary.put(PdfName.DI, new PdfNumber(180));
                break;
            }
            case 11: {
                pdfDictionary.put(PdfName.S, PdfName.WIPE);
                pdfDictionary.put(PdfName.D, new PdfNumber(this.duration));
                pdfDictionary.put(PdfName.DI, new PdfNumber(90));
                break;
            }
            case 12: {
                pdfDictionary.put(PdfName.S, PdfName.WIPE);
                pdfDictionary.put(PdfName.D, new PdfNumber(this.duration));
                pdfDictionary.put(PdfName.DI, new PdfNumber(270));
                break;
            }
            case 13: {
                pdfDictionary.put(PdfName.S, PdfName.DISSOLVE);
                pdfDictionary.put(PdfName.D, new PdfNumber(this.duration));
                break;
            }
            case 14: {
                pdfDictionary.put(PdfName.S, PdfName.GLITTER);
                pdfDictionary.put(PdfName.D, new PdfNumber(this.duration));
                pdfDictionary.put(PdfName.DI, new PdfNumber(0));
                break;
            }
            case 15: {
                pdfDictionary.put(PdfName.S, PdfName.GLITTER);
                pdfDictionary.put(PdfName.D, new PdfNumber(this.duration));
                pdfDictionary.put(PdfName.DI, new PdfNumber(270));
                break;
            }
            case 16: {
                pdfDictionary.put(PdfName.S, PdfName.GLITTER);
                pdfDictionary.put(PdfName.D, new PdfNumber(this.duration));
                pdfDictionary.put(PdfName.DI, new PdfNumber(315));
            }
        }
        return pdfDictionary;
    }
}

