/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Image;
import com.lowagie.text.Rectangle;
import com.lowagie.text.exceptions.BadPasswordException;
import com.lowagie.text.pdf.AcroFields;
import com.lowagie.text.pdf.ByteBuffer;
import com.lowagie.text.pdf.IntHashtable;
import com.lowagie.text.pdf.PRIndirectReference;
import com.lowagie.text.pdf.PRStream;
import com.lowagie.text.pdf.PageResources;
import com.lowagie.text.pdf.PdfAction;
import com.lowagie.text.pdf.PdfAnnotation;
import com.lowagie.text.pdf.PdfAppearance;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfContents;
import com.lowagie.text.pdf.PdfDate;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfDocument;
import com.lowagie.text.pdf.PdfEncryption;
import com.lowagie.text.pdf.PdfException;
import com.lowagie.text.pdf.PdfFormField;
import com.lowagie.text.pdf.PdfIndirectObject;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfLayer;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNameTree;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfRectangle;
import com.lowagie.text.pdf.PdfStream;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfTransition;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.RandomAccessFileOrArray;
import com.lowagie.text.pdf.StampContent;
import com.lowagie.text.pdf.internal.PdfViewerPreferencesImp;
import com.lowagie.text.xml.xmp.XmpReader;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.ListIterator;
import java.util.Map;
import org.xml.sax.SAXException;

public class PdfStamperImp
extends PdfWriter {
    private PdfObject pdfFileID = null;
    private final HashMap readers2intrefs = new LinkedHashMap();
    private final HashMap readers2file = new LinkedHashMap();
    private final RandomAccessFileOrArray file;
    PdfReader reader;
    private final IntHashtable myXref = new IntHashtable();
    private final HashMap pagesToContent = new LinkedHashMap();
    private boolean closed = false;
    private boolean rotateContents = true;
    private AcroFields acroFields;
    private boolean flat = false;
    private boolean flatFreeText = false;
    private final int[] namePtr = new int[]{0};
    private final HashSet partialFlattening = new HashSet();
    private boolean useVp = false;
    private final PdfViewerPreferencesImp viewerPreferences = new PdfViewerPreferencesImp();
    private final HashMap fieldTemplates = new LinkedHashMap();
    private boolean fieldsAdded = false;
    private int sigFlags = 0;
    private final boolean append;
    private IntHashtable marked;
    private final int initialXrefSize;
    private PdfAction openAction;

    PdfStamperImp(PdfReader pdfReader, OutputStream outputStream, char c, boolean bl, Calendar calendar) throws DocumentException, IOException {
        super(new PdfDocument(calendar), outputStream);
        if (!pdfReader.isOpenedWithFullPermissions()) {
            throw new BadPasswordException("PdfReader not opened with owner password");
        }
        if (pdfReader.isTampered()) {
            throw new DocumentException("The original document was reused. Read it again from file.");
        }
        pdfReader.setTampered(true);
        this.reader = pdfReader;
        this.file = pdfReader.getSafeFile();
        this.append = bl;
        if (bl) {
            int n;
            if (pdfReader.isRebuilt()) {
                throw new DocumentException("Append mode requires a document without errors even if recovery was possible.");
            }
            if (pdfReader.isEncrypted()) {
                this.crypto = new PdfEncryption(pdfReader.getDecrypt());
            }
            this.pdf_version.setAppendmode(true);
            this.file.reOpen();
            byte[] byArray = new byte[8192];
            while ((n = this.file.read(byArray)) > 0) {
                this.os.write(byArray, 0, n);
            }
            this.file.close();
            this.prevxref = pdfReader.getLastXref();
            pdfReader.setAppendable(true);
        } else if (c == '\u0000') {
            super.setPdfVersion(pdfReader.getPdfVersion());
        } else {
            super.setPdfVersion(c);
        }
        super.open();
        this.pdf.addWriter(this);
        if (bl) {
            this.body.setRefnum(pdfReader.getXrefSize());
            this.marked = new IntHashtable();
            if (pdfReader.isNewXrefType()) {
                this.fullCompression = true;
            }
            if (pdfReader.isHybridXref()) {
                this.fullCompression = false;
            }
        }
        this.initialXrefSize = pdfReader.getXrefSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(HashMap hashMap, Calendar calendar) throws IOException {
        PdfObject pdfObject;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        PdfObject pdfObject2;
        if (this.closed) {
            return;
        }
        if (this.useVp) {
            this.reader.setViewerPreferences(this.viewerPreferences);
            this.markUsed(this.reader.getTrailer().get(PdfName.ROOT));
        }
        if (this.flat) {
            this.flatFields();
        }
        if (this.flatFreeText) {
            this.flatFreeTextFields();
        }
        this.addFieldResources();
        PdfDictionary pdfDictionary = this.reader.getCatalog();
        PdfDictionary pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.PAGES));
        pdfDictionary2.put(PdfName.ITXT, new PdfString(Document.getRelease()));
        this.markUsed(pdfDictionary2);
        PdfDictionary pdfDictionary3 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.ACROFORM), this.reader.getCatalog());
        if (this.acroFields != null && this.acroFields.getXfa().isChanged()) {
            this.markUsed(pdfDictionary3);
            if (!this.flat) {
                this.acroFields.getXfa().setXfa(this);
            }
        }
        if (this.sigFlags != 0 && pdfDictionary3 != null) {
            pdfDictionary3.put(PdfName.SIGFLAGS, new PdfNumber(this.sigFlags));
            this.markUsed(pdfDictionary3);
            this.markUsed(pdfDictionary);
        }
        this.closed = true;
        this.addSharedObjectsToBody();
        this.setOutlines();
        this.setJavaScript();
        this.addFileAttachments();
        if (this.openAction != null) {
            pdfDictionary.put(PdfName.OPENACTION, this.openAction);
        }
        if (this.pdf.pageLabels != null) {
            pdfDictionary.put(PdfName.PAGELABELS, this.pdf.pageLabels.getDictionary(this));
        }
        if (!this.documentOCG.isEmpty()) {
            this.fillOCProperties(false);
            PdfDictionary pdfDictionary4 = pdfDictionary.getAsDict(PdfName.OCPROPERTIES);
            if (pdfDictionary4 == null) {
                this.reader.getCatalog().put(PdfName.OCPROPERTIES, this.OCProperties);
            } else {
                pdfDictionary4.put(PdfName.OCGS, this.OCProperties.get(PdfName.OCGS));
                pdfObject2 = pdfDictionary4.getAsDict(PdfName.D);
                if (pdfObject2 == null) {
                    pdfObject2 = new PdfDictionary();
                    pdfDictionary4.put(PdfName.D, pdfObject2);
                }
                ((PdfDictionary)pdfObject2).put(PdfName.ORDER, this.OCProperties.getAsDict(PdfName.D).get(PdfName.ORDER));
                ((PdfDictionary)pdfObject2).put(PdfName.RBGROUPS, this.OCProperties.getAsDict(PdfName.D).get(PdfName.RBGROUPS));
                ((PdfDictionary)pdfObject2).put(PdfName.OFF, this.OCProperties.getAsDict(PdfName.D).get(PdfName.OFF));
                ((PdfDictionary)pdfObject2).put(PdfName.AS, this.OCProperties.getAsDict(PdfName.D).get(PdfName.AS));
            }
        }
        int n = -1;
        pdfObject2 = (PRIndirectReference)this.reader.getTrailer().get(PdfName.INFO);
        PdfDictionary pdfDictionary5 = (PdfDictionary)PdfReader.getPdfObject(pdfObject2);
        String string = null;
        if (pdfObject2 != null) {
            n = ((PdfIndirectReference)pdfObject2).getNumber();
        }
        if (pdfDictionary5 != null && pdfDictionary5.get(PdfName.PRODUCER) != null) {
            string = pdfDictionary5.getAsString(PdfName.PRODUCER).toString();
        }
        if (string == null) {
            string = Document.getVersion();
        } else if (string.indexOf(Document.getProduct()) == -1) {
            object4 = new StringBuffer(string);
            ((StringBuffer)object4).append("; modified using ");
            ((StringBuffer)object4).append(Document.getVersion());
            string = ((StringBuffer)object4).toString();
        }
        object4 = null;
        PdfObject pdfObject3 = PdfReader.getPdfObject(pdfDictionary.get(PdfName.METADATA));
        if (pdfObject3 != null && pdfObject3.isStream()) {
            object4 = PdfReader.getStreamBytesRaw((PRStream)pdfObject3);
            PdfReader.killIndirect(pdfDictionary.get(PdfName.METADATA));
        }
        if (this.xmpMetadata != null) {
            object4 = this.xmpMetadata;
        }
        PdfDate pdfDate = new PdfDate(calendar);
        if (object4 != null) {
            PdfStream pdfStream;
            try {
                object3 = new XmpReader((byte[])object4);
                if (!((XmpReader)object3).replace("http://ns.adobe.com/pdf/1.3/", "Producer", string)) {
                    ((XmpReader)object3).add("rdf:Description", "http://ns.adobe.com/pdf/1.3/", "pdf:Producer", string);
                }
                if (!((XmpReader)object3).replace("http://ns.adobe.com/xap/1.0/", "ModifyDate", pdfDate.getW3CDate())) {
                    ((XmpReader)object3).add("rdf:Description", "http://ns.adobe.com/xap/1.0/", "xmp:ModifyDate", pdfDate.getW3CDate());
                }
                ((XmpReader)object3).replace("http://ns.adobe.com/xap/1.0/", "MetadataDate", pdfDate.getW3CDate());
                pdfStream = new PdfStream(((XmpReader)object3).serializeDoc());
            }
            catch (SAXException sAXException) {
                pdfStream = new PdfStream((byte[])object4);
            }
            catch (IOException iOException) {
                pdfStream = new PdfStream((byte[])object4);
            }
            pdfStream.put(PdfName.TYPE, PdfName.METADATA);
            pdfStream.put(PdfName.SUBTYPE, PdfName.XML);
            if (this.crypto != null && !this.crypto.isMetadataEncrypted()) {
                object3 = new PdfArray();
                ((PdfArray)object3).add(PdfName.CRYPT);
                pdfStream.put(PdfName.FILTER, (PdfObject)object3);
            }
            if (this.append && pdfObject3 != null) {
                this.body.add((PdfObject)pdfStream, pdfObject3.getIndRef());
            } else {
                pdfDictionary.put(PdfName.METADATA, this.body.add(pdfStream).getIndirectReference());
                this.markUsed(pdfDictionary);
            }
        }
        try {
            this.file.reOpen();
            this.alterContents();
            int n2 = ((PRIndirectReference)this.reader.trailer.get(PdfName.ROOT)).getNumber();
            if (this.append) {
                for (Object object5 : object3 = (Object)this.marked.getKeys()) {
                    object2 = this.reader.getPdfObjectRelease((int)object5);
                    if (object2 == null || n == object5 || object5 >= this.initialXrefSize) continue;
                    this.addToBody((PdfObject)object2, (int)object5, object5 != n2);
                }
                for (int i = this.initialXrefSize; i < this.reader.getXrefSize(); ++i) {
                    PdfObject pdfObject4 = this.reader.getPdfObject(i);
                    if (pdfObject4 == null) continue;
                    this.addToBody(pdfObject4, this.getNewObjectNumber(this.reader, i, 0));
                }
            } else {
                for (int i = 1; i < this.reader.getXrefSize(); ++i) {
                    PdfObject pdfObject5 = this.reader.getPdfObjectRelease(i);
                    if (pdfObject5 == null || n == i) continue;
                    this.addToBody(pdfObject5, this.getNewObjectNumber(this.reader, i, 0), i != n2);
                }
            }
        }
        finally {
            try {
                this.file.close();
            }
            catch (Exception exception) {}
        }
        PdfIndirectReference pdfIndirectReference = null;
        PdfObject pdfObject6 = null;
        if (this.crypto != null) {
            if (this.append) {
                pdfIndirectReference = this.reader.getCryptoRef();
            } else {
                PdfIndirectObject pdfIndirectObject = this.addToBody((PdfObject)this.crypto.getEncryptionDictionary(), false);
                pdfIndirectReference = pdfIndirectObject.getIndirectReference();
            }
            pdfObject6 = this.crypto.getFileID();
        } else {
            pdfObject6 = PdfEncryption.createInfoId(PdfEncryption.createDocumentId());
        }
        this.pdfFileID = pdfObject6;
        PRIndirectReference pRIndirectReference = (PRIndirectReference)this.reader.trailer.get(PdfName.ROOT);
        PdfIndirectReference pdfIndirectReference2 = new PdfIndirectReference(0, this.getNewObjectNumber(this.reader, pRIndirectReference.getNumber(), 0));
        PdfIndirectReference pdfIndirectReference3 = null;
        PdfDictionary pdfDictionary6 = new PdfDictionary();
        if (pdfDictionary5 != null) {
            for (Map.Entry entry : pdfDictionary5.getKeys()) {
                object = (PdfName)((Object)entry);
                pdfObject = PdfReader.getPdfObject(pdfDictionary5.get((PdfName)object));
                pdfDictionary6.put((PdfName)object, pdfObject);
            }
        }
        if (hashMap != null) {
            for (Map.Entry entry : hashMap.entrySet()) {
                object = (String)entry.getKey();
                pdfObject = new PdfName((String)object);
                String string2 = (String)entry.getValue();
                if (string2 == null) {
                    pdfDictionary6.remove((PdfName)pdfObject);
                    continue;
                }
                pdfDictionary6.put((PdfName)pdfObject, new PdfString(string2, "UnicodeBig"));
            }
        }
        pdfDictionary6.put(PdfName.MODDATE, pdfDate);
        pdfDictionary6.put(PdfName.PRODUCER, new PdfString(string));
        pdfIndirectReference3 = this.append ? (pdfObject2 == null ? this.addToBody((PdfObject)pdfDictionary6, false).getIndirectReference() : this.addToBody((PdfObject)pdfDictionary6, ((PdfIndirectReference)pdfObject2).getNumber(), false).getIndirectReference()) : this.addToBody((PdfObject)pdfDictionary6, false).getIndirectReference();
        this.body.writeCrossReferenceTable(this.os, pdfIndirectReference2, pdfIndirectReference3, pdfIndirectReference, pdfObject6, this.prevxref);
        if (this.fullCompression) {
            this.os.write(PdfStamperImp.getISOBytes("startxref\n"));
            this.os.write(PdfStamperImp.getISOBytes(String.valueOf(this.body.offset())));
            this.os.write(PdfStamperImp.getISOBytes("\n%%EOF\n"));
        } else {
            object2 = new PdfWriter.PdfTrailer(this.body.size(), this.body.offset(), pdfIndirectReference2, pdfIndirectReference3, pdfIndirectReference, pdfObject6, this.prevxref);
            ((PdfWriter.PdfTrailer)object2).toPdf(this, this.os);
        }
        this.os.flush();
        if (this.isCloseStream()) {
            this.os.close();
        }
        this.reader.close();
    }

    private void applyRotation(PdfDictionary pdfDictionary, ByteBuffer byteBuffer) {
        if (!this.rotateContents) {
            return;
        }
        Rectangle rectangle = this.reader.getPageSizeWithRotation(pdfDictionary);
        int n = rectangle.getRotation();
        switch (n) {
            case 90: {
                byteBuffer.append(PdfContents.ROTATE90);
                byteBuffer.append(rectangle.getTop());
                byteBuffer.append(' ').append('0').append(PdfContents.ROTATEFINAL);
                break;
            }
            case 180: {
                byteBuffer.append(PdfContents.ROTATE180);
                byteBuffer.append(rectangle.getRight());
                byteBuffer.append(' ');
                byteBuffer.append(rectangle.getTop());
                byteBuffer.append(PdfContents.ROTATEFINAL);
                break;
            }
            case 270: {
                byteBuffer.append(PdfContents.ROTATE270);
                byteBuffer.append('0').append(' ');
                byteBuffer.append(rectangle.getRight());
                byteBuffer.append(PdfContents.ROTATEFINAL);
            }
        }
    }

    private void alterContents() throws IOException {
        for (PageStamp pageStamp : this.pagesToContent.values()) {
            PdfDictionary pdfDictionary = pageStamp.pageN;
            this.markUsed(pdfDictionary);
            PdfArray pdfArray = null;
            PdfObject pdfObject = PdfReader.getPdfObject(pdfDictionary.get(PdfName.CONTENTS), pdfDictionary);
            if (pdfObject == null) {
                pdfArray = new PdfArray();
                pdfDictionary.put(PdfName.CONTENTS, pdfArray);
            } else if (pdfObject.isArray()) {
                pdfArray = (PdfArray)pdfObject;
                this.markUsed(pdfArray);
            } else if (pdfObject.isStream()) {
                pdfArray = new PdfArray();
                pdfArray.add(pdfDictionary.get(PdfName.CONTENTS));
                pdfDictionary.put(PdfName.CONTENTS, pdfArray);
            } else {
                pdfArray = new PdfArray();
                pdfDictionary.put(PdfName.CONTENTS, pdfArray);
            }
            ByteBuffer byteBuffer = new ByteBuffer();
            if (pageStamp.under != null) {
                byteBuffer.append(PdfContents.SAVESTATE);
                this.applyRotation(pdfDictionary, byteBuffer);
                byteBuffer.append(pageStamp.under.getInternalBuffer());
                byteBuffer.append(PdfContents.RESTORESTATE);
            }
            if (pageStamp.over != null) {
                byteBuffer.append(PdfContents.SAVESTATE);
            }
            PdfStream pdfStream = new PdfStream(byteBuffer.toByteArray());
            pdfStream.flateCompress(this.compressionLevel);
            pdfArray.addFirst(this.addToBody(pdfStream).getIndirectReference());
            byteBuffer.reset();
            if (pageStamp.over != null) {
                byteBuffer.append(' ');
                byteBuffer.append(PdfContents.RESTORESTATE);
                ByteBuffer byteBuffer2 = pageStamp.over.getInternalBuffer();
                byteBuffer.append(byteBuffer2.getBuffer(), 0, 0);
                byteBuffer.append(PdfContents.SAVESTATE);
                this.applyRotation(pdfDictionary, byteBuffer);
                byteBuffer.append(byteBuffer2.getBuffer(), 0, byteBuffer2.size() - 0);
                byteBuffer.append(PdfContents.RESTORESTATE);
                pdfStream = new PdfStream(byteBuffer.toByteArray());
                pdfStream.flateCompress(this.compressionLevel);
                pdfArray.add(this.addToBody(pdfStream).getIndirectReference());
            }
            this.alterResources(pageStamp);
        }
    }

    private void alterResources(PageStamp pageStamp) {
        pageStamp.pageN.put(PdfName.RESOURCES, pageStamp.pageResources.getResources());
    }

    @Override
    protected int getNewObjectNumber(PdfReader pdfReader, int n, int n2) {
        IntHashtable intHashtable = (IntHashtable)this.readers2intrefs.get(pdfReader);
        if (intHashtable != null) {
            int n3 = intHashtable.get(n);
            if (n3 == 0) {
                n3 = this.getIndirectReferenceNumber();
                intHashtable.put(n, n3);
            }
            return n3;
        }
        if (this.currentPdfReaderInstance == null) {
            if (this.append && n < this.initialXrefSize) {
                return n;
            }
            int n4 = this.myXref.get(n);
            if (n4 == 0) {
                n4 = this.getIndirectReferenceNumber();
                this.myXref.put(n, n4);
            }
            return n4;
        }
        return this.currentPdfReaderInstance.getNewObjectNumber(n, n2);
    }

    @Override
    RandomAccessFileOrArray getReaderFile(PdfReader pdfReader) {
        if (this.readers2intrefs.containsKey(pdfReader)) {
            RandomAccessFileOrArray randomAccessFileOrArray = (RandomAccessFileOrArray)this.readers2file.get(pdfReader);
            if (randomAccessFileOrArray != null) {
                return randomAccessFileOrArray;
            }
            return pdfReader.getSafeFile();
        }
        if (this.currentPdfReaderInstance == null) {
            return this.file;
        }
        return this.currentPdfReaderInstance.getReaderFile();
    }

    private void registerReader(PdfReader pdfReader, boolean bl) throws IOException {
        if (this.readers2intrefs.containsKey(pdfReader)) {
            return;
        }
        this.readers2intrefs.put(pdfReader, new IntHashtable());
        if (bl) {
            RandomAccessFileOrArray randomAccessFileOrArray = pdfReader.getSafeFile();
            this.readers2file.put(pdfReader, randomAccessFileOrArray);
            randomAccessFileOrArray.reOpen();
        }
    }

    private static void findAllObjects(PdfReader pdfReader, PdfObject pdfObject, IntHashtable intHashtable) {
        if (pdfObject == null) {
            return;
        }
        switch (pdfObject.type()) {
            case 10: {
                PRIndirectReference pRIndirectReference = (PRIndirectReference)pdfObject;
                if (pdfReader != pRIndirectReference.getReader()) {
                    return;
                }
                if (intHashtable.containsKey(pRIndirectReference.getNumber())) {
                    return;
                }
                intHashtable.put(pRIndirectReference.getNumber(), 1);
                PdfStamperImp.findAllObjects(pdfReader, PdfReader.getPdfObject(pdfObject), intHashtable);
                return;
            }
            case 5: {
                PdfArray pdfArray = (PdfArray)pdfObject;
                for (int i = 0; i < pdfArray.size(); ++i) {
                    PdfStamperImp.findAllObjects(pdfReader, pdfArray.getPdfObject(i), intHashtable);
                }
                return;
            }
            case 6: 
            case 7: {
                PdfDictionary pdfDictionary = (PdfDictionary)pdfObject;
                Iterator<PdfName> iterator = pdfDictionary.getKeys().iterator();
                while (iterator.hasNext()) {
                    PdfName pdfName;
                    PdfName pdfName2 = pdfName = iterator.next();
                    PdfStamperImp.findAllObjects(pdfReader, pdfDictionary.get(pdfName2), intHashtable);
                }
                return;
            }
        }
    }

    private PageStamp getPageStamp(int n) {
        PdfDictionary pdfDictionary = this.reader.getPageN(n);
        PageStamp pageStamp = (PageStamp)this.pagesToContent.get(pdfDictionary);
        if (pageStamp == null) {
            pageStamp = new PageStamp(this, this.reader, pdfDictionary);
            this.pagesToContent.put(pdfDictionary, pageStamp);
        }
        return pageStamp;
    }

    PdfContentByte getOverContent(int n) {
        if (n < 1 || n > this.reader.getNumberOfPages()) {
            return null;
        }
        PageStamp pageStamp = this.getPageStamp(n);
        if (pageStamp.over == null) {
            pageStamp.over = new StampContent(this, pageStamp);
        }
        return pageStamp.over;
    }

    private void correctAcroFieldPages(int n) {
        if (this.acroFields == null) {
            return;
        }
        if (n > this.reader.getNumberOfPages()) {
            return;
        }
        HashMap hashMap = this.acroFields.getFields();
        for (AcroFields.Item item : hashMap.values()) {
            for (int i = 0; i < item.size(); ++i) {
                int n2 = item.getPage(i);
                if (n2 < n) continue;
                item.forcePage(i, n2 + 1);
            }
        }
    }

    private static void moveRectangle(PdfDictionary pdfDictionary, PdfReader pdfReader, int n, PdfName pdfName, String string) {
        Rectangle rectangle = pdfReader.getBoxSize(n, string);
        if (rectangle == null) {
            pdfDictionary.remove(pdfName);
        } else {
            pdfDictionary.put(pdfName, new PdfRectangle(rectangle));
        }
    }

    boolean isRotateContents() {
        return this.rotateContents;
    }

    void setRotateContents(boolean bl) {
        this.rotateContents = bl;
    }

    boolean isContentWritten() {
        return this.body.size() > 1;
    }

    AcroFields getAcroFields() {
        if (this.acroFields == null) {
            this.acroFields = new AcroFields(this.reader, this);
        }
        return this.acroFields;
    }

    void setFormFlattening(boolean bl) {
        this.flat = bl;
    }

    void setFreeTextFlattening(boolean bl) {
        this.flatFreeText = bl;
    }

    private void flatFields() {
        Object object;
        Object object2;
        if (this.append) {
            throw new IllegalArgumentException("Field flattening is not supported in append mode.");
        }
        this.getAcroFields();
        HashMap hashMap = this.acroFields.getFields();
        if (this.fieldsAdded && this.partialFlattening.isEmpty()) {
            object2 = hashMap.keySet().iterator();
            while (object2.hasNext()) {
                this.partialFlattening.add(object2.next());
            }
        }
        object2 = this.reader.getCatalog().getAsDict(PdfName.ACROFORM);
        PdfArray pdfArray = null;
        if (object2 != null) {
            pdfArray = (PdfArray)PdfReader.getPdfObject(((PdfDictionary)object2).get(PdfName.FIELDS), (PdfObject)object2);
        }
        for (Map.Entry object3 : hashMap.entrySet()) {
            object = (String)object3.getKey();
            if (!this.partialFlattening.isEmpty() && !this.partialFlattening.contains(object)) continue;
            AcroFields.Item item = (AcroFields.Item)object3.getValue();
            for (int pdfObject = 0; pdfObject < item.size(); ++pdfObject) {
                PdfIndirectReference pdfIndirectReference;
                Object object4;
                Object object5;
                PdfObject pdfObject2;
                PdfDictionary pdfDictionary = item.getMerged(pdfObject);
                PdfNumber pdfNumber = pdfDictionary.getAsNumber(PdfName.F);
                int n = 0;
                if (pdfNumber != null) {
                    n = pdfNumber.intValue();
                }
                int n2 = item.getPage(pdfObject);
                PdfDictionary pdfDictionary2 = pdfDictionary.getAsDict(PdfName.AP);
                if (pdfDictionary2 != null && (n & 4) != 0 && (n & 2) == 0) {
                    Object object6;
                    pdfObject2 = pdfDictionary2.get(PdfName.N);
                    object5 = null;
                    if (pdfObject2 != null) {
                        object6 = PdfReader.getPdfObject(pdfObject2);
                        if (pdfObject2 instanceof PdfIndirectReference && !pdfObject2.isIndirect()) {
                            object5 = new PdfAppearance((PdfIndirectReference)pdfObject2);
                        } else if (object6 instanceof PdfStream) {
                            ((PdfDictionary)object6).put(PdfName.SUBTYPE, PdfName.FORM);
                            object5 = new PdfAppearance((PdfIndirectReference)pdfObject2);
                        } else if (object6 != null && ((PdfObject)object6).isDictionary() && (object4 = pdfDictionary.getAsName(PdfName.AS)) != null && (pdfIndirectReference = (PdfIndirectReference)((PdfDictionary)object6).get((PdfName)object4)) != null) {
                            object5 = new PdfAppearance(pdfIndirectReference);
                            if (pdfIndirectReference.isIndirect()) {
                                object6 = PdfReader.getPdfObject(pdfIndirectReference);
                                ((PdfDictionary)object6).put(PdfName.SUBTYPE, PdfName.FORM);
                            }
                        }
                    }
                    if (object5 != null) {
                        object6 = PdfReader.getNormalizedRectangle(pdfDictionary.getAsArray(PdfName.RECT));
                        object4 = this.getOverContent(n2);
                        ((PdfContentByte)object4).setLiteral("Q ");
                        ((PdfContentByte)object4).addTemplate((PdfTemplate)object5, ((Rectangle)object6).getLeft(), ((Rectangle)object6).getBottom());
                        ((PdfContentByte)object4).setLiteral("q ");
                    }
                }
                if (this.partialFlattening.isEmpty() || (object5 = ((PdfDictionary)(pdfObject2 = this.reader.getPageN(n2))).getAsArray(PdfName.ANNOTS)) == null) continue;
                block3: for (int i = 0; i < ((PdfArray)object5).size(); ++i) {
                    object4 = ((PdfArray)object5).getPdfObject(i);
                    if (!((PdfObject)object4).isIndirect() || !(pdfIndirectReference = item.getWidgetRef(pdfObject)).isIndirect() || ((PRIndirectReference)object4).getNumber() != ((PRIndirectReference)pdfIndirectReference).getNumber()) continue;
                    ((PdfArray)object5).remove(i--);
                    PRIndirectReference pRIndirectReference = (PRIndirectReference)pdfIndirectReference;
                    while (true) {
                        PdfObject pdfObject3;
                        PdfDictionary pdfDictionary3 = (PdfDictionary)PdfReader.getPdfObject(pRIndirectReference);
                        PRIndirectReference pRIndirectReference2 = (PRIndirectReference)pdfDictionary3.get(PdfName.PARENT);
                        PdfReader.killIndirect(pRIndirectReference);
                        if (pRIndirectReference2 == null) {
                            for (int j = 0; j < pdfArray.size(); ++j) {
                                pdfObject3 = pdfArray.getPdfObject(j);
                                if (!pdfObject3.isIndirect() || ((PRIndirectReference)pdfObject3).getNumber() != pRIndirectReference.getNumber()) continue;
                                pdfArray.remove(j);
                                --j;
                            }
                            continue block3;
                        }
                        PdfDictionary pdfDictionary4 = (PdfDictionary)PdfReader.getPdfObject(pRIndirectReference2);
                        pdfObject3 = pdfDictionary4.getAsArray(PdfName.KIDS);
                        for (int j = 0; j < ((PdfArray)pdfObject3).size(); ++j) {
                            PdfObject pdfObject4 = ((PdfArray)pdfObject3).getPdfObject(j);
                            if (!pdfObject4.isIndirect() || ((PRIndirectReference)pdfObject4).getNumber() != pRIndirectReference.getNumber()) continue;
                            ((PdfArray)pdfObject3).remove(j);
                            --j;
                        }
                        if (!((PdfArray)pdfObject3).isEmpty()) continue block3;
                        pRIndirectReference = pRIndirectReference2;
                    }
                }
                if (!((PdfArray)object5).isEmpty()) continue;
                PdfReader.killIndirect(((PdfDictionary)pdfObject2).get(PdfName.ANNOTS));
                ((PdfDictionary)pdfObject2).remove(PdfName.ANNOTS);
            }
        }
        if (!this.fieldsAdded && this.partialFlattening.isEmpty()) {
            for (int i = 1; i <= this.reader.getNumberOfPages(); ++i) {
                PdfDictionary pdfDictionary = this.reader.getPageN(i);
                object = pdfDictionary.getAsArray(PdfName.ANNOTS);
                if (object == null) continue;
                for (int j = 0; j < ((PdfArray)object).size(); ++j) {
                    PdfObject pdfObject = ((PdfArray)object).getDirectObject(j);
                    if (pdfObject instanceof PdfIndirectReference && !pdfObject.isIndirect() || pdfObject.isDictionary() && !PdfName.WIDGET.equals(((PdfDictionary)pdfObject).get(PdfName.SUBTYPE))) continue;
                    ((PdfArray)object).remove(j);
                    --j;
                }
                if (!((PdfArray)object).isEmpty()) continue;
                PdfReader.killIndirect(pdfDictionary.get(PdfName.ANNOTS));
                pdfDictionary.remove(PdfName.ANNOTS);
            }
            this.eliminateAcroformObjects();
        }
    }

    private void eliminateAcroformObjects() {
        PdfObject pdfObject = this.reader.getCatalog().get(PdfName.ACROFORM);
        if (pdfObject == null) {
            return;
        }
        PdfDictionary pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(pdfObject);
        this.reader.killXref(pdfDictionary.get(PdfName.XFA));
        pdfDictionary.remove(PdfName.XFA);
        PdfObject pdfObject2 = pdfDictionary.get(PdfName.FIELDS);
        if (pdfObject2 != null) {
            PdfDictionary pdfDictionary2 = new PdfDictionary();
            pdfDictionary2.put(PdfName.KIDS, pdfObject2);
            this.sweepKids(pdfDictionary2);
            PdfReader.killIndirect(pdfObject2);
            pdfDictionary.put(PdfName.FIELDS, new PdfArray());
        }
    }

    private void sweepKids(PdfObject pdfObject) {
        PdfObject pdfObject2 = PdfReader.killIndirect(pdfObject);
        if (pdfObject2 == null || !pdfObject2.isDictionary()) {
            return;
        }
        PdfDictionary pdfDictionary = (PdfDictionary)pdfObject2;
        PdfArray pdfArray = (PdfArray)PdfReader.killIndirect(pdfDictionary.get(PdfName.KIDS));
        if (pdfArray == null) {
            return;
        }
        for (int i = 0; i < pdfArray.size(); ++i) {
            this.sweepKids(pdfArray.getPdfObject(i));
        }
    }

    private void flatFreeTextFields() {
        if (this.append) {
            throw new IllegalArgumentException("FreeText flattening is not supported in append mode.");
        }
        for (int i = 1; i <= this.reader.getNumberOfPages(); ++i) {
            PdfObject pdfObject;
            int n;
            PdfDictionary pdfDictionary = this.reader.getPageN(i);
            PdfArray pdfArray = pdfDictionary.getAsArray(PdfName.ANNOTS);
            if (pdfArray == null) continue;
            for (n = 0; n < pdfArray.size(); ++n) {
                Object object;
                Object object2;
                PdfObject pdfObject2;
                int n2;
                PdfDictionary pdfDictionary2;
                pdfObject = pdfArray.getDirectObject(n);
                if (pdfObject instanceof PdfIndirectReference && !pdfObject.isIndirect() || !((PdfName)(pdfDictionary2 = (PdfDictionary)pdfObject).get(PdfName.SUBTYPE)).equals(PdfName.FREETEXT)) continue;
                PdfNumber pdfNumber = pdfDictionary2.getAsNumber(PdfName.F);
                int n3 = n2 = pdfNumber != null ? pdfNumber.intValue() : 0;
                if ((n2 & 4) == 0 || (n2 & 2) != 0 || (pdfObject2 = pdfDictionary2.get(PdfName.AP)) == null) continue;
                PdfDictionary pdfDictionary3 = pdfObject2 instanceof PdfIndirectReference ? (PdfDictionary)PdfReader.getPdfObject(pdfObject2) : (PdfDictionary)pdfObject2;
                PdfObject pdfObject3 = pdfDictionary3.get(PdfName.N);
                PdfAppearance pdfAppearance = null;
                PdfObject pdfObject4 = PdfReader.getPdfObject(pdfObject3);
                if (pdfObject3 instanceof PdfIndirectReference && !pdfObject3.isIndirect()) {
                    pdfAppearance = new PdfAppearance((PdfIndirectReference)pdfObject3);
                } else if (pdfObject4 instanceof PdfStream) {
                    ((PdfDictionary)pdfObject4).put(PdfName.SUBTYPE, PdfName.FORM);
                    pdfAppearance = new PdfAppearance((PdfIndirectReference)pdfObject3);
                } else if (pdfObject4.isDictionary() && (object2 = pdfDictionary3.getAsName(PdfName.AS)) != null && (object = (PdfIndirectReference)((PdfDictionary)pdfObject4).get((PdfName)object2)) != null) {
                    pdfAppearance = new PdfAppearance((PdfIndirectReference)object);
                    if (((PdfObject)object).isIndirect()) {
                        pdfObject4 = PdfReader.getPdfObject((PdfObject)object);
                        ((PdfDictionary)pdfObject4).put(PdfName.SUBTYPE, PdfName.FORM);
                    }
                }
                if (pdfAppearance == null) continue;
                object2 = PdfReader.getNormalizedRectangle(pdfDictionary2.getAsArray(PdfName.RECT));
                object = this.getOverContent(i);
                ((PdfContentByte)object).setLiteral("Q ");
                ((PdfContentByte)object).addTemplate(pdfAppearance, ((Rectangle)object2).getLeft(), ((Rectangle)object2).getBottom());
                ((PdfContentByte)object).setLiteral("q ");
            }
            for (n = 0; n < pdfArray.size(); ++n) {
                pdfObject = pdfArray.getAsDict(n);
                if (pdfObject == null || !PdfName.FREETEXT.equals(((PdfDictionary)pdfObject).get(PdfName.SUBTYPE))) continue;
                pdfArray.remove(n);
                --n;
            }
            if (!pdfArray.isEmpty()) continue;
            PdfReader.killIndirect(pdfDictionary.get(PdfName.ANNOTS));
            pdfDictionary.remove(PdfName.ANNOTS);
        }
    }

    @Override
    public PdfIndirectReference getPageReference(int n) {
        PRIndirectReference pRIndirectReference = this.reader.getPageOrigRef(n);
        if (pRIndirectReference == null) {
            throw new IllegalArgumentException("Invalid page number " + n);
        }
        return pRIndirectReference;
    }

    @Override
    public void addAnnotation(PdfAnnotation pdfAnnotation) {
        throw new RuntimeException("Unsupported in this context. Use PdfStamper.addAnnotation()");
    }

    private void addDocumentField(PdfIndirectReference pdfIndirectReference) {
        PdfArray pdfArray;
        PdfDictionary pdfDictionary = this.reader.getCatalog();
        PdfDictionary pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.ACROFORM), pdfDictionary);
        if (pdfDictionary2 == null) {
            pdfDictionary2 = new PdfDictionary();
            pdfDictionary.put(PdfName.ACROFORM, pdfDictionary2);
            this.markUsed(pdfDictionary);
        }
        if ((pdfArray = (PdfArray)PdfReader.getPdfObject(pdfDictionary2.get(PdfName.FIELDS), pdfDictionary2)) == null) {
            pdfArray = new PdfArray();
            pdfDictionary2.put(PdfName.FIELDS, pdfArray);
            this.markUsed(pdfDictionary2);
        }
        if (!pdfDictionary2.contains(PdfName.DA)) {
            pdfDictionary2.put(PdfName.DA, new PdfString("/Helv 0 Tf 0 g "));
            this.markUsed(pdfDictionary2);
        }
        pdfArray.add(pdfIndirectReference);
        this.markUsed(pdfArray);
    }

    private void addFieldResources() throws IOException {
        Object object2;
        PdfDictionary pdfDictionary;
        if (this.fieldTemplates.isEmpty()) {
            return;
        }
        PdfDictionary pdfDictionary2 = this.reader.getCatalog();
        PdfDictionary pdfDictionary3 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary2.get(PdfName.ACROFORM), pdfDictionary2);
        if (pdfDictionary3 == null) {
            pdfDictionary3 = new PdfDictionary();
            pdfDictionary2.put(PdfName.ACROFORM, pdfDictionary3);
            this.markUsed(pdfDictionary2);
        }
        if ((pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary3.get(PdfName.DR), pdfDictionary3)) == null) {
            pdfDictionary = new PdfDictionary();
            pdfDictionary3.put(PdfName.DR, pdfDictionary);
            this.markUsed(pdfDictionary3);
        }
        this.markUsed(pdfDictionary);
        for (Object object2 : this.fieldTemplates.keySet()) {
            PdfFormField.mergeResources(pdfDictionary, (PdfDictionary)((PdfTemplate)object2).getResources(), this);
        }
        Object object3 = pdfDictionary.getAsDict(PdfName.FONT);
        if (object3 == null) {
            object3 = new PdfDictionary();
            pdfDictionary.put(PdfName.FONT, (PdfObject)object3);
        }
        if (!((PdfDictionary)object3).contains(PdfName.HELV)) {
            object2 = new PdfDictionary(PdfName.FONT);
            ((PdfDictionary)object2).put(PdfName.BASEFONT, PdfName.HELVETICA);
            ((PdfDictionary)object2).put(PdfName.ENCODING, PdfName.WIN_ANSI_ENCODING);
            ((PdfDictionary)object2).put(PdfName.NAME, PdfName.HELV);
            ((PdfDictionary)object2).put(PdfName.SUBTYPE, PdfName.TYPE1);
            ((PdfDictionary)object3).put(PdfName.HELV, this.addToBody((PdfObject)object2).getIndirectReference());
        }
        if (!((PdfDictionary)object3).contains(PdfName.ZADB)) {
            object2 = new PdfDictionary(PdfName.FONT);
            ((PdfDictionary)object2).put(PdfName.BASEFONT, PdfName.ZAPFDINGBATS);
            ((PdfDictionary)object2).put(PdfName.NAME, PdfName.ZADB);
            ((PdfDictionary)object2).put(PdfName.SUBTYPE, PdfName.TYPE1);
            ((PdfDictionary)object3).put(PdfName.ZADB, this.addToBody((PdfObject)object2).getIndirectReference());
        }
        if (pdfDictionary3.get(PdfName.DA) == null) {
            pdfDictionary3.put(PdfName.DA, new PdfString("/Helv 0 Tf 0 g "));
            this.markUsed(pdfDictionary3);
        }
    }

    private void expandFields(PdfFormField pdfFormField, ArrayList arrayList) {
        arrayList.add(pdfFormField);
        ArrayList arrayList2 = pdfFormField.getKids();
        if (arrayList2 != null) {
            for (int i = 0; i < arrayList2.size(); ++i) {
                this.expandFields((PdfFormField)arrayList2.get(i), arrayList);
            }
        }
    }

    void addAnnotation(PdfAnnotation pdfAnnotation, PdfDictionary pdfDictionary) {
        try {
            ArrayList<PdfAnnotation> arrayList = new ArrayList<PdfAnnotation>();
            if (pdfAnnotation.isForm()) {
                this.fieldsAdded = true;
                this.getAcroFields();
                PdfFormField pdfFormField = (PdfFormField)pdfAnnotation;
                if (pdfFormField.getParent() != null) {
                    return;
                }
                this.expandFields(pdfFormField, arrayList);
            } else {
                arrayList.add(pdfAnnotation);
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                Object object;
                pdfAnnotation = (PdfAnnotation)arrayList.get(i);
                if (pdfAnnotation.getPlaceInPage() > 0) {
                    pdfDictionary = this.reader.getPageN(pdfAnnotation.getPlaceInPage());
                }
                if (pdfAnnotation.isForm()) {
                    if (!pdfAnnotation.isUsed() && (object = pdfAnnotation.getTemplates()) != null) {
                        this.fieldTemplates.putAll(object);
                    }
                    if (((PdfFormField)(object = (PdfFormField)pdfAnnotation)).getParent() == null) {
                        this.addDocumentField(((PdfAnnotation)object).getIndirectReference());
                    }
                }
                if (pdfAnnotation.isAnnotation()) {
                    PdfRectangle pdfRectangle;
                    object = PdfReader.getPdfObject(pdfDictionary.get(PdfName.ANNOTS), pdfDictionary);
                    PdfArray pdfArray = null;
                    if (object == null || !((PdfObject)object).isArray()) {
                        pdfArray = new PdfArray();
                        pdfDictionary.put(PdfName.ANNOTS, pdfArray);
                        this.markUsed(pdfDictionary);
                    } else {
                        pdfArray = (PdfArray)object;
                    }
                    pdfArray.add(pdfAnnotation.getIndirectReference());
                    this.markUsed(pdfArray);
                    if (!(pdfAnnotation.isUsed() || (pdfRectangle = (PdfRectangle)pdfAnnotation.get(PdfName.RECT)) == null || pdfRectangle.left() == 0.0f && pdfRectangle.right() == 0.0f && pdfRectangle.top() == 0.0f && pdfRectangle.bottom() == 0.0f)) {
                        int n = this.reader.getPageRotation(pdfDictionary);
                        Rectangle rectangle = this.reader.getPageSizeWithRotation(pdfDictionary);
                        switch (n) {
                            case 90: {
                                pdfAnnotation.put(PdfName.RECT, new PdfRectangle(rectangle.getTop() - pdfRectangle.bottom(), pdfRectangle.left(), rectangle.getTop() - pdfRectangle.top(), pdfRectangle.right()));
                                break;
                            }
                            case 180: {
                                pdfAnnotation.put(PdfName.RECT, new PdfRectangle(rectangle.getRight() - pdfRectangle.left(), rectangle.getTop() - pdfRectangle.bottom(), rectangle.getRight() - pdfRectangle.right(), rectangle.getTop() - pdfRectangle.top()));
                                break;
                            }
                            case 270: {
                                pdfAnnotation.put(PdfName.RECT, new PdfRectangle(pdfRectangle.bottom(), rectangle.getRight() - pdfRectangle.left(), pdfRectangle.top(), rectangle.getRight() - pdfRectangle.right()));
                            }
                        }
                    }
                }
                if (pdfAnnotation.isUsed()) continue;
                pdfAnnotation.setUsed();
                this.addToBody((PdfObject)pdfAnnotation, pdfAnnotation.getIndirectReference());
            }
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
    }

    @Override
    void addAnnotation(PdfAnnotation pdfAnnotation, int n) {
        pdfAnnotation.setPage(n);
        this.addAnnotation(pdfAnnotation, this.reader.getPageN(n));
    }

    private void outlineTravel(PRIndirectReference pRIndirectReference) {
        while (pRIndirectReference != null) {
            PdfDictionary pdfDictionary = (PdfDictionary)PdfReader.getPdfObjectRelease(pRIndirectReference);
            PRIndirectReference pRIndirectReference2 = (PRIndirectReference)pdfDictionary.get(PdfName.FIRST);
            if (pRIndirectReference2 != null) {
                this.outlineTravel(pRIndirectReference2);
            }
            PdfReader.killIndirect(pdfDictionary.get(PdfName.DEST));
            PdfReader.killIndirect(pdfDictionary.get(PdfName.A));
            PdfReader.killIndirect(pRIndirectReference);
            pRIndirectReference = (PRIndirectReference)pdfDictionary.get(PdfName.NEXT);
        }
    }

    private void deleteOutlines() {
        PdfDictionary pdfDictionary = this.reader.getCatalog();
        PRIndirectReference pRIndirectReference = (PRIndirectReference)pdfDictionary.get(PdfName.OUTLINES);
        if (pRIndirectReference == null) {
            return;
        }
        this.outlineTravel(pRIndirectReference);
        PdfReader.killIndirect(pRIndirectReference);
        pdfDictionary.remove(PdfName.OUTLINES);
        this.markUsed(pdfDictionary);
    }

    private void setJavaScript() throws IOException {
        HashMap hashMap = this.pdf.getDocumentLevelJS();
        if (hashMap.isEmpty()) {
            return;
        }
        PdfDictionary pdfDictionary = this.reader.getCatalog();
        PdfDictionary pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.NAMES), pdfDictionary);
        if (pdfDictionary2 == null) {
            pdfDictionary2 = new PdfDictionary();
            pdfDictionary.put(PdfName.NAMES, pdfDictionary2);
            this.markUsed(pdfDictionary);
        }
        this.markUsed(pdfDictionary2);
        PdfDictionary pdfDictionary3 = PdfNameTree.writeTree(hashMap, this);
        pdfDictionary2.put(PdfName.JAVASCRIPT, this.addToBody(pdfDictionary3).getIndirectReference());
    }

    private void addFileAttachments() throws IOException {
        HashMap hashMap = this.pdf.getDocumentFileAttachment();
        if (hashMap.isEmpty()) {
            return;
        }
        PdfDictionary pdfDictionary = this.reader.getCatalog();
        PdfDictionary pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.NAMES), pdfDictionary);
        if (pdfDictionary2 == null) {
            pdfDictionary2 = new PdfDictionary();
            pdfDictionary.put(PdfName.NAMES, pdfDictionary2);
            this.markUsed(pdfDictionary);
        }
        this.markUsed(pdfDictionary2);
        HashMap hashMap2 = PdfNameTree.readTree((PdfDictionary)PdfReader.getPdfObjectRelease(pdfDictionary2.get(PdfName.EMBEDDEDFILES)));
        for (Map.Entry entry : hashMap.entrySet()) {
            String string = (String)entry.getKey();
            int n = 0;
            String string2 = string;
            while (hashMap2.containsKey(string2)) {
                string2 = string2 + " " + ++n;
            }
            hashMap2.put(string2, entry.getValue());
        }
        PdfDictionary pdfDictionary3 = PdfNameTree.writeTree(hashMap2, this);
        pdfDictionary2.put(PdfName.EMBEDDEDFILES, this.addToBody(pdfDictionary3).getIndirectReference());
    }

    private void setOutlines() throws IOException {
        if (this.newBookmarks == null) {
            return;
        }
        this.deleteOutlines();
        if (this.newBookmarks.isEmpty()) {
            return;
        }
        PdfDictionary pdfDictionary = this.reader.getCatalog();
        boolean bl = pdfDictionary.get(PdfName.DESTS) != null;
        this.writeOutlines(pdfDictionary, bl);
        this.markUsed(pdfDictionary);
    }

    @Override
    public void setViewerPreferences(int n) {
        this.useVp = true;
        this.viewerPreferences.setViewerPreferences(n);
    }

    @Override
    public void addViewerPreference(PdfName pdfName, PdfObject pdfObject) {
        this.useVp = true;
        this.viewerPreferences.addViewerPreference(pdfName, pdfObject);
    }

    @Override
    public void setSigFlags(int n) {
        this.sigFlags |= n;
    }

    @Override
    public void setPageAction(PdfName pdfName, PdfAction pdfAction) throws PdfException {
        throw new UnsupportedOperationException("Use setPageAction(PdfName actionType, PdfAction action, int page)");
    }

    @Override
    public void setDuration(int n) {
        throw new UnsupportedOperationException("Use setPageAction(PdfName actionType, PdfAction action, int page)");
    }

    @Override
    public void setTransition(PdfTransition pdfTransition) {
        throw new UnsupportedOperationException("Use setPageAction(PdfName actionType, PdfAction action, int page)");
    }

    protected void markUsed(PdfObject pdfObject) {
        if (this.append && pdfObject != null) {
            PRIndirectReference pRIndirectReference = null;
            pRIndirectReference = pdfObject.type() == 10 ? (PRIndirectReference)pdfObject : pdfObject.getIndRef();
            if (pRIndirectReference != null) {
                this.marked.put(pRIndirectReference.getNumber(), 1);
            }
        }
    }

    boolean isAppend() {
        return this.append;
    }

    @Override
    public void setAdditionalAction(PdfName pdfName, PdfAction pdfAction) throws PdfException {
        if (!(pdfName.equals(DOCUMENT_CLOSE) || pdfName.equals(WILL_SAVE) || pdfName.equals(DID_SAVE) || pdfName.equals(WILL_PRINT) || pdfName.equals(DID_PRINT))) {
            throw new PdfException("Invalid additional action type: " + pdfName.toString());
        }
        PdfDictionary pdfDictionary = this.reader.getCatalog().getAsDict(PdfName.AA);
        if (pdfDictionary == null) {
            if (pdfAction == null) {
                return;
            }
            pdfDictionary = new PdfDictionary();
            this.reader.getCatalog().put(PdfName.AA, pdfDictionary);
        }
        this.markUsed(pdfDictionary);
        if (pdfAction == null) {
            pdfDictionary.remove(pdfName);
        } else {
            pdfDictionary.put(pdfName, pdfAction);
        }
    }

    @Override
    public void setOpenAction(PdfAction pdfAction) {
        this.openAction = pdfAction;
    }

    @Override
    public void setOpenAction(String string) {
        throw new UnsupportedOperationException("Open actions by name are not supported.");
    }

    @Override
    public void setThumbnail(Image image) {
        throw new UnsupportedOperationException("Use PdfStamper.setThumbnail().");
    }

    @Override
    public PdfContentByte getDirectContentUnder() {
        throw new UnsupportedOperationException("Use PdfStamper.getUnderContent() or PdfStamper.getOverContent()");
    }

    @Override
    public PdfContentByte getDirectContent() {
        throw new UnsupportedOperationException("Use PdfStamper.getUnderContent() or PdfStamper.getOverContent()");
    }

    private void readOCProperties() {
        Object object;
        PdfLayer pdfLayer;
        PdfIndirectReference pdfIndirectReference;
        if (!this.documentOCG.isEmpty()) {
            return;
        }
        PdfDictionary pdfDictionary = this.reader.getCatalog().getAsDict(PdfName.OCPROPERTIES);
        if (pdfDictionary == null) {
            return;
        }
        PdfArray pdfArray = pdfDictionary.getAsArray(PdfName.OCGS);
        LinkedHashMap<String, PdfLayer> linkedHashMap = new LinkedHashMap<String, PdfLayer>();
        Object object2 = pdfArray.listIterator();
        while (object2.hasNext()) {
            pdfIndirectReference = (PdfIndirectReference)object2.next();
            pdfLayer = new PdfLayer(null);
            pdfLayer.setRef(pdfIndirectReference);
            pdfLayer.setOnPanel(false);
            pdfLayer.merge((PdfDictionary)PdfReader.getPdfObject(pdfIndirectReference));
            linkedHashMap.put(pdfIndirectReference.toString(), pdfLayer);
        }
        object2 = pdfDictionary.getAsDict(PdfName.D);
        PdfArray pdfArray2 = ((PdfDictionary)object2).getAsArray(PdfName.OFF);
        if (pdfArray2 != null) {
            object = pdfArray2.listIterator();
            while (object.hasNext()) {
                pdfIndirectReference = (PdfIndirectReference)object.next();
                pdfLayer = (PdfLayer)((HashMap)linkedHashMap).get(pdfIndirectReference.toString());
                pdfLayer.setOn(false);
            }
        }
        if ((object = ((PdfDictionary)object2).getAsArray(PdfName.ORDER)) != null) {
            this.addOrder(null, (PdfArray)object, linkedHashMap);
        }
        this.documentOCG.addAll(((HashMap)linkedHashMap).values());
        this.OCGRadioGroup = ((PdfDictionary)object2).getAsArray(PdfName.RBGROUPS);
        this.OCGLocked = ((PdfDictionary)object2).getAsArray(PdfName.LOCKED);
        if (this.OCGLocked == null) {
            this.OCGLocked = new PdfArray();
        }
    }

    private void addOrder(PdfLayer pdfLayer, PdfArray pdfArray, Map map) {
        for (int i = 0; i < pdfArray.size(); ++i) {
            PdfLayer pdfLayer2;
            PdfObject pdfObject = pdfArray.getPdfObject(i);
            if (pdfObject.isIndirect()) {
                pdfLayer2 = (PdfLayer)map.get(pdfObject.toString());
                pdfLayer2.setOnPanel(true);
                this.registerLayer(pdfLayer2);
                if (pdfLayer != null) {
                    pdfLayer.addChild(pdfLayer2);
                }
                if (pdfArray.size() <= i + 1 || !pdfArray.getPdfObject(i + 1).isArray()) continue;
                this.addOrder(pdfLayer2, (PdfArray)pdfArray.getPdfObject(++i), map);
                continue;
            }
            if (!pdfObject.isArray()) continue;
            PdfArray pdfArray2 = (PdfArray)pdfObject;
            if (pdfArray2.isEmpty()) {
                return;
            }
            pdfObject = pdfArray2.getPdfObject(0);
            if (pdfObject.isString()) {
                pdfLayer2 = new PdfLayer(pdfObject.toString());
                pdfLayer2.setOnPanel(true);
                this.registerLayer(pdfLayer2);
                if (pdfLayer != null) {
                    pdfLayer.addChild(pdfLayer2);
                }
                PdfArray pdfArray3 = new PdfArray();
                ListIterator<PdfObject> listIterator = pdfArray2.listIterator();
                while (listIterator.hasNext()) {
                    pdfArray3.add((PdfObject)listIterator.next());
                }
                this.addOrder(pdfLayer2, pdfArray3, map);
                continue;
            }
            this.addOrder(pdfLayer, (PdfArray)pdfObject, map);
        }
    }

    public Map getPdfLayers() {
        if (this.documentOCG.isEmpty()) {
            this.readOCProperties();
        }
        LinkedHashMap<String, PdfLayer> linkedHashMap = new LinkedHashMap<String, PdfLayer>();
        for (PdfLayer pdfLayer : this.documentOCG) {
            String string = pdfLayer.getTitle() == null ? pdfLayer.getAsString(PdfName.NAME).toString() : pdfLayer.getTitle();
            if (linkedHashMap.containsKey(string)) {
                int n = 2;
                String string2 = string + "(" + n + ")";
                while (linkedHashMap.containsKey(string2)) {
                    string2 = string + "(" + ++n + ")";
                }
                string = string2;
            }
            linkedHashMap.put(string, pdfLayer);
        }
        return linkedHashMap;
    }

    public PdfObject getFileID() {
        return this.pdfFileID;
    }

    static class PageStamp {
        PdfDictionary pageN;
        private StampContent under;
        private StampContent over;
        PageResources pageResources;
        private final int replacePoint = 0;

        private PageStamp(PdfStamperImp pdfStamperImp, PdfReader pdfReader, PdfDictionary pdfDictionary) {
            this.pageN = pdfDictionary;
            this.pageResources = new PageResources();
            PdfDictionary pdfDictionary2 = pdfDictionary.getAsDict(PdfName.RESOURCES);
            this.pageResources.setOriginalResources(pdfDictionary2, pdfStamperImp.namePtr);
        }
    }
}

