/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocWriter;
import com.lowagie.text.DocumentException;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.pdf.AcroFields;
import com.lowagie.text.pdf.ByteBuffer;
import com.lowagie.text.pdf.PdfAnnotation;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfFileSpecification;
import com.lowagie.text.pdf.PdfLiteral;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfSigGenericPKCS;
import com.lowagie.text.pdf.PdfSignatureAppearance;
import com.lowagie.text.pdf.PdfStamperImp;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.interfaces.PdfEncryptionSettings;
import com.lowagie.text.pdf.interfaces.PdfViewerPreferences;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PdfStamper
implements PdfViewerPreferences,
PdfEncryptionSettings {
    private final PdfStamperImp stamper;
    private HashMap moreInfo;
    private boolean hasSignature;
    private PdfSignatureAppearance sigApp;

    public PdfStamper(PdfReader pdfReader, OutputStream outputStream, Calendar calendar) throws DocumentException, IOException {
        this.stamper = new PdfStamperImp(pdfReader, outputStream, '\u0000', false, calendar);
    }

    private PdfStamper(PdfReader pdfReader, OutputStream outputStream, char c, boolean bl, Calendar calendar) throws DocumentException, IOException {
        this.stamper = new PdfStamperImp(pdfReader, outputStream, c, bl, calendar);
    }

    public HashMap getMoreInfo() {
        return this.moreInfo;
    }

    public void setMoreInfo(HashMap hashMap) {
        this.moreInfo = hashMap;
    }

    public PdfSignatureAppearance getSignatureAppearance() {
        return this.sigApp;
    }

    public void close(Calendar calendar) throws DocumentException, IOException {
        if (!this.hasSignature) {
            this.stamper.close(this.moreInfo, calendar);
            return;
        }
        this.sigApp.preClose(calendar);
        PdfSigGenericPKCS pdfSigGenericPKCS = this.sigApp.getSigStandard();
        PdfLiteral pdfLiteral = (PdfLiteral)pdfSigGenericPKCS.get(PdfName.CONTENTS);
        int n = (pdfLiteral.getPosLength() - 2) / 2;
        byte[] byArray = new byte[8192];
        InputStream inputStream = this.sigApp.getRangeStream();
        try {
            int n2;
            while ((n2 = inputStream.read(byArray)) > 0) {
                pdfSigGenericPKCS.getSigner().update(byArray, 0, n2);
            }
        }
        catch (SignatureException signatureException) {
            throw new ExceptionConverter(signatureException);
        }
        byArray = new byte[n];
        byte[] byArray2 = pdfSigGenericPKCS.getSignerContents();
        System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
        PdfString pdfString = new PdfString(byArray);
        pdfString.setHexWriting(true);
        PdfDictionary pdfDictionary = new PdfDictionary();
        pdfDictionary.put(PdfName.CONTENTS, pdfString);
        this.sigApp.close(pdfDictionary);
        this.stamper.reader.close();
    }

    public boolean isRotateContents() {
        return this.stamper.isRotateContents();
    }

    public void setRotateContents(boolean bl) {
        this.stamper.setRotateContents(bl);
    }

    void setEncryption(byte[] byArray, byte[] byArray2, int n, boolean bl) throws DocumentException {
        if (this.stamper.isAppend()) {
            throw new DocumentException("Append mode does not support changing the encryption status.");
        }
        if (this.stamper.isContentWritten()) {
            throw new DocumentException("Content was already written to the output.");
        }
        this.stamper.setEncryption(byArray, byArray2, n, bl ? 1 : 0);
    }

    @Override
    public void setEncryption(byte[] byArray, byte[] byArray2, int n, int n2) throws DocumentException {
        if (this.stamper.isAppend()) {
            throw new DocumentException("Append mode does not support changing the encryption status.");
        }
        if (this.stamper.isContentWritten()) {
            throw new DocumentException("Content was already written to the output.");
        }
        this.stamper.setEncryption(byArray, byArray2, n, n2);
    }

    void setEncryption(boolean bl, String string, String string2, int n) throws DocumentException {
        this.setEncryption(DocWriter.getISOBytes(string), DocWriter.getISOBytes(string2), n, bl);
    }

    void setEncryption(int n, String string, String string2, int n2) throws DocumentException {
        this.setEncryption(DocWriter.getISOBytes(string), DocWriter.getISOBytes(string2), n2, n);
    }

    @Override
    public void setEncryption(Certificate[] certificateArray, int[] nArray, int n) throws DocumentException {
        if (this.stamper.isAppend()) {
            throw new DocumentException("Append mode does not support changing the encryption status.");
        }
        if (this.stamper.isContentWritten()) {
            throw new DocumentException("Content was already written to the output.");
        }
        this.stamper.setEncryption(certificateArray, nArray, n);
    }

    public PdfWriter getWriter() {
        return this.stamper;
    }

    public PdfReader getReader() {
        return this.stamper.reader;
    }

    public AcroFields getAcroFields() {
        return this.stamper.getAcroFields();
    }

    public void setFormFlattening(boolean bl) {
        this.stamper.setFormFlattening(bl);
    }

    public void setFreeTextFlattening(boolean bl) {
        this.stamper.setFreeTextFlattening(bl);
    }

    private void addAnnotation(PdfAnnotation pdfAnnotation, int n) {
        this.stamper.addAnnotation(pdfAnnotation, n);
    }

    public void setOutlines(List list) {
        this.stamper.setOutlines(list);
    }

    private void addFileAttachment(String string, PdfFileSpecification pdfFileSpecification) throws IOException {
        this.stamper.addFileAttachment(string, pdfFileSpecification);
    }

    @Override
    public void setViewerPreferences(int n) {
        this.stamper.setViewerPreferences(n);
    }

    @Override
    public void addViewerPreference(PdfName pdfName, PdfObject pdfObject) {
        this.stamper.addViewerPreference(pdfName, pdfObject);
    }

    public void setXmpMetadata(byte[] byArray) {
        this.stamper.setXmpMetadata(byArray);
    }

    public boolean isFullCompression() {
        return this.stamper.isFullCompression();
    }

    public void setFullCompression() {
        if (this.stamper.isAppend()) {
            return;
        }
        this.stamper.setFullCompression();
    }

    public static PdfStamper createSignature(PdfReader pdfReader, OutputStream outputStream, char c, File file, boolean bl) throws DocumentException, IOException {
        return PdfStamper.createSignature(pdfReader, outputStream, c, file, bl, null);
    }

    public static PdfStamper createSignature(PdfReader pdfReader, OutputStream outputStream, char c, File file, boolean bl, Calendar calendar) throws DocumentException, IOException {
        PdfStamper pdfStamper;
        Object object;
        Calendar calendar2;
        Calendar calendar3 = calendar2 = calendar != null ? calendar : new GregorianCalendar();
        if (file == null) {
            object = new ByteBuffer();
            pdfStamper = new PdfStamper(pdfReader, (OutputStream)object, c, bl, calendar2);
            pdfStamper.sigApp = new PdfSignatureAppearance(pdfStamper.stamper, calendar2);
            pdfStamper.sigApp.setSigout((ByteBuffer)object);
        } else {
            if (file.isDirectory()) {
                file = File.createTempFile("pdf", null, file);
            }
            object = new FileOutputStream(file);
            pdfStamper = new PdfStamper(pdfReader, (OutputStream)object, c, bl, calendar);
            pdfStamper.sigApp = new PdfSignatureAppearance(pdfStamper.stamper, calendar);
            pdfStamper.sigApp.setTempFile(file);
        }
        pdfStamper.sigApp.setOriginalout(outputStream);
        pdfStamper.sigApp.setStamper(pdfStamper);
        pdfStamper.hasSignature = true;
        object = pdfReader.getCatalog();
        PdfDictionary pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(((PdfDictionary)object).get(PdfName.ACROFORM), (PdfObject)object);
        if (pdfDictionary != null) {
            pdfDictionary.remove(PdfName.NEEDAPPEARANCES);
            pdfStamper.stamper.markUsed(pdfDictionary);
        }
        return pdfStamper;
    }

    public PdfContentByte getOverContent(int n) {
        return this.stamper.getOverContent(n);
    }

    public Map getPdfLayers() {
        return this.stamper.getPdfLayers();
    }
}

