/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.pdf.CMYKColor;
import com.lowagie.text.pdf.ExtendedColor;
import com.lowagie.text.pdf.GrayColor;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfFunction;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;

public class PdfSpotColor {
    private float tint;
    private PdfName name;
    private Color altcs;

    public float getTint() {
        return this.tint;
    }

    public Color getAlternativeCS() {
        return this.altcs;
    }

    protected PdfObject getSpotObject(PdfWriter pdfWriter) {
        PdfArray pdfArray = new PdfArray(PdfName.SEPARATION);
        pdfArray.add(this.name);
        PdfFunction pdfFunction = null;
        if (this.altcs instanceof ExtendedColor) {
            int n = ((ExtendedColor)this.altcs).type;
            switch (n) {
                case 1: {
                    pdfArray.add(PdfName.DEVICEGRAY);
                    pdfFunction = PdfFunction.type2(pdfWriter, new float[]{0.0f, 1.0f}, null, new float[]{0.0f}, new float[]{((GrayColor)this.altcs).getGray()}, 1.0f);
                    break;
                }
                case 2: {
                    pdfArray.add(PdfName.DEVICECMYK);
                    CMYKColor cMYKColor = (CMYKColor)this.altcs;
                    pdfFunction = PdfFunction.type2(pdfWriter, new float[]{0.0f, 1.0f}, null, new float[]{0.0f, 0.0f, 0.0f, 0.0f}, new float[]{cMYKColor.getCyan(), cMYKColor.getMagenta(), cMYKColor.getYellow(), cMYKColor.getBlack()}, 1.0f);
                    break;
                }
                default: {
                    throw new RuntimeException("Only RGB, Gray and CMYK are supported as alternative color spaces.");
                }
            }
        } else {
            pdfArray.add(PdfName.DEVICERGB);
            pdfFunction = PdfFunction.type2(pdfWriter, new float[]{0.0f, 1.0f}, null, new float[]{1.0f, 1.0f, 1.0f}, new float[]{(float)this.altcs.getRed() / 255.0f, (float)this.altcs.getGreen() / 255.0f, (float)this.altcs.getBlue() / 255.0f}, 1.0f);
        }
        pdfArray.add(pdfFunction.getReference());
        return pdfArray;
    }
}

