/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Image;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfPattern;
import com.lowagie.text.pdf.PdfSpotColor;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;

public final class PdfPatternPainter
extends PdfTemplate {
    private float xstep;
    private float ystep;
    private boolean stencil = false;
    private Color defaultColor;

    private PdfPatternPainter() {
        this.type = 3;
    }

    PdfPatternPainter(PdfWriter pdfWriter) {
        super(pdfWriter);
        this.type = 3;
    }

    PdfPatternPainter(PdfWriter pdfWriter, Color color) {
        this(pdfWriter);
        this.stencil = true;
        this.defaultColor = color == null ? Color.gray : color;
    }

    public void setXStep(float f) {
        this.xstep = f;
    }

    public void setYStep(float f) {
        this.ystep = f;
    }

    public float getXStep() {
        return this.xstep;
    }

    public float getYStep() {
        return this.ystep;
    }

    public boolean isStencil() {
        return this.stencil;
    }

    void setPatternMatrix(float f, float f2, float f3, float f4, float f5, float f6) {
        this.setMatrix(f, f2, f3, f4, f5, f6);
    }

    PdfPattern getPattern(int n) {
        return new PdfPattern(this, n);
    }

    @Override
    public PdfContentByte getDuplicate() {
        PdfPatternPainter pdfPatternPainter = new PdfPatternPainter();
        pdfPatternPainter.writer = this.writer;
        pdfPatternPainter.pdf = this.pdf;
        pdfPatternPainter.thisReference = this.thisReference;
        pdfPatternPainter.pageResources = this.pageResources;
        pdfPatternPainter.bBox = new Rectangle(this.bBox);
        pdfPatternPainter.xstep = this.xstep;
        pdfPatternPainter.ystep = this.ystep;
        pdfPatternPainter.matrix = this.matrix;
        pdfPatternPainter.stencil = this.stencil;
        pdfPatternPainter.defaultColor = this.defaultColor;
        return pdfPatternPainter;
    }

    public Color getDefaultColor() {
        return this.defaultColor;
    }

    @Override
    public void setGrayFill(float f) {
        this.checkNoColor();
        super.setGrayFill(f);
    }

    @Override
    public void resetGrayFill() {
        this.checkNoColor();
        super.resetGrayFill();
    }

    @Override
    public void setGrayStroke(float f) {
        this.checkNoColor();
        super.setGrayStroke(f);
    }

    @Override
    public void resetGrayStroke() {
        this.checkNoColor();
        super.resetGrayStroke();
    }

    @Override
    public void setRGBColorFillF(float f, float f2, float f3) {
        this.checkNoColor();
        super.setRGBColorFillF(f, f2, f3);
    }

    @Override
    public void resetRGBColorFill() {
        this.checkNoColor();
        super.resetRGBColorFill();
    }

    @Override
    public void setRGBColorStrokeF(float f, float f2, float f3) {
        this.checkNoColor();
        super.setRGBColorStrokeF(f, f2, f3);
    }

    @Override
    public void resetRGBColorStroke() {
        this.checkNoColor();
        super.resetRGBColorStroke();
    }

    @Override
    public void setCMYKColorFillF(float f, float f2, float f3, float f4) {
        this.checkNoColor();
        super.setCMYKColorFillF(f, f2, f3, f4);
    }

    @Override
    public void resetCMYKColorFill() {
        this.checkNoColor();
        super.resetCMYKColorFill();
    }

    @Override
    public void setCMYKColorStrokeF(float f, float f2, float f3, float f4) {
        this.checkNoColor();
        super.setCMYKColorStrokeF(f, f2, f3, f4);
    }

    @Override
    public void resetCMYKColorStroke() {
        this.checkNoColor();
        super.resetCMYKColorStroke();
    }

    @Override
    public void addImage(Image image, float f, float f2, float f3, float f4, float f5, float f6) throws DocumentException {
        if (this.stencil && !image.isMask()) {
            this.checkNoColor();
        }
        super.addImage(image, f, f2, f3, f4, f5, f6);
    }

    @Override
    public void setCMYKColorFill(int n, int n2, int n3, int n4) {
        this.checkNoColor();
        super.setCMYKColorFill(n, n2, n3, n4);
    }

    @Override
    public void setCMYKColorStroke(int n, int n2, int n3, int n4) {
        this.checkNoColor();
        super.setCMYKColorStroke(n, n2, n3, n4);
    }

    @Override
    public void setRGBColorFill(int n, int n2, int n3) {
        this.checkNoColor();
        super.setRGBColorFill(n, n2, n3);
    }

    @Override
    public void setRGBColorStroke(int n, int n2, int n3) {
        this.checkNoColor();
        super.setRGBColorStroke(n, n2, n3);
    }

    @Override
    public void setColorStroke(Color color) {
        this.checkNoColor();
        super.setColorStroke(color);
    }

    @Override
    public void setColorFill(Color color) {
        this.checkNoColor();
        super.setColorFill(color);
    }

    @Override
    public void setColorFill(PdfSpotColor pdfSpotColor, float f) {
        this.checkNoColor();
        super.setColorFill(pdfSpotColor, f);
    }

    @Override
    public void setColorStroke(PdfSpotColor pdfSpotColor, float f) {
        this.checkNoColor();
        super.setColorStroke(pdfSpotColor, f);
    }

    @Override
    public void setPatternFill(PdfPatternPainter pdfPatternPainter) {
        this.checkNoColor();
        super.setPatternFill(pdfPatternPainter);
    }

    @Override
    public void setPatternFill(PdfPatternPainter pdfPatternPainter, Color color, float f) {
        this.checkNoColor();
        super.setPatternFill(pdfPatternPainter, color, f);
    }

    @Override
    public void setPatternStroke(PdfPatternPainter pdfPatternPainter, Color color, float f) {
        this.checkNoColor();
        super.setPatternStroke(pdfPatternPainter, color, f);
    }

    @Override
    public void setPatternStroke(PdfPatternPainter pdfPatternPainter) {
        this.checkNoColor();
        super.setPatternStroke(pdfPatternPainter);
    }

    private void checkNoColor() {
        if (this.stencil) {
            throw new RuntimeException("Colors are not allowed in uncolored tile patterns.");
        }
    }
}

